/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.selectable.ProductionSupplyAreaSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyArea
 * ProductionSupplyArea} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class ProductionSupplyAreaByKeyFluentHelper
    extends
    FluentHelperByKey<ProductionSupplyAreaByKeyFluentHelper, ProductionSupplyArea, ProductionSupplyAreaSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyArea
     * ProductionSupplyArea} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProductionSupplyArea}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProductionSupplyArea}
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param productionSupplyArea
     *            Production Supply Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public ProductionSupplyAreaByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String productionSupplyArea,
        final String plant )
    {
        super(servicePath, entityCollection);
        this.key.put("ProductionSupplyArea", productionSupplyArea);
        this.key.put("Plant", plant);
    }

    @Override
    @Nonnull
    protected Class<ProductionSupplyArea> getEntityClass()
    {
        return ProductionSupplyArea.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
