/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ProductionSupplyAreaServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionSupplyAreaService ProductionSupplyAreaService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultProductionSupplyAreaServiceBatch
    extends
    BatchFluentHelperBasic<ProductionSupplyAreaServiceBatch, ProductionSupplyAreaServiceBatchChangeSet>
    implements
    ProductionSupplyAreaServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionSupplyAreaService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultProductionSupplyAreaServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductionSupplyAreaServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionSupplyAreaService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionSupplyAreaService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultProductionSupplyAreaServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductionSupplyAreaServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionSupplyAreaService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultProductionSupplyAreaServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductionSupplyAreaServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultProductionSupplyAreaServiceBatchChangeSet(this, service);
    }

}
