/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyArea;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText;

/**
 * Implementation of the {@link ProductionSupplyAreaServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionSupplyAreaService ProductionSupplyAreaService}.
 *
 */
public class DefaultProductionSupplyAreaServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProductionSupplyAreaServiceBatch, ProductionSupplyAreaServiceBatchChangeSet>
    implements
    ProductionSupplyAreaServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionSupplyAreaService service;

    @SuppressWarnings( "deprecation" )
    DefaultProductionSupplyAreaServiceBatchChangeSet(
        @Nonnull final DefaultProductionSupplyAreaServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionSupplyAreaService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProductionSupplyAreaServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductionSupplyAreaServiceBatchChangeSet createProductionSupplyArea(
        @Nonnull final ProductionSupplyArea productionSupplyArea )
    {
        return addRequestCreate(service::createProductionSupplyArea, productionSupplyArea);
    }

    @Nonnull
    @Override
    public ProductionSupplyAreaServiceBatchChangeSet updateProductionSupplyArea(
        @Nonnull final ProductionSupplyArea productionSupplyArea )
    {
        return addRequestUpdate(service::updateProductionSupplyArea, productionSupplyArea);
    }

    @Nonnull
    @Override
    public ProductionSupplyAreaServiceBatchChangeSet deleteProductionSupplyArea(
        @Nonnull final ProductionSupplyArea productionSupplyArea )
    {
        return addRequestDelete(service::deleteProductionSupplyArea, productionSupplyArea);
    }

    @Nonnull
    @Override
    public ProductionSupplyAreaServiceBatchChangeSet createProductionSupplyAreaAddress(
        @Nonnull final ProductionSupplyAreaAddress productionSupplyAreaAddress )
    {
        return addRequestCreate(service::createProductionSupplyAreaAddress, productionSupplyAreaAddress);
    }

    @Nonnull
    @Override
    public ProductionSupplyAreaServiceBatchChangeSet updateProductionSupplyAreaAddress(
        @Nonnull final ProductionSupplyAreaAddress productionSupplyAreaAddress )
    {
        return addRequestUpdate(service::updateProductionSupplyAreaAddress, productionSupplyAreaAddress);
    }

    @Nonnull
    @Override
    public ProductionSupplyAreaServiceBatchChangeSet deleteProductionSupplyAreaAddress(
        @Nonnull final ProductionSupplyAreaAddress productionSupplyAreaAddress )
    {
        return addRequestDelete(service::deleteProductionSupplyAreaAddress, productionSupplyAreaAddress);
    }

    @Nonnull
    @Override
    public ProductionSupplyAreaServiceBatchChangeSet createProductionSupplyAreaText(
        @Nonnull final ProductionSupplyAreaText productionSupplyAreaText )
    {
        return addRequestCreate(service::createProductionSupplyAreaText, productionSupplyAreaText);
    }

    @Nonnull
    @Override
    public ProductionSupplyAreaServiceBatchChangeSet updateProductionSupplyAreaText(
        @Nonnull final ProductionSupplyAreaText productionSupplyAreaText )
    {
        return addRequestUpdate(service::updateProductionSupplyAreaText, productionSupplyAreaText);
    }

    @Nonnull
    @Override
    public ProductionSupplyAreaServiceBatchChangeSet deleteProductionSupplyAreaText(
        @Nonnull final ProductionSupplyAreaText productionSupplyAreaText )
    {
        return addRequestDelete(service::deleteProductionSupplyAreaText, productionSupplyAreaText);
    }

}
