/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyArea;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionSupplyAreaService
 * ProductionSupplyAreaService}.
 *
 */
public interface ProductionSupplyAreaServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ProductionSupplyAreaServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ProductionSupplyAreaServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyArea
     * ProductionSupplyArea} entity and save it to the S/4HANA system.
     *
     * @param productionSupplyArea
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyArea
     *            ProductionSupplyArea} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionSupplyAreaServiceBatchChangeSet
        createProductionSupplyArea( @Nonnull final ProductionSupplyArea productionSupplyArea );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyArea
     * ProductionSupplyArea} entity and save it to the S/4HANA system.
     *
     * @param productionSupplyArea
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyArea
     *            ProductionSupplyArea} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionSupplyAreaServiceBatchChangeSet
        updateProductionSupplyArea( @Nonnull final ProductionSupplyArea productionSupplyArea );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyArea
     * ProductionSupplyArea} entity in the S/4HANA system.
     *
     * @param productionSupplyArea
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyArea
     *            ProductionSupplyArea} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionSupplyAreaServiceBatchChangeSet
        deleteProductionSupplyArea( @Nonnull final ProductionSupplyArea productionSupplyArea );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaAddress
     * ProductionSupplyAreaAddress} entity and save it to the S/4HANA system.
     *
     * @param productionSupplyAreaAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaAddress
     *            ProductionSupplyAreaAddress} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionSupplyAreaServiceBatchChangeSet
        createProductionSupplyAreaAddress( @Nonnull final ProductionSupplyAreaAddress productionSupplyAreaAddress );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaAddress
     * ProductionSupplyAreaAddress} entity and save it to the S/4HANA system.
     *
     * @param productionSupplyAreaAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaAddress
     *            ProductionSupplyAreaAddress} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionSupplyAreaServiceBatchChangeSet
        updateProductionSupplyAreaAddress( @Nonnull final ProductionSupplyAreaAddress productionSupplyAreaAddress );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaAddress
     * ProductionSupplyAreaAddress} entity in the S/4HANA system.
     *
     * @param productionSupplyAreaAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaAddress
     *            ProductionSupplyAreaAddress} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionSupplyAreaServiceBatchChangeSet
        deleteProductionSupplyAreaAddress( @Nonnull final ProductionSupplyAreaAddress productionSupplyAreaAddress );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText
     * ProductionSupplyAreaText} entity and save it to the S/4HANA system.
     *
     * @param productionSupplyAreaText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText
     *            ProductionSupplyAreaText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionSupplyAreaServiceBatchChangeSet
        createProductionSupplyAreaText( @Nonnull final ProductionSupplyAreaText productionSupplyAreaText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText
     * ProductionSupplyAreaText} entity and save it to the S/4HANA system.
     *
     * @param productionSupplyAreaText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText
     *            ProductionSupplyAreaText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionSupplyAreaServiceBatchChangeSet
        updateProductionSupplyAreaText( @Nonnull final ProductionSupplyAreaText productionSupplyAreaText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText
     * ProductionSupplyAreaText} entity in the S/4HANA system.
     *
     * @param productionSupplyAreaText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText
     *            ProductionSupplyAreaText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductionSupplyAreaServiceBatchChangeSet
        deleteProductionSupplyAreaText( @Nonnull final ProductionSupplyAreaText productionSupplyAreaText );

}
