/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText
 * ProductionSupplyAreaText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.field.ProductionSupplyAreaTextField
 * ProductionSupplyAreaTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.link.ProductionSupplyAreaTextLink
 * ProductionSupplyAreaTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText#PRODUCTION_SUPPLY_AREA
 * PRODUCTION_SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText#PRODUCTION_SUPPLY_AREA_NAME
 * PRODUCTION_SUPPLY_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * </ul>
 *
 */
public interface ProductionSupplyAreaTextSelectable extends EntitySelectable<ProductionSupplyAreaText>
{

}
