/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.field.ProductionVolumeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.selectable.ProductionVolumeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Production Volumes
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProductionVolumeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductionVolume extends VdmEntity<ProductionVolume>
{

    /**
     * Selector for all available fields of ProductionVolume.
     *
     */
    public final static ProductionVolumeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Well</b>
     * </p>
     *
     * @return Well ID
     */
    @Key
    @SerializedName( "Well" )
    @JsonProperty( "Well" )
    @Nullable
    @ODataField( odataName = "Well" )
    private String well;
    /**
     * Use with available fluent helpers to apply the <b>Well</b> field to query operations.
     *
     */
    public final static ProductionVolumeField<String> WELL = new ProductionVolumeField<String>("Well");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>WellCompletion</b>
     * </p>
     *
     * @return Well Completion ID
     */
    @Key
    @SerializedName( "WellCompletion" )
    @JsonProperty( "WellCompletion" )
    @Nullable
    @ODataField( odataName = "WellCompletion" )
    private String wellCompletion;
    /**
     * Use with available fluent helpers to apply the <b>WellCompletion</b> field to query operations.
     *
     */
    public final static ProductionVolumeField<String> WELL_COMPLETION =
        new ProductionVolumeField<String>("WellCompletion");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductionDate</b>
     * </p>
     *
     * @return Production Date
     */
    @Key
    @SerializedName( "ProductionDate" )
    @JsonProperty( "ProductionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProductionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime productionDate;
    /**
     * Use with available fluent helpers to apply the <b>ProductionDate</b> field to query operations.
     *
     */
    public final static ProductionVolumeField<LocalDateTime> PRODUCTION_DATE =
        new ProductionVolumeField<LocalDateTime>("ProductionDate");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OilAllocAtWellCompltnDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @Key
    @SerializedName( "OilAllocAtWellCompltnDateTime" )
    @JsonProperty( "OilAllocAtWellCompltnDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "OilAllocAtWellCompltnDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime oilAllocAtWellCompltnDateTime;
    /**
     * Use with available fluent helpers to apply the <b>OilAllocAtWellCompltnDateTime</b> field to query operations.
     *
     */
    public final static ProductionVolumeField<ZonedDateTime> OIL_ALLOC_AT_WELL_COMPLTN_DATE_TIME =
        new ProductionVolumeField<ZonedDateTime>("OilAllocAtWellCompltnDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WellDescription</b>
     * </p>
     *
     * @return Well Description
     */
    @SerializedName( "WellDescription" )
    @JsonProperty( "WellDescription" )
    @Nullable
    @ODataField( odataName = "WellDescription" )
    private String wellDescription;
    /**
     * Use with available fluent helpers to apply the <b>WellDescription</b> field to query operations.
     *
     */
    public final static ProductionVolumeField<String> WELL_DESCRIPTION =
        new ProductionVolumeField<String>("WellDescription");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WellCompletionDescription</b>
     * </p>
     *
     * @return Well Completion description
     */
    @SerializedName( "WellCompletionDescription" )
    @JsonProperty( "WellCompletionDescription" )
    @Nullable
    @ODataField( odataName = "WellCompletionDescription" )
    private String wellCompletionDescription;
    /**
     * Use with available fluent helpers to apply the <b>WellCompletionDescription</b> field to query operations.
     *
     */
    public final static ProductionVolumeField<String> WELL_COMPLETION_DESCRIPTION =
        new ProductionVolumeField<String>("WellCompletionDescription");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static ProductionVolumeField<String> COMPANY_CODE = new ProductionVolumeField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static ProductionVolumeField<String> CONTROLLING_AREA =
        new ProductionVolumeField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OilProdnVolAtWellOrWellCompltn</b>
     * </p>
     *
     * @return Production Volume
     */
    @SerializedName( "OilProdnVolAtWellOrWellCompltn" )
    @JsonProperty( "OilProdnVolAtWellOrWellCompltn" )
    @Nullable
    @ODataField( odataName = "OilProdnVolAtWellOrWellCompltn" )
    private BigDecimal oilProdnVolAtWellOrWellCompltn;
    /**
     * Use with available fluent helpers to apply the <b>OilProdnVolAtWellOrWellCompltn</b> field to query operations.
     *
     */
    public final static ProductionVolumeField<BigDecimal> OIL_PRODN_VOL_AT_WELL_OR_WELL_COMPLTN =
        new ProductionVolumeField<BigDecimal>("OilProdnVolAtWellOrWellCompltn");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "VolumeUnit" )
    @JsonProperty( "VolumeUnit" )
    @Nullable
    @ODataField( odataName = "VolumeUnit" )
    private String volumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>VolumeUnit</b> field to query operations.
     *
     */
    public final static ProductionVolumeField<String> VOLUME_UNIT = new ProductionVolumeField<String>("VolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AllocationFrequency</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "AllocationFrequency" )
    @JsonProperty( "AllocationFrequency" )
    @Nullable
    @ODataField( odataName = "AllocationFrequency" )
    private String allocationFrequency;
    /**
     * Use with available fluent helpers to apply the <b>AllocationFrequency</b> field to query operations.
     *
     */
    public final static ProductionVolumeField<String> ALLOCATION_FREQUENCY =
        new ProductionVolumeField<String>("AllocationFrequency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ProductionVolumeField<ZonedDateTime> CREATION_DATE_TIME =
        new ProductionVolumeField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProductionVolumeField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ProductionVolumeField<ZonedDateTime>("LastChangeDateTime");

    @Nonnull
    @Override
    public Class<ProductionVolume> getType()
    {
        return ProductionVolume.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Well</b>
     * </p>
     *
     * @param well
     *            Well ID
     */
    public void setWell( @Nullable final String well )
    {
        rememberChangedField("Well", this.well);
        this.well = well;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>WellCompletion</b>
     * </p>
     *
     * @param wellCompletion
     *            Well Completion ID
     */
    public void setWellCompletion( @Nullable final String wellCompletion )
    {
        rememberChangedField("WellCompletion", this.wellCompletion);
        this.wellCompletion = wellCompletion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductionDate</b>
     * </p>
     *
     * @param productionDate
     *            Production Date
     */
    public void setProductionDate( @Nullable final LocalDateTime productionDate )
    {
        rememberChangedField("ProductionDate", this.productionDate);
        this.productionDate = productionDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OilAllocAtWellCompltnDateTime</b>
     * </p>
     *
     * @param oilAllocAtWellCompltnDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setOilAllocAtWellCompltnDateTime( @Nullable final ZonedDateTime oilAllocAtWellCompltnDateTime )
    {
        rememberChangedField("OilAllocAtWellCompltnDateTime", this.oilAllocAtWellCompltnDateTime);
        this.oilAllocAtWellCompltnDateTime = oilAllocAtWellCompltnDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WellDescription</b>
     * </p>
     *
     * @param wellDescription
     *            Well Description
     */
    public void setWellDescription( @Nullable final String wellDescription )
    {
        rememberChangedField("WellDescription", this.wellDescription);
        this.wellDescription = wellDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WellCompletionDescription</b>
     * </p>
     *
     * @param wellCompletionDescription
     *            Well Completion description
     */
    public void setWellCompletionDescription( @Nullable final String wellCompletionDescription )
    {
        rememberChangedField("WellCompletionDescription", this.wellCompletionDescription);
        this.wellCompletionDescription = wellCompletionDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OilProdnVolAtWellOrWellCompltn</b>
     * </p>
     *
     * @param oilProdnVolAtWellOrWellCompltn
     *            Production Volume
     */
    public void setOilProdnVolAtWellOrWellCompltn( @Nullable final BigDecimal oilProdnVolAtWellOrWellCompltn )
    {
        rememberChangedField("OilProdnVolAtWellOrWellCompltn", this.oilProdnVolAtWellOrWellCompltn);
        this.oilProdnVolAtWellOrWellCompltn = oilProdnVolAtWellOrWellCompltn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     *
     * @param volumeUnit
     *            Unit of Measurement
     */
    public void setVolumeUnit( @Nullable final String volumeUnit )
    {
        rememberChangedField("VolumeUnit", this.volumeUnit);
        this.volumeUnit = volumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AllocationFrequency</b>
     * </p>
     *
     * @param allocationFrequency
     *            Unit of Measurement
     */
    public void setAllocationFrequency( @Nullable final String allocationFrequency )
    {
        rememberChangedField("AllocationFrequency", this.allocationFrequency);
        this.allocationFrequency = allocationFrequency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProductionVolume";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Well", getWell());
        result.put("WellCompletion", getWellCompletion());
        result.put("ProductionDate", getProductionDate());
        result.put("OilAllocAtWellCompltnDateTime", getOilAllocAtWellCompltnDateTime());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Well", getWell());
        values.put("WellCompletion", getWellCompletion());
        values.put("ProductionDate", getProductionDate());
        values.put("OilAllocAtWellCompltnDateTime", getOilAllocAtWellCompltnDateTime());
        values.put("WellDescription", getWellDescription());
        values.put("WellCompletionDescription", getWellCompletionDescription());
        values.put("CompanyCode", getCompanyCode());
        values.put("ControllingArea", getControllingArea());
        values.put("OilProdnVolAtWellOrWellCompltn", getOilProdnVolAtWellOrWellCompltn());
        values.put("VolumeUnit", getVolumeUnit());
        values.put("AllocationFrequency", getAllocationFrequency());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Well") ) {
                final Object value = values.remove("Well");
                if( (value == null) || (!value.equals(getWell())) ) {
                    setWell(((String) value));
                }
            }
            if( values.containsKey("WellCompletion") ) {
                final Object value = values.remove("WellCompletion");
                if( (value == null) || (!value.equals(getWellCompletion())) ) {
                    setWellCompletion(((String) value));
                }
            }
            if( values.containsKey("ProductionDate") ) {
                final Object value = values.remove("ProductionDate");
                if( (value == null) || (!value.equals(getProductionDate())) ) {
                    setProductionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OilAllocAtWellCompltnDateTime") ) {
                final Object value = values.remove("OilAllocAtWellCompltnDateTime");
                if( (value == null) || (!value.equals(getOilAllocAtWellCompltnDateTime())) ) {
                    setOilAllocAtWellCompltnDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("WellDescription") ) {
                final Object value = values.remove("WellDescription");
                if( (value == null) || (!value.equals(getWellDescription())) ) {
                    setWellDescription(((String) value));
                }
            }
            if( values.containsKey("WellCompletionDescription") ) {
                final Object value = values.remove("WellCompletionDescription");
                if( (value == null) || (!value.equals(getWellCompletionDescription())) ) {
                    setWellCompletionDescription(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("OilProdnVolAtWellOrWellCompltn") ) {
                final Object value = values.remove("OilProdnVolAtWellOrWellCompltn");
                if( (value == null) || (!value.equals(getOilProdnVolAtWellOrWellCompltn())) ) {
                    setOilProdnVolAtWellOrWellCompltn(((BigDecimal) value));
                }
            }
            if( values.containsKey("VolumeUnit") ) {
                final Object value = values.remove("VolumeUnit");
                if( (value == null) || (!value.equals(getVolumeUnit())) ) {
                    setVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("AllocationFrequency") ) {
                final Object value = values.remove("AllocationFrequency");
                if( (value == null) || (!value.equals(getAllocationFrequency())) ) {
                    setAllocationFrequency(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductionVolumeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductionVolumeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductionVolumeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductionVolumeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionVolumeCaptureService.DEFAULT_SERVICE_PATH);
    }

}
