/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ProductionVolumeCaptureServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionVolumeCaptureService
 * ProductionVolumeCaptureService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultProductionVolumeCaptureServiceBatch
    extends
    BatchFluentHelperBasic<ProductionVolumeCaptureServiceBatch, ProductionVolumeCaptureServiceBatchChangeSet>
    implements
    ProductionVolumeCaptureServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionVolumeCaptureService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultProductionVolumeCaptureServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductionVolumeCaptureServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionVolumeCaptureService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionVolumeCaptureService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultProductionVolumeCaptureServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductionVolumeCaptureServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionVolumeCaptureService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultProductionVolumeCaptureServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductionVolumeCaptureServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultProductionVolumeCaptureServiceBatchChangeSet(this, service);
    }

}
