/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume;

/**
 * Implementation of the {@link ProductionVolumeCaptureServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionVolumeCaptureService
 * ProductionVolumeCaptureService}.
 *
 */
public class DefaultProductionVolumeCaptureServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProductionVolumeCaptureServiceBatch, ProductionVolumeCaptureServiceBatchChangeSet>
    implements
    ProductionVolumeCaptureServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionVolumeCaptureService service;

    @SuppressWarnings( "deprecation" )
    DefaultProductionVolumeCaptureServiceBatchChangeSet(
        @Nonnull final DefaultProductionVolumeCaptureServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionVolumeCaptureService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProductionVolumeCaptureServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductionVolumeCaptureServiceBatchChangeSet createProductionVolume(
        @Nonnull final ProductionVolume productionVolume )
    {
        return addRequestCreate(service::createProductionVolume, productionVolume);
    }

}
