/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume
 * ProductionVolume}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.field.ProductionVolumeField
 * ProductionVolumeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.link.ProductionVolumeLink
 * ProductionVolumeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume#WELL
 * WELL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume#WELL_COMPLETION
 * WELL_COMPLETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume#PRODUCTION_DATE
 * PRODUCTION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume#OIL_ALLOC_AT_WELL_COMPLTN_DATE_TIME
 * OIL_ALLOC_AT_WELL_COMPLTN_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume#WELL_DESCRIPTION
 * WELL_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume#WELL_COMPLETION_DESCRIPTION
 * WELL_COMPLETION_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume#OIL_PRODN_VOL_AT_WELL_OR_WELL_COMPLTN
 * OIL_PRODN_VOL_AT_WELL_OR_WELL_COMPLTN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume#VOLUME_UNIT
 * VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume#ALLOCATION_FREQUENCY
 * ALLOCATION_FREQUENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * </ul>
 *
 */
public interface ProductionVolumeSelectable extends EntitySelectable<ProductionVolume>
{

}
