/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductMLAccountField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductMLAccountSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Material Ledger Account
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductMLAccountType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductMLAccount extends VdmEntity<ProductMLAccount>
{

    /**
     * Selector for all available fields of ProductMLAccount.
     *
     */
    public final static ProductMLAccountSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductMLAccountField<String> PRODUCT = new ProductMLAccountField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @return Valuation Area
     */
    @Key
    @SerializedName( "ValuationArea" )
    @JsonProperty( "ValuationArea" )
    @Nullable
    @ODataField( odataName = "ValuationArea" )
    private String valuationArea;
    /**
     * Use with available fluent helpers to apply the <b>ValuationArea</b> field to query operations.
     *
     */
    public final static ProductMLAccountField<String> VALUATION_AREA =
        new ProductMLAccountField<String>("ValuationArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @return Valuation Type
     */
    @Key
    @SerializedName( "ValuationType" )
    @JsonProperty( "ValuationType" )
    @Nullable
    @ODataField( odataName = "ValuationType" )
    private String valuationType;
    /**
     * Use with available fluent helpers to apply the <b>ValuationType</b> field to query operations.
     *
     */
    public final static ProductMLAccountField<String> VALUATION_TYPE =
        new ProductMLAccountField<String>("ValuationType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CurrencyRole</b>
     * </p>
     *
     * @return External Currency Type and Valuation View
     */
    @Key
    @SerializedName( "CurrencyRole" )
    @JsonProperty( "CurrencyRole" )
    @Nullable
    @ODataField( odataName = "CurrencyRole" )
    private String currencyRole;
    /**
     * Use with available fluent helpers to apply the <b>CurrencyRole</b> field to query operations.
     *
     */
    public final static ProductMLAccountField<String> CURRENCY_ROLE = new ProductMLAccountField<String>("CurrencyRole");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ProductMLAccountField<String> CURRENCY = new ProductMLAccountField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductPriceControl</b>
     * </p>
     *
     * @return Price control indicator
     */
    @SerializedName( "ProductPriceControl" )
    @JsonProperty( "ProductPriceControl" )
    @Nullable
    @ODataField( odataName = "ProductPriceControl" )
    private String productPriceControl;
    /**
     * Use with available fluent helpers to apply the <b>ProductPriceControl</b> field to query operations.
     *
     */
    public final static ProductMLAccountField<String> PRODUCT_PRICE_CONTROL =
        new ProductMLAccountField<String>("ProductPriceControl");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PriceUnitQty</b>
     * </p>
     *
     * @return Price unit
     */
    @SerializedName( "PriceUnitQty" )
    @JsonProperty( "PriceUnitQty" )
    @Nullable
    @ODataField( odataName = "PriceUnitQty" )
    private BigDecimal priceUnitQty;
    /**
     * Use with available fluent helpers to apply the <b>PriceUnitQty</b> field to query operations.
     *
     */
    public final static ProductMLAccountField<BigDecimal> PRICE_UNIT_QTY =
        new ProductMLAccountField<BigDecimal>("PriceUnitQty");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MovingAveragePrice</b>
     * </p>
     *
     * @return Periodic unit price
     */
    @SerializedName( "MovingAveragePrice" )
    @JsonProperty( "MovingAveragePrice" )
    @Nullable
    @ODataField( odataName = "MovingAveragePrice" )
    private BigDecimal movingAveragePrice;
    /**
     * Use with available fluent helpers to apply the <b>MovingAveragePrice</b> field to query operations.
     *
     */
    public final static ProductMLAccountField<BigDecimal> MOVING_AVERAGE_PRICE =
        new ProductMLAccountField<BigDecimal>("MovingAveragePrice");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardPrice</b>
     * </p>
     *
     * @return Standard price
     */
    @SerializedName( "StandardPrice" )
    @JsonProperty( "StandardPrice" )
    @Nullable
    @ODataField( odataName = "StandardPrice" )
    private BigDecimal standardPrice;
    /**
     * Use with available fluent helpers to apply the <b>StandardPrice</b> field to query operations.
     *
     */
    public final static ProductMLAccountField<BigDecimal> STANDARD_PRICE =
        new ProductMLAccountField<BigDecimal>("StandardPrice");

    @Nonnull
    @Override
    public Class<ProductMLAccount> getType()
    {
        return ProductMLAccount.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @param valuationArea
     *            Valuation Area
     */
    public void setValuationArea( @Nullable final String valuationArea )
    {
        rememberChangedField("ValuationArea", this.valuationArea);
        this.valuationArea = valuationArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @param valuationType
     *            Valuation Type
     */
    public void setValuationType( @Nullable final String valuationType )
    {
        rememberChangedField("ValuationType", this.valuationType);
        this.valuationType = valuationType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CurrencyRole</b>
     * </p>
     *
     * @param currencyRole
     *            External Currency Type and Valuation View
     */
    public void setCurrencyRole( @Nullable final String currencyRole )
    {
        rememberChangedField("CurrencyRole", this.currencyRole);
        this.currencyRole = currencyRole;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductPriceControl</b>
     * </p>
     *
     * @param productPriceControl
     *            Price control indicator
     */
    public void setProductPriceControl( @Nullable final String productPriceControl )
    {
        rememberChangedField("ProductPriceControl", this.productPriceControl);
        this.productPriceControl = productPriceControl;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PriceUnitQty</b>
     * </p>
     *
     * @param priceUnitQty
     *            Price unit
     */
    public void setPriceUnitQty( @Nullable final BigDecimal priceUnitQty )
    {
        rememberChangedField("PriceUnitQty", this.priceUnitQty);
        this.priceUnitQty = priceUnitQty;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MovingAveragePrice</b>
     * </p>
     *
     * @param movingAveragePrice
     *            Periodic unit price
     */
    public void setMovingAveragePrice( @Nullable final BigDecimal movingAveragePrice )
    {
        rememberChangedField("MovingAveragePrice", this.movingAveragePrice);
        this.movingAveragePrice = movingAveragePrice;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardPrice</b>
     * </p>
     *
     * @param standardPrice
     *            Standard price
     */
    public void setStandardPrice( @Nullable final BigDecimal standardPrice )
    {
        rememberChangedField("StandardPrice", this.standardPrice);
        this.standardPrice = standardPrice;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductMLAccount";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("ValuationArea", getValuationArea());
        result.put("ValuationType", getValuationType());
        result.put("CurrencyRole", getCurrencyRole());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("ValuationArea", getValuationArea());
        values.put("ValuationType", getValuationType());
        values.put("CurrencyRole", getCurrencyRole());
        values.put("Currency", getCurrency());
        values.put("ProductPriceControl", getProductPriceControl());
        values.put("PriceUnitQty", getPriceUnitQty());
        values.put("MovingAveragePrice", getMovingAveragePrice());
        values.put("StandardPrice", getStandardPrice());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("ValuationArea") ) {
                final Object value = values.remove("ValuationArea");
                if( (value == null) || (!value.equals(getValuationArea())) ) {
                    setValuationArea(((String) value));
                }
            }
            if( values.containsKey("ValuationType") ) {
                final Object value = values.remove("ValuationType");
                if( (value == null) || (!value.equals(getValuationType())) ) {
                    setValuationType(((String) value));
                }
            }
            if( values.containsKey("CurrencyRole") ) {
                final Object value = values.remove("CurrencyRole");
                if( (value == null) || (!value.equals(getCurrencyRole())) ) {
                    setCurrencyRole(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("ProductPriceControl") ) {
                final Object value = values.remove("ProductPriceControl");
                if( (value == null) || (!value.equals(getProductPriceControl())) ) {
                    setProductPriceControl(((String) value));
                }
            }
            if( values.containsKey("PriceUnitQty") ) {
                final Object value = values.remove("PriceUnitQty");
                if( (value == null) || (!value.equals(getPriceUnitQty())) ) {
                    setPriceUnitQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("MovingAveragePrice") ) {
                final Object value = values.remove("MovingAveragePrice");
                if( (value == null) || (!value.equals(getMovingAveragePrice())) ) {
                    setMovingAveragePrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("StandardPrice") ) {
                final Object value = values.remove("StandardPrice");
                if( (value == null) || (!value.equals(getStandardPrice())) ) {
                    setStandardPrice(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductMLAccountField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductMLAccountField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductMLAccountField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductMLAccountField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
