/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductMLPricesField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductMLPricesSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Material Ledger Prices
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductMLPricesType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductMLPrices extends VdmEntity<ProductMLPrices>
{

    /**
     * Selector for all available fields of ProductMLPrices.
     *
     */
    public final static ProductMLPricesSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductMLPricesField<String> PRODUCT = new ProductMLPricesField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @return Valuation Area
     */
    @Key
    @SerializedName( "ValuationArea" )
    @JsonProperty( "ValuationArea" )
    @Nullable
    @ODataField( odataName = "ValuationArea" )
    private String valuationArea;
    /**
     * Use with available fluent helpers to apply the <b>ValuationArea</b> field to query operations.
     *
     */
    public final static ProductMLPricesField<String> VALUATION_AREA = new ProductMLPricesField<String>("ValuationArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @return Valuation Type
     */
    @Key
    @SerializedName( "ValuationType" )
    @JsonProperty( "ValuationType" )
    @Nullable
    @ODataField( odataName = "ValuationType" )
    private String valuationType;
    /**
     * Use with available fluent helpers to apply the <b>ValuationType</b> field to query operations.
     *
     */
    public final static ProductMLPricesField<String> VALUATION_TYPE = new ProductMLPricesField<String>("ValuationType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CurrencyRole</b>
     * </p>
     *
     * @return External Currency Type and Valuation View
     */
    @Key
    @SerializedName( "CurrencyRole" )
    @JsonProperty( "CurrencyRole" )
    @Nullable
    @ODataField( odataName = "CurrencyRole" )
    private String currencyRole;
    /**
     * Use with available fluent helpers to apply the <b>CurrencyRole</b> field to query operations.
     *
     */
    public final static ProductMLPricesField<String> CURRENCY_ROLE = new ProductMLPricesField<String>("CurrencyRole");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ProductMLPricesField<String> CURRENCY = new ProductMLPricesField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FuturePrice</b>
     * </p>
     *
     * @return Future Price
     */
    @SerializedName( "FuturePrice" )
    @JsonProperty( "FuturePrice" )
    @Nullable
    @ODataField( odataName = "FuturePrice" )
    private BigDecimal futurePrice;
    /**
     * Use with available fluent helpers to apply the <b>FuturePrice</b> field to query operations.
     *
     */
    public final static ProductMLPricesField<BigDecimal> FUTURE_PRICE =
        new ProductMLPricesField<BigDecimal>("FuturePrice");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FuturePriceValidityStartDate</b>
     * </p>
     *
     * @return Date from Which a Future Valuation Price Is to Be Valid
     */
    @SerializedName( "FuturePriceValidityStartDate" )
    @JsonProperty( "FuturePriceValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FuturePriceValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime futurePriceValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>FuturePriceValidityStartDate</b> field to query operations.
     *
     */
    public final static ProductMLPricesField<LocalDateTime> FUTURE_PRICE_VALIDITY_START_DATE =
        new ProductMLPricesField<LocalDateTime>("FuturePriceValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPrice</b>
     * </p>
     *
     * @return Cost
     */
    @SerializedName( "PlannedPrice" )
    @JsonProperty( "PlannedPrice" )
    @Nullable
    @ODataField( odataName = "PlannedPrice" )
    private BigDecimal plannedPrice;
    /**
     * Use with available fluent helpers to apply the <b>PlannedPrice</b> field to query operations.
     *
     */
    public final static ProductMLPricesField<BigDecimal> PLANNED_PRICE =
        new ProductMLPricesField<BigDecimal>("PlannedPrice");

    @Nonnull
    @Override
    public Class<ProductMLPrices> getType()
    {
        return ProductMLPrices.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @param valuationArea
     *            Valuation Area
     */
    public void setValuationArea( @Nullable final String valuationArea )
    {
        rememberChangedField("ValuationArea", this.valuationArea);
        this.valuationArea = valuationArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @param valuationType
     *            Valuation Type
     */
    public void setValuationType( @Nullable final String valuationType )
    {
        rememberChangedField("ValuationType", this.valuationType);
        this.valuationType = valuationType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CurrencyRole</b>
     * </p>
     *
     * @param currencyRole
     *            External Currency Type and Valuation View
     */
    public void setCurrencyRole( @Nullable final String currencyRole )
    {
        rememberChangedField("CurrencyRole", this.currencyRole);
        this.currencyRole = currencyRole;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FuturePrice</b>
     * </p>
     *
     * @param futurePrice
     *            Future Price
     */
    public void setFuturePrice( @Nullable final BigDecimal futurePrice )
    {
        rememberChangedField("FuturePrice", this.futurePrice);
        this.futurePrice = futurePrice;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FuturePriceValidityStartDate</b>
     * </p>
     *
     * @param futurePriceValidityStartDate
     *            Date from Which a Future Valuation Price Is to Be Valid
     */
    public void setFuturePriceValidityStartDate( @Nullable final LocalDateTime futurePriceValidityStartDate )
    {
        rememberChangedField("FuturePriceValidityStartDate", this.futurePriceValidityStartDate);
        this.futurePriceValidityStartDate = futurePriceValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPrice</b>
     * </p>
     *
     * @param plannedPrice
     *            Cost
     */
    public void setPlannedPrice( @Nullable final BigDecimal plannedPrice )
    {
        rememberChangedField("PlannedPrice", this.plannedPrice);
        this.plannedPrice = plannedPrice;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductMLPrices";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("ValuationArea", getValuationArea());
        result.put("ValuationType", getValuationType());
        result.put("CurrencyRole", getCurrencyRole());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("ValuationArea", getValuationArea());
        values.put("ValuationType", getValuationType());
        values.put("CurrencyRole", getCurrencyRole());
        values.put("Currency", getCurrency());
        values.put("FuturePrice", getFuturePrice());
        values.put("FuturePriceValidityStartDate", getFuturePriceValidityStartDate());
        values.put("PlannedPrice", getPlannedPrice());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("ValuationArea") ) {
                final Object value = values.remove("ValuationArea");
                if( (value == null) || (!value.equals(getValuationArea())) ) {
                    setValuationArea(((String) value));
                }
            }
            if( values.containsKey("ValuationType") ) {
                final Object value = values.remove("ValuationType");
                if( (value == null) || (!value.equals(getValuationType())) ) {
                    setValuationType(((String) value));
                }
            }
            if( values.containsKey("CurrencyRole") ) {
                final Object value = values.remove("CurrencyRole");
                if( (value == null) || (!value.equals(getCurrencyRole())) ) {
                    setCurrencyRole(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("FuturePrice") ) {
                final Object value = values.remove("FuturePrice");
                if( (value == null) || (!value.equals(getFuturePrice())) ) {
                    setFuturePrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("FuturePriceValidityStartDate") ) {
                final Object value = values.remove("FuturePriceValidityStartDate");
                if( (value == null) || (!value.equals(getFuturePriceValidityStartDate())) ) {
                    setFuturePriceValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PlannedPrice") ) {
                final Object value = values.remove("PlannedPrice");
                if( (value == null) || (!value.equals(getPlannedPrice())) ) {
                    setPlannedPrice(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductMLPricesField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductMLPricesField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductMLPricesField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductMLPricesField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
