/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductPlantCostingField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductPlantCostingSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Costing Data at Plant Level
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductPlantCostingType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductPlantCosting extends VdmEntity<ProductPlantCosting>
{

    /**
     * Selector for all available fields of ProductPlantCosting.
     *
     */
    public final static ProductPlantCostingSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<String> PRODUCT = new ProductPlantCostingField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<String> PLANT = new ProductPlantCostingField<String>("Plant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCoProduct</b>
     * </p>
     *
     * @return Co-Product
     */
    @SerializedName( "IsCoProduct" )
    @JsonProperty( "IsCoProduct" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCoProduct" )
    private Boolean isCoProduct;
    /**
     * Use with available fluent helpers to apply the <b>IsCoProduct</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<Boolean> IS_CO_PRODUCT =
        new ProductPlantCostingField<Boolean>("IsCoProduct");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostingLotSize</b>
     * </p>
     *
     * @return Lot Size for Product Costing
     */
    @SerializedName( "CostingLotSize" )
    @JsonProperty( "CostingLotSize" )
    @Nullable
    @ODataField( odataName = "CostingLotSize" )
    private BigDecimal costingLotSize;
    /**
     * Use with available fluent helpers to apply the <b>CostingLotSize</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<BigDecimal> COSTING_LOT_SIZE =
        new ProductPlantCostingField<BigDecimal>("CostingLotSize");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>VarianceKey</b>
     * </p>
     *
     * @return Variance Key
     */
    @SerializedName( "VarianceKey" )
    @JsonProperty( "VarianceKey" )
    @Nullable
    @ODataField( odataName = "VarianceKey" )
    private String varianceKey;
    /**
     * Use with available fluent helpers to apply the <b>VarianceKey</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<String> VARIANCE_KEY =
        new ProductPlantCostingField<String>("VarianceKey");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<String> BASE_UNIT = new ProductPlantCostingField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     *
     * @return Group Counter
     */
    @SerializedName( "TaskListGroupCounter" )
    @JsonProperty( "TaskListGroupCounter" )
    @Nullable
    @ODataField( odataName = "TaskListGroupCounter" )
    private String taskListGroupCounter;
    /**
     * Use with available fluent helpers to apply the <b>TaskListGroupCounter</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<String> TASK_LIST_GROUP_COUNTER =
        new ProductPlantCostingField<String>("TaskListGroupCounter");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @SerializedName( "TaskListGroup" )
    @JsonProperty( "TaskListGroup" )
    @Nullable
    @ODataField( odataName = "TaskListGroup" )
    private String taskListGroup;
    /**
     * Use with available fluent helpers to apply the <b>TaskListGroup</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<String> TASK_LIST_GROUP =
        new ProductPlantCostingField<String>("TaskListGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     *
     * @return Task List Type
     */
    @SerializedName( "TaskListType" )
    @JsonProperty( "TaskListType" )
    @Nullable
    @ODataField( odataName = "TaskListType" )
    private String taskListType;
    /**
     * Use with available fluent helpers to apply the <b>TaskListType</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<String> TASK_LIST_TYPE =
        new ProductPlantCostingField<String>("TaskListType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostingProductionVersion</b>
     * </p>
     *
     * @return Production Version To Be Costed
     */
    @SerializedName( "CostingProductionVersion" )
    @JsonProperty( "CostingProductionVersion" )
    @Nullable
    @ODataField( odataName = "CostingProductionVersion" )
    private String costingProductionVersion;
    /**
     * Use with available fluent helpers to apply the <b>CostingProductionVersion</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<String> COSTING_PRODUCTION_VERSION =
        new ProductPlantCostingField<String>("CostingProductionVersion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsFixedPriceCoProduct</b>
     * </p>
     *
     * @return Fixed-Price Co-Product
     */
    @SerializedName( "IsFixedPriceCoProduct" )
    @JsonProperty( "IsFixedPriceCoProduct" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsFixedPriceCoProduct" )
    private Boolean isFixedPriceCoProduct;
    /**
     * Use with available fluent helpers to apply the <b>IsFixedPriceCoProduct</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<Boolean> IS_FIXED_PRICE_CO_PRODUCT =
        new ProductPlantCostingField<Boolean>("IsFixedPriceCoProduct");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CostingSpecialProcurementType</b>
     * </p>
     *
     * @return Special Procurement Type for Costing
     */
    @SerializedName( "CostingSpecialProcurementType" )
    @JsonProperty( "CostingSpecialProcurementType" )
    @Nullable
    @ODataField( odataName = "CostingSpecialProcurementType" )
    private String costingSpecialProcurementType;
    /**
     * Use with available fluent helpers to apply the <b>CostingSpecialProcurementType</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<String> COSTING_SPECIAL_PROCUREMENT_TYPE =
        new ProductPlantCostingField<String>("CostingSpecialProcurementType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceBOMAlternative</b>
     * </p>
     *
     * @return Alternative BOM
     */
    @SerializedName( "SourceBOMAlternative" )
    @JsonProperty( "SourceBOMAlternative" )
    @Nullable
    @ODataField( odataName = "SourceBOMAlternative" )
    private String sourceBOMAlternative;
    /**
     * Use with available fluent helpers to apply the <b>SourceBOMAlternative</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<String> SOURCE_BOM_ALTERNATIVE =
        new ProductPlantCostingField<String>("SourceBOMAlternative");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductBOMUsage</b>
     * </p>
     *
     * @return BOM Usage
     */
    @SerializedName( "ProductBOMUsage" )
    @JsonProperty( "ProductBOMUsage" )
    @Nullable
    @ODataField( odataName = "ProductBOMUsage" )
    private String productBOMUsage;
    /**
     * Use with available fluent helpers to apply the <b>ProductBOMUsage</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<String> PRODUCT_BOM_USAGE =
        new ProductPlantCostingField<String>("ProductBOMUsage");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsCostingRelevant</b>
     * </p>
     *
     * @return Do Not Cost
     */
    @SerializedName( "ProductIsCostingRelevant" )
    @JsonProperty( "ProductIsCostingRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductIsCostingRelevant" )
    private Boolean productIsCostingRelevant;
    /**
     * Use with available fluent helpers to apply the <b>ProductIsCostingRelevant</b> field to query operations.
     *
     */
    public final static ProductPlantCostingField<Boolean> PRODUCT_IS_COSTING_RELEVANT =
        new ProductPlantCostingField<Boolean>("ProductIsCostingRelevant");

    @Nonnull
    @Override
    public Class<ProductPlantCosting> getType()
    {
        return ProductPlantCosting.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCoProduct</b>
     * </p>
     *
     * @param isCoProduct
     *            Co-Product
     */
    public void setIsCoProduct( @Nullable final Boolean isCoProduct )
    {
        rememberChangedField("IsCoProduct", this.isCoProduct);
        this.isCoProduct = isCoProduct;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostingLotSize</b>
     * </p>
     *
     * @param costingLotSize
     *            Lot Size for Product Costing
     */
    public void setCostingLotSize( @Nullable final BigDecimal costingLotSize )
    {
        rememberChangedField("CostingLotSize", this.costingLotSize);
        this.costingLotSize = costingLotSize;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>VarianceKey</b>
     * </p>
     *
     * @param varianceKey
     *            Variance Key
     */
    public void setVarianceKey( @Nullable final String varianceKey )
    {
        rememberChangedField("VarianceKey", this.varianceKey);
        this.varianceKey = varianceKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     *
     * @param taskListGroupCounter
     *            Group Counter
     */
    public void setTaskListGroupCounter( @Nullable final String taskListGroupCounter )
    {
        rememberChangedField("TaskListGroupCounter", this.taskListGroupCounter);
        this.taskListGroupCounter = taskListGroupCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     *
     * @param taskListGroup
     *            Key for Task List Group
     */
    public void setTaskListGroup( @Nullable final String taskListGroup )
    {
        rememberChangedField("TaskListGroup", this.taskListGroup);
        this.taskListGroup = taskListGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     *
     * @param taskListType
     *            Task List Type
     */
    public void setTaskListType( @Nullable final String taskListType )
    {
        rememberChangedField("TaskListType", this.taskListType);
        this.taskListType = taskListType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostingProductionVersion</b>
     * </p>
     *
     * @param costingProductionVersion
     *            Production Version To Be Costed
     */
    public void setCostingProductionVersion( @Nullable final String costingProductionVersion )
    {
        rememberChangedField("CostingProductionVersion", this.costingProductionVersion);
        this.costingProductionVersion = costingProductionVersion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsFixedPriceCoProduct</b>
     * </p>
     *
     * @param isFixedPriceCoProduct
     *            Fixed-Price Co-Product
     */
    public void setIsFixedPriceCoProduct( @Nullable final Boolean isFixedPriceCoProduct )
    {
        rememberChangedField("IsFixedPriceCoProduct", this.isFixedPriceCoProduct);
        this.isFixedPriceCoProduct = isFixedPriceCoProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CostingSpecialProcurementType</b>
     * </p>
     *
     * @param costingSpecialProcurementType
     *            Special Procurement Type for Costing
     */
    public void setCostingSpecialProcurementType( @Nullable final String costingSpecialProcurementType )
    {
        rememberChangedField("CostingSpecialProcurementType", this.costingSpecialProcurementType);
        this.costingSpecialProcurementType = costingSpecialProcurementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceBOMAlternative</b>
     * </p>
     *
     * @param sourceBOMAlternative
     *            Alternative BOM
     */
    public void setSourceBOMAlternative( @Nullable final String sourceBOMAlternative )
    {
        rememberChangedField("SourceBOMAlternative", this.sourceBOMAlternative);
        this.sourceBOMAlternative = sourceBOMAlternative;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductBOMUsage</b>
     * </p>
     *
     * @param productBOMUsage
     *            BOM Usage
     */
    public void setProductBOMUsage( @Nullable final String productBOMUsage )
    {
        rememberChangedField("ProductBOMUsage", this.productBOMUsage);
        this.productBOMUsage = productBOMUsage;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsCostingRelevant</b>
     * </p>
     *
     * @param productIsCostingRelevant
     *            Do Not Cost
     */
    public void setProductIsCostingRelevant( @Nullable final Boolean productIsCostingRelevant )
    {
        rememberChangedField("ProductIsCostingRelevant", this.productIsCostingRelevant);
        this.productIsCostingRelevant = productIsCostingRelevant;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductPlantCosting";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("IsCoProduct", getIsCoProduct());
        values.put("CostingLotSize", getCostingLotSize());
        values.put("VarianceKey", getVarianceKey());
        values.put("BaseUnit", getBaseUnit());
        values.put("TaskListGroupCounter", getTaskListGroupCounter());
        values.put("TaskListGroup", getTaskListGroup());
        values.put("TaskListType", getTaskListType());
        values.put("CostingProductionVersion", getCostingProductionVersion());
        values.put("IsFixedPriceCoProduct", getIsFixedPriceCoProduct());
        values.put("CostingSpecialProcurementType", getCostingSpecialProcurementType());
        values.put("SourceBOMAlternative", getSourceBOMAlternative());
        values.put("ProductBOMUsage", getProductBOMUsage());
        values.put("ProductIsCostingRelevant", getProductIsCostingRelevant());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("IsCoProduct") ) {
                final Object value = values.remove("IsCoProduct");
                if( (value == null) || (!value.equals(getIsCoProduct())) ) {
                    setIsCoProduct(((Boolean) value));
                }
            }
            if( values.containsKey("CostingLotSize") ) {
                final Object value = values.remove("CostingLotSize");
                if( (value == null) || (!value.equals(getCostingLotSize())) ) {
                    setCostingLotSize(((BigDecimal) value));
                }
            }
            if( values.containsKey("VarianceKey") ) {
                final Object value = values.remove("VarianceKey");
                if( (value == null) || (!value.equals(getVarianceKey())) ) {
                    setVarianceKey(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("TaskListGroupCounter") ) {
                final Object value = values.remove("TaskListGroupCounter");
                if( (value == null) || (!value.equals(getTaskListGroupCounter())) ) {
                    setTaskListGroupCounter(((String) value));
                }
            }
            if( values.containsKey("TaskListGroup") ) {
                final Object value = values.remove("TaskListGroup");
                if( (value == null) || (!value.equals(getTaskListGroup())) ) {
                    setTaskListGroup(((String) value));
                }
            }
            if( values.containsKey("TaskListType") ) {
                final Object value = values.remove("TaskListType");
                if( (value == null) || (!value.equals(getTaskListType())) ) {
                    setTaskListType(((String) value));
                }
            }
            if( values.containsKey("CostingProductionVersion") ) {
                final Object value = values.remove("CostingProductionVersion");
                if( (value == null) || (!value.equals(getCostingProductionVersion())) ) {
                    setCostingProductionVersion(((String) value));
                }
            }
            if( values.containsKey("IsFixedPriceCoProduct") ) {
                final Object value = values.remove("IsFixedPriceCoProduct");
                if( (value == null) || (!value.equals(getIsFixedPriceCoProduct())) ) {
                    setIsFixedPriceCoProduct(((Boolean) value));
                }
            }
            if( values.containsKey("CostingSpecialProcurementType") ) {
                final Object value = values.remove("CostingSpecialProcurementType");
                if( (value == null) || (!value.equals(getCostingSpecialProcurementType())) ) {
                    setCostingSpecialProcurementType(((String) value));
                }
            }
            if( values.containsKey("SourceBOMAlternative") ) {
                final Object value = values.remove("SourceBOMAlternative");
                if( (value == null) || (!value.equals(getSourceBOMAlternative())) ) {
                    setSourceBOMAlternative(((String) value));
                }
            }
            if( values.containsKey("ProductBOMUsage") ) {
                final Object value = values.remove("ProductBOMUsage");
                if( (value == null) || (!value.equals(getProductBOMUsage())) ) {
                    setProductBOMUsage(((String) value));
                }
            }
            if( values.containsKey("ProductIsCostingRelevant") ) {
                final Object value = values.remove("ProductIsCostingRelevant");
                if( (value == null) || (!value.equals(getProductIsCostingRelevant())) ) {
                    setProductIsCostingRelevant(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductPlantCostingField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductPlantCostingField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductPlantCostingField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductPlantCostingField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
