/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductPlantForecastingField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductPlantForecastingSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Forecasting Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductPlantForecastingType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductPlantForecasting extends VdmEntity<ProductPlantForecasting>
{

    /**
     * Selector for all available fields of ProductPlantForecasting.
     *
     */
    public final static ProductPlantForecastingSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductPlantForecastingField<String> PRODUCT =
        new ProductPlantForecastingField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductPlantForecastingField<String> PLANT = new ProductPlantForecastingField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionRefUsageEndDate</b>
     * </p>
     *
     * @return To date of the material to be copied for consumption
     */
    @SerializedName( "ConsumptionRefUsageEndDate" )
    @JsonProperty( "ConsumptionRefUsageEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConsumptionRefUsageEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime consumptionRefUsageEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionRefUsageEndDate</b> field to query operations.
     *
     */
    public final static ProductPlantForecastingField<LocalDateTime> CONSUMPTION_REF_USAGE_END_DATE =
        new ProductPlantForecastingField<LocalDateTime>("ConsumptionRefUsageEndDate");
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionQtyMultiplier</b>
     * </p>
     *
     * @return Multiplier for reference material for consumption
     */
    @SerializedName( "ConsumptionQtyMultiplier" )
    @JsonProperty( "ConsumptionQtyMultiplier" )
    @Nullable
    @ODataField( odataName = "ConsumptionQtyMultiplier" )
    private BigDecimal consumptionQtyMultiplier;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionQtyMultiplier</b> field to query operations.
     *
     */
    public final static ProductPlantForecastingField<BigDecimal> CONSUMPTION_QTY_MULTIPLIER =
        new ProductPlantForecastingField<BigDecimal>("ConsumptionQtyMultiplier");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionReferenceProduct</b>
     * </p>
     *
     * @return Reference material for consumption
     */
    @SerializedName( "ConsumptionReferenceProduct" )
    @JsonProperty( "ConsumptionReferenceProduct" )
    @Nullable
    @ODataField( odataName = "ConsumptionReferenceProduct" )
    private String consumptionReferenceProduct;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionReferenceProduct</b> field to query operations.
     *
     */
    public final static ProductPlantForecastingField<String> CONSUMPTION_REFERENCE_PRODUCT =
        new ProductPlantForecastingField<String>("ConsumptionReferenceProduct");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionReferencePlant</b>
     * </p>
     *
     * @return Reference plant for consumption
     */
    @SerializedName( "ConsumptionReferencePlant" )
    @JsonProperty( "ConsumptionReferencePlant" )
    @Nullable
    @ODataField( odataName = "ConsumptionReferencePlant" )
    private String consumptionReferencePlant;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionReferencePlant</b> field to query operations.
     *
     */
    public final static ProductPlantForecastingField<String> CONSUMPTION_REFERENCE_PLANT =
        new ProductPlantForecastingField<String>("ConsumptionReferencePlant");

    @Nonnull
    @Override
    public Class<ProductPlantForecasting> getType()
    {
        return ProductPlantForecasting.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionRefUsageEndDate</b>
     * </p>
     *
     * @param consumptionRefUsageEndDate
     *            To date of the material to be copied for consumption
     */
    public void setConsumptionRefUsageEndDate( @Nullable final LocalDateTime consumptionRefUsageEndDate )
    {
        rememberChangedField("ConsumptionRefUsageEndDate", this.consumptionRefUsageEndDate);
        this.consumptionRefUsageEndDate = consumptionRefUsageEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionQtyMultiplier</b>
     * </p>
     *
     * @param consumptionQtyMultiplier
     *            Multiplier for reference material for consumption
     */
    public void setConsumptionQtyMultiplier( @Nullable final BigDecimal consumptionQtyMultiplier )
    {
        rememberChangedField("ConsumptionQtyMultiplier", this.consumptionQtyMultiplier);
        this.consumptionQtyMultiplier = consumptionQtyMultiplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionReferenceProduct</b>
     * </p>
     *
     * @param consumptionReferenceProduct
     *            Reference material for consumption
     */
    public void setConsumptionReferenceProduct( @Nullable final String consumptionReferenceProduct )
    {
        rememberChangedField("ConsumptionReferenceProduct", this.consumptionReferenceProduct);
        this.consumptionReferenceProduct = consumptionReferenceProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionReferencePlant</b>
     * </p>
     *
     * @param consumptionReferencePlant
     *            Reference plant for consumption
     */
    public void setConsumptionReferencePlant( @Nullable final String consumptionReferencePlant )
    {
        rememberChangedField("ConsumptionReferencePlant", this.consumptionReferencePlant);
        this.consumptionReferencePlant = consumptionReferencePlant;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductPlantForecasting";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("ConsumptionRefUsageEndDate", getConsumptionRefUsageEndDate());
        values.put("ConsumptionQtyMultiplier", getConsumptionQtyMultiplier());
        values.put("ConsumptionReferenceProduct", getConsumptionReferenceProduct());
        values.put("ConsumptionReferencePlant", getConsumptionReferencePlant());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ConsumptionRefUsageEndDate") ) {
                final Object value = values.remove("ConsumptionRefUsageEndDate");
                if( (value == null) || (!value.equals(getConsumptionRefUsageEndDate())) ) {
                    setConsumptionRefUsageEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConsumptionQtyMultiplier") ) {
                final Object value = values.remove("ConsumptionQtyMultiplier");
                if( (value == null) || (!value.equals(getConsumptionQtyMultiplier())) ) {
                    setConsumptionQtyMultiplier(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConsumptionReferenceProduct") ) {
                final Object value = values.remove("ConsumptionReferenceProduct");
                if( (value == null) || (!value.equals(getConsumptionReferenceProduct())) ) {
                    setConsumptionReferenceProduct(((String) value));
                }
            }
            if( values.containsKey("ConsumptionReferencePlant") ) {
                final Object value = values.remove("ConsumptionReferencePlant");
                if( (value == null) || (!value.equals(getConsumptionReferencePlant())) ) {
                    setConsumptionReferencePlant(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductPlantForecastingField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductPlantForecastingField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductPlantForecastingField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductPlantForecastingField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
