/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductPlantIntlTrdField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductPlantIntlTrdSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * International Trade Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductPlantIntlTrdType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductPlantIntlTrd extends VdmEntity<ProductPlantIntlTrd>
{

    /**
     * Selector for all available fields of ProductPlantIntlTrd.
     *
     */
    public final static ProductPlantIntlTrdSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductPlantIntlTrdField<String> PRODUCT = new ProductPlantIntlTrdField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductPlantIntlTrdField<String> PLANT = new ProductPlantIntlTrdField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryOfOrigin</b>
     * </p>
     *
     * @return Country/Region of Origin of Product
     */
    @SerializedName( "CountryOfOrigin" )
    @JsonProperty( "CountryOfOrigin" )
    @Nullable
    @ODataField( odataName = "CountryOfOrigin" )
    private String countryOfOrigin;
    /**
     * Use with available fluent helpers to apply the <b>CountryOfOrigin</b> field to query operations.
     *
     */
    public final static ProductPlantIntlTrdField<String> COUNTRY_OF_ORIGIN =
        new ProductPlantIntlTrdField<String>("CountryOfOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RegionOfOrigin</b>
     * </p>
     *
     * @return Region of Origin
     */
    @SerializedName( "RegionOfOrigin" )
    @JsonProperty( "RegionOfOrigin" )
    @Nullable
    @ODataField( odataName = "RegionOfOrigin" )
    private String regionOfOrigin;
    /**
     * Use with available fluent helpers to apply the <b>RegionOfOrigin</b> field to query operations.
     *
     */
    public final static ProductPlantIntlTrdField<String> REGION_OF_ORIGIN =
        new ProductPlantIntlTrdField<String>("RegionOfOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionTaxCtrlCode</b>
     * </p>
     *
     * @return Control code for consumption taxes in foreign trade
     */
    @SerializedName( "ConsumptionTaxCtrlCode" )
    @JsonProperty( "ConsumptionTaxCtrlCode" )
    @Nullable
    @ODataField( odataName = "ConsumptionTaxCtrlCode" )
    private String consumptionTaxCtrlCode;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionTaxCtrlCode</b> field to query operations.
     *
     */
    public final static ProductPlantIntlTrdField<String> CONSUMPTION_TAX_CTRL_CODE =
        new ProductPlantIntlTrdField<String>("ConsumptionTaxCtrlCode");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>ProductCASNumber</b>
     * </p>
     *
     * @return CAS number for pharmaceutical products in foreign trade
     */
    @SerializedName( "ProductCASNumber" )
    @JsonProperty( "ProductCASNumber" )
    @Nullable
    @ODataField( odataName = "ProductCASNumber" )
    private String productCASNumber;
    /**
     * Use with available fluent helpers to apply the <b>ProductCASNumber</b> field to query operations.
     *
     */
    public final static ProductPlantIntlTrdField<String> PRODUCT_CAS_NUMBER =
        new ProductPlantIntlTrdField<String>("ProductCASNumber");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProdIntlTradeClassification</b>
     * </p>
     *
     * @return Production statistics: PRODCOM number for foreign trade
     */
    @SerializedName( "ProdIntlTradeClassification" )
    @JsonProperty( "ProdIntlTradeClassification" )
    @Nullable
    @ODataField( odataName = "ProdIntlTradeClassification" )
    private String prodIntlTradeClassification;
    /**
     * Use with available fluent helpers to apply the <b>ProdIntlTradeClassification</b> field to query operations.
     *
     */
    public final static ProductPlantIntlTrdField<String> PROD_INTL_TRADE_CLASSIFICATION =
        new ProductPlantIntlTrdField<String>("ProdIntlTradeClassification");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ExportAndImportProductGroup</b>
     * </p>
     *
     * @return Material Group for Intrastat
     */
    @SerializedName( "ExportAndImportProductGroup" )
    @JsonProperty( "ExportAndImportProductGroup" )
    @Nullable
    @ODataField( odataName = "ExportAndImportProductGroup" )
    private String exportAndImportProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>ExportAndImportProductGroup</b> field to query operations.
     *
     */
    public final static ProductPlantIntlTrdField<String> EXPORT_AND_IMPORT_PRODUCT_GROUP =
        new ProductPlantIntlTrdField<String>("ExportAndImportProductGroup");

    @Nonnull
    @Override
    public Class<ProductPlantIntlTrd> getType()
    {
        return ProductPlantIntlTrd.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryOfOrigin</b>
     * </p>
     *
     * @param countryOfOrigin
     *            Country/Region of Origin of Product
     */
    public void setCountryOfOrigin( @Nullable final String countryOfOrigin )
    {
        rememberChangedField("CountryOfOrigin", this.countryOfOrigin);
        this.countryOfOrigin = countryOfOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RegionOfOrigin</b>
     * </p>
     *
     * @param regionOfOrigin
     *            Region of Origin
     */
    public void setRegionOfOrigin( @Nullable final String regionOfOrigin )
    {
        rememberChangedField("RegionOfOrigin", this.regionOfOrigin);
        this.regionOfOrigin = regionOfOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionTaxCtrlCode</b>
     * </p>
     *
     * @param consumptionTaxCtrlCode
     *            Control code for consumption taxes in foreign trade
     */
    public void setConsumptionTaxCtrlCode( @Nullable final String consumptionTaxCtrlCode )
    {
        rememberChangedField("ConsumptionTaxCtrlCode", this.consumptionTaxCtrlCode);
        this.consumptionTaxCtrlCode = consumptionTaxCtrlCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>ProductCASNumber</b>
     * </p>
     *
     * @param productCASNumber
     *            CAS number for pharmaceutical products in foreign trade
     */
    public void setProductCASNumber( @Nullable final String productCASNumber )
    {
        rememberChangedField("ProductCASNumber", this.productCASNumber);
        this.productCASNumber = productCASNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProdIntlTradeClassification</b>
     * </p>
     *
     * @param prodIntlTradeClassification
     *            Production statistics: PRODCOM number for foreign trade
     */
    public void setProdIntlTradeClassification( @Nullable final String prodIntlTradeClassification )
    {
        rememberChangedField("ProdIntlTradeClassification", this.prodIntlTradeClassification);
        this.prodIntlTradeClassification = prodIntlTradeClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ExportAndImportProductGroup</b>
     * </p>
     *
     * @param exportAndImportProductGroup
     *            Material Group for Intrastat
     */
    public void setExportAndImportProductGroup( @Nullable final String exportAndImportProductGroup )
    {
        rememberChangedField("ExportAndImportProductGroup", this.exportAndImportProductGroup);
        this.exportAndImportProductGroup = exportAndImportProductGroup;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductPlantIntlTrd";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("CountryOfOrigin", getCountryOfOrigin());
        values.put("RegionOfOrigin", getRegionOfOrigin());
        values.put("ConsumptionTaxCtrlCode", getConsumptionTaxCtrlCode());
        values.put("ProductCASNumber", getProductCASNumber());
        values.put("ProdIntlTradeClassification", getProdIntlTradeClassification());
        values.put("ExportAndImportProductGroup", getExportAndImportProductGroup());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("CountryOfOrigin") ) {
                final Object value = values.remove("CountryOfOrigin");
                if( (value == null) || (!value.equals(getCountryOfOrigin())) ) {
                    setCountryOfOrigin(((String) value));
                }
            }
            if( values.containsKey("RegionOfOrigin") ) {
                final Object value = values.remove("RegionOfOrigin");
                if( (value == null) || (!value.equals(getRegionOfOrigin())) ) {
                    setRegionOfOrigin(((String) value));
                }
            }
            if( values.containsKey("ConsumptionTaxCtrlCode") ) {
                final Object value = values.remove("ConsumptionTaxCtrlCode");
                if( (value == null) || (!value.equals(getConsumptionTaxCtrlCode())) ) {
                    setConsumptionTaxCtrlCode(((String) value));
                }
            }
            if( values.containsKey("ProductCASNumber") ) {
                final Object value = values.remove("ProductCASNumber");
                if( (value == null) || (!value.equals(getProductCASNumber())) ) {
                    setProductCASNumber(((String) value));
                }
            }
            if( values.containsKey("ProdIntlTradeClassification") ) {
                final Object value = values.remove("ProdIntlTradeClassification");
                if( (value == null) || (!value.equals(getProdIntlTradeClassification())) ) {
                    setProdIntlTradeClassification(((String) value));
                }
            }
            if( values.containsKey("ExportAndImportProductGroup") ) {
                final Object value = values.remove("ExportAndImportProductGroup");
                if( (value == null) || (!value.equals(getExportAndImportProductGroup())) ) {
                    setExportAndImportProductGroup(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductPlantIntlTrdField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductPlantIntlTrdField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductPlantIntlTrdField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductPlantIntlTrdField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
