/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductPlantMRPAreaField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductPlantMRPAreaSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * MRP Area Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductPlantMRPAreaType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductPlantMRPArea extends VdmEntity<ProductPlantMRPArea>
{

    /**
     * Selector for all available fields of ProductPlantMRPArea.
     *
     */
    public final static ProductPlantMRPAreaSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> PRODUCT = new ProductPlantMRPAreaField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return MRP Area: Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> PLANT = new ProductPlantMRPAreaField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return MRP Area
     */
    @Key
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> MRP_AREA = new ProductPlantMRPAreaField<String>("MRPArea");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPType</b>
     * </p>
     *
     * @return MRP Type
     */
    @SerializedName( "MRPType" )
    @JsonProperty( "MRPType" )
    @Nullable
    @ODataField( odataName = "MRPType" )
    private String mRPType;
    /**
     * Use with available fluent helpers to apply the <b>MRPType</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> MRP_TYPE = new ProductPlantMRPAreaField<String>("MRPType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPResponsible</b>
     * </p>
     *
     * @return MRP Controller
     */
    @SerializedName( "MRPResponsible" )
    @JsonProperty( "MRPResponsible" )
    @Nullable
    @ODataField( odataName = "MRPResponsible" )
    private String mRPResponsible;
    /**
     * Use with available fluent helpers to apply the <b>MRPResponsible</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> MRP_RESPONSIBLE =
        new ProductPlantMRPAreaField<String>("MRPResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPGroup</b>
     * </p>
     *
     * @return MRP Group
     */
    @SerializedName( "MRPGroup" )
    @JsonProperty( "MRPGroup" )
    @Nullable
    @ODataField( odataName = "MRPGroup" )
    private String mRPGroup;
    /**
     * Use with available fluent helpers to apply the <b>MRPGroup</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> MRP_GROUP = new ProductPlantMRPAreaField<String>("MRPGroup");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReorderThresholdQuantity</b>
     * </p>
     *
     * @return Reorder Point
     */
    @SerializedName( "ReorderThresholdQuantity" )
    @JsonProperty( "ReorderThresholdQuantity" )
    @Nullable
    @ODataField( odataName = "ReorderThresholdQuantity" )
    private BigDecimal reorderThresholdQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ReorderThresholdQuantity</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<BigDecimal> REORDER_THRESHOLD_QUANTITY =
        new ProductPlantMRPAreaField<BigDecimal>("ReorderThresholdQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTimeFence</b>
     * </p>
     *
     * @return Planning time fence
     */
    @SerializedName( "PlanningTimeFence" )
    @JsonProperty( "PlanningTimeFence" )
    @Nullable
    @ODataField( odataName = "PlanningTimeFence" )
    private String planningTimeFence;
    /**
     * Use with available fluent helpers to apply the <b>PlanningTimeFence</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> PLANNING_TIME_FENCE =
        new ProductPlantMRPAreaField<String>("PlanningTimeFence");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LotSizingProcedure</b>
     * </p>
     *
     * @return Lot Sizing Procedure in Materials Planning
     */
    @SerializedName( "LotSizingProcedure" )
    @JsonProperty( "LotSizingProcedure" )
    @Nullable
    @ODataField( odataName = "LotSizingProcedure" )
    private String lotSizingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>LotSizingProcedure</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> LOT_SIZING_PROCEDURE =
        new ProductPlantMRPAreaField<String>("LotSizingProcedure");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LotSizeRoundingQuantity</b>
     * </p>
     *
     * @return Rounding value for purchase order quantity
     */
    @SerializedName( "LotSizeRoundingQuantity" )
    @JsonProperty( "LotSizeRoundingQuantity" )
    @Nullable
    @ODataField( odataName = "LotSizeRoundingQuantity" )
    private BigDecimal lotSizeRoundingQuantity;
    /**
     * Use with available fluent helpers to apply the <b>LotSizeRoundingQuantity</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<BigDecimal> LOT_SIZE_ROUNDING_QUANTITY =
        new ProductPlantMRPAreaField<BigDecimal>("LotSizeRoundingQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @return Minimum Lot Size
     */
    @SerializedName( "MinimumLotSizeQuantity" )
    @JsonProperty( "MinimumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumLotSizeQuantity" )
    private BigDecimal minimumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<BigDecimal> MINIMUM_LOT_SIZE_QUANTITY =
        new ProductPlantMRPAreaField<BigDecimal>("MinimumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @return Maximum Lot Size
     */
    @SerializedName( "MaximumLotSizeQuantity" )
    @JsonProperty( "MaximumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MaximumLotSizeQuantity" )
    private BigDecimal maximumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaximumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<BigDecimal> MAXIMUM_LOT_SIZE_QUANTITY =
        new ProductPlantMRPAreaField<BigDecimal>("MaximumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumStockQuantity</b>
     * </p>
     *
     * @return Maximum Stock Level
     */
    @SerializedName( "MaximumStockQuantity" )
    @JsonProperty( "MaximumStockQuantity" )
    @Nullable
    @ODataField( odataName = "MaximumStockQuantity" )
    private BigDecimal maximumStockQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaximumStockQuantity</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<BigDecimal> MAXIMUM_STOCK_QUANTITY =
        new ProductPlantMRPAreaField<BigDecimal>("MaximumStockQuantity");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssemblyScrapPercent</b>
     * </p>
     *
     * @return Assembly scrap in percent
     */
    @SerializedName( "AssemblyScrapPercent" )
    @JsonProperty( "AssemblyScrapPercent" )
    @Nullable
    @ODataField( odataName = "AssemblyScrapPercent" )
    private BigDecimal assemblyScrapPercent;
    /**
     * Use with available fluent helpers to apply the <b>AssemblyScrapPercent</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<BigDecimal> ASSEMBLY_SCRAP_PERCENT =
        new ProductPlantMRPAreaField<BigDecimal>("AssemblyScrapPercent");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementSubType</b>
     * </p>
     *
     * @return Special Procurement Type
     */
    @SerializedName( "ProcurementSubType" )
    @JsonProperty( "ProcurementSubType" )
    @Nullable
    @ODataField( odataName = "ProcurementSubType" )
    private String procurementSubType;
    /**
     * Use with available fluent helpers to apply the <b>ProcurementSubType</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> PROCUREMENT_SUB_TYPE =
        new ProductPlantMRPAreaField<String>("ProcurementSubType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DfltStorageLocationExtProcmt</b>
     * </p>
     *
     * @return Default Storage Location for External Procurement
     */
    @SerializedName( "DfltStorageLocationExtProcmt" )
    @JsonProperty( "DfltStorageLocationExtProcmt" )
    @Nullable
    @ODataField( odataName = "DfltStorageLocationExtProcmt" )
    private String dfltStorageLocationExtProcmt;
    /**
     * Use with available fluent helpers to apply the <b>DfltStorageLocationExtProcmt</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> DFLT_STORAGE_LOCATION_EXT_PROCMT =
        new ProductPlantMRPAreaField<String>("DfltStorageLocationExtProcmt");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningCalendar</b>
     * </p>
     *
     * @return Planning Calendar
     */
    @SerializedName( "MRPPlanningCalendar" )
    @JsonProperty( "MRPPlanningCalendar" )
    @Nullable
    @ODataField( odataName = "MRPPlanningCalendar" )
    private String mRPPlanningCalendar;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlanningCalendar</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> MRP_PLANNING_CALENDAR =
        new ProductPlantMRPAreaField<String>("MRPPlanningCalendar");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SafetyStockQuantity</b>
     * </p>
     *
     * @return Safety Stock
     */
    @SerializedName( "SafetyStockQuantity" )
    @JsonProperty( "SafetyStockQuantity" )
    @Nullable
    @ODataField( odataName = "SafetyStockQuantity" )
    private BigDecimal safetyStockQuantity;
    /**
     * Use with available fluent helpers to apply the <b>SafetyStockQuantity</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<BigDecimal> SAFETY_STOCK_QUANTITY =
        new ProductPlantMRPAreaField<BigDecimal>("SafetyStockQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RangeOfCvrgPrflCode</b>
     * </p>
     *
     * @return Range-of-Coverage Profile
     */
    @SerializedName( "RangeOfCvrgPrflCode" )
    @JsonProperty( "RangeOfCvrgPrflCode" )
    @Nullable
    @ODataField( odataName = "RangeOfCvrgPrflCode" )
    private String rangeOfCvrgPrflCode;
    /**
     * Use with available fluent helpers to apply the <b>RangeOfCvrgPrflCode</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> RANGE_OF_CVRG_PRFL_CODE =
        new ProductPlantMRPAreaField<String>("RangeOfCvrgPrflCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SafetyDuration</b>
     * </p>
     *
     * @return Safety Time (in Workdays)
     */
    @SerializedName( "SafetyDuration" )
    @JsonProperty( "SafetyDuration" )
    @Nullable
    @ODataField( odataName = "SafetyDuration" )
    private String safetyDuration;
    /**
     * Use with available fluent helpers to apply the <b>SafetyDuration</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> SAFETY_DURATION =
        new ProductPlantMRPAreaField<String>("SafetyDuration");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedLotSizeQuantity</b>
     * </p>
     *
     * @return Fixed lot size
     */
    @SerializedName( "FixedLotSizeQuantity" )
    @JsonProperty( "FixedLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "FixedLotSizeQuantity" )
    private BigDecimal fixedLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>FixedLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<BigDecimal> FIXED_LOT_SIZE_QUANTITY =
        new ProductPlantMRPAreaField<BigDecimal>("FixedLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LotSizeIndependentCosts</b>
     * </p>
     *
     * @return Lot-Size-Independent Costs
     */
    @SerializedName( "LotSizeIndependentCosts" )
    @JsonProperty( "LotSizeIndependentCosts" )
    @Nullable
    @ODataField( odataName = "LotSizeIndependentCosts" )
    private BigDecimal lotSizeIndependentCosts;
    /**
     * Use with available fluent helpers to apply the <b>LotSizeIndependentCosts</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<BigDecimal> LOT_SIZE_INDEPENDENT_COSTS =
        new ProductPlantMRPAreaField<BigDecimal>("LotSizeIndependentCosts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsStorageCosts</b>
     * </p>
     *
     * @return Storage Costs Percentage Code
     */
    @SerializedName( "IsStorageCosts" )
    @JsonProperty( "IsStorageCosts" )
    @Nullable
    @ODataField( odataName = "IsStorageCosts" )
    private String isStorageCosts;
    /**
     * Use with available fluent helpers to apply the <b>IsStorageCosts</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> IS_STORAGE_COSTS =
        new ProductPlantMRPAreaField<String>("IsStorageCosts");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>RqmtQtyRcptTaktTmeInWrkgDays</b>
     * </p>
     *
     * @return Takt time
     */
    @SerializedName( "RqmtQtyRcptTaktTmeInWrkgDays" )
    @JsonProperty( "RqmtQtyRcptTaktTmeInWrkgDays" )
    @Nullable
    @ODataField( odataName = "RqmtQtyRcptTaktTmeInWrkgDays" )
    private BigDecimal rqmtQtyRcptTaktTmeInWrkgDays;
    /**
     * Use with available fluent helpers to apply the <b>RqmtQtyRcptTaktTmeInWrkgDays</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<BigDecimal> RQMT_QTY_RCPT_TAKT_TME_IN_WRKG_DAYS =
        new ProductPlantMRPAreaField<BigDecimal>("RqmtQtyRcptTaktTmeInWrkgDays");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcLvl</b>
     * </p>
     *
     * @return Service level
     */
    @SerializedName( "SrvcLvl" )
    @JsonProperty( "SrvcLvl" )
    @Nullable
    @ODataField( odataName = "SrvcLvl" )
    private BigDecimal srvcLvl;
    /**
     * Use with available fluent helpers to apply the <b>SrvcLvl</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<BigDecimal> SRVC_LVL =
        new ProductPlantMRPAreaField<BigDecimal>("SrvcLvl");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<Boolean> IS_MARKED_FOR_DELETION =
        new ProductPlantMRPAreaField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PerdPrflForSftyTme</b>
     * </p>
     *
     * @return Period Profile for Safety Time
     */
    @SerializedName( "PerdPrflForSftyTme" )
    @JsonProperty( "PerdPrflForSftyTme" )
    @Nullable
    @ODataField( odataName = "PerdPrflForSftyTme" )
    private String perdPrflForSftyTme;
    /**
     * Use with available fluent helpers to apply the <b>PerdPrflForSftyTme</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> PERD_PRFL_FOR_SFTY_TME =
        new ProductPlantMRPAreaField<String>("PerdPrflForSftyTme");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMRPDependentRqmt</b>
     * </p>
     *
     * @return MRP relevancy for dependent requirements
     */
    @SerializedName( "IsMRPDependentRqmt" )
    @JsonProperty( "IsMRPDependentRqmt" )
    @Nullable
    @ODataField( odataName = "IsMRPDependentRqmt" )
    private String isMRPDependentRqmt;
    /**
     * Use with available fluent helpers to apply the <b>IsMRPDependentRqmt</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> IS_MRP_DEPENDENT_RQMT =
        new ProductPlantMRPAreaField<String>("IsMRPDependentRqmt");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSafetyTime</b>
     * </p>
     *
     * @return Safety Time Indicator (with or without safety time)
     */
    @SerializedName( "IsSafetyTime" )
    @JsonProperty( "IsSafetyTime" )
    @Nullable
    @ODataField( odataName = "IsSafetyTime" )
    private String isSafetyTime;
    /**
     * Use with available fluent helpers to apply the <b>IsSafetyTime</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> IS_SAFETY_TIME =
        new ProductPlantMRPAreaField<String>("IsSafetyTime");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryDurationInDays</b>
     * </p>
     *
     * @return Planned Delivery Time in Days
     */
    @SerializedName( "PlannedDeliveryDurationInDays" )
    @JsonProperty( "PlannedDeliveryDurationInDays" )
    @Nullable
    @ODataField( odataName = "PlannedDeliveryDurationInDays" )
    private BigDecimal plannedDeliveryDurationInDays;
    /**
     * Use with available fluent helpers to apply the <b>PlannedDeliveryDurationInDays</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<BigDecimal> PLANNED_DELIVERY_DURATION_IN_DAYS =
        new ProductPlantMRPAreaField<BigDecimal>("PlannedDeliveryDurationInDays");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsPlannedDeliveryTime</b>
     * </p>
     *
     * @return Consider Planned Delivery Time of the MRP Area
     */
    @SerializedName( "IsPlannedDeliveryTime" )
    @JsonProperty( "IsPlannedDeliveryTime" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsPlannedDeliveryTime" )
    private Boolean isPlannedDeliveryTime;
    /**
     * Use with available fluent helpers to apply the <b>IsPlannedDeliveryTime</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<Boolean> IS_PLANNED_DELIVERY_TIME =
        new ProductPlantMRPAreaField<Boolean>("IsPlannedDeliveryTime");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> CURRENCY = new ProductPlantMRPAreaField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> BASE_UNIT = new ProductPlantMRPAreaField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlanAndOrderDayDetermination</b>
     * </p>
     *
     * @return Planning Cycle
     */
    @SerializedName( "PlanAndOrderDayDetermination" )
    @JsonProperty( "PlanAndOrderDayDetermination" )
    @Nullable
    @ODataField( odataName = "PlanAndOrderDayDetermination" )
    private String planAndOrderDayDetermination;
    /**
     * Use with available fluent helpers to apply the <b>PlanAndOrderDayDetermination</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> PLAN_AND_ORDER_DAY_DETERMINATION =
        new ProductPlantMRPAreaField<String>("PlanAndOrderDayDetermination");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RoundingProfile</b>
     * </p>
     *
     * @return Rounding Profile
     */
    @SerializedName( "RoundingProfile" )
    @JsonProperty( "RoundingProfile" )
    @Nullable
    @ODataField( odataName = "RoundingProfile" )
    private String roundingProfile;
    /**
     * Use with available fluent helpers to apply the <b>RoundingProfile</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> ROUNDING_PROFILE =
        new ProductPlantMRPAreaField<String>("RoundingProfile");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Issue Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static ProductPlantMRPAreaField<String> STORAGE_LOCATION =
        new ProductPlantMRPAreaField<String>("StorageLocation");

    @Nonnull
    @Override
    public Class<ProductPlantMRPArea> getType()
    {
        return ProductPlantMRPArea.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            MRP Area: Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPType</b>
     * </p>
     *
     * @param mRPType
     *            MRP Type
     */
    public void setMRPType( @Nullable final String mRPType )
    {
        rememberChangedField("MRPType", this.mRPType);
        this.mRPType = mRPType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPResponsible</b>
     * </p>
     *
     * @param mRPResponsible
     *            MRP Controller
     */
    public void setMRPResponsible( @Nullable final String mRPResponsible )
    {
        rememberChangedField("MRPResponsible", this.mRPResponsible);
        this.mRPResponsible = mRPResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPGroup</b>
     * </p>
     *
     * @param mRPGroup
     *            MRP Group
     */
    public void setMRPGroup( @Nullable final String mRPGroup )
    {
        rememberChangedField("MRPGroup", this.mRPGroup);
        this.mRPGroup = mRPGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReorderThresholdQuantity</b>
     * </p>
     *
     * @param reorderThresholdQuantity
     *            Reorder Point
     */
    public void setReorderThresholdQuantity( @Nullable final BigDecimal reorderThresholdQuantity )
    {
        rememberChangedField("ReorderThresholdQuantity", this.reorderThresholdQuantity);
        this.reorderThresholdQuantity = reorderThresholdQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTimeFence</b>
     * </p>
     *
     * @param planningTimeFence
     *            Planning time fence
     */
    public void setPlanningTimeFence( @Nullable final String planningTimeFence )
    {
        rememberChangedField("PlanningTimeFence", this.planningTimeFence);
        this.planningTimeFence = planningTimeFence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LotSizingProcedure</b>
     * </p>
     *
     * @param lotSizingProcedure
     *            Lot Sizing Procedure in Materials Planning
     */
    public void setLotSizingProcedure( @Nullable final String lotSizingProcedure )
    {
        rememberChangedField("LotSizingProcedure", this.lotSizingProcedure);
        this.lotSizingProcedure = lotSizingProcedure;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LotSizeRoundingQuantity</b>
     * </p>
     *
     * @param lotSizeRoundingQuantity
     *            Rounding value for purchase order quantity
     */
    public void setLotSizeRoundingQuantity( @Nullable final BigDecimal lotSizeRoundingQuantity )
    {
        rememberChangedField("LotSizeRoundingQuantity", this.lotSizeRoundingQuantity);
        this.lotSizeRoundingQuantity = lotSizeRoundingQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @param minimumLotSizeQuantity
     *            Minimum Lot Size
     */
    public void setMinimumLotSizeQuantity( @Nullable final BigDecimal minimumLotSizeQuantity )
    {
        rememberChangedField("MinimumLotSizeQuantity", this.minimumLotSizeQuantity);
        this.minimumLotSizeQuantity = minimumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @param maximumLotSizeQuantity
     *            Maximum Lot Size
     */
    public void setMaximumLotSizeQuantity( @Nullable final BigDecimal maximumLotSizeQuantity )
    {
        rememberChangedField("MaximumLotSizeQuantity", this.maximumLotSizeQuantity);
        this.maximumLotSizeQuantity = maximumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumStockQuantity</b>
     * </p>
     *
     * @param maximumStockQuantity
     *            Maximum Stock Level
     */
    public void setMaximumStockQuantity( @Nullable final BigDecimal maximumStockQuantity )
    {
        rememberChangedField("MaximumStockQuantity", this.maximumStockQuantity);
        this.maximumStockQuantity = maximumStockQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssemblyScrapPercent</b>
     * </p>
     *
     * @param assemblyScrapPercent
     *            Assembly scrap in percent
     */
    public void setAssemblyScrapPercent( @Nullable final BigDecimal assemblyScrapPercent )
    {
        rememberChangedField("AssemblyScrapPercent", this.assemblyScrapPercent);
        this.assemblyScrapPercent = assemblyScrapPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementSubType</b>
     * </p>
     *
     * @param procurementSubType
     *            Special Procurement Type
     */
    public void setProcurementSubType( @Nullable final String procurementSubType )
    {
        rememberChangedField("ProcurementSubType", this.procurementSubType);
        this.procurementSubType = procurementSubType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DfltStorageLocationExtProcmt</b>
     * </p>
     *
     * @param dfltStorageLocationExtProcmt
     *            Default Storage Location for External Procurement
     */
    public void setDfltStorageLocationExtProcmt( @Nullable final String dfltStorageLocationExtProcmt )
    {
        rememberChangedField("DfltStorageLocationExtProcmt", this.dfltStorageLocationExtProcmt);
        this.dfltStorageLocationExtProcmt = dfltStorageLocationExtProcmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningCalendar</b>
     * </p>
     *
     * @param mRPPlanningCalendar
     *            Planning Calendar
     */
    public void setMRPPlanningCalendar( @Nullable final String mRPPlanningCalendar )
    {
        rememberChangedField("MRPPlanningCalendar", this.mRPPlanningCalendar);
        this.mRPPlanningCalendar = mRPPlanningCalendar;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SafetyStockQuantity</b>
     * </p>
     *
     * @param safetyStockQuantity
     *            Safety Stock
     */
    public void setSafetyStockQuantity( @Nullable final BigDecimal safetyStockQuantity )
    {
        rememberChangedField("SafetyStockQuantity", this.safetyStockQuantity);
        this.safetyStockQuantity = safetyStockQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RangeOfCvrgPrflCode</b>
     * </p>
     *
     * @param rangeOfCvrgPrflCode
     *            Range-of-Coverage Profile
     */
    public void setRangeOfCvrgPrflCode( @Nullable final String rangeOfCvrgPrflCode )
    {
        rememberChangedField("RangeOfCvrgPrflCode", this.rangeOfCvrgPrflCode);
        this.rangeOfCvrgPrflCode = rangeOfCvrgPrflCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SafetyDuration</b>
     * </p>
     *
     * @param safetyDuration
     *            Safety Time (in Workdays)
     */
    public void setSafetyDuration( @Nullable final String safetyDuration )
    {
        rememberChangedField("SafetyDuration", this.safetyDuration);
        this.safetyDuration = safetyDuration;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedLotSizeQuantity</b>
     * </p>
     *
     * @param fixedLotSizeQuantity
     *            Fixed lot size
     */
    public void setFixedLotSizeQuantity( @Nullable final BigDecimal fixedLotSizeQuantity )
    {
        rememberChangedField("FixedLotSizeQuantity", this.fixedLotSizeQuantity);
        this.fixedLotSizeQuantity = fixedLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LotSizeIndependentCosts</b>
     * </p>
     *
     * @param lotSizeIndependentCosts
     *            Lot-Size-Independent Costs
     */
    public void setLotSizeIndependentCosts( @Nullable final BigDecimal lotSizeIndependentCosts )
    {
        rememberChangedField("LotSizeIndependentCosts", this.lotSizeIndependentCosts);
        this.lotSizeIndependentCosts = lotSizeIndependentCosts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsStorageCosts</b>
     * </p>
     *
     * @param isStorageCosts
     *            Storage Costs Percentage Code
     */
    public void setIsStorageCosts( @Nullable final String isStorageCosts )
    {
        rememberChangedField("IsStorageCosts", this.isStorageCosts);
        this.isStorageCosts = isStorageCosts;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>RqmtQtyRcptTaktTmeInWrkgDays</b>
     * </p>
     *
     * @param rqmtQtyRcptTaktTmeInWrkgDays
     *            Takt time
     */
    public void setRqmtQtyRcptTaktTmeInWrkgDays( @Nullable final BigDecimal rqmtQtyRcptTaktTmeInWrkgDays )
    {
        rememberChangedField("RqmtQtyRcptTaktTmeInWrkgDays", this.rqmtQtyRcptTaktTmeInWrkgDays);
        this.rqmtQtyRcptTaktTmeInWrkgDays = rqmtQtyRcptTaktTmeInWrkgDays;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcLvl</b>
     * </p>
     *
     * @param srvcLvl
     *            Service level
     */
    public void setSrvcLvl( @Nullable final BigDecimal srvcLvl )
    {
        rememberChangedField("SrvcLvl", this.srvcLvl);
        this.srvcLvl = srvcLvl;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Deletion Indicator
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PerdPrflForSftyTme</b>
     * </p>
     *
     * @param perdPrflForSftyTme
     *            Period Profile for Safety Time
     */
    public void setPerdPrflForSftyTme( @Nullable final String perdPrflForSftyTme )
    {
        rememberChangedField("PerdPrflForSftyTme", this.perdPrflForSftyTme);
        this.perdPrflForSftyTme = perdPrflForSftyTme;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMRPDependentRqmt</b>
     * </p>
     *
     * @param isMRPDependentRqmt
     *            MRP relevancy for dependent requirements
     */
    public void setIsMRPDependentRqmt( @Nullable final String isMRPDependentRqmt )
    {
        rememberChangedField("IsMRPDependentRqmt", this.isMRPDependentRqmt);
        this.isMRPDependentRqmt = isMRPDependentRqmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSafetyTime</b>
     * </p>
     *
     * @param isSafetyTime
     *            Safety Time Indicator (with or without safety time)
     */
    public void setIsSafetyTime( @Nullable final String isSafetyTime )
    {
        rememberChangedField("IsSafetyTime", this.isSafetyTime);
        this.isSafetyTime = isSafetyTime;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryDurationInDays</b>
     * </p>
     *
     * @param plannedDeliveryDurationInDays
     *            Planned Delivery Time in Days
     */
    public void setPlannedDeliveryDurationInDays( @Nullable final BigDecimal plannedDeliveryDurationInDays )
    {
        rememberChangedField("PlannedDeliveryDurationInDays", this.plannedDeliveryDurationInDays);
        this.plannedDeliveryDurationInDays = plannedDeliveryDurationInDays;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsPlannedDeliveryTime</b>
     * </p>
     *
     * @param isPlannedDeliveryTime
     *            Consider Planned Delivery Time of the MRP Area
     */
    public void setIsPlannedDeliveryTime( @Nullable final Boolean isPlannedDeliveryTime )
    {
        rememberChangedField("IsPlannedDeliveryTime", this.isPlannedDeliveryTime);
        this.isPlannedDeliveryTime = isPlannedDeliveryTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlanAndOrderDayDetermination</b>
     * </p>
     *
     * @param planAndOrderDayDetermination
     *            Planning Cycle
     */
    public void setPlanAndOrderDayDetermination( @Nullable final String planAndOrderDayDetermination )
    {
        rememberChangedField("PlanAndOrderDayDetermination", this.planAndOrderDayDetermination);
        this.planAndOrderDayDetermination = planAndOrderDayDetermination;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RoundingProfile</b>
     * </p>
     *
     * @param roundingProfile
     *            Rounding Profile
     */
    public void setRoundingProfile( @Nullable final String roundingProfile )
    {
        rememberChangedField("RoundingProfile", this.roundingProfile);
        this.roundingProfile = roundingProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Issue Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductPlantMRPArea";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        result.put("MRPArea", getMRPArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("MRPArea", getMRPArea());
        values.put("MRPType", getMRPType());
        values.put("MRPResponsible", getMRPResponsible());
        values.put("MRPGroup", getMRPGroup());
        values.put("ReorderThresholdQuantity", getReorderThresholdQuantity());
        values.put("PlanningTimeFence", getPlanningTimeFence());
        values.put("LotSizingProcedure", getLotSizingProcedure());
        values.put("LotSizeRoundingQuantity", getLotSizeRoundingQuantity());
        values.put("MinimumLotSizeQuantity", getMinimumLotSizeQuantity());
        values.put("MaximumLotSizeQuantity", getMaximumLotSizeQuantity());
        values.put("MaximumStockQuantity", getMaximumStockQuantity());
        values.put("AssemblyScrapPercent", getAssemblyScrapPercent());
        values.put("ProcurementSubType", getProcurementSubType());
        values.put("DfltStorageLocationExtProcmt", getDfltStorageLocationExtProcmt());
        values.put("MRPPlanningCalendar", getMRPPlanningCalendar());
        values.put("SafetyStockQuantity", getSafetyStockQuantity());
        values.put("RangeOfCvrgPrflCode", getRangeOfCvrgPrflCode());
        values.put("SafetyDuration", getSafetyDuration());
        values.put("FixedLotSizeQuantity", getFixedLotSizeQuantity());
        values.put("LotSizeIndependentCosts", getLotSizeIndependentCosts());
        values.put("IsStorageCosts", getIsStorageCosts());
        values.put("RqmtQtyRcptTaktTmeInWrkgDays", getRqmtQtyRcptTaktTmeInWrkgDays());
        values.put("SrvcLvl", getSrvcLvl());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("PerdPrflForSftyTme", getPerdPrflForSftyTme());
        values.put("IsMRPDependentRqmt", getIsMRPDependentRqmt());
        values.put("IsSafetyTime", getIsSafetyTime());
        values.put("PlannedDeliveryDurationInDays", getPlannedDeliveryDurationInDays());
        values.put("IsPlannedDeliveryTime", getIsPlannedDeliveryTime());
        values.put("Currency", getCurrency());
        values.put("BaseUnit", getBaseUnit());
        values.put("PlanAndOrderDayDetermination", getPlanAndOrderDayDetermination());
        values.put("RoundingProfile", getRoundingProfile());
        values.put("StorageLocation", getStorageLocation());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("MRPType") ) {
                final Object value = values.remove("MRPType");
                if( (value == null) || (!value.equals(getMRPType())) ) {
                    setMRPType(((String) value));
                }
            }
            if( values.containsKey("MRPResponsible") ) {
                final Object value = values.remove("MRPResponsible");
                if( (value == null) || (!value.equals(getMRPResponsible())) ) {
                    setMRPResponsible(((String) value));
                }
            }
            if( values.containsKey("MRPGroup") ) {
                final Object value = values.remove("MRPGroup");
                if( (value == null) || (!value.equals(getMRPGroup())) ) {
                    setMRPGroup(((String) value));
                }
            }
            if( values.containsKey("ReorderThresholdQuantity") ) {
                final Object value = values.remove("ReorderThresholdQuantity");
                if( (value == null) || (!value.equals(getReorderThresholdQuantity())) ) {
                    setReorderThresholdQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlanningTimeFence") ) {
                final Object value = values.remove("PlanningTimeFence");
                if( (value == null) || (!value.equals(getPlanningTimeFence())) ) {
                    setPlanningTimeFence(((String) value));
                }
            }
            if( values.containsKey("LotSizingProcedure") ) {
                final Object value = values.remove("LotSizingProcedure");
                if( (value == null) || (!value.equals(getLotSizingProcedure())) ) {
                    setLotSizingProcedure(((String) value));
                }
            }
            if( values.containsKey("LotSizeRoundingQuantity") ) {
                final Object value = values.remove("LotSizeRoundingQuantity");
                if( (value == null) || (!value.equals(getLotSizeRoundingQuantity())) ) {
                    setLotSizeRoundingQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MinimumLotSizeQuantity") ) {
                final Object value = values.remove("MinimumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMinimumLotSizeQuantity())) ) {
                    setMinimumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumLotSizeQuantity") ) {
                final Object value = values.remove("MaximumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMaximumLotSizeQuantity())) ) {
                    setMaximumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumStockQuantity") ) {
                final Object value = values.remove("MaximumStockQuantity");
                if( (value == null) || (!value.equals(getMaximumStockQuantity())) ) {
                    setMaximumStockQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("AssemblyScrapPercent") ) {
                final Object value = values.remove("AssemblyScrapPercent");
                if( (value == null) || (!value.equals(getAssemblyScrapPercent())) ) {
                    setAssemblyScrapPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProcurementSubType") ) {
                final Object value = values.remove("ProcurementSubType");
                if( (value == null) || (!value.equals(getProcurementSubType())) ) {
                    setProcurementSubType(((String) value));
                }
            }
            if( values.containsKey("DfltStorageLocationExtProcmt") ) {
                final Object value = values.remove("DfltStorageLocationExtProcmt");
                if( (value == null) || (!value.equals(getDfltStorageLocationExtProcmt())) ) {
                    setDfltStorageLocationExtProcmt(((String) value));
                }
            }
            if( values.containsKey("MRPPlanningCalendar") ) {
                final Object value = values.remove("MRPPlanningCalendar");
                if( (value == null) || (!value.equals(getMRPPlanningCalendar())) ) {
                    setMRPPlanningCalendar(((String) value));
                }
            }
            if( values.containsKey("SafetyStockQuantity") ) {
                final Object value = values.remove("SafetyStockQuantity");
                if( (value == null) || (!value.equals(getSafetyStockQuantity())) ) {
                    setSafetyStockQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("RangeOfCvrgPrflCode") ) {
                final Object value = values.remove("RangeOfCvrgPrflCode");
                if( (value == null) || (!value.equals(getRangeOfCvrgPrflCode())) ) {
                    setRangeOfCvrgPrflCode(((String) value));
                }
            }
            if( values.containsKey("SafetyDuration") ) {
                final Object value = values.remove("SafetyDuration");
                if( (value == null) || (!value.equals(getSafetyDuration())) ) {
                    setSafetyDuration(((String) value));
                }
            }
            if( values.containsKey("FixedLotSizeQuantity") ) {
                final Object value = values.remove("FixedLotSizeQuantity");
                if( (value == null) || (!value.equals(getFixedLotSizeQuantity())) ) {
                    setFixedLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("LotSizeIndependentCosts") ) {
                final Object value = values.remove("LotSizeIndependentCosts");
                if( (value == null) || (!value.equals(getLotSizeIndependentCosts())) ) {
                    setLotSizeIndependentCosts(((BigDecimal) value));
                }
            }
            if( values.containsKey("IsStorageCosts") ) {
                final Object value = values.remove("IsStorageCosts");
                if( (value == null) || (!value.equals(getIsStorageCosts())) ) {
                    setIsStorageCosts(((String) value));
                }
            }
            if( values.containsKey("RqmtQtyRcptTaktTmeInWrkgDays") ) {
                final Object value = values.remove("RqmtQtyRcptTaktTmeInWrkgDays");
                if( (value == null) || (!value.equals(getRqmtQtyRcptTaktTmeInWrkgDays())) ) {
                    setRqmtQtyRcptTaktTmeInWrkgDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("SrvcLvl") ) {
                final Object value = values.remove("SrvcLvl");
                if( (value == null) || (!value.equals(getSrvcLvl())) ) {
                    setSrvcLvl(((BigDecimal) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("PerdPrflForSftyTme") ) {
                final Object value = values.remove("PerdPrflForSftyTme");
                if( (value == null) || (!value.equals(getPerdPrflForSftyTme())) ) {
                    setPerdPrflForSftyTme(((String) value));
                }
            }
            if( values.containsKey("IsMRPDependentRqmt") ) {
                final Object value = values.remove("IsMRPDependentRqmt");
                if( (value == null) || (!value.equals(getIsMRPDependentRqmt())) ) {
                    setIsMRPDependentRqmt(((String) value));
                }
            }
            if( values.containsKey("IsSafetyTime") ) {
                final Object value = values.remove("IsSafetyTime");
                if( (value == null) || (!value.equals(getIsSafetyTime())) ) {
                    setIsSafetyTime(((String) value));
                }
            }
            if( values.containsKey("PlannedDeliveryDurationInDays") ) {
                final Object value = values.remove("PlannedDeliveryDurationInDays");
                if( (value == null) || (!value.equals(getPlannedDeliveryDurationInDays())) ) {
                    setPlannedDeliveryDurationInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("IsPlannedDeliveryTime") ) {
                final Object value = values.remove("IsPlannedDeliveryTime");
                if( (value == null) || (!value.equals(getIsPlannedDeliveryTime())) ) {
                    setIsPlannedDeliveryTime(((Boolean) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("PlanAndOrderDayDetermination") ) {
                final Object value = values.remove("PlanAndOrderDayDetermination");
                if( (value == null) || (!value.equals(getPlanAndOrderDayDetermination())) ) {
                    setPlanAndOrderDayDetermination(((String) value));
                }
            }
            if( values.containsKey("RoundingProfile") ) {
                final Object value = values.remove("RoundingProfile");
                if( (value == null) || (!value.equals(getRoundingProfile())) ) {
                    setRoundingProfile(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductPlantMRPAreaField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductPlantMRPAreaField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductPlantMRPAreaField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductPlantMRPAreaField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
