/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductPlantProcurementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductPlantProcurementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Procurement Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductPlantProcurementType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductPlantProcurement extends VdmEntity<ProductPlantProcurement>
{

    /**
     * Selector for all available fields of ProductPlantProcurement.
     *
     */
    public final static ProductPlantProcurementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductPlantProcurementField<String> PRODUCT =
        new ProductPlantProcurementField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductPlantProcurementField<String> PLANT = new ProductPlantProcurementField<String>("Plant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsAutoPurOrdCreationAllowed</b>
     * </p>
     *
     * @return Indicator: "automatic purchase order allowed"
     */
    @SerializedName( "IsAutoPurOrdCreationAllowed" )
    @JsonProperty( "IsAutoPurOrdCreationAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsAutoPurOrdCreationAllowed" )
    private Boolean isAutoPurOrdCreationAllowed;
    /**
     * Use with available fluent helpers to apply the <b>IsAutoPurOrdCreationAllowed</b> field to query operations.
     *
     */
    public final static ProductPlantProcurementField<Boolean> IS_AUTO_PUR_ORD_CREATION_ALLOWED =
        new ProductPlantProcurementField<Boolean>("IsAutoPurOrdCreationAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSourceListRequired</b>
     * </p>
     *
     * @return Indicator: Source list requirement
     */
    @SerializedName( "IsSourceListRequired" )
    @JsonProperty( "IsSourceListRequired" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsSourceListRequired" )
    private Boolean isSourceListRequired;
    /**
     * Use with available fluent helpers to apply the <b>IsSourceListRequired</b> field to query operations.
     *
     */
    public final static ProductPlantProcurementField<Boolean> IS_SOURCE_LIST_REQUIRED =
        new ProductPlantProcurementField<Boolean>("IsSourceListRequired");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfSupplyCategory</b>
     * </p>
     *
     * @return Source of Supply
     */
    @SerializedName( "SourceOfSupplyCategory" )
    @JsonProperty( "SourceOfSupplyCategory" )
    @Nullable
    @ODataField( odataName = "SourceOfSupplyCategory" )
    private String sourceOfSupplyCategory;
    /**
     * Use with available fluent helpers to apply the <b>SourceOfSupplyCategory</b> field to query operations.
     *
     */
    public final static ProductPlantProcurementField<String> SOURCE_OF_SUPPLY_CATEGORY =
        new ProductPlantProcurementField<String>("SourceOfSupplyCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItmIsRlvtToJITDelivSchedules</b>
     * </p>
     *
     * @return JIT Delivery Schedules
     */
    @SerializedName( "ItmIsRlvtToJITDelivSchedules" )
    @JsonProperty( "ItmIsRlvtToJITDelivSchedules" )
    @Nullable
    @ODataField( odataName = "ItmIsRlvtToJITDelivSchedules" )
    private String itmIsRlvtToJITDelivSchedules;
    /**
     * Use with available fluent helpers to apply the <b>ItmIsRlvtToJITDelivSchedules</b> field to query operations.
     *
     */
    public final static ProductPlantProcurementField<String> ITM_IS_RLVT_TO_JIT_DELIV_SCHEDULES =
        new ProductPlantProcurementField<String>("ItmIsRlvtToJITDelivSchedules");

    @Nonnull
    @Override
    public Class<ProductPlantProcurement> getType()
    {
        return ProductPlantProcurement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsAutoPurOrdCreationAllowed</b>
     * </p>
     *
     * @param isAutoPurOrdCreationAllowed
     *            Indicator: "automatic purchase order allowed"
     */
    public void setIsAutoPurOrdCreationAllowed( @Nullable final Boolean isAutoPurOrdCreationAllowed )
    {
        rememberChangedField("IsAutoPurOrdCreationAllowed", this.isAutoPurOrdCreationAllowed);
        this.isAutoPurOrdCreationAllowed = isAutoPurOrdCreationAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSourceListRequired</b>
     * </p>
     *
     * @param isSourceListRequired
     *            Indicator: Source list requirement
     */
    public void setIsSourceListRequired( @Nullable final Boolean isSourceListRequired )
    {
        rememberChangedField("IsSourceListRequired", this.isSourceListRequired);
        this.isSourceListRequired = isSourceListRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfSupplyCategory</b>
     * </p>
     *
     * @param sourceOfSupplyCategory
     *            Source of Supply
     */
    public void setSourceOfSupplyCategory( @Nullable final String sourceOfSupplyCategory )
    {
        rememberChangedField("SourceOfSupplyCategory", this.sourceOfSupplyCategory);
        this.sourceOfSupplyCategory = sourceOfSupplyCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItmIsRlvtToJITDelivSchedules</b>
     * </p>
     *
     * @param itmIsRlvtToJITDelivSchedules
     *            JIT Delivery Schedules
     */
    public void setItmIsRlvtToJITDelivSchedules( @Nullable final String itmIsRlvtToJITDelivSchedules )
    {
        rememberChangedField("ItmIsRlvtToJITDelivSchedules", this.itmIsRlvtToJITDelivSchedules);
        this.itmIsRlvtToJITDelivSchedules = itmIsRlvtToJITDelivSchedules;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductPlantProcurement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("IsAutoPurOrdCreationAllowed", getIsAutoPurOrdCreationAllowed());
        values.put("IsSourceListRequired", getIsSourceListRequired());
        values.put("SourceOfSupplyCategory", getSourceOfSupplyCategory());
        values.put("ItmIsRlvtToJITDelivSchedules", getItmIsRlvtToJITDelivSchedules());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("IsAutoPurOrdCreationAllowed") ) {
                final Object value = values.remove("IsAutoPurOrdCreationAllowed");
                if( (value == null) || (!value.equals(getIsAutoPurOrdCreationAllowed())) ) {
                    setIsAutoPurOrdCreationAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("IsSourceListRequired") ) {
                final Object value = values.remove("IsSourceListRequired");
                if( (value == null) || (!value.equals(getIsSourceListRequired())) ) {
                    setIsSourceListRequired(((Boolean) value));
                }
            }
            if( values.containsKey("SourceOfSupplyCategory") ) {
                final Object value = values.remove("SourceOfSupplyCategory");
                if( (value == null) || (!value.equals(getSourceOfSupplyCategory())) ) {
                    setSourceOfSupplyCategory(((String) value));
                }
            }
            if( values.containsKey("ItmIsRlvtToJITDelivSchedules") ) {
                final Object value = values.remove("ItmIsRlvtToJITDelivSchedules");
                if( (value == null) || (!value.equals(getItmIsRlvtToJITDelivSchedules())) ) {
                    setItmIsRlvtToJITDelivSchedules(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductPlantProcurementField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductPlantProcurementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductPlantProcurementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductPlantProcurementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
