/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductPlantQualityMgmtField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductPlantQualityMgmtSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Quality Management Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductPlantQualityMgmtType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductPlantQualityMgmt extends VdmEntity<ProductPlantQualityMgmt>
{

    /**
     * Selector for all available fields of ProductPlantQualityMgmt.
     *
     */
    public final static ProductPlantQualityMgmtSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductPlantQualityMgmtField<String> PRODUCT =
        new ProductPlantQualityMgmtField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductPlantQualityMgmtField<String> PLANT = new ProductPlantQualityMgmtField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaximumStoragePeriod</b>
     * </p>
     *
     * @return Maximum Storage Period
     */
    @SerializedName( "MaximumStoragePeriod" )
    @JsonProperty( "MaximumStoragePeriod" )
    @Nullable
    @ODataField( odataName = "MaximumStoragePeriod" )
    private BigDecimal maximumStoragePeriod;
    /**
     * Use with available fluent helpers to apply the <b>MaximumStoragePeriod</b> field to query operations.
     *
     */
    public final static ProductPlantQualityMgmtField<BigDecimal> MAXIMUM_STORAGE_PERIOD =
        new ProductPlantQualityMgmtField<BigDecimal>("MaximumStoragePeriod");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>QualityMgmtCtrlKey</b>
     * </p>
     *
     * @return Control Key for Quality Management in Procurement
     */
    @SerializedName( "QualityMgmtCtrlKey" )
    @JsonProperty( "QualityMgmtCtrlKey" )
    @Nullable
    @ODataField( odataName = "QualityMgmtCtrlKey" )
    private String qualityMgmtCtrlKey;
    /**
     * Use with available fluent helpers to apply the <b>QualityMgmtCtrlKey</b> field to query operations.
     *
     */
    public final static ProductPlantQualityMgmtField<String> QUALITY_MGMT_CTRL_KEY =
        new ProductPlantQualityMgmtField<String>("QualityMgmtCtrlKey");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MatlQualityAuthorizationGroup</b>
     * </p>
     *
     * @return Material Authorization Group for Activities in QM
     */
    @SerializedName( "MatlQualityAuthorizationGroup" )
    @JsonProperty( "MatlQualityAuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "MatlQualityAuthorizationGroup" )
    private String matlQualityAuthorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>MatlQualityAuthorizationGroup</b> field to query operations.
     *
     */
    public final static ProductPlantQualityMgmtField<String> MATL_QUALITY_AUTHORIZATION_GROUP =
        new ProductPlantQualityMgmtField<String>("MatlQualityAuthorizationGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HasPostToInspectionStock</b>
     * </p>
     *
     * @return Has Post to Inspection Stock
     */
    @SerializedName( "HasPostToInspectionStock" )
    @JsonProperty( "HasPostToInspectionStock" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "HasPostToInspectionStock" )
    private Boolean hasPostToInspectionStock;
    /**
     * Use with available fluent helpers to apply the <b>HasPostToInspectionStock</b> field to query operations.
     *
     */
    public final static ProductPlantQualityMgmtField<Boolean> HAS_POST_TO_INSPECTION_STOCK =
        new ProductPlantQualityMgmtField<Boolean>("HasPostToInspectionStock");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDocumentationIsRequired</b>
     * </p>
     *
     * @return Documentation required indicator
     */
    @SerializedName( "InspLotDocumentationIsRequired" )
    @JsonProperty( "InspLotDocumentationIsRequired" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspLotDocumentationIsRequired" )
    private Boolean inspLotDocumentationIsRequired;
    /**
     * Use with available fluent helpers to apply the <b>InspLotDocumentationIsRequired</b> field to query operations.
     *
     */
    public final static ProductPlantQualityMgmtField<Boolean> INSP_LOT_DOCUMENTATION_IS_REQUIRED =
        new ProductPlantQualityMgmtField<Boolean>("InspLotDocumentationIsRequired");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SuplrQualityManagementSystem</b>
     * </p>
     *
     * @return Required QM System for Supplier
     */
    @SerializedName( "SuplrQualityManagementSystem" )
    @JsonProperty( "SuplrQualityManagementSystem" )
    @Nullable
    @ODataField( odataName = "SuplrQualityManagementSystem" )
    private String suplrQualityManagementSystem;
    /**
     * Use with available fluent helpers to apply the <b>SuplrQualityManagementSystem</b> field to query operations.
     *
     */
    public final static ProductPlantQualityMgmtField<String> SUPLR_QUALITY_MANAGEMENT_SYSTEM =
        new ProductPlantQualityMgmtField<String>("SuplrQualityManagementSystem");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecrrgInspIntervalTimeInDays</b>
     * </p>
     *
     * @return Interval Until Next Recurring Inspection
     */
    @SerializedName( "RecrrgInspIntervalTimeInDays" )
    @JsonProperty( "RecrrgInspIntervalTimeInDays" )
    @Nullable
    @ODataField( odataName = "RecrrgInspIntervalTimeInDays" )
    private BigDecimal recrrgInspIntervalTimeInDays;
    /**
     * Use with available fluent helpers to apply the <b>RecrrgInspIntervalTimeInDays</b> field to query operations.
     *
     */
    public final static ProductPlantQualityMgmtField<BigDecimal> RECRRG_INSP_INTERVAL_TIME_IN_DAYS =
        new ProductPlantQualityMgmtField<BigDecimal>("RecrrgInspIntervalTimeInDays");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductQualityCertificateType</b>
     * </p>
     *
     * @return Certificate Type
     */
    @SerializedName( "ProductQualityCertificateType" )
    @JsonProperty( "ProductQualityCertificateType" )
    @Nullable
    @ODataField( odataName = "ProductQualityCertificateType" )
    private String productQualityCertificateType;
    /**
     * Use with available fluent helpers to apply the <b>ProductQualityCertificateType</b> field to query operations.
     *
     */
    public final static ProductPlantQualityMgmtField<String> PRODUCT_QUALITY_CERTIFICATE_TYPE =
        new ProductPlantQualityMgmtField<String>("ProductQualityCertificateType");

    @Nonnull
    @Override
    public Class<ProductPlantQualityMgmt> getType()
    {
        return ProductPlantQualityMgmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaximumStoragePeriod</b>
     * </p>
     *
     * @param maximumStoragePeriod
     *            Maximum Storage Period
     */
    public void setMaximumStoragePeriod( @Nullable final BigDecimal maximumStoragePeriod )
    {
        rememberChangedField("MaximumStoragePeriod", this.maximumStoragePeriod);
        this.maximumStoragePeriod = maximumStoragePeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>QualityMgmtCtrlKey</b>
     * </p>
     *
     * @param qualityMgmtCtrlKey
     *            Control Key for Quality Management in Procurement
     */
    public void setQualityMgmtCtrlKey( @Nullable final String qualityMgmtCtrlKey )
    {
        rememberChangedField("QualityMgmtCtrlKey", this.qualityMgmtCtrlKey);
        this.qualityMgmtCtrlKey = qualityMgmtCtrlKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MatlQualityAuthorizationGroup</b>
     * </p>
     *
     * @param matlQualityAuthorizationGroup
     *            Material Authorization Group for Activities in QM
     */
    public void setMatlQualityAuthorizationGroup( @Nullable final String matlQualityAuthorizationGroup )
    {
        rememberChangedField("MatlQualityAuthorizationGroup", this.matlQualityAuthorizationGroup);
        this.matlQualityAuthorizationGroup = matlQualityAuthorizationGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HasPostToInspectionStock</b>
     * </p>
     *
     * @param hasPostToInspectionStock
     *            Has Post to Inspection Stock
     */
    public void setHasPostToInspectionStock( @Nullable final Boolean hasPostToInspectionStock )
    {
        rememberChangedField("HasPostToInspectionStock", this.hasPostToInspectionStock);
        this.hasPostToInspectionStock = hasPostToInspectionStock;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspLotDocumentationIsRequired</b>
     * </p>
     *
     * @param inspLotDocumentationIsRequired
     *            Documentation required indicator
     */
    public void setInspLotDocumentationIsRequired( @Nullable final Boolean inspLotDocumentationIsRequired )
    {
        rememberChangedField("InspLotDocumentationIsRequired", this.inspLotDocumentationIsRequired);
        this.inspLotDocumentationIsRequired = inspLotDocumentationIsRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SuplrQualityManagementSystem</b>
     * </p>
     *
     * @param suplrQualityManagementSystem
     *            Required QM System for Supplier
     */
    public void setSuplrQualityManagementSystem( @Nullable final String suplrQualityManagementSystem )
    {
        rememberChangedField("SuplrQualityManagementSystem", this.suplrQualityManagementSystem);
        this.suplrQualityManagementSystem = suplrQualityManagementSystem;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecrrgInspIntervalTimeInDays</b>
     * </p>
     *
     * @param recrrgInspIntervalTimeInDays
     *            Interval Until Next Recurring Inspection
     */
    public void setRecrrgInspIntervalTimeInDays( @Nullable final BigDecimal recrrgInspIntervalTimeInDays )
    {
        rememberChangedField("RecrrgInspIntervalTimeInDays", this.recrrgInspIntervalTimeInDays);
        this.recrrgInspIntervalTimeInDays = recrrgInspIntervalTimeInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductQualityCertificateType</b>
     * </p>
     *
     * @param productQualityCertificateType
     *            Certificate Type
     */
    public void setProductQualityCertificateType( @Nullable final String productQualityCertificateType )
    {
        rememberChangedField("ProductQualityCertificateType", this.productQualityCertificateType);
        this.productQualityCertificateType = productQualityCertificateType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductPlantQualityMgmt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("MaximumStoragePeriod", getMaximumStoragePeriod());
        values.put("QualityMgmtCtrlKey", getQualityMgmtCtrlKey());
        values.put("MatlQualityAuthorizationGroup", getMatlQualityAuthorizationGroup());
        values.put("HasPostToInspectionStock", getHasPostToInspectionStock());
        values.put("InspLotDocumentationIsRequired", getInspLotDocumentationIsRequired());
        values.put("SuplrQualityManagementSystem", getSuplrQualityManagementSystem());
        values.put("RecrrgInspIntervalTimeInDays", getRecrrgInspIntervalTimeInDays());
        values.put("ProductQualityCertificateType", getProductQualityCertificateType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MaximumStoragePeriod") ) {
                final Object value = values.remove("MaximumStoragePeriod");
                if( (value == null) || (!value.equals(getMaximumStoragePeriod())) ) {
                    setMaximumStoragePeriod(((BigDecimal) value));
                }
            }
            if( values.containsKey("QualityMgmtCtrlKey") ) {
                final Object value = values.remove("QualityMgmtCtrlKey");
                if( (value == null) || (!value.equals(getQualityMgmtCtrlKey())) ) {
                    setQualityMgmtCtrlKey(((String) value));
                }
            }
            if( values.containsKey("MatlQualityAuthorizationGroup") ) {
                final Object value = values.remove("MatlQualityAuthorizationGroup");
                if( (value == null) || (!value.equals(getMatlQualityAuthorizationGroup())) ) {
                    setMatlQualityAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("HasPostToInspectionStock") ) {
                final Object value = values.remove("HasPostToInspectionStock");
                if( (value == null) || (!value.equals(getHasPostToInspectionStock())) ) {
                    setHasPostToInspectionStock(((Boolean) value));
                }
            }
            if( values.containsKey("InspLotDocumentationIsRequired") ) {
                final Object value = values.remove("InspLotDocumentationIsRequired");
                if( (value == null) || (!value.equals(getInspLotDocumentationIsRequired())) ) {
                    setInspLotDocumentationIsRequired(((Boolean) value));
                }
            }
            if( values.containsKey("SuplrQualityManagementSystem") ) {
                final Object value = values.remove("SuplrQualityManagementSystem");
                if( (value == null) || (!value.equals(getSuplrQualityManagementSystem())) ) {
                    setSuplrQualityManagementSystem(((String) value));
                }
            }
            if( values.containsKey("RecrrgInspIntervalTimeInDays") ) {
                final Object value = values.remove("RecrrgInspIntervalTimeInDays");
                if( (value == null) || (!value.equals(getRecrrgInspIntervalTimeInDays())) ) {
                    setRecrrgInspIntervalTimeInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductQualityCertificateType") ) {
                final Object value = values.remove("ProductQualityCertificateType");
                if( (value == null) || (!value.equals(getProductQualityCertificateType())) ) {
                    setProductQualityCertificateType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductPlantQualityMgmtField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductPlantQualityMgmtField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductPlantQualityMgmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductPlantQualityMgmtField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
