/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductPlantQualityMgmtSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
 * ProductPlantQualityMgmt} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class ProductPlantQualityMgmtByKeyFluentHelper
    extends
    FluentHelperByKey<ProductPlantQualityMgmtByKeyFluentHelper, ProductPlantQualityMgmt, ProductPlantQualityMgmtSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     * ProductPlantQualityMgmt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProductPlantQualityMgmt}
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProductPlantQualityMgmt}
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public ProductPlantQualityMgmtByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String product,
        final String plant )
    {
        super(servicePath, entityCollection);
        this.key.put("Product", product);
        this.key.put("Plant", plant);
    }

    @Override
    @Nonnull
    protected Class<ProductPlantQualityMgmt> getEntityClass()
    {
        return ProductPlantQualityMgmt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
