/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductPlantSalesField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductPlantSalesSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Sales Data at Plant Level
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductPlantSalesType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductPlantSales extends VdmEntity<ProductPlantSales>
{

    /**
     * Selector for all available fields of ProductPlantSales.
     *
     */
    public final static ProductPlantSalesSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductPlantSalesField<String> PRODUCT = new ProductPlantSalesField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductPlantSalesField<String> PLANT = new ProductPlantSalesField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LoadingGroup</b>
     * </p>
     *
     * @return Loading Group
     */
    @SerializedName( "LoadingGroup" )
    @JsonProperty( "LoadingGroup" )
    @Nullable
    @ODataField( odataName = "LoadingGroup" )
    private String loadingGroup;
    /**
     * Use with available fluent helpers to apply the <b>LoadingGroup</b> field to query operations.
     *
     */
    public final static ProductPlantSalesField<String> LOADING_GROUP =
        new ProductPlantSalesField<String>("LoadingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReplacementPartType</b>
     * </p>
     *
     * @return Replacement part
     */
    @SerializedName( "ReplacementPartType" )
    @JsonProperty( "ReplacementPartType" )
    @Nullable
    @ODataField( odataName = "ReplacementPartType" )
    private String replacementPartType;
    /**
     * Use with available fluent helpers to apply the <b>ReplacementPartType</b> field to query operations.
     *
     */
    public final static ProductPlantSalesField<String> REPLACEMENT_PART_TYPE =
        new ProductPlantSalesField<String>("ReplacementPartType");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapPlanningQuantityInBaseUoM</b>
     * </p>
     *
     * @return Base quantity for capacity planning in shipping
     */
    @SerializedName( "CapPlanningQuantityInBaseUoM" )
    @JsonProperty( "CapPlanningQuantityInBaseUoM" )
    @Nullable
    @ODataField( odataName = "CapPlanningQuantityInBaseUoM" )
    private BigDecimal capPlanningQuantityInBaseUoM;
    /**
     * Use with available fluent helpers to apply the <b>CapPlanningQuantityInBaseUoM</b> field to query operations.
     *
     */
    public final static ProductPlantSalesField<BigDecimal> CAP_PLANNING_QUANTITY_IN_BASE_UO_M =
        new ProductPlantSalesField<BigDecimal>("CapPlanningQuantityInBaseUoM");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductShippingProcessingTime</b>
     * </p>
     *
     * @return Shipping processing time
     */
    @SerializedName( "ProductShippingProcessingTime" )
    @JsonProperty( "ProductShippingProcessingTime" )
    @Nullable
    @ODataField( odataName = "ProductShippingProcessingTime" )
    private BigDecimal productShippingProcessingTime;
    /**
     * Use with available fluent helpers to apply the <b>ProductShippingProcessingTime</b> field to query operations.
     *
     */
    public final static ProductPlantSalesField<BigDecimal> PRODUCT_SHIPPING_PROCESSING_TIME =
        new ProductPlantSalesField<BigDecimal>("ProductShippingProcessingTime");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>WrkCentersShipgSetupTimeInDays</b>
     * </p>
     *
     * @return Shipping setup time
     */
    @SerializedName( "WrkCentersShipgSetupTimeInDays" )
    @JsonProperty( "WrkCentersShipgSetupTimeInDays" )
    @Nullable
    @ODataField( odataName = "WrkCentersShipgSetupTimeInDays" )
    private BigDecimal wrkCentersShipgSetupTimeInDays;
    /**
     * Use with available fluent helpers to apply the <b>WrkCentersShipgSetupTimeInDays</b> field to query operations.
     *
     */
    public final static ProductPlantSalesField<BigDecimal> WRK_CENTERS_SHIPG_SETUP_TIME_IN_DAYS =
        new ProductPlantSalesField<BigDecimal>("WrkCentersShipgSetupTimeInDays");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityCheckType</b>
     * </p>
     *
     * @return Checking Group for Availability Check
     */
    @SerializedName( "AvailabilityCheckType" )
    @JsonProperty( "AvailabilityCheckType" )
    @Nullable
    @ODataField( odataName = "AvailabilityCheckType" )
    private String availabilityCheckType;
    /**
     * Use with available fluent helpers to apply the <b>AvailabilityCheckType</b> field to query operations.
     *
     */
    public final static ProductPlantSalesField<String> AVAILABILITY_CHECK_TYPE =
        new ProductPlantSalesField<String>("AvailabilityCheckType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProductPlantSalesField<String> BASE_UNIT = new ProductPlantSalesField<String>("BaseUnit");

    @Nonnull
    @Override
    public Class<ProductPlantSales> getType()
    {
        return ProductPlantSales.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LoadingGroup</b>
     * </p>
     *
     * @param loadingGroup
     *            Loading Group
     */
    public void setLoadingGroup( @Nullable final String loadingGroup )
    {
        rememberChangedField("LoadingGroup", this.loadingGroup);
        this.loadingGroup = loadingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReplacementPartType</b>
     * </p>
     *
     * @param replacementPartType
     *            Replacement part
     */
    public void setReplacementPartType( @Nullable final String replacementPartType )
    {
        rememberChangedField("ReplacementPartType", this.replacementPartType);
        this.replacementPartType = replacementPartType;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapPlanningQuantityInBaseUoM</b>
     * </p>
     *
     * @param capPlanningQuantityInBaseUoM
     *            Base quantity for capacity planning in shipping
     */
    public void setCapPlanningQuantityInBaseUoM( @Nullable final BigDecimal capPlanningQuantityInBaseUoM )
    {
        rememberChangedField("CapPlanningQuantityInBaseUoM", this.capPlanningQuantityInBaseUoM);
        this.capPlanningQuantityInBaseUoM = capPlanningQuantityInBaseUoM;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductShippingProcessingTime</b>
     * </p>
     *
     * @param productShippingProcessingTime
     *            Shipping processing time
     */
    public void setProductShippingProcessingTime( @Nullable final BigDecimal productShippingProcessingTime )
    {
        rememberChangedField("ProductShippingProcessingTime", this.productShippingProcessingTime);
        this.productShippingProcessingTime = productShippingProcessingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>WrkCentersShipgSetupTimeInDays</b>
     * </p>
     *
     * @param wrkCentersShipgSetupTimeInDays
     *            Shipping setup time
     */
    public void setWrkCentersShipgSetupTimeInDays( @Nullable final BigDecimal wrkCentersShipgSetupTimeInDays )
    {
        rememberChangedField("WrkCentersShipgSetupTimeInDays", this.wrkCentersShipgSetupTimeInDays);
        this.wrkCentersShipgSetupTimeInDays = wrkCentersShipgSetupTimeInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityCheckType</b>
     * </p>
     *
     * @param availabilityCheckType
     *            Checking Group for Availability Check
     */
    public void setAvailabilityCheckType( @Nullable final String availabilityCheckType )
    {
        rememberChangedField("AvailabilityCheckType", this.availabilityCheckType);
        this.availabilityCheckType = availabilityCheckType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductPlantSales";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("LoadingGroup", getLoadingGroup());
        values.put("ReplacementPartType", getReplacementPartType());
        values.put("CapPlanningQuantityInBaseUoM", getCapPlanningQuantityInBaseUoM());
        values.put("ProductShippingProcessingTime", getProductShippingProcessingTime());
        values.put("WrkCentersShipgSetupTimeInDays", getWrkCentersShipgSetupTimeInDays());
        values.put("AvailabilityCheckType", getAvailabilityCheckType());
        values.put("BaseUnit", getBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("LoadingGroup") ) {
                final Object value = values.remove("LoadingGroup");
                if( (value == null) || (!value.equals(getLoadingGroup())) ) {
                    setLoadingGroup(((String) value));
                }
            }
            if( values.containsKey("ReplacementPartType") ) {
                final Object value = values.remove("ReplacementPartType");
                if( (value == null) || (!value.equals(getReplacementPartType())) ) {
                    setReplacementPartType(((String) value));
                }
            }
            if( values.containsKey("CapPlanningQuantityInBaseUoM") ) {
                final Object value = values.remove("CapPlanningQuantityInBaseUoM");
                if( (value == null) || (!value.equals(getCapPlanningQuantityInBaseUoM())) ) {
                    setCapPlanningQuantityInBaseUoM(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductShippingProcessingTime") ) {
                final Object value = values.remove("ProductShippingProcessingTime");
                if( (value == null) || (!value.equals(getProductShippingProcessingTime())) ) {
                    setProductShippingProcessingTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("WrkCentersShipgSetupTimeInDays") ) {
                final Object value = values.remove("WrkCentersShipgSetupTimeInDays");
                if( (value == null) || (!value.equals(getWrkCentersShipgSetupTimeInDays())) ) {
                    setWrkCentersShipgSetupTimeInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("AvailabilityCheckType") ) {
                final Object value = values.remove("AvailabilityCheckType");
                if( (value == null) || (!value.equals(getAvailabilityCheckType())) ) {
                    setAvailabilityCheckType(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductPlantSalesField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductPlantSalesField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductPlantSalesField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductPlantSalesField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
