/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductPlantStorageField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductPlantStorageSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Storage Data at Plant Level
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductPlantStorageType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductPlantStorage extends VdmEntity<ProductPlantStorage>
{

    /**
     * Selector for all available fields of ProductPlantStorage.
     *
     */
    public final static ProductPlantStorageSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductPlantStorageField<String> PRODUCT = new ProductPlantStorageField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductPlantStorageField<String> PLANT = new ProductPlantStorageField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventoryForCycleCountInd</b>
     * </p>
     *
     * @return Physical Inventory Indicator for Cycle Counting
     */
    @SerializedName( "InventoryForCycleCountInd" )
    @JsonProperty( "InventoryForCycleCountInd" )
    @Nullable
    @ODataField( odataName = "InventoryForCycleCountInd" )
    private String inventoryForCycleCountInd;
    /**
     * Use with available fluent helpers to apply the <b>InventoryForCycleCountInd</b> field to query operations.
     *
     */
    public final static ProductPlantStorageField<String> INVENTORY_FOR_CYCLE_COUNT_IND =
        new ProductPlantStorageField<String>("InventoryForCycleCountInd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProvisioningServiceLevel</b>
     * </p>
     *
     * @return IS-R service level
     */
    @SerializedName( "ProvisioningServiceLevel" )
    @JsonProperty( "ProvisioningServiceLevel" )
    @Nullable
    @ODataField( odataName = "ProvisioningServiceLevel" )
    private String provisioningServiceLevel;
    /**
     * Use with available fluent helpers to apply the <b>ProvisioningServiceLevel</b> field to query operations.
     *
     */
    public final static ProductPlantStorageField<String> PROVISIONING_SERVICE_LEVEL =
        new ProductPlantStorageField<String>("ProvisioningServiceLevel");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CycleCountingIndicatorIsFixed</b>
     * </p>
     *
     * @return CC indicator is fixed
     */
    @SerializedName( "CycleCountingIndicatorIsFixed" )
    @JsonProperty( "CycleCountingIndicatorIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CycleCountingIndicatorIsFixed" )
    private Boolean cycleCountingIndicatorIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>CycleCountingIndicatorIsFixed</b> field to query operations.
     *
     */
    public final static ProductPlantStorageField<Boolean> CYCLE_COUNTING_INDICATOR_IS_FIXED =
        new ProductPlantStorageField<Boolean>("CycleCountingIndicatorIsFixed");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdMaximumStoragePeriodUnit</b>
     * </p>
     *
     * @return Unit for maximum storage period
     */
    @SerializedName( "ProdMaximumStoragePeriodUnit" )
    @JsonProperty( "ProdMaximumStoragePeriodUnit" )
    @Nullable
    @ODataField( odataName = "ProdMaximumStoragePeriodUnit" )
    private String prodMaximumStoragePeriodUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProdMaximumStoragePeriodUnit</b> field to query operations.
     *
     */
    public final static ProductPlantStorageField<String> PROD_MAXIMUM_STORAGE_PERIOD_UNIT =
        new ProductPlantStorageField<String>("ProdMaximumStoragePeriodUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrhsMgmtPtwyAndStkRemovalStrgy</b>
     * </p>
     *
     * @return Strategy for Putaway and Stock Removal
     */
    @SerializedName( "WrhsMgmtPtwyAndStkRemovalStrgy" )
    @JsonProperty( "WrhsMgmtPtwyAndStkRemovalStrgy" )
    @Nullable
    @ODataField( odataName = "WrhsMgmtPtwyAndStkRemovalStrgy" )
    private String wrhsMgmtPtwyAndStkRemovalStrgy;
    /**
     * Use with available fluent helpers to apply the <b>WrhsMgmtPtwyAndStkRemovalStrgy</b> field to query operations.
     *
     */
    public final static ProductPlantStorageField<String> WRHS_MGMT_PTWY_AND_STK_REMOVAL_STRGY =
        new ProductPlantStorageField<String>("WrhsMgmtPtwyAndStkRemovalStrgy");

    @Nonnull
    @Override
    public Class<ProductPlantStorage> getType()
    {
        return ProductPlantStorage.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventoryForCycleCountInd</b>
     * </p>
     *
     * @param inventoryForCycleCountInd
     *            Physical Inventory Indicator for Cycle Counting
     */
    public void setInventoryForCycleCountInd( @Nullable final String inventoryForCycleCountInd )
    {
        rememberChangedField("InventoryForCycleCountInd", this.inventoryForCycleCountInd);
        this.inventoryForCycleCountInd = inventoryForCycleCountInd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProvisioningServiceLevel</b>
     * </p>
     *
     * @param provisioningServiceLevel
     *            IS-R service level
     */
    public void setProvisioningServiceLevel( @Nullable final String provisioningServiceLevel )
    {
        rememberChangedField("ProvisioningServiceLevel", this.provisioningServiceLevel);
        this.provisioningServiceLevel = provisioningServiceLevel;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CycleCountingIndicatorIsFixed</b>
     * </p>
     *
     * @param cycleCountingIndicatorIsFixed
     *            CC indicator is fixed
     */
    public void setCycleCountingIndicatorIsFixed( @Nullable final Boolean cycleCountingIndicatorIsFixed )
    {
        rememberChangedField("CycleCountingIndicatorIsFixed", this.cycleCountingIndicatorIsFixed);
        this.cycleCountingIndicatorIsFixed = cycleCountingIndicatorIsFixed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdMaximumStoragePeriodUnit</b>
     * </p>
     *
     * @param prodMaximumStoragePeriodUnit
     *            Unit for maximum storage period
     */
    public void setProdMaximumStoragePeriodUnit( @Nullable final String prodMaximumStoragePeriodUnit )
    {
        rememberChangedField("ProdMaximumStoragePeriodUnit", this.prodMaximumStoragePeriodUnit);
        this.prodMaximumStoragePeriodUnit = prodMaximumStoragePeriodUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrhsMgmtPtwyAndStkRemovalStrgy</b>
     * </p>
     *
     * @param wrhsMgmtPtwyAndStkRemovalStrgy
     *            Strategy for Putaway and Stock Removal
     */
    public void setWrhsMgmtPtwyAndStkRemovalStrgy( @Nullable final String wrhsMgmtPtwyAndStkRemovalStrgy )
    {
        rememberChangedField("WrhsMgmtPtwyAndStkRemovalStrgy", this.wrhsMgmtPtwyAndStkRemovalStrgy);
        this.wrhsMgmtPtwyAndStkRemovalStrgy = wrhsMgmtPtwyAndStkRemovalStrgy;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductPlantStorage";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("InventoryForCycleCountInd", getInventoryForCycleCountInd());
        values.put("ProvisioningServiceLevel", getProvisioningServiceLevel());
        values.put("CycleCountingIndicatorIsFixed", getCycleCountingIndicatorIsFixed());
        values.put("ProdMaximumStoragePeriodUnit", getProdMaximumStoragePeriodUnit());
        values.put("WrhsMgmtPtwyAndStkRemovalStrgy", getWrhsMgmtPtwyAndStkRemovalStrgy());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("InventoryForCycleCountInd") ) {
                final Object value = values.remove("InventoryForCycleCountInd");
                if( (value == null) || (!value.equals(getInventoryForCycleCountInd())) ) {
                    setInventoryForCycleCountInd(((String) value));
                }
            }
            if( values.containsKey("ProvisioningServiceLevel") ) {
                final Object value = values.remove("ProvisioningServiceLevel");
                if( (value == null) || (!value.equals(getProvisioningServiceLevel())) ) {
                    setProvisioningServiceLevel(((String) value));
                }
            }
            if( values.containsKey("CycleCountingIndicatorIsFixed") ) {
                final Object value = values.remove("CycleCountingIndicatorIsFixed");
                if( (value == null) || (!value.equals(getCycleCountingIndicatorIsFixed())) ) {
                    setCycleCountingIndicatorIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("ProdMaximumStoragePeriodUnit") ) {
                final Object value = values.remove("ProdMaximumStoragePeriodUnit");
                if( (value == null) || (!value.equals(getProdMaximumStoragePeriodUnit())) ) {
                    setProdMaximumStoragePeriodUnit(((String) value));
                }
            }
            if( values.containsKey("WrhsMgmtPtwyAndStkRemovalStrgy") ) {
                final Object value = values.remove("WrhsMgmtPtwyAndStkRemovalStrgy");
                if( (value == null) || (!value.equals(getWrhsMgmtPtwyAndStkRemovalStrgy())) ) {
                    setWrhsMgmtPtwyAndStkRemovalStrgy(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductPlantStorageField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductPlantStorageField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductPlantStorageField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductPlantStorageField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
