/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductProcurementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductProcurementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Basic Procurement Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductProcurementType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductProcurement extends VdmEntity<ProductProcurement>
{

    /**
     * Selector for all available fields of ProductProcurement.
     *
     */
    public final static ProductProcurementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductProcurementField<String> PRODUCT = new ProductProcurementField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "PurchaseOrderQuantityUnit" )
    @JsonProperty( "PurchaseOrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderQuantityUnit" )
    private String purchaseOrderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderQuantityUnit</b> field to query operations.
     *
     */
    public final static ProductProcurementField<String> PURCHASE_ORDER_QUANTITY_UNIT =
        new ProductProcurementField<String>("PurchaseOrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VarblPurOrdUnitStatus</b>
     * </p>
     *
     * @return Variable Purchase Order Unit Active
     */
    @SerializedName( "VarblPurOrdUnitStatus" )
    @JsonProperty( "VarblPurOrdUnitStatus" )
    @Nullable
    @ODataField( odataName = "VarblPurOrdUnitStatus" )
    private String varblPurOrdUnitStatus;
    /**
     * Use with available fluent helpers to apply the <b>VarblPurOrdUnitStatus</b> field to query operations.
     *
     */
    public final static ProductProcurementField<String> VARBL_PUR_ORD_UNIT_STATUS =
        new ProductProcurementField<String>("VarblPurOrdUnitStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingAcknProfile</b>
     * </p>
     *
     * @return Purchasing Value Key
     */
    @SerializedName( "PurchasingAcknProfile" )
    @JsonProperty( "PurchasingAcknProfile" )
    @Nullable
    @ODataField( odataName = "PurchasingAcknProfile" )
    private String purchasingAcknProfile;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingAcknProfile</b> field to query operations.
     *
     */
    public final static ProductProcurementField<String> PURCHASING_ACKN_PROFILE =
        new ProductProcurementField<String>("PurchasingAcknProfile");

    @Nonnull
    @Override
    public Class<ProductProcurement> getType()
    {
        return ProductProcurement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQuantityUnit</b>
     * </p>
     *
     * @param purchaseOrderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setPurchaseOrderQuantityUnit( @Nullable final String purchaseOrderQuantityUnit )
    {
        rememberChangedField("PurchaseOrderQuantityUnit", this.purchaseOrderQuantityUnit);
        this.purchaseOrderQuantityUnit = purchaseOrderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VarblPurOrdUnitStatus</b>
     * </p>
     *
     * @param varblPurOrdUnitStatus
     *            Variable Purchase Order Unit Active
     */
    public void setVarblPurOrdUnitStatus( @Nullable final String varblPurOrdUnitStatus )
    {
        rememberChangedField("VarblPurOrdUnitStatus", this.varblPurOrdUnitStatus);
        this.varblPurOrdUnitStatus = varblPurOrdUnitStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingAcknProfile</b>
     * </p>
     *
     * @param purchasingAcknProfile
     *            Purchasing Value Key
     */
    public void setPurchasingAcknProfile( @Nullable final String purchasingAcknProfile )
    {
        rememberChangedField("PurchasingAcknProfile", this.purchasingAcknProfile);
        this.purchasingAcknProfile = purchasingAcknProfile;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductProcurement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("PurchaseOrderQuantityUnit", getPurchaseOrderQuantityUnit());
        values.put("VarblPurOrdUnitStatus", getVarblPurOrdUnitStatus());
        values.put("PurchasingAcknProfile", getPurchasingAcknProfile());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderQuantityUnit") ) {
                final Object value = values.remove("PurchaseOrderQuantityUnit");
                if( (value == null) || (!value.equals(getPurchaseOrderQuantityUnit())) ) {
                    setPurchaseOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("VarblPurOrdUnitStatus") ) {
                final Object value = values.remove("VarblPurOrdUnitStatus");
                if( (value == null) || (!value.equals(getVarblPurOrdUnitStatus())) ) {
                    setVarblPurOrdUnitStatus(((String) value));
                }
            }
            if( values.containsKey("PurchasingAcknProfile") ) {
                final Object value = values.remove("PurchasingAcknProfile");
                if( (value == null) || (!value.equals(getPurchasingAcknProfile())) ) {
                    setPurchasingAcknProfile(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductProcurementField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductProcurementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductProcurementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductProcurementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
