/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductSalesField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductSalesSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Basic Sales Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductSalesType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductSales extends VdmEntity<ProductSales>
{

    /**
     * Selector for all available fields of ProductSales.
     *
     */
    public final static ProductSalesSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductSalesField<String> PRODUCT = new ProductSalesField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesStatus</b>
     * </p>
     *
     * @return Cross-Distribution-Chain Material Status
     */
    @SerializedName( "SalesStatus" )
    @JsonProperty( "SalesStatus" )
    @Nullable
    @ODataField( odataName = "SalesStatus" )
    private String salesStatus;
    /**
     * Use with available fluent helpers to apply the <b>SalesStatus</b> field to query operations.
     *
     */
    public final static ProductSalesField<String> SALES_STATUS = new ProductSalesField<String>("SalesStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SalesStatusValidityDate</b>
     * </p>
     *
     * @return Date from which the X-distr.-chain Product status is valid
     */
    @SerializedName( "SalesStatusValidityDate" )
    @JsonProperty( "SalesStatusValidityDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SalesStatusValidityDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime salesStatusValidityDate;
    /**
     * Use with available fluent helpers to apply the <b>SalesStatusValidityDate</b> field to query operations.
     *
     */
    public final static ProductSalesField<LocalDateTime> SALES_STATUS_VALIDITY_DATE =
        new ProductSalesField<LocalDateTime>("SalesStatusValidityDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaxClassification</b>
     * </p>
     *
     * @return Tax classification of the material
     */
    @SerializedName( "TaxClassification" )
    @JsonProperty( "TaxClassification" )
    @Nullable
    @ODataField( odataName = "TaxClassification" )
    private String taxClassification;
    /**
     * Use with available fluent helpers to apply the <b>TaxClassification</b> field to query operations.
     *
     */
    public final static ProductSalesField<String> TAX_CLASSIFICATION =
        new ProductSalesField<String>("TaxClassification");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TransportationGroup</b>
     * </p>
     *
     * @return Transportation Group
     */
    @SerializedName( "TransportationGroup" )
    @JsonProperty( "TransportationGroup" )
    @Nullable
    @ODataField( odataName = "TransportationGroup" )
    private String transportationGroup;
    /**
     * Use with available fluent helpers to apply the <b>TransportationGroup</b> field to query operations.
     *
     */
    public final static ProductSalesField<String> TRANSPORTATION_GROUP =
        new ProductSalesField<String>("TransportationGroup");

    @Nonnull
    @Override
    public Class<ProductSales> getType()
    {
        return ProductSales.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesStatus</b>
     * </p>
     *
     * @param salesStatus
     *            Cross-Distribution-Chain Material Status
     */
    public void setSalesStatus( @Nullable final String salesStatus )
    {
        rememberChangedField("SalesStatus", this.salesStatus);
        this.salesStatus = salesStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SalesStatusValidityDate</b>
     * </p>
     *
     * @param salesStatusValidityDate
     *            Date from which the X-distr.-chain Product status is valid
     */
    public void setSalesStatusValidityDate( @Nullable final LocalDateTime salesStatusValidityDate )
    {
        rememberChangedField("SalesStatusValidityDate", this.salesStatusValidityDate);
        this.salesStatusValidityDate = salesStatusValidityDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaxClassification</b>
     * </p>
     *
     * @param taxClassification
     *            Tax classification of the material
     */
    public void setTaxClassification( @Nullable final String taxClassification )
    {
        rememberChangedField("TaxClassification", this.taxClassification);
        this.taxClassification = taxClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TransportationGroup</b>
     * </p>
     *
     * @param transportationGroup
     *            Transportation Group
     */
    public void setTransportationGroup( @Nullable final String transportationGroup )
    {
        rememberChangedField("TransportationGroup", this.transportationGroup);
        this.transportationGroup = transportationGroup;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductSales";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("SalesStatus", getSalesStatus());
        values.put("SalesStatusValidityDate", getSalesStatusValidityDate());
        values.put("TaxClassification", getTaxClassification());
        values.put("TransportationGroup", getTransportationGroup());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("SalesStatus") ) {
                final Object value = values.remove("SalesStatus");
                if( (value == null) || (!value.equals(getSalesStatus())) ) {
                    setSalesStatus(((String) value));
                }
            }
            if( values.containsKey("SalesStatusValidityDate") ) {
                final Object value = values.remove("SalesStatusValidityDate");
                if( (value == null) || (!value.equals(getSalesStatusValidityDate())) ) {
                    setSalesStatusValidityDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TaxClassification") ) {
                final Object value = values.remove("TaxClassification");
                if( (value == null) || (!value.equals(getTaxClassification())) ) {
                    setTaxClassification(((String) value));
                }
            }
            if( values.containsKey("TransportationGroup") ) {
                final Object value = values.remove("TransportationGroup");
                if( (value == null) || (!value.equals(getTransportationGroup())) ) {
                    setTransportationGroup(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProductSalesField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductSalesField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductSalesField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductSalesField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
