/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductSalesDeliveryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductSalesDeliveryLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductSalesDeliverySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Organization Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductSalesDeliveryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductSalesDelivery extends VdmEntity<ProductSalesDelivery>
{

    /**
     * Selector for all available fields of ProductSalesDelivery.
     *
     */
    public final static ProductSalesDeliverySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRODUCT = new ProductSalesDeliveryField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductSalesOrg</b>
     * </p>
     *
     * @return Sales Organization
     */
    @Key
    @SerializedName( "ProductSalesOrg" )
    @JsonProperty( "ProductSalesOrg" )
    @Nullable
    @ODataField( odataName = "ProductSalesOrg" )
    private String productSalesOrg;
    /**
     * Use with available fluent helpers to apply the <b>ProductSalesOrg</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRODUCT_SALES_ORG =
        new ProductSalesDeliveryField<String>("ProductSalesOrg");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductDistributionChnl</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @Key
    @SerializedName( "ProductDistributionChnl" )
    @JsonProperty( "ProductDistributionChnl" )
    @Nullable
    @ODataField( odataName = "ProductDistributionChnl" )
    private String productDistributionChnl;
    /**
     * Use with available fluent helpers to apply the <b>ProductDistributionChnl</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRODUCT_DISTRIBUTION_CHNL =
        new ProductSalesDeliveryField<String>("ProductDistributionChnl");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumOrderQuantity</b>
     * </p>
     *
     * @return Minimum order quantity in base unit of measure
     */
    @SerializedName( "MinimumOrderQuantity" )
    @JsonProperty( "MinimumOrderQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumOrderQuantity" )
    private BigDecimal minimumOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumOrderQuantity</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<BigDecimal> MINIMUM_ORDER_QUANTITY =
        new ProductSalesDeliveryField<BigDecimal>("MinimumOrderQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     *
     * @return Delivering Plant (Own or External)
     */
    @SerializedName( "SupplyingPlant" )
    @JsonProperty( "SupplyingPlant" )
    @Nullable
    @ODataField( odataName = "SupplyingPlant" )
    private String supplyingPlant;
    /**
     * Use with available fluent helpers to apply the <b>SupplyingPlant</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> SUPPLYING_PLANT =
        new ProductSalesDeliveryField<String>("SupplyingPlant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PriceSpecificationProductGroup</b>
     * </p>
     *
     * @return Product Pricing Group
     */
    @SerializedName( "PriceSpecificationProductGroup" )
    @JsonProperty( "PriceSpecificationProductGroup" )
    @Nullable
    @ODataField( odataName = "PriceSpecificationProductGroup" )
    private String priceSpecificationProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>PriceSpecificationProductGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRICE_SPECIFICATION_PRODUCT_GROUP =
        new ProductSalesDeliveryField<String>("PriceSpecificationProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountDetnProductGroup</b>
     * </p>
     *
     * @return Account Assignment Group for Material
     */
    @SerializedName( "AccountDetnProductGroup" )
    @JsonProperty( "AccountDetnProductGroup" )
    @Nullable
    @ODataField( odataName = "AccountDetnProductGroup" )
    private String accountDetnProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>AccountDetnProductGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> ACCOUNT_DETN_PRODUCT_GROUP =
        new ProductSalesDeliveryField<String>("AccountDetnProductGroup");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryNoteProcMinDelivQty</b>
     * </p>
     *
     * @return Minimum Delivery Quantity in Delivery Note Processing
     */
    @SerializedName( "DeliveryNoteProcMinDelivQty" )
    @JsonProperty( "DeliveryNoteProcMinDelivQty" )
    @Nullable
    @ODataField( odataName = "DeliveryNoteProcMinDelivQty" )
    private BigDecimal deliveryNoteProcMinDelivQty;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryNoteProcMinDelivQty</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<BigDecimal> DELIVERY_NOTE_PROC_MIN_DELIV_QTY =
        new ProductSalesDeliveryField<BigDecimal>("DeliveryNoteProcMinDelivQty");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ItemCategoryGroup</b>
     * </p>
     *
     * @return Item Category Group from Material Master
     */
    @SerializedName( "ItemCategoryGroup" )
    @JsonProperty( "ItemCategoryGroup" )
    @Nullable
    @ODataField( odataName = "ItemCategoryGroup" )
    private String itemCategoryGroup;
    /**
     * Use with available fluent helpers to apply the <b>ItemCategoryGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> ITEM_CATEGORY_GROUP =
        new ProductSalesDeliveryField<String>("ItemCategoryGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryQuantityUnit</b>
     * </p>
     *
     * @return Unit Of Measure Of Delivery Unit
     */
    @SerializedName( "DeliveryQuantityUnit" )
    @JsonProperty( "DeliveryQuantityUnit" )
    @Nullable
    @ODataField( odataName = "DeliveryQuantityUnit" )
    private String deliveryQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryQuantityUnit</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> DELIVERY_QUANTITY_UNIT =
        new ProductSalesDeliveryField<String>("DeliveryQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryQuantity</b>
     * </p>
     *
     * @return Delivery unit
     */
    @SerializedName( "DeliveryQuantity" )
    @JsonProperty( "DeliveryQuantity" )
    @Nullable
    @ODataField( odataName = "DeliveryQuantity" )
    private BigDecimal deliveryQuantity;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryQuantity</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<BigDecimal> DELIVERY_QUANTITY =
        new ProductSalesDeliveryField<BigDecimal>("DeliveryQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductSalesStatus</b>
     * </p>
     *
     * @return Distribution-chain-specific material status
     */
    @SerializedName( "ProductSalesStatus" )
    @JsonProperty( "ProductSalesStatus" )
    @Nullable
    @ODataField( odataName = "ProductSalesStatus" )
    private String productSalesStatus;
    /**
     * Use with available fluent helpers to apply the <b>ProductSalesStatus</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRODUCT_SALES_STATUS =
        new ProductSalesDeliveryField<String>("ProductSalesStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductSalesStatusValidityDate</b>
     * </p>
     *
     * @return Date from which distr.-chain-spec. material status is valid
     */
    @SerializedName( "ProductSalesStatusValidityDate" )
    @JsonProperty( "ProductSalesStatusValidityDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProductSalesStatusValidityDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime productSalesStatusValidityDate;
    /**
     * Use with available fluent helpers to apply the <b>ProductSalesStatusValidityDate</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<LocalDateTime> PRODUCT_SALES_STATUS_VALIDITY_DATE =
        new ProductSalesDeliveryField<LocalDateTime>("ProductSalesStatusValidityDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesMeasureUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "SalesMeasureUnit" )
    @JsonProperty( "SalesMeasureUnit" )
    @Nullable
    @ODataField( odataName = "SalesMeasureUnit" )
    private String salesMeasureUnit;
    /**
     * Use with available fluent helpers to apply the <b>SalesMeasureUnit</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> SALES_MEASURE_UNIT =
        new ProductSalesDeliveryField<String>("SalesMeasureUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Ind.: Flag material for deletion at distribution chain level
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<Boolean> IS_MARKED_FOR_DELETION =
        new ProductSalesDeliveryField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchy</b>
     * </p>
     *
     * @return Product Hierarchy
     */
    @SerializedName( "ProductHierarchy" )
    @JsonProperty( "ProductHierarchy" )
    @Nullable
    @ODataField( odataName = "ProductHierarchy" )
    private String productHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>ProductHierarchy</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRODUCT_HIERARCHY =
        new ProductSalesDeliveryField<String>("ProductHierarchy");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FirstSalesSpecProductGroup</b>
     * </p>
     *
     * @return Product Group 1
     */
    @SerializedName( "FirstSalesSpecProductGroup" )
    @JsonProperty( "FirstSalesSpecProductGroup" )
    @Nullable
    @ODataField( odataName = "FirstSalesSpecProductGroup" )
    private String firstSalesSpecProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>FirstSalesSpecProductGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> FIRST_SALES_SPEC_PRODUCT_GROUP =
        new ProductSalesDeliveryField<String>("FirstSalesSpecProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SecondSalesSpecProductGroup</b>
     * </p>
     *
     * @return Product Group 2
     */
    @SerializedName( "SecondSalesSpecProductGroup" )
    @JsonProperty( "SecondSalesSpecProductGroup" )
    @Nullable
    @ODataField( odataName = "SecondSalesSpecProductGroup" )
    private String secondSalesSpecProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>SecondSalesSpecProductGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> SECOND_SALES_SPEC_PRODUCT_GROUP =
        new ProductSalesDeliveryField<String>("SecondSalesSpecProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ThirdSalesSpecProductGroup</b>
     * </p>
     *
     * @return Product Group 3
     */
    @SerializedName( "ThirdSalesSpecProductGroup" )
    @JsonProperty( "ThirdSalesSpecProductGroup" )
    @Nullable
    @ODataField( odataName = "ThirdSalesSpecProductGroup" )
    private String thirdSalesSpecProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>ThirdSalesSpecProductGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> THIRD_SALES_SPEC_PRODUCT_GROUP =
        new ProductSalesDeliveryField<String>("ThirdSalesSpecProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FourthSalesSpecProductGroup</b>
     * </p>
     *
     * @return Product Group 4
     */
    @SerializedName( "FourthSalesSpecProductGroup" )
    @JsonProperty( "FourthSalesSpecProductGroup" )
    @Nullable
    @ODataField( odataName = "FourthSalesSpecProductGroup" )
    private String fourthSalesSpecProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>FourthSalesSpecProductGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> FOURTH_SALES_SPEC_PRODUCT_GROUP =
        new ProductSalesDeliveryField<String>("FourthSalesSpecProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FifthSalesSpecProductGroup</b>
     * </p>
     *
     * @return Product Group 5
     */
    @SerializedName( "FifthSalesSpecProductGroup" )
    @JsonProperty( "FifthSalesSpecProductGroup" )
    @Nullable
    @ODataField( odataName = "FifthSalesSpecProductGroup" )
    private String fifthSalesSpecProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>FifthSalesSpecProductGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> FIFTH_SALES_SPEC_PRODUCT_GROUP =
        new ProductSalesDeliveryField<String>("FifthSalesSpecProductGroup");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumMakeToOrderOrderQty</b>
     * </p>
     *
     * @return Minimum make-to-order quantity
     */
    @SerializedName( "MinimumMakeToOrderOrderQty" )
    @JsonProperty( "MinimumMakeToOrderOrderQty" )
    @Nullable
    @ODataField( odataName = "MinimumMakeToOrderOrderQty" )
    private BigDecimal minimumMakeToOrderOrderQty;
    /**
     * Use with available fluent helpers to apply the <b>MinimumMakeToOrderOrderQty</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<BigDecimal> MINIMUM_MAKE_TO_ORDER_ORDER_QTY =
        new ProductSalesDeliveryField<BigDecimal>("MinimumMakeToOrderOrderQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> BASE_UNIT = new ProductSalesDeliveryField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LogisticsStatisticsGroup</b>
     * </p>
     *
     * @return Material statistics group
     */
    @SerializedName( "LogisticsStatisticsGroup" )
    @JsonProperty( "LogisticsStatisticsGroup" )
    @Nullable
    @ODataField( odataName = "LogisticsStatisticsGroup" )
    private String logisticsStatisticsGroup;
    /**
     * Use with available fluent helpers to apply the <b>LogisticsStatisticsGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> LOGISTICS_STATISTICS_GROUP =
        new ProductSalesDeliveryField<String>("LogisticsStatisticsGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>VolumeRebateGroup</b>
     * </p>
     *
     * @return Volume rebate group
     */
    @SerializedName( "VolumeRebateGroup" )
    @JsonProperty( "VolumeRebateGroup" )
    @Nullable
    @ODataField( odataName = "VolumeRebateGroup" )
    private String volumeRebateGroup;
    /**
     * Use with available fluent helpers to apply the <b>VolumeRebateGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> VOLUME_REBATE_GROUP =
        new ProductSalesDeliveryField<String>("VolumeRebateGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductCommissionGroup</b>
     * </p>
     *
     * @return Commission Group
     */
    @SerializedName( "ProductCommissionGroup" )
    @JsonProperty( "ProductCommissionGroup" )
    @Nullable
    @ODataField( odataName = "ProductCommissionGroup" )
    private String productCommissionGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProductCommissionGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRODUCT_COMMISSION_GROUP =
        new ProductSalesDeliveryField<String>("ProductCommissionGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountIsDeductible</b>
     * </p>
     *
     * @return Cash Discount Indicator
     */
    @SerializedName( "CashDiscountIsDeductible" )
    @JsonProperty( "CashDiscountIsDeductible" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CashDiscountIsDeductible" )
    private Boolean cashDiscountIsDeductible;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscountIsDeductible</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<Boolean> CASH_DISCOUNT_IS_DEDUCTIBLE =
        new ProductSalesDeliveryField<Boolean>("CashDiscountIsDeductible");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PricingReferenceProduct</b>
     * </p>
     *
     * @return Pricing Reference Material
     */
    @SerializedName( "PricingReferenceProduct" )
    @JsonProperty( "PricingReferenceProduct" )
    @Nullable
    @ODataField( odataName = "PricingReferenceProduct" )
    private String pricingReferenceProduct;
    /**
     * Use with available fluent helpers to apply the <b>PricingReferenceProduct</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRICING_REFERENCE_PRODUCT =
        new ProductSalesDeliveryField<String>("PricingReferenceProduct");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RoundingProfile</b>
     * </p>
     *
     * @return Rounding Profile
     */
    @SerializedName( "RoundingProfile" )
    @JsonProperty( "RoundingProfile" )
    @Nullable
    @ODataField( odataName = "RoundingProfile" )
    private String roundingProfile;
    /**
     * Use with available fluent helpers to apply the <b>RoundingProfile</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> ROUNDING_PROFILE =
        new ProductSalesDeliveryField<String>("RoundingProfile");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductUnitGroup</b>
     * </p>
     *
     * @return Unit of Measure Group
     */
    @SerializedName( "ProductUnitGroup" )
    @JsonProperty( "ProductUnitGroup" )
    @Nullable
    @ODataField( odataName = "ProductUnitGroup" )
    private String productUnitGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProductUnitGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRODUCT_UNIT_GROUP =
        new ProductSalesDeliveryField<String>("ProductUnitGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>VariableSalesUnitIsNotAllowed</b>
     * </p>
     *
     * @return Variable Sales Unit Not Allowed
     */
    @SerializedName( "VariableSalesUnitIsNotAllowed" )
    @JsonProperty( "VariableSalesUnitIsNotAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "VariableSalesUnitIsNotAllowed" )
    private Boolean variableSalesUnitIsNotAllowed;
    /**
     * Use with available fluent helpers to apply the <b>VariableSalesUnitIsNotAllowed</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<Boolean> VARIABLE_SALES_UNIT_IS_NOT_ALLOWED =
        new ProductSalesDeliveryField<Boolean>("VariableSalesUnitIsNotAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID01</b>
     * </p>
     *
     * @return ID for product attribute 1
     */
    @SerializedName( "ProductHasAttributeID01" )
    @JsonProperty( "ProductHasAttributeID01" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductHasAttributeID01" )
    private Boolean productHasAttributeID01;
    /**
     * Use with available fluent helpers to apply the <b>ProductHasAttributeID01</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<Boolean> PRODUCT_HAS_ATTRIBUTE_I_D01 =
        new ProductSalesDeliveryField<Boolean>("ProductHasAttributeID01");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID02</b>
     * </p>
     *
     * @return ID for product attribute 2
     */
    @SerializedName( "ProductHasAttributeID02" )
    @JsonProperty( "ProductHasAttributeID02" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductHasAttributeID02" )
    private Boolean productHasAttributeID02;
    /**
     * Use with available fluent helpers to apply the <b>ProductHasAttributeID02</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<Boolean> PRODUCT_HAS_ATTRIBUTE_I_D02 =
        new ProductSalesDeliveryField<Boolean>("ProductHasAttributeID02");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID03</b>
     * </p>
     *
     * @return ID for product attribute 3
     */
    @SerializedName( "ProductHasAttributeID03" )
    @JsonProperty( "ProductHasAttributeID03" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductHasAttributeID03" )
    private Boolean productHasAttributeID03;
    /**
     * Use with available fluent helpers to apply the <b>ProductHasAttributeID03</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<Boolean> PRODUCT_HAS_ATTRIBUTE_I_D03 =
        new ProductSalesDeliveryField<Boolean>("ProductHasAttributeID03");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID04</b>
     * </p>
     *
     * @return ID for product attribute 4
     */
    @SerializedName( "ProductHasAttributeID04" )
    @JsonProperty( "ProductHasAttributeID04" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductHasAttributeID04" )
    private Boolean productHasAttributeID04;
    /**
     * Use with available fluent helpers to apply the <b>ProductHasAttributeID04</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<Boolean> PRODUCT_HAS_ATTRIBUTE_I_D04 =
        new ProductSalesDeliveryField<Boolean>("ProductHasAttributeID04");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID05</b>
     * </p>
     *
     * @return ID for product attribute 5
     */
    @SerializedName( "ProductHasAttributeID05" )
    @JsonProperty( "ProductHasAttributeID05" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductHasAttributeID05" )
    private Boolean productHasAttributeID05;
    /**
     * Use with available fluent helpers to apply the <b>ProductHasAttributeID05</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<Boolean> PRODUCT_HAS_ATTRIBUTE_I_D05 =
        new ProductSalesDeliveryField<Boolean>("ProductHasAttributeID05");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID06</b>
     * </p>
     *
     * @return ID for product attribute 6
     */
    @SerializedName( "ProductHasAttributeID06" )
    @JsonProperty( "ProductHasAttributeID06" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductHasAttributeID06" )
    private Boolean productHasAttributeID06;
    /**
     * Use with available fluent helpers to apply the <b>ProductHasAttributeID06</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<Boolean> PRODUCT_HAS_ATTRIBUTE_I_D06 =
        new ProductSalesDeliveryField<Boolean>("ProductHasAttributeID06");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID07</b>
     * </p>
     *
     * @return ID for product attribute 7
     */
    @SerializedName( "ProductHasAttributeID07" )
    @JsonProperty( "ProductHasAttributeID07" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductHasAttributeID07" )
    private Boolean productHasAttributeID07;
    /**
     * Use with available fluent helpers to apply the <b>ProductHasAttributeID07</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<Boolean> PRODUCT_HAS_ATTRIBUTE_I_D07 =
        new ProductSalesDeliveryField<Boolean>("ProductHasAttributeID07");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID08</b>
     * </p>
     *
     * @return ID for product attribute 8
     */
    @SerializedName( "ProductHasAttributeID08" )
    @JsonProperty( "ProductHasAttributeID08" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductHasAttributeID08" )
    private Boolean productHasAttributeID08;
    /**
     * Use with available fluent helpers to apply the <b>ProductHasAttributeID08</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<Boolean> PRODUCT_HAS_ATTRIBUTE_I_D08 =
        new ProductSalesDeliveryField<Boolean>("ProductHasAttributeID08");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID09</b>
     * </p>
     *
     * @return ID for product attribute 9
     */
    @SerializedName( "ProductHasAttributeID09" )
    @JsonProperty( "ProductHasAttributeID09" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductHasAttributeID09" )
    private Boolean productHasAttributeID09;
    /**
     * Use with available fluent helpers to apply the <b>ProductHasAttributeID09</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<Boolean> PRODUCT_HAS_ATTRIBUTE_I_D09 =
        new ProductSalesDeliveryField<Boolean>("ProductHasAttributeID09");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID10</b>
     * </p>
     *
     * @return ID for product attribute 10
     */
    @SerializedName( "ProductHasAttributeID10" )
    @JsonProperty( "ProductHasAttributeID10" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductHasAttributeID10" )
    private Boolean productHasAttributeID10;
    /**
     * Use with available fluent helpers to apply the <b>ProductHasAttributeID10</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<Boolean> PRODUCT_HAS_ATTRIBUTE_I_D10 =
        new ProductSalesDeliveryField<Boolean>("ProductHasAttributeID10");
    /**
     * Navigation property <b>to_SalesTax</b> for <b>ProductSalesDelivery</b> to multiple <b>ProductSalesTax</b>.
     *
     */
    @SerializedName( "to_SalesTax" )
    @JsonProperty( "to_SalesTax" )
    @ODataField( odataName = "to_SalesTax" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductSalesTax> toSalesTax;
    /**
     * Navigation property <b>to_SalesText</b> for <b>ProductSalesDelivery</b> to multiple <b>ProductSalesText</b>.
     *
     */
    @SerializedName( "to_SalesText" )
    @JsonProperty( "to_SalesText" )
    @ODataField( odataName = "to_SalesText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductSalesText> toSalesText;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesTax</b> navigation property to query operations.
     *
     */
    public final static ProductSalesDeliveryLink<ProductSalesTax> TO_SALES_TAX =
        new ProductSalesDeliveryLink<ProductSalesTax>("to_SalesTax");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesText</b> navigation property to query operations.
     *
     */
    public final static ProductSalesDeliveryLink<ProductSalesText> TO_SALES_TEXT =
        new ProductSalesDeliveryLink<ProductSalesText>("to_SalesText");

    @Nonnull
    @Override
    public Class<ProductSalesDelivery> getType()
    {
        return ProductSalesDelivery.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductSalesOrg</b>
     * </p>
     *
     * @param productSalesOrg
     *            Sales Organization
     */
    public void setProductSalesOrg( @Nullable final String productSalesOrg )
    {
        rememberChangedField("ProductSalesOrg", this.productSalesOrg);
        this.productSalesOrg = productSalesOrg;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductDistributionChnl</b>
     * </p>
     *
     * @param productDistributionChnl
     *            Distribution Channel
     */
    public void setProductDistributionChnl( @Nullable final String productDistributionChnl )
    {
        rememberChangedField("ProductDistributionChnl", this.productDistributionChnl);
        this.productDistributionChnl = productDistributionChnl;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumOrderQuantity</b>
     * </p>
     *
     * @param minimumOrderQuantity
     *            Minimum order quantity in base unit of measure
     */
    public void setMinimumOrderQuantity( @Nullable final BigDecimal minimumOrderQuantity )
    {
        rememberChangedField("MinimumOrderQuantity", this.minimumOrderQuantity);
        this.minimumOrderQuantity = minimumOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     *
     * @param supplyingPlant
     *            Delivering Plant (Own or External)
     */
    public void setSupplyingPlant( @Nullable final String supplyingPlant )
    {
        rememberChangedField("SupplyingPlant", this.supplyingPlant);
        this.supplyingPlant = supplyingPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PriceSpecificationProductGroup</b>
     * </p>
     *
     * @param priceSpecificationProductGroup
     *            Product Pricing Group
     */
    public void setPriceSpecificationProductGroup( @Nullable final String priceSpecificationProductGroup )
    {
        rememberChangedField("PriceSpecificationProductGroup", this.priceSpecificationProductGroup);
        this.priceSpecificationProductGroup = priceSpecificationProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountDetnProductGroup</b>
     * </p>
     *
     * @param accountDetnProductGroup
     *            Account Assignment Group for Material
     */
    public void setAccountDetnProductGroup( @Nullable final String accountDetnProductGroup )
    {
        rememberChangedField("AccountDetnProductGroup", this.accountDetnProductGroup);
        this.accountDetnProductGroup = accountDetnProductGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryNoteProcMinDelivQty</b>
     * </p>
     *
     * @param deliveryNoteProcMinDelivQty
     *            Minimum Delivery Quantity in Delivery Note Processing
     */
    public void setDeliveryNoteProcMinDelivQty( @Nullable final BigDecimal deliveryNoteProcMinDelivQty )
    {
        rememberChangedField("DeliveryNoteProcMinDelivQty", this.deliveryNoteProcMinDelivQty);
        this.deliveryNoteProcMinDelivQty = deliveryNoteProcMinDelivQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ItemCategoryGroup</b>
     * </p>
     *
     * @param itemCategoryGroup
     *            Item Category Group from Material Master
     */
    public void setItemCategoryGroup( @Nullable final String itemCategoryGroup )
    {
        rememberChangedField("ItemCategoryGroup", this.itemCategoryGroup);
        this.itemCategoryGroup = itemCategoryGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryQuantityUnit</b>
     * </p>
     *
     * @param deliveryQuantityUnit
     *            Unit Of Measure Of Delivery Unit
     */
    public void setDeliveryQuantityUnit( @Nullable final String deliveryQuantityUnit )
    {
        rememberChangedField("DeliveryQuantityUnit", this.deliveryQuantityUnit);
        this.deliveryQuantityUnit = deliveryQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryQuantity</b>
     * </p>
     *
     * @param deliveryQuantity
     *            Delivery unit
     */
    public void setDeliveryQuantity( @Nullable final BigDecimal deliveryQuantity )
    {
        rememberChangedField("DeliveryQuantity", this.deliveryQuantity);
        this.deliveryQuantity = deliveryQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductSalesStatus</b>
     * </p>
     *
     * @param productSalesStatus
     *            Distribution-chain-specific material status
     */
    public void setProductSalesStatus( @Nullable final String productSalesStatus )
    {
        rememberChangedField("ProductSalesStatus", this.productSalesStatus);
        this.productSalesStatus = productSalesStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductSalesStatusValidityDate</b>
     * </p>
     *
     * @param productSalesStatusValidityDate
     *            Date from which distr.-chain-spec. material status is valid
     */
    public void setProductSalesStatusValidityDate( @Nullable final LocalDateTime productSalesStatusValidityDate )
    {
        rememberChangedField("ProductSalesStatusValidityDate", this.productSalesStatusValidityDate);
        this.productSalesStatusValidityDate = productSalesStatusValidityDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesMeasureUnit</b>
     * </p>
     *
     * @param salesMeasureUnit
     *            Sales Unit
     */
    public void setSalesMeasureUnit( @Nullable final String salesMeasureUnit )
    {
        rememberChangedField("SalesMeasureUnit", this.salesMeasureUnit);
        this.salesMeasureUnit = salesMeasureUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Ind.: Flag material for deletion at distribution chain level
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchy</b>
     * </p>
     *
     * @param productHierarchy
     *            Product Hierarchy
     */
    public void setProductHierarchy( @Nullable final String productHierarchy )
    {
        rememberChangedField("ProductHierarchy", this.productHierarchy);
        this.productHierarchy = productHierarchy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FirstSalesSpecProductGroup</b>
     * </p>
     *
     * @param firstSalesSpecProductGroup
     *            Product Group 1
     */
    public void setFirstSalesSpecProductGroup( @Nullable final String firstSalesSpecProductGroup )
    {
        rememberChangedField("FirstSalesSpecProductGroup", this.firstSalesSpecProductGroup);
        this.firstSalesSpecProductGroup = firstSalesSpecProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SecondSalesSpecProductGroup</b>
     * </p>
     *
     * @param secondSalesSpecProductGroup
     *            Product Group 2
     */
    public void setSecondSalesSpecProductGroup( @Nullable final String secondSalesSpecProductGroup )
    {
        rememberChangedField("SecondSalesSpecProductGroup", this.secondSalesSpecProductGroup);
        this.secondSalesSpecProductGroup = secondSalesSpecProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ThirdSalesSpecProductGroup</b>
     * </p>
     *
     * @param thirdSalesSpecProductGroup
     *            Product Group 3
     */
    public void setThirdSalesSpecProductGroup( @Nullable final String thirdSalesSpecProductGroup )
    {
        rememberChangedField("ThirdSalesSpecProductGroup", this.thirdSalesSpecProductGroup);
        this.thirdSalesSpecProductGroup = thirdSalesSpecProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FourthSalesSpecProductGroup</b>
     * </p>
     *
     * @param fourthSalesSpecProductGroup
     *            Product Group 4
     */
    public void setFourthSalesSpecProductGroup( @Nullable final String fourthSalesSpecProductGroup )
    {
        rememberChangedField("FourthSalesSpecProductGroup", this.fourthSalesSpecProductGroup);
        this.fourthSalesSpecProductGroup = fourthSalesSpecProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FifthSalesSpecProductGroup</b>
     * </p>
     *
     * @param fifthSalesSpecProductGroup
     *            Product Group 5
     */
    public void setFifthSalesSpecProductGroup( @Nullable final String fifthSalesSpecProductGroup )
    {
        rememberChangedField("FifthSalesSpecProductGroup", this.fifthSalesSpecProductGroup);
        this.fifthSalesSpecProductGroup = fifthSalesSpecProductGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumMakeToOrderOrderQty</b>
     * </p>
     *
     * @param minimumMakeToOrderOrderQty
     *            Minimum make-to-order quantity
     */
    public void setMinimumMakeToOrderOrderQty( @Nullable final BigDecimal minimumMakeToOrderOrderQty )
    {
        rememberChangedField("MinimumMakeToOrderOrderQty", this.minimumMakeToOrderOrderQty);
        this.minimumMakeToOrderOrderQty = minimumMakeToOrderOrderQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LogisticsStatisticsGroup</b>
     * </p>
     *
     * @param logisticsStatisticsGroup
     *            Material statistics group
     */
    public void setLogisticsStatisticsGroup( @Nullable final String logisticsStatisticsGroup )
    {
        rememberChangedField("LogisticsStatisticsGroup", this.logisticsStatisticsGroup);
        this.logisticsStatisticsGroup = logisticsStatisticsGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>VolumeRebateGroup</b>
     * </p>
     *
     * @param volumeRebateGroup
     *            Volume rebate group
     */
    public void setVolumeRebateGroup( @Nullable final String volumeRebateGroup )
    {
        rememberChangedField("VolumeRebateGroup", this.volumeRebateGroup);
        this.volumeRebateGroup = volumeRebateGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductCommissionGroup</b>
     * </p>
     *
     * @param productCommissionGroup
     *            Commission Group
     */
    public void setProductCommissionGroup( @Nullable final String productCommissionGroup )
    {
        rememberChangedField("ProductCommissionGroup", this.productCommissionGroup);
        this.productCommissionGroup = productCommissionGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountIsDeductible</b>
     * </p>
     *
     * @param cashDiscountIsDeductible
     *            Cash Discount Indicator
     */
    public void setCashDiscountIsDeductible( @Nullable final Boolean cashDiscountIsDeductible )
    {
        rememberChangedField("CashDiscountIsDeductible", this.cashDiscountIsDeductible);
        this.cashDiscountIsDeductible = cashDiscountIsDeductible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PricingReferenceProduct</b>
     * </p>
     *
     * @param pricingReferenceProduct
     *            Pricing Reference Material
     */
    public void setPricingReferenceProduct( @Nullable final String pricingReferenceProduct )
    {
        rememberChangedField("PricingReferenceProduct", this.pricingReferenceProduct);
        this.pricingReferenceProduct = pricingReferenceProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RoundingProfile</b>
     * </p>
     *
     * @param roundingProfile
     *            Rounding Profile
     */
    public void setRoundingProfile( @Nullable final String roundingProfile )
    {
        rememberChangedField("RoundingProfile", this.roundingProfile);
        this.roundingProfile = roundingProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductUnitGroup</b>
     * </p>
     *
     * @param productUnitGroup
     *            Unit of Measure Group
     */
    public void setProductUnitGroup( @Nullable final String productUnitGroup )
    {
        rememberChangedField("ProductUnitGroup", this.productUnitGroup);
        this.productUnitGroup = productUnitGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>VariableSalesUnitIsNotAllowed</b>
     * </p>
     *
     * @param variableSalesUnitIsNotAllowed
     *            Variable Sales Unit Not Allowed
     */
    public void setVariableSalesUnitIsNotAllowed( @Nullable final Boolean variableSalesUnitIsNotAllowed )
    {
        rememberChangedField("VariableSalesUnitIsNotAllowed", this.variableSalesUnitIsNotAllowed);
        this.variableSalesUnitIsNotAllowed = variableSalesUnitIsNotAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID01</b>
     * </p>
     *
     * @param productHasAttributeID01
     *            ID for product attribute 1
     */
    public void setProductHasAttributeID01( @Nullable final Boolean productHasAttributeID01 )
    {
        rememberChangedField("ProductHasAttributeID01", this.productHasAttributeID01);
        this.productHasAttributeID01 = productHasAttributeID01;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID02</b>
     * </p>
     *
     * @param productHasAttributeID02
     *            ID for product attribute 2
     */
    public void setProductHasAttributeID02( @Nullable final Boolean productHasAttributeID02 )
    {
        rememberChangedField("ProductHasAttributeID02", this.productHasAttributeID02);
        this.productHasAttributeID02 = productHasAttributeID02;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID03</b>
     * </p>
     *
     * @param productHasAttributeID03
     *            ID for product attribute 3
     */
    public void setProductHasAttributeID03( @Nullable final Boolean productHasAttributeID03 )
    {
        rememberChangedField("ProductHasAttributeID03", this.productHasAttributeID03);
        this.productHasAttributeID03 = productHasAttributeID03;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID04</b>
     * </p>
     *
     * @param productHasAttributeID04
     *            ID for product attribute 4
     */
    public void setProductHasAttributeID04( @Nullable final Boolean productHasAttributeID04 )
    {
        rememberChangedField("ProductHasAttributeID04", this.productHasAttributeID04);
        this.productHasAttributeID04 = productHasAttributeID04;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID05</b>
     * </p>
     *
     * @param productHasAttributeID05
     *            ID for product attribute 5
     */
    public void setProductHasAttributeID05( @Nullable final Boolean productHasAttributeID05 )
    {
        rememberChangedField("ProductHasAttributeID05", this.productHasAttributeID05);
        this.productHasAttributeID05 = productHasAttributeID05;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID06</b>
     * </p>
     *
     * @param productHasAttributeID06
     *            ID for product attribute 6
     */
    public void setProductHasAttributeID06( @Nullable final Boolean productHasAttributeID06 )
    {
        rememberChangedField("ProductHasAttributeID06", this.productHasAttributeID06);
        this.productHasAttributeID06 = productHasAttributeID06;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID07</b>
     * </p>
     *
     * @param productHasAttributeID07
     *            ID for product attribute 7
     */
    public void setProductHasAttributeID07( @Nullable final Boolean productHasAttributeID07 )
    {
        rememberChangedField("ProductHasAttributeID07", this.productHasAttributeID07);
        this.productHasAttributeID07 = productHasAttributeID07;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID08</b>
     * </p>
     *
     * @param productHasAttributeID08
     *            ID for product attribute 8
     */
    public void setProductHasAttributeID08( @Nullable final Boolean productHasAttributeID08 )
    {
        rememberChangedField("ProductHasAttributeID08", this.productHasAttributeID08);
        this.productHasAttributeID08 = productHasAttributeID08;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID09</b>
     * </p>
     *
     * @param productHasAttributeID09
     *            ID for product attribute 9
     */
    public void setProductHasAttributeID09( @Nullable final Boolean productHasAttributeID09 )
    {
        rememberChangedField("ProductHasAttributeID09", this.productHasAttributeID09);
        this.productHasAttributeID09 = productHasAttributeID09;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductHasAttributeID10</b>
     * </p>
     *
     * @param productHasAttributeID10
     *            ID for product attribute 10
     */
    public void setProductHasAttributeID10( @Nullable final Boolean productHasAttributeID10 )
    {
        rememberChangedField("ProductHasAttributeID10", this.productHasAttributeID10);
        this.productHasAttributeID10 = productHasAttributeID10;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductSalesDelivery";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("ProductSalesOrg", getProductSalesOrg());
        result.put("ProductDistributionChnl", getProductDistributionChnl());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("ProductSalesOrg", getProductSalesOrg());
        values.put("ProductDistributionChnl", getProductDistributionChnl());
        values.put("MinimumOrderQuantity", getMinimumOrderQuantity());
        values.put("SupplyingPlant", getSupplyingPlant());
        values.put("PriceSpecificationProductGroup", getPriceSpecificationProductGroup());
        values.put("AccountDetnProductGroup", getAccountDetnProductGroup());
        values.put("DeliveryNoteProcMinDelivQty", getDeliveryNoteProcMinDelivQty());
        values.put("ItemCategoryGroup", getItemCategoryGroup());
        values.put("DeliveryQuantityUnit", getDeliveryQuantityUnit());
        values.put("DeliveryQuantity", getDeliveryQuantity());
        values.put("ProductSalesStatus", getProductSalesStatus());
        values.put("ProductSalesStatusValidityDate", getProductSalesStatusValidityDate());
        values.put("SalesMeasureUnit", getSalesMeasureUnit());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("ProductHierarchy", getProductHierarchy());
        values.put("FirstSalesSpecProductGroup", getFirstSalesSpecProductGroup());
        values.put("SecondSalesSpecProductGroup", getSecondSalesSpecProductGroup());
        values.put("ThirdSalesSpecProductGroup", getThirdSalesSpecProductGroup());
        values.put("FourthSalesSpecProductGroup", getFourthSalesSpecProductGroup());
        values.put("FifthSalesSpecProductGroup", getFifthSalesSpecProductGroup());
        values.put("MinimumMakeToOrderOrderQty", getMinimumMakeToOrderOrderQty());
        values.put("BaseUnit", getBaseUnit());
        values.put("LogisticsStatisticsGroup", getLogisticsStatisticsGroup());
        values.put("VolumeRebateGroup", getVolumeRebateGroup());
        values.put("ProductCommissionGroup", getProductCommissionGroup());
        values.put("CashDiscountIsDeductible", getCashDiscountIsDeductible());
        values.put("PricingReferenceProduct", getPricingReferenceProduct());
        values.put("RoundingProfile", getRoundingProfile());
        values.put("ProductUnitGroup", getProductUnitGroup());
        values.put("VariableSalesUnitIsNotAllowed", getVariableSalesUnitIsNotAllowed());
        values.put("ProductHasAttributeID01", getProductHasAttributeID01());
        values.put("ProductHasAttributeID02", getProductHasAttributeID02());
        values.put("ProductHasAttributeID03", getProductHasAttributeID03());
        values.put("ProductHasAttributeID04", getProductHasAttributeID04());
        values.put("ProductHasAttributeID05", getProductHasAttributeID05());
        values.put("ProductHasAttributeID06", getProductHasAttributeID06());
        values.put("ProductHasAttributeID07", getProductHasAttributeID07());
        values.put("ProductHasAttributeID08", getProductHasAttributeID08());
        values.put("ProductHasAttributeID09", getProductHasAttributeID09());
        values.put("ProductHasAttributeID10", getProductHasAttributeID10());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("ProductSalesOrg") ) {
                final Object value = values.remove("ProductSalesOrg");
                if( (value == null) || (!value.equals(getProductSalesOrg())) ) {
                    setProductSalesOrg(((String) value));
                }
            }
            if( values.containsKey("ProductDistributionChnl") ) {
                final Object value = values.remove("ProductDistributionChnl");
                if( (value == null) || (!value.equals(getProductDistributionChnl())) ) {
                    setProductDistributionChnl(((String) value));
                }
            }
            if( values.containsKey("MinimumOrderQuantity") ) {
                final Object value = values.remove("MinimumOrderQuantity");
                if( (value == null) || (!value.equals(getMinimumOrderQuantity())) ) {
                    setMinimumOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplyingPlant") ) {
                final Object value = values.remove("SupplyingPlant");
                if( (value == null) || (!value.equals(getSupplyingPlant())) ) {
                    setSupplyingPlant(((String) value));
                }
            }
            if( values.containsKey("PriceSpecificationProductGroup") ) {
                final Object value = values.remove("PriceSpecificationProductGroup");
                if( (value == null) || (!value.equals(getPriceSpecificationProductGroup())) ) {
                    setPriceSpecificationProductGroup(((String) value));
                }
            }
            if( values.containsKey("AccountDetnProductGroup") ) {
                final Object value = values.remove("AccountDetnProductGroup");
                if( (value == null) || (!value.equals(getAccountDetnProductGroup())) ) {
                    setAccountDetnProductGroup(((String) value));
                }
            }
            if( values.containsKey("DeliveryNoteProcMinDelivQty") ) {
                final Object value = values.remove("DeliveryNoteProcMinDelivQty");
                if( (value == null) || (!value.equals(getDeliveryNoteProcMinDelivQty())) ) {
                    setDeliveryNoteProcMinDelivQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemCategoryGroup") ) {
                final Object value = values.remove("ItemCategoryGroup");
                if( (value == null) || (!value.equals(getItemCategoryGroup())) ) {
                    setItemCategoryGroup(((String) value));
                }
            }
            if( values.containsKey("DeliveryQuantityUnit") ) {
                final Object value = values.remove("DeliveryQuantityUnit");
                if( (value == null) || (!value.equals(getDeliveryQuantityUnit())) ) {
                    setDeliveryQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("DeliveryQuantity") ) {
                final Object value = values.remove("DeliveryQuantity");
                if( (value == null) || (!value.equals(getDeliveryQuantity())) ) {
                    setDeliveryQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductSalesStatus") ) {
                final Object value = values.remove("ProductSalesStatus");
                if( (value == null) || (!value.equals(getProductSalesStatus())) ) {
                    setProductSalesStatus(((String) value));
                }
            }
            if( values.containsKey("ProductSalesStatusValidityDate") ) {
                final Object value = values.remove("ProductSalesStatusValidityDate");
                if( (value == null) || (!value.equals(getProductSalesStatusValidityDate())) ) {
                    setProductSalesStatusValidityDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SalesMeasureUnit") ) {
                final Object value = values.remove("SalesMeasureUnit");
                if( (value == null) || (!value.equals(getSalesMeasureUnit())) ) {
                    setSalesMeasureUnit(((String) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("ProductHierarchy") ) {
                final Object value = values.remove("ProductHierarchy");
                if( (value == null) || (!value.equals(getProductHierarchy())) ) {
                    setProductHierarchy(((String) value));
                }
            }
            if( values.containsKey("FirstSalesSpecProductGroup") ) {
                final Object value = values.remove("FirstSalesSpecProductGroup");
                if( (value == null) || (!value.equals(getFirstSalesSpecProductGroup())) ) {
                    setFirstSalesSpecProductGroup(((String) value));
                }
            }
            if( values.containsKey("SecondSalesSpecProductGroup") ) {
                final Object value = values.remove("SecondSalesSpecProductGroup");
                if( (value == null) || (!value.equals(getSecondSalesSpecProductGroup())) ) {
                    setSecondSalesSpecProductGroup(((String) value));
                }
            }
            if( values.containsKey("ThirdSalesSpecProductGroup") ) {
                final Object value = values.remove("ThirdSalesSpecProductGroup");
                if( (value == null) || (!value.equals(getThirdSalesSpecProductGroup())) ) {
                    setThirdSalesSpecProductGroup(((String) value));
                }
            }
            if( values.containsKey("FourthSalesSpecProductGroup") ) {
                final Object value = values.remove("FourthSalesSpecProductGroup");
                if( (value == null) || (!value.equals(getFourthSalesSpecProductGroup())) ) {
                    setFourthSalesSpecProductGroup(((String) value));
                }
            }
            if( values.containsKey("FifthSalesSpecProductGroup") ) {
                final Object value = values.remove("FifthSalesSpecProductGroup");
                if( (value == null) || (!value.equals(getFifthSalesSpecProductGroup())) ) {
                    setFifthSalesSpecProductGroup(((String) value));
                }
            }
            if( values.containsKey("MinimumMakeToOrderOrderQty") ) {
                final Object value = values.remove("MinimumMakeToOrderOrderQty");
                if( (value == null) || (!value.equals(getMinimumMakeToOrderOrderQty())) ) {
                    setMinimumMakeToOrderOrderQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("LogisticsStatisticsGroup") ) {
                final Object value = values.remove("LogisticsStatisticsGroup");
                if( (value == null) || (!value.equals(getLogisticsStatisticsGroup())) ) {
                    setLogisticsStatisticsGroup(((String) value));
                }
            }
            if( values.containsKey("VolumeRebateGroup") ) {
                final Object value = values.remove("VolumeRebateGroup");
                if( (value == null) || (!value.equals(getVolumeRebateGroup())) ) {
                    setVolumeRebateGroup(((String) value));
                }
            }
            if( values.containsKey("ProductCommissionGroup") ) {
                final Object value = values.remove("ProductCommissionGroup");
                if( (value == null) || (!value.equals(getProductCommissionGroup())) ) {
                    setProductCommissionGroup(((String) value));
                }
            }
            if( values.containsKey("CashDiscountIsDeductible") ) {
                final Object value = values.remove("CashDiscountIsDeductible");
                if( (value == null) || (!value.equals(getCashDiscountIsDeductible())) ) {
                    setCashDiscountIsDeductible(((Boolean) value));
                }
            }
            if( values.containsKey("PricingReferenceProduct") ) {
                final Object value = values.remove("PricingReferenceProduct");
                if( (value == null) || (!value.equals(getPricingReferenceProduct())) ) {
                    setPricingReferenceProduct(((String) value));
                }
            }
            if( values.containsKey("RoundingProfile") ) {
                final Object value = values.remove("RoundingProfile");
                if( (value == null) || (!value.equals(getRoundingProfile())) ) {
                    setRoundingProfile(((String) value));
                }
            }
            if( values.containsKey("ProductUnitGroup") ) {
                final Object value = values.remove("ProductUnitGroup");
                if( (value == null) || (!value.equals(getProductUnitGroup())) ) {
                    setProductUnitGroup(((String) value));
                }
            }
            if( values.containsKey("VariableSalesUnitIsNotAllowed") ) {
                final Object value = values.remove("VariableSalesUnitIsNotAllowed");
                if( (value == null) || (!value.equals(getVariableSalesUnitIsNotAllowed())) ) {
                    setVariableSalesUnitIsNotAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("ProductHasAttributeID01") ) {
                final Object value = values.remove("ProductHasAttributeID01");
                if( (value == null) || (!value.equals(getProductHasAttributeID01())) ) {
                    setProductHasAttributeID01(((Boolean) value));
                }
            }
            if( values.containsKey("ProductHasAttributeID02") ) {
                final Object value = values.remove("ProductHasAttributeID02");
                if( (value == null) || (!value.equals(getProductHasAttributeID02())) ) {
                    setProductHasAttributeID02(((Boolean) value));
                }
            }
            if( values.containsKey("ProductHasAttributeID03") ) {
                final Object value = values.remove("ProductHasAttributeID03");
                if( (value == null) || (!value.equals(getProductHasAttributeID03())) ) {
                    setProductHasAttributeID03(((Boolean) value));
                }
            }
            if( values.containsKey("ProductHasAttributeID04") ) {
                final Object value = values.remove("ProductHasAttributeID04");
                if( (value == null) || (!value.equals(getProductHasAttributeID04())) ) {
                    setProductHasAttributeID04(((Boolean) value));
                }
            }
            if( values.containsKey("ProductHasAttributeID05") ) {
                final Object value = values.remove("ProductHasAttributeID05");
                if( (value == null) || (!value.equals(getProductHasAttributeID05())) ) {
                    setProductHasAttributeID05(((Boolean) value));
                }
            }
            if( values.containsKey("ProductHasAttributeID06") ) {
                final Object value = values.remove("ProductHasAttributeID06");
                if( (value == null) || (!value.equals(getProductHasAttributeID06())) ) {
                    setProductHasAttributeID06(((Boolean) value));
                }
            }
            if( values.containsKey("ProductHasAttributeID07") ) {
                final Object value = values.remove("ProductHasAttributeID07");
                if( (value == null) || (!value.equals(getProductHasAttributeID07())) ) {
                    setProductHasAttributeID07(((Boolean) value));
                }
            }
            if( values.containsKey("ProductHasAttributeID08") ) {
                final Object value = values.remove("ProductHasAttributeID08");
                if( (value == null) || (!value.equals(getProductHasAttributeID08())) ) {
                    setProductHasAttributeID08(((Boolean) value));
                }
            }
            if( values.containsKey("ProductHasAttributeID09") ) {
                final Object value = values.remove("ProductHasAttributeID09");
                if( (value == null) || (!value.equals(getProductHasAttributeID09())) ) {
                    setProductHasAttributeID09(((Boolean) value));
                }
            }
            if( values.containsKey("ProductHasAttributeID10") ) {
                final Object value = values.remove("ProductHasAttributeID10");
                if( (value == null) || (!value.equals(getProductHasAttributeID10())) ) {
                    setProductHasAttributeID10(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesTax") ) {
                final Object value = (values).remove("to_SalesTax");
                if( value instanceof Iterable ) {
                    if( toSalesTax == null ) {
                        toSalesTax = Lists.newArrayList();
                    } else {
                        toSalesTax = Lists.newArrayList(toSalesTax);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductSalesTax entity;
                        if( toSalesTax.size() > i ) {
                            entity = toSalesTax.get(i);
                        } else {
                            entity = new ProductSalesTax();
                            toSalesTax.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SalesText") ) {
                final Object value = (values).remove("to_SalesText");
                if( value instanceof Iterable ) {
                    if( toSalesText == null ) {
                        toSalesText = Lists.newArrayList();
                    } else {
                        toSalesText = Lists.newArrayList(toSalesText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductSalesText entity;
                        if( toSalesText.size() > i ) {
                            entity = toSalesText.get(i);
                        } else {
                            entity = new ProductSalesText();
                            toSalesText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductSalesDeliveryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductSalesDeliveryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductSalesDeliveryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductSalesDeliveryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesTax != null ) {
            (values).put("to_SalesTax", toSalesTax);
        }
        if( toSalesText != null ) {
            (values).put("to_SalesText", toSalesText);
        }
        return values;
    }

    /**
     * Fetches the <b>ProductSalesTax</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SalesTax</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductSalesTax</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductSalesTax> fetchSalesTax()
    {
        return fetchFieldAsList("to_SalesTax", ProductSalesTax.class);
    }

    /**
     * Retrieval of associated <b>ProductSalesTax</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SalesTax</b>.
     * <p>
     * If the navigation property <b>to_SalesTax</b> of a queried <b>ProductSalesDelivery</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductSalesTax</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductSalesTax> getSalesTaxOrFetch()
    {
        if( toSalesTax == null ) {
            toSalesTax = fetchSalesTax();
        }
        return toSalesTax;
    }

    /**
     * Retrieval of associated <b>ProductSalesTax</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SalesTax</b>.
     * <p>
     * If the navigation property for an entity <b>ProductSalesDelivery</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesTax</b> is already loaded, the result will contain
     *         the <b>ProductSalesTax</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<ProductSalesTax>> getSalesTaxIfPresent()
    {
        return Option.of(toSalesTax);
    }

    /**
     * Overwrites the list of associated <b>ProductSalesTax</b> entities for the loaded navigation property
     * <b>to_SalesTax</b>.
     * <p>
     * If the navigation property <b>to_SalesTax</b> of a queried <b>ProductSalesDelivery</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductSalesTax</b> entities.
     */
    public void setSalesTax( @Nonnull final List<ProductSalesTax> value )
    {
        if( toSalesTax == null ) {
            toSalesTax = Lists.newArrayList();
        }
        toSalesTax.clear();
        toSalesTax.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductSalesTax</b> entities. This corresponds to the OData navigation
     * property <b>to_SalesTax</b>.
     * <p>
     * If the navigation property <b>to_SalesTax</b> of a queried <b>ProductSalesDelivery</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductSalesTax</b> entities.
     */
    public void addSalesTax( ProductSalesTax... entity )
    {
        if( toSalesTax == null ) {
            toSalesTax = Lists.newArrayList();
        }
        toSalesTax.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProductSalesText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SalesText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductSalesText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductSalesText> fetchSalesText()
    {
        return fetchFieldAsList("to_SalesText", ProductSalesText.class);
    }

    /**
     * Retrieval of associated <b>ProductSalesText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SalesText</b>.
     * <p>
     * If the navigation property <b>to_SalesText</b> of a queried <b>ProductSalesDelivery</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductSalesText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductSalesText> getSalesTextOrFetch()
    {
        if( toSalesText == null ) {
            toSalesText = fetchSalesText();
        }
        return toSalesText;
    }

    /**
     * Retrieval of associated <b>ProductSalesText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SalesText</b>.
     * <p>
     * If the navigation property for an entity <b>ProductSalesDelivery</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesText</b> is already loaded, the result will contain
     *         the <b>ProductSalesText</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<ProductSalesText>> getSalesTextIfPresent()
    {
        return Option.of(toSalesText);
    }

    /**
     * Overwrites the list of associated <b>ProductSalesText</b> entities for the loaded navigation property
     * <b>to_SalesText</b>.
     * <p>
     * If the navigation property <b>to_SalesText</b> of a queried <b>ProductSalesDelivery</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductSalesText</b> entities.
     */
    public void setSalesText( @Nonnull final List<ProductSalesText> value )
    {
        if( toSalesText == null ) {
            toSalesText = Lists.newArrayList();
        }
        toSalesText.clear();
        toSalesText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductSalesText</b> entities. This corresponds to the OData
     * navigation property <b>to_SalesText</b>.
     * <p>
     * If the navigation property <b>to_SalesText</b> of a queried <b>ProductSalesDelivery</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductSalesText</b> entities.
     */
    public void addSalesText( ProductSalesText... entity )
    {
        if( toSalesText == null ) {
            toSalesText = Lists.newArrayList();
        }
        toSalesText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProductSalesDelivery instances.
     *
     */
    public final static class ProductSalesDeliveryBuilder
    {

        private List<ProductSalesTax> toSalesTax = Lists.newArrayList();
        private List<ProductSalesText> toSalesText = Lists.newArrayList();

        private ProductSalesDelivery.ProductSalesDeliveryBuilder toSalesTax( final List<ProductSalesTax> value )
        {
            toSalesTax.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SalesTax</b> for <b>ProductSalesDelivery</b> to multiple <b>ProductSalesTax</b>.
         *
         * @param value
         *            The ProductSalesTaxs to build this ProductSalesDelivery with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductSalesDelivery.ProductSalesDeliveryBuilder salesTax( ProductSalesTax... value )
        {
            return toSalesTax(Lists.newArrayList(value));
        }

        private ProductSalesDelivery.ProductSalesDeliveryBuilder toSalesText( final List<ProductSalesText> value )
        {
            toSalesText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SalesText</b> for <b>ProductSalesDelivery</b> to multiple <b>ProductSalesText</b>.
         *
         * @param value
         *            The ProductSalesTexts to build this ProductSalesDelivery with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductSalesDelivery.ProductSalesDeliveryBuilder salesText( ProductSalesText... value )
        {
            return toSalesText(Lists.newArrayList(value));
        }

    }

}
