/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductStorageField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductStorageSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Basic Storage Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductStorageType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductStorage extends VdmEntity<ProductStorage>
{

    /**
     * Selector for all available fields of ProductStorage.
     *
     */
    public final static ProductStorageSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductStorageField<String> PRODUCT = new ProductStorageField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>StorageConditions</b>
     * </p>
     *
     * @return Storage conditions
     */
    @SerializedName( "StorageConditions" )
    @JsonProperty( "StorageConditions" )
    @Nullable
    @ODataField( odataName = "StorageConditions" )
    private String storageConditions;
    /**
     * Use with available fluent helpers to apply the <b>StorageConditions</b> field to query operations.
     *
     */
    public final static ProductStorageField<String> STORAGE_CONDITIONS =
        new ProductStorageField<String>("StorageConditions");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TemperatureConditionInd</b>
     * </p>
     *
     * @return Temperature conditions indicator
     */
    @SerializedName( "TemperatureConditionInd" )
    @JsonProperty( "TemperatureConditionInd" )
    @Nullable
    @ODataField( odataName = "TemperatureConditionInd" )
    private String temperatureConditionInd;
    /**
     * Use with available fluent helpers to apply the <b>TemperatureConditionInd</b> field to query operations.
     *
     */
    public final static ProductStorageField<String> TEMPERATURE_CONDITION_IND =
        new ProductStorageField<String>("TemperatureConditionInd");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HazardousMaterialNumber</b>
     * </p>
     *
     * @return Hazardous material number
     */
    @SerializedName( "HazardousMaterialNumber" )
    @JsonProperty( "HazardousMaterialNumber" )
    @Nullable
    @ODataField( odataName = "HazardousMaterialNumber" )
    private String hazardousMaterialNumber;
    /**
     * Use with available fluent helpers to apply the <b>HazardousMaterialNumber</b> field to query operations.
     *
     */
    public final static ProductStorageField<String> HAZARDOUS_MATERIAL_NUMBER =
        new ProductStorageField<String>("HazardousMaterialNumber");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NmbrOfGROrGISlipsToPrintQty</b>
     * </p>
     *
     * @return Quantity: Number of GR/GI slips to be printed
     */
    @SerializedName( "NmbrOfGROrGISlipsToPrintQty" )
    @JsonProperty( "NmbrOfGROrGISlipsToPrintQty" )
    @Nullable
    @ODataField( odataName = "NmbrOfGROrGISlipsToPrintQty" )
    private BigDecimal nmbrOfGROrGISlipsToPrintQty;
    /**
     * Use with available fluent helpers to apply the <b>NmbrOfGROrGISlipsToPrintQty</b> field to query operations.
     *
     */
    public final static ProductStorageField<BigDecimal> NMBR_OF_GR_OR_GI_SLIPS_TO_PRINT_QTY =
        new ProductStorageField<BigDecimal>("NmbrOfGROrGISlipsToPrintQty");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LabelType</b>
     * </p>
     *
     * @return Label type
     */
    @SerializedName( "LabelType" )
    @JsonProperty( "LabelType" )
    @Nullable
    @ODataField( odataName = "LabelType" )
    private String labelType;
    /**
     * Use with available fluent helpers to apply the <b>LabelType</b> field to query operations.
     *
     */
    public final static ProductStorageField<String> LABEL_TYPE = new ProductStorageField<String>("LabelType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LabelForm</b>
     * </p>
     *
     * @return Label form
     */
    @SerializedName( "LabelForm" )
    @JsonProperty( "LabelForm" )
    @Nullable
    @ODataField( odataName = "LabelForm" )
    private String labelForm;
    /**
     * Use with available fluent helpers to apply the <b>LabelForm</b> field to query operations.
     *
     */
    public final static ProductStorageField<String> LABEL_FORM = new ProductStorageField<String>("LabelForm");
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MinRemainingShelfLife</b>
     * </p>
     *
     * @return Minimum Remaining Shelf Life
     */
    @SerializedName( "MinRemainingShelfLife" )
    @JsonProperty( "MinRemainingShelfLife" )
    @Nullable
    @ODataField( odataName = "MinRemainingShelfLife" )
    private BigDecimal minRemainingShelfLife;
    /**
     * Use with available fluent helpers to apply the <b>MinRemainingShelfLife</b> field to query operations.
     *
     */
    public final static ProductStorageField<BigDecimal> MIN_REMAINING_SHELF_LIFE =
        new ProductStorageField<BigDecimal>("MinRemainingShelfLife");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ExpirationDate</b>
     * </p>
     *
     * @return Expiration Date
     */
    @SerializedName( "ExpirationDate" )
    @JsonProperty( "ExpirationDate" )
    @Nullable
    @ODataField( odataName = "ExpirationDate" )
    private String expirationDate;
    /**
     * Use with available fluent helpers to apply the <b>ExpirationDate</b> field to query operations.
     *
     */
    public final static ProductStorageField<String> EXPIRATION_DATE = new ProductStorageField<String>("ExpirationDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDatePeriod</b>
     * </p>
     *
     * @return Period Indicator for Shelf Life Expiration Date
     */
    @SerializedName( "ShelfLifeExpirationDatePeriod" )
    @JsonProperty( "ShelfLifeExpirationDatePeriod" )
    @Nullable
    @ODataField( odataName = "ShelfLifeExpirationDatePeriod" )
    private String shelfLifeExpirationDatePeriod;
    /**
     * Use with available fluent helpers to apply the <b>ShelfLifeExpirationDatePeriod</b> field to query operations.
     *
     */
    public final static ProductStorageField<String> SHELF_LIFE_EXPIRATION_DATE_PERIOD =
        new ProductStorageField<String>("ShelfLifeExpirationDatePeriod");
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TotalShelfLife</b>
     * </p>
     *
     * @return Total shelf life
     */
    @SerializedName( "TotalShelfLife" )
    @JsonProperty( "TotalShelfLife" )
    @Nullable
    @ODataField( odataName = "TotalShelfLife" )
    private BigDecimal totalShelfLife;
    /**
     * Use with available fluent helpers to apply the <b>TotalShelfLife</b> field to query operations.
     *
     */
    public final static ProductStorageField<BigDecimal> TOTAL_SHELF_LIFE =
        new ProductStorageField<BigDecimal>("TotalShelfLife");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProductStorageField<String> BASE_UNIT = new ProductStorageField<String>("BaseUnit");

    @Nonnull
    @Override
    public Class<ProductStorage> getType()
    {
        return ProductStorage.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>StorageConditions</b>
     * </p>
     *
     * @param storageConditions
     *            Storage conditions
     */
    public void setStorageConditions( @Nullable final String storageConditions )
    {
        rememberChangedField("StorageConditions", this.storageConditions);
        this.storageConditions = storageConditions;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TemperatureConditionInd</b>
     * </p>
     *
     * @param temperatureConditionInd
     *            Temperature conditions indicator
     */
    public void setTemperatureConditionInd( @Nullable final String temperatureConditionInd )
    {
        rememberChangedField("TemperatureConditionInd", this.temperatureConditionInd);
        this.temperatureConditionInd = temperatureConditionInd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HazardousMaterialNumber</b>
     * </p>
     *
     * @param hazardousMaterialNumber
     *            Hazardous material number
     */
    public void setHazardousMaterialNumber( @Nullable final String hazardousMaterialNumber )
    {
        rememberChangedField("HazardousMaterialNumber", this.hazardousMaterialNumber);
        this.hazardousMaterialNumber = hazardousMaterialNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NmbrOfGROrGISlipsToPrintQty</b>
     * </p>
     *
     * @param nmbrOfGROrGISlipsToPrintQty
     *            Quantity: Number of GR/GI slips to be printed
     */
    public void setNmbrOfGROrGISlipsToPrintQty( @Nullable final BigDecimal nmbrOfGROrGISlipsToPrintQty )
    {
        rememberChangedField("NmbrOfGROrGISlipsToPrintQty", this.nmbrOfGROrGISlipsToPrintQty);
        this.nmbrOfGROrGISlipsToPrintQty = nmbrOfGROrGISlipsToPrintQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LabelType</b>
     * </p>
     *
     * @param labelType
     *            Label type
     */
    public void setLabelType( @Nullable final String labelType )
    {
        rememberChangedField("LabelType", this.labelType);
        this.labelType = labelType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LabelForm</b>
     * </p>
     *
     * @param labelForm
     *            Label form
     */
    public void setLabelForm( @Nullable final String labelForm )
    {
        rememberChangedField("LabelForm", this.labelForm);
        this.labelForm = labelForm;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MinRemainingShelfLife</b>
     * </p>
     *
     * @param minRemainingShelfLife
     *            Minimum Remaining Shelf Life
     */
    public void setMinRemainingShelfLife( @Nullable final BigDecimal minRemainingShelfLife )
    {
        rememberChangedField("MinRemainingShelfLife", this.minRemainingShelfLife);
        this.minRemainingShelfLife = minRemainingShelfLife;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ExpirationDate</b>
     * </p>
     *
     * @param expirationDate
     *            Expiration Date
     */
    public void setExpirationDate( @Nullable final String expirationDate )
    {
        rememberChangedField("ExpirationDate", this.expirationDate);
        this.expirationDate = expirationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDatePeriod</b>
     * </p>
     *
     * @param shelfLifeExpirationDatePeriod
     *            Period Indicator for Shelf Life Expiration Date
     */
    public void setShelfLifeExpirationDatePeriod( @Nullable final String shelfLifeExpirationDatePeriod )
    {
        rememberChangedField("ShelfLifeExpirationDatePeriod", this.shelfLifeExpirationDatePeriod);
        this.shelfLifeExpirationDatePeriod = shelfLifeExpirationDatePeriod;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TotalShelfLife</b>
     * </p>
     *
     * @param totalShelfLife
     *            Total shelf life
     */
    public void setTotalShelfLife( @Nullable final BigDecimal totalShelfLife )
    {
        rememberChangedField("TotalShelfLife", this.totalShelfLife);
        this.totalShelfLife = totalShelfLife;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductStorage";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("StorageConditions", getStorageConditions());
        values.put("TemperatureConditionInd", getTemperatureConditionInd());
        values.put("HazardousMaterialNumber", getHazardousMaterialNumber());
        values.put("NmbrOfGROrGISlipsToPrintQty", getNmbrOfGROrGISlipsToPrintQty());
        values.put("LabelType", getLabelType());
        values.put("LabelForm", getLabelForm());
        values.put("MinRemainingShelfLife", getMinRemainingShelfLife());
        values.put("ExpirationDate", getExpirationDate());
        values.put("ShelfLifeExpirationDatePeriod", getShelfLifeExpirationDatePeriod());
        values.put("TotalShelfLife", getTotalShelfLife());
        values.put("BaseUnit", getBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("StorageConditions") ) {
                final Object value = values.remove("StorageConditions");
                if( (value == null) || (!value.equals(getStorageConditions())) ) {
                    setStorageConditions(((String) value));
                }
            }
            if( values.containsKey("TemperatureConditionInd") ) {
                final Object value = values.remove("TemperatureConditionInd");
                if( (value == null) || (!value.equals(getTemperatureConditionInd())) ) {
                    setTemperatureConditionInd(((String) value));
                }
            }
            if( values.containsKey("HazardousMaterialNumber") ) {
                final Object value = values.remove("HazardousMaterialNumber");
                if( (value == null) || (!value.equals(getHazardousMaterialNumber())) ) {
                    setHazardousMaterialNumber(((String) value));
                }
            }
            if( values.containsKey("NmbrOfGROrGISlipsToPrintQty") ) {
                final Object value = values.remove("NmbrOfGROrGISlipsToPrintQty");
                if( (value == null) || (!value.equals(getNmbrOfGROrGISlipsToPrintQty())) ) {
                    setNmbrOfGROrGISlipsToPrintQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("LabelType") ) {
                final Object value = values.remove("LabelType");
                if( (value == null) || (!value.equals(getLabelType())) ) {
                    setLabelType(((String) value));
                }
            }
            if( values.containsKey("LabelForm") ) {
                final Object value = values.remove("LabelForm");
                if( (value == null) || (!value.equals(getLabelForm())) ) {
                    setLabelForm(((String) value));
                }
            }
            if( values.containsKey("MinRemainingShelfLife") ) {
                final Object value = values.remove("MinRemainingShelfLife");
                if( (value == null) || (!value.equals(getMinRemainingShelfLife())) ) {
                    setMinRemainingShelfLife(((BigDecimal) value));
                }
            }
            if( values.containsKey("ExpirationDate") ) {
                final Object value = values.remove("ExpirationDate");
                if( (value == null) || (!value.equals(getExpirationDate())) ) {
                    setExpirationDate(((String) value));
                }
            }
            if( values.containsKey("ShelfLifeExpirationDatePeriod") ) {
                final Object value = values.remove("ShelfLifeExpirationDatePeriod");
                if( (value == null) || (!value.equals(getShelfLifeExpirationDatePeriod())) ) {
                    setShelfLifeExpirationDatePeriod(((String) value));
                }
            }
            if( values.containsKey("TotalShelfLife") ) {
                final Object value = values.remove("TotalShelfLife");
                if( (value == null) || (!value.equals(getTotalShelfLife())) ) {
                    setTotalShelfLife(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProductStorageField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductStorageField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductStorageField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductStorageField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
