/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductSupplyPlanningField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductSupplyPlanningSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Supply Planning Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductSupplyPlanningType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductSupplyPlanning extends VdmEntity<ProductSupplyPlanning>
{

    /**
     * Selector for all available fields of ProductSupplyPlanning.
     *
     */
    public final static ProductSupplyPlanningSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PRODUCT = new ProductSupplyPlanningField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PLANT = new ProductSupplyPlanningField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedLotSizeQuantity</b>
     * </p>
     *
     * @return Fixed lot size
     */
    @SerializedName( "FixedLotSizeQuantity" )
    @JsonProperty( "FixedLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "FixedLotSizeQuantity" )
    private BigDecimal fixedLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>FixedLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> FIXED_LOT_SIZE_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("FixedLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @return Maximum Lot Size
     */
    @SerializedName( "MaximumLotSizeQuantity" )
    @JsonProperty( "MaximumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MaximumLotSizeQuantity" )
    private BigDecimal maximumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaximumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> MAXIMUM_LOT_SIZE_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("MaximumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @return Minimum Lot Size
     */
    @SerializedName( "MinimumLotSizeQuantity" )
    @JsonProperty( "MinimumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumLotSizeQuantity" )
    private BigDecimal minimumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> MINIMUM_LOT_SIZE_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("MinimumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LotSizeRoundingQuantity</b>
     * </p>
     *
     * @return Rounding value for purchase order quantity
     */
    @SerializedName( "LotSizeRoundingQuantity" )
    @JsonProperty( "LotSizeRoundingQuantity" )
    @Nullable
    @ODataField( odataName = "LotSizeRoundingQuantity" )
    private BigDecimal lotSizeRoundingQuantity;
    /**
     * Use with available fluent helpers to apply the <b>LotSizeRoundingQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> LOT_SIZE_ROUNDING_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("LotSizeRoundingQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LotSizingProcedure</b>
     * </p>
     *
     * @return Lot Sizing Procedure in Materials Planning
     */
    @SerializedName( "LotSizingProcedure" )
    @JsonProperty( "LotSizingProcedure" )
    @Nullable
    @ODataField( odataName = "LotSizingProcedure" )
    private String lotSizingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>LotSizingProcedure</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> LOT_SIZING_PROCEDURE =
        new ProductSupplyPlanningField<String>("LotSizingProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPType</b>
     * </p>
     *
     * @return MRP Type
     */
    @SerializedName( "MRPType" )
    @JsonProperty( "MRPType" )
    @Nullable
    @ODataField( odataName = "MRPType" )
    private String mRPType;
    /**
     * Use with available fluent helpers to apply the <b>MRPType</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> MRP_TYPE = new ProductSupplyPlanningField<String>("MRPType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPResponsible</b>
     * </p>
     *
     * @return MRP Controller
     */
    @SerializedName( "MRPResponsible" )
    @JsonProperty( "MRPResponsible" )
    @Nullable
    @ODataField( odataName = "MRPResponsible" )
    private String mRPResponsible;
    /**
     * Use with available fluent helpers to apply the <b>MRPResponsible</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> MRP_RESPONSIBLE =
        new ProductSupplyPlanningField<String>("MRPResponsible");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SafetyStockQuantity</b>
     * </p>
     *
     * @return Safety Stock
     */
    @SerializedName( "SafetyStockQuantity" )
    @JsonProperty( "SafetyStockQuantity" )
    @Nullable
    @ODataField( odataName = "SafetyStockQuantity" )
    private BigDecimal safetyStockQuantity;
    /**
     * Use with available fluent helpers to apply the <b>SafetyStockQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> SAFETY_STOCK_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("SafetyStockQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumSafetyStockQuantity</b>
     * </p>
     *
     * @return Minimum Safety Stock
     */
    @SerializedName( "MinimumSafetyStockQuantity" )
    @JsonProperty( "MinimumSafetyStockQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumSafetyStockQuantity" )
    private BigDecimal minimumSafetyStockQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumSafetyStockQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> MINIMUM_SAFETY_STOCK_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("MinimumSafetyStockQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTimeFence</b>
     * </p>
     *
     * @return Planning time fence
     */
    @SerializedName( "PlanningTimeFence" )
    @JsonProperty( "PlanningTimeFence" )
    @Nullable
    @ODataField( odataName = "PlanningTimeFence" )
    private String planningTimeFence;
    /**
     * Use with available fluent helpers to apply the <b>PlanningTimeFence</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PLANNING_TIME_FENCE =
        new ProductSupplyPlanningField<String>("PlanningTimeFence");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicator</b>
     * </p>
     *
     * @return ABC Indicator
     */
    @SerializedName( "ABCIndicator" )
    @JsonProperty( "ABCIndicator" )
    @Nullable
    @ODataField( odataName = "ABCIndicator" )
    private String aBCIndicator;
    /**
     * Use with available fluent helpers to apply the <b>ABCIndicator</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> ABC_INDICATOR =
        new ProductSupplyPlanningField<String>("ABCIndicator");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumStockQuantity</b>
     * </p>
     *
     * @return Maximum Stock Level
     */
    @SerializedName( "MaximumStockQuantity" )
    @JsonProperty( "MaximumStockQuantity" )
    @Nullable
    @ODataField( odataName = "MaximumStockQuantity" )
    private BigDecimal maximumStockQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaximumStockQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> MAXIMUM_STOCK_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("MaximumStockQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReorderThresholdQuantity</b>
     * </p>
     *
     * @return Reorder Point
     */
    @SerializedName( "ReorderThresholdQuantity" )
    @JsonProperty( "ReorderThresholdQuantity" )
    @Nullable
    @ODataField( odataName = "ReorderThresholdQuantity" )
    private BigDecimal reorderThresholdQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ReorderThresholdQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> REORDER_THRESHOLD_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("ReorderThresholdQuantity");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryDurationInDays</b>
     * </p>
     *
     * @return Planned Delivery Time in Days
     */
    @SerializedName( "PlannedDeliveryDurationInDays" )
    @JsonProperty( "PlannedDeliveryDurationInDays" )
    @Nullable
    @ODataField( odataName = "PlannedDeliveryDurationInDays" )
    private BigDecimal plannedDeliveryDurationInDays;
    /**
     * Use with available fluent helpers to apply the <b>PlannedDeliveryDurationInDays</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> PLANNED_DELIVERY_DURATION_IN_DAYS =
        new ProductSupplyPlanningField<BigDecimal>("PlannedDeliveryDurationInDays");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SafetyDuration</b>
     * </p>
     *
     * @return Safety Time (in Workdays)
     */
    @SerializedName( "SafetyDuration" )
    @JsonProperty( "SafetyDuration" )
    @Nullable
    @ODataField( odataName = "SafetyDuration" )
    private String safetyDuration;
    /**
     * Use with available fluent helpers to apply the <b>SafetyDuration</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> SAFETY_DURATION =
        new ProductSupplyPlanningField<String>("SafetyDuration");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlanningStrategyGroup</b>
     * </p>
     *
     * @return Planning Strategy Group
     */
    @SerializedName( "PlanningStrategyGroup" )
    @JsonProperty( "PlanningStrategyGroup" )
    @Nullable
    @ODataField( odataName = "PlanningStrategyGroup" )
    private String planningStrategyGroup;
    /**
     * Use with available fluent helpers to apply the <b>PlanningStrategyGroup</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PLANNING_STRATEGY_GROUP =
        new ProductSupplyPlanningField<String>("PlanningStrategyGroup");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TotalReplenishmentLeadTime</b>
     * </p>
     *
     * @return Total replenishment lead time (in workdays)
     */
    @SerializedName( "TotalReplenishmentLeadTime" )
    @JsonProperty( "TotalReplenishmentLeadTime" )
    @Nullable
    @ODataField( odataName = "TotalReplenishmentLeadTime" )
    private BigDecimal totalReplenishmentLeadTime;
    /**
     * Use with available fluent helpers to apply the <b>TotalReplenishmentLeadTime</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> TOTAL_REPLENISHMENT_LEAD_TIME =
        new ProductSupplyPlanningField<BigDecimal>("TotalReplenishmentLeadTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementType</b>
     * </p>
     *
     * @return Procurement Type
     */
    @SerializedName( "ProcurementType" )
    @JsonProperty( "ProcurementType" )
    @Nullable
    @ODataField( odataName = "ProcurementType" )
    private String procurementType;
    /**
     * Use with available fluent helpers to apply the <b>ProcurementType</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PROCUREMENT_TYPE =
        new ProductSupplyPlanningField<String>("ProcurementType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementSubType</b>
     * </p>
     *
     * @return Special Procurement Type
     */
    @SerializedName( "ProcurementSubType" )
    @JsonProperty( "ProcurementSubType" )
    @Nullable
    @ODataField( odataName = "ProcurementSubType" )
    private String procurementSubType;
    /**
     * Use with available fluent helpers to apply the <b>ProcurementSubType</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PROCUREMENT_SUB_TYPE =
        new ProductSupplyPlanningField<String>("ProcurementSubType");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssemblyScrapPercent</b>
     * </p>
     *
     * @return Assembly scrap in percent
     */
    @SerializedName( "AssemblyScrapPercent" )
    @JsonProperty( "AssemblyScrapPercent" )
    @Nullable
    @ODataField( odataName = "AssemblyScrapPercent" )
    private BigDecimal assemblyScrapPercent;
    /**
     * Use with available fluent helpers to apply the <b>AssemblyScrapPercent</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> ASSEMBLY_SCRAP_PERCENT =
        new ProductSupplyPlanningField<BigDecimal>("AssemblyScrapPercent");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityCheckType</b>
     * </p>
     *
     * @return Checking Group for Availability Check
     */
    @SerializedName( "AvailabilityCheckType" )
    @JsonProperty( "AvailabilityCheckType" )
    @Nullable
    @ODataField( odataName = "AvailabilityCheckType" )
    private String availabilityCheckType;
    /**
     * Use with available fluent helpers to apply the <b>AvailabilityCheckType</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> AVAILABILITY_CHECK_TYPE =
        new ProductSupplyPlanningField<String>("AvailabilityCheckType");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDuration</b>
     * </p>
     *
     * @return Goods receipt processing time in days
     */
    @SerializedName( "GoodsReceiptDuration" )
    @JsonProperty( "GoodsReceiptDuration" )
    @Nullable
    @ODataField( odataName = "GoodsReceiptDuration" )
    private BigDecimal goodsReceiptDuration;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptDuration</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> GOODS_RECEIPT_DURATION =
        new ProductSupplyPlanningField<BigDecimal>("GoodsReceiptDuration");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPGroup</b>
     * </p>
     *
     * @return MRP Group
     */
    @SerializedName( "MRPGroup" )
    @JsonProperty( "MRPGroup" )
    @Nullable
    @ODataField( odataName = "MRPGroup" )
    private String mRPGroup;
    /**
     * Use with available fluent helpers to apply the <b>MRPGroup</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> MRP_GROUP =
        new ProductSupplyPlanningField<String>("MRPGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DfltStorageLocationExtProcmt</b>
     * </p>
     *
     * @return Default Storage Location for External Procurement
     */
    @SerializedName( "DfltStorageLocationExtProcmt" )
    @JsonProperty( "DfltStorageLocationExtProcmt" )
    @Nullable
    @ODataField( odataName = "DfltStorageLocationExtProcmt" )
    private String dfltStorageLocationExtProcmt;
    /**
     * Use with available fluent helpers to apply the <b>DfltStorageLocationExtProcmt</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> DFLT_STORAGE_LOCATION_EXT_PROCMT =
        new ProductSupplyPlanningField<String>("DfltStorageLocationExtProcmt");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdRqmtsConsumptionMode</b>
     * </p>
     *
     * @return Consumption mode
     */
    @SerializedName( "ProdRqmtsConsumptionMode" )
    @JsonProperty( "ProdRqmtsConsumptionMode" )
    @Nullable
    @ODataField( odataName = "ProdRqmtsConsumptionMode" )
    private String prodRqmtsConsumptionMode;
    /**
     * Use with available fluent helpers to apply the <b>ProdRqmtsConsumptionMode</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PROD_RQMTS_CONSUMPTION_MODE =
        new ProductSupplyPlanningField<String>("ProdRqmtsConsumptionMode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BackwardCnsmpnPeriodInWorkDays</b>
     * </p>
     *
     * @return Consumption Period: Backward
     */
    @SerializedName( "BackwardCnsmpnPeriodInWorkDays" )
    @JsonProperty( "BackwardCnsmpnPeriodInWorkDays" )
    @Nullable
    @ODataField( odataName = "BackwardCnsmpnPeriodInWorkDays" )
    private String backwardCnsmpnPeriodInWorkDays;
    /**
     * Use with available fluent helpers to apply the <b>BackwardCnsmpnPeriodInWorkDays</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> BACKWARD_CNSMPN_PERIOD_IN_WORK_DAYS =
        new ProductSupplyPlanningField<String>("BackwardCnsmpnPeriodInWorkDays");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FwdConsumptionPeriodInWorkDays</b>
     * </p>
     *
     * @return Consumption period: Forward
     */
    @SerializedName( "FwdConsumptionPeriodInWorkDays" )
    @JsonProperty( "FwdConsumptionPeriodInWorkDays" )
    @Nullable
    @ODataField( odataName = "FwdConsumptionPeriodInWorkDays" )
    private String fwdConsumptionPeriodInWorkDays;
    /**
     * Use with available fluent helpers to apply the <b>FwdConsumptionPeriodInWorkDays</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> FWD_CONSUMPTION_PERIOD_IN_WORK_DAYS =
        new ProductSupplyPlanningField<String>("FwdConsumptionPeriodInWorkDays");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> BASE_UNIT =
        new ProductSupplyPlanningField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlanAndOrderDayDetermination</b>
     * </p>
     *
     * @return Planning Cycle
     */
    @SerializedName( "PlanAndOrderDayDetermination" )
    @JsonProperty( "PlanAndOrderDayDetermination" )
    @Nullable
    @ODataField( odataName = "PlanAndOrderDayDetermination" )
    private String planAndOrderDayDetermination;
    /**
     * Use with available fluent helpers to apply the <b>PlanAndOrderDayDetermination</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PLAN_AND_ORDER_DAY_DETERMINATION =
        new ProductSupplyPlanningField<String>("PlanAndOrderDayDetermination");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RoundingProfile</b>
     * </p>
     *
     * @return Rounding Profile
     */
    @SerializedName( "RoundingProfile" )
    @JsonProperty( "RoundingProfile" )
    @Nullable
    @ODataField( odataName = "RoundingProfile" )
    private String roundingProfile;
    /**
     * Use with available fluent helpers to apply the <b>RoundingProfile</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> ROUNDING_PROFILE =
        new ProductSupplyPlanningField<String>("RoundingProfile");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LotSizeIndependentCosts</b>
     * </p>
     *
     * @return Lot-Size-Independent Costs
     */
    @SerializedName( "LotSizeIndependentCosts" )
    @JsonProperty( "LotSizeIndependentCosts" )
    @Nullable
    @ODataField( odataName = "LotSizeIndependentCosts" )
    private BigDecimal lotSizeIndependentCosts;
    /**
     * Use with available fluent helpers to apply the <b>LotSizeIndependentCosts</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> LOT_SIZE_INDEPENDENT_COSTS =
        new ProductSupplyPlanningField<BigDecimal>("LotSizeIndependentCosts");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningCalendar</b>
     * </p>
     *
     * @return Planning Calendar
     */
    @SerializedName( "MRPPlanningCalendar" )
    @JsonProperty( "MRPPlanningCalendar" )
    @Nullable
    @ODataField( odataName = "MRPPlanningCalendar" )
    private String mRPPlanningCalendar;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlanningCalendar</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> MRP_PLANNING_CALENDAR =
        new ProductSupplyPlanningField<String>("MRPPlanningCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RangeOfCvrgPrflCode</b>
     * </p>
     *
     * @return Range-of-Coverage Profile
     */
    @SerializedName( "RangeOfCvrgPrflCode" )
    @JsonProperty( "RangeOfCvrgPrflCode" )
    @Nullable
    @ODataField( odataName = "RangeOfCvrgPrflCode" )
    private String rangeOfCvrgPrflCode;
    /**
     * Use with available fluent helpers to apply the <b>RangeOfCvrgPrflCode</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> RANGE_OF_CVRG_PRFL_CODE =
        new ProductSupplyPlanningField<String>("RangeOfCvrgPrflCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSafetyTime</b>
     * </p>
     *
     * @return Safety Time Indicator (with or without safety time)
     */
    @SerializedName( "IsSafetyTime" )
    @JsonProperty( "IsSafetyTime" )
    @Nullable
    @ODataField( odataName = "IsSafetyTime" )
    private String isSafetyTime;
    /**
     * Use with available fluent helpers to apply the <b>IsSafetyTime</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> IS_SAFETY_TIME =
        new ProductSupplyPlanningField<String>("IsSafetyTime");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PerdPrflForSftyTme</b>
     * </p>
     *
     * @return Period Profile for Safety Time
     */
    @SerializedName( "PerdPrflForSftyTme" )
    @JsonProperty( "PerdPrflForSftyTme" )
    @Nullable
    @ODataField( odataName = "PerdPrflForSftyTme" )
    private String perdPrflForSftyTme;
    /**
     * Use with available fluent helpers to apply the <b>PerdPrflForSftyTme</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PERD_PRFL_FOR_SFTY_TME =
        new ProductSupplyPlanningField<String>("PerdPrflForSftyTme");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMRPDependentRqmt</b>
     * </p>
     *
     * @return MRP relevancy for dependent requirements
     */
    @SerializedName( "IsMRPDependentRqmt" )
    @JsonProperty( "IsMRPDependentRqmt" )
    @Nullable
    @ODataField( odataName = "IsMRPDependentRqmt" )
    private String isMRPDependentRqmt;
    /**
     * Use with available fluent helpers to apply the <b>IsMRPDependentRqmt</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> IS_MRP_DEPENDENT_RQMT =
        new ProductSupplyPlanningField<String>("IsMRPDependentRqmt");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>InHouseProductionTime</b>
     * </p>
     *
     * @return In-house production time
     */
    @SerializedName( "InHouseProductionTime" )
    @JsonProperty( "InHouseProductionTime" )
    @Nullable
    @ODataField( odataName = "InHouseProductionTime" )
    private BigDecimal inHouseProductionTime;
    /**
     * Use with available fluent helpers to apply the <b>InHouseProductionTime</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> IN_HOUSE_PRODUCTION_TIME =
        new ProductSupplyPlanningField<BigDecimal>("InHouseProductionTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsForCrossProject</b>
     * </p>
     *
     * @return Indicator for Cross-Project Material
     */
    @SerializedName( "ProductIsForCrossProject" )
    @JsonProperty( "ProductIsForCrossProject" )
    @Nullable
    @ODataField( odataName = "ProductIsForCrossProject" )
    private String productIsForCrossProject;
    /**
     * Use with available fluent helpers to apply the <b>ProductIsForCrossProject</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PRODUCT_IS_FOR_CROSS_PROJECT =
        new ProductSupplyPlanningField<String>("ProductIsForCrossProject");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StorageCostsPercentageCode</b>
     * </p>
     *
     * @return Storage Costs Percentage Code
     */
    @SerializedName( "StorageCostsPercentageCode" )
    @JsonProperty( "StorageCostsPercentageCode" )
    @Nullable
    @ODataField( odataName = "StorageCostsPercentageCode" )
    private String storageCostsPercentageCode;
    /**
     * Use with available fluent helpers to apply the <b>StorageCostsPercentageCode</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> STORAGE_COSTS_PERCENTAGE_CODE =
        new ProductSupplyPlanningField<String>("StorageCostsPercentageCode");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcLvl</b>
     * </p>
     *
     * @return Service level
     */
    @SerializedName( "SrvcLvl" )
    @JsonProperty( "SrvcLvl" )
    @Nullable
    @ODataField( odataName = "SrvcLvl" )
    private BigDecimal srvcLvl;
    /**
     * Use with available fluent helpers to apply the <b>SrvcLvl</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> SRVC_LVL =
        new ProductSupplyPlanningField<BigDecimal>("SrvcLvl");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MRPAvailabilityType</b>
     * </p>
     *
     * @return Mixed MRP indicator
     */
    @SerializedName( "MRPAvailabilityType" )
    @JsonProperty( "MRPAvailabilityType" )
    @Nullable
    @ODataField( odataName = "MRPAvailabilityType" )
    private String mRPAvailabilityType;
    /**
     * Use with available fluent helpers to apply the <b>MRPAvailabilityType</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> MRP_AVAILABILITY_TYPE =
        new ProductSupplyPlanningField<String>("MRPAvailabilityType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FollowUpProduct</b>
     * </p>
     *
     * @return Follow-Up Material
     */
    @SerializedName( "FollowUpProduct" )
    @JsonProperty( "FollowUpProduct" )
    @Nullable
    @ODataField( odataName = "FollowUpProduct" )
    private String followUpProduct;
    /**
     * Use with available fluent helpers to apply the <b>FollowUpProduct</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> FOLLOW_UP_PRODUCT =
        new ProductSupplyPlanningField<String>("FollowUpProduct");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RepetitiveManufacturingIsAllwd</b>
     * </p>
     *
     * @return Repetitive Manufacturing Enabled
     */
    @SerializedName( "RepetitiveManufacturingIsAllwd" )
    @JsonProperty( "RepetitiveManufacturingIsAllwd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RepetitiveManufacturingIsAllwd" )
    private Boolean repetitiveManufacturingIsAllwd;
    /**
     * Use with available fluent helpers to apply the <b>RepetitiveManufacturingIsAllwd</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<Boolean> REPETITIVE_MANUFACTURING_IS_ALLWD =
        new ProductSupplyPlanningField<Boolean>("RepetitiveManufacturingIsAllwd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DependentRequirementsType</b>
     * </p>
     *
     * @return Indicator for Individual and Collective Requirements
     */
    @SerializedName( "DependentRequirementsType" )
    @JsonProperty( "DependentRequirementsType" )
    @Nullable
    @ODataField( odataName = "DependentRequirementsType" )
    private String dependentRequirementsType;
    /**
     * Use with available fluent helpers to apply the <b>DependentRequirementsType</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> DEPENDENT_REQUIREMENTS_TYPE =
        new ProductSupplyPlanningField<String>("DependentRequirementsType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBulkMaterialComponent</b>
     * </p>
     *
     * @return Indicator: Bulk Material
     */
    @SerializedName( "IsBulkMaterialComponent" )
    @JsonProperty( "IsBulkMaterialComponent" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsBulkMaterialComponent" )
    private Boolean isBulkMaterialComponent;
    /**
     * Use with available fluent helpers to apply the <b>IsBulkMaterialComponent</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<Boolean> IS_BULK_MATERIAL_COMPONENT =
        new ProductSupplyPlanningField<Boolean>("IsBulkMaterialComponent");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RepetitiveManufacturingProfile</b>
     * </p>
     *
     * @return Repetitive Manufacturing Profile
     */
    @SerializedName( "RepetitiveManufacturingProfile" )
    @JsonProperty( "RepetitiveManufacturingProfile" )
    @Nullable
    @ODataField( odataName = "RepetitiveManufacturingProfile" )
    private String repetitiveManufacturingProfile;
    /**
     * Use with available fluent helpers to apply the <b>RepetitiveManufacturingProfile</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> REPETITIVE_MANUFACTURING_PROFILE =
        new ProductSupplyPlanningField<String>("RepetitiveManufacturingProfile");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>RqmtQtyRcptTaktTmeInWrkgDays</b>
     * </p>
     *
     * @return Takt time
     */
    @SerializedName( "RqmtQtyRcptTaktTmeInWrkgDays" )
    @JsonProperty( "RqmtQtyRcptTaktTmeInWrkgDays" )
    @Nullable
    @ODataField( odataName = "RqmtQtyRcptTaktTmeInWrkgDays" )
    private BigDecimal rqmtQtyRcptTaktTmeInWrkgDays;
    /**
     * Use with available fluent helpers to apply the <b>RqmtQtyRcptTaktTmeInWrkgDays</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> RQMT_QTY_RCPT_TAKT_TME_IN_WRKG_DAYS =
        new ProductSupplyPlanningField<BigDecimal>("RqmtQtyRcptTaktTmeInWrkgDays");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ForecastRequirementsAreSplit</b>
     * </p>
     *
     * @return Splitting Indicator
     */
    @SerializedName( "ForecastRequirementsAreSplit" )
    @JsonProperty( "ForecastRequirementsAreSplit" )
    @Nullable
    @ODataField( odataName = "ForecastRequirementsAreSplit" )
    private String forecastRequirementsAreSplit;
    /**
     * Use with available fluent helpers to apply the <b>ForecastRequirementsAreSplit</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> FORECAST_REQUIREMENTS_ARE_SPLIT =
        new ProductSupplyPlanningField<String>("ForecastRequirementsAreSplit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EffectiveOutDate</b>
     * </p>
     *
     * @return Effective-Out Date
     */
    @SerializedName( "EffectiveOutDate" )
    @JsonProperty( "EffectiveOutDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EffectiveOutDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime effectiveOutDate;
    /**
     * Use with available fluent helpers to apply the <b>EffectiveOutDate</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<LocalDateTime> EFFECTIVE_OUT_DATE =
        new ProductSupplyPlanningField<LocalDateTime>("EffectiveOutDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPProfile</b>
     * </p>
     *
     * @return Material: MRP profile
     */
    @SerializedName( "MRPProfile" )
    @JsonProperty( "MRPProfile" )
    @Nullable
    @ODataField( odataName = "MRPProfile" )
    private String mRPProfile;
    /**
     * Use with available fluent helpers to apply the <b>MRPProfile</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> MRP_PROFILE =
        new ProductSupplyPlanningField<String>("MRPProfile");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ComponentScrapInPercent</b>
     * </p>
     *
     * @return Component Scrap in Percent
     */
    @SerializedName( "ComponentScrapInPercent" )
    @JsonProperty( "ComponentScrapInPercent" )
    @Nullable
    @ODataField( odataName = "ComponentScrapInPercent" )
    private BigDecimal componentScrapInPercent;
    /**
     * Use with available fluent helpers to apply the <b>ComponentScrapInPercent</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> COMPONENT_SCRAP_IN_PERCENT =
        new ProductSupplyPlanningField<BigDecimal>("ComponentScrapInPercent");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsToBeDiscontinued</b>
     * </p>
     *
     * @return Discontinuation indicator
     */
    @SerializedName( "ProductIsToBeDiscontinued" )
    @JsonProperty( "ProductIsToBeDiscontinued" )
    @Nullable
    @ODataField( odataName = "ProductIsToBeDiscontinued" )
    private String productIsToBeDiscontinued;
    /**
     * Use with available fluent helpers to apply the <b>ProductIsToBeDiscontinued</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PRODUCT_IS_TO_BE_DISCONTINUED =
        new ProductSupplyPlanningField<String>("ProductIsToBeDiscontinued");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdRqmtsAreConsolidated</b>
     * </p>
     *
     * @return Indicator for Requirements Grouping
     */
    @SerializedName( "ProdRqmtsAreConsolidated" )
    @JsonProperty( "ProdRqmtsAreConsolidated" )
    @Nullable
    @ODataField( odataName = "ProdRqmtsAreConsolidated" )
    private String prodRqmtsAreConsolidated;
    /**
     * Use with available fluent helpers to apply the <b>ProdRqmtsAreConsolidated</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PROD_RQMTS_ARE_CONSOLIDATED =
        new ProductSupplyPlanningField<String>("ProdRqmtsAreConsolidated");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     *
     * @return Indicator: Backflush
     */
    @SerializedName( "MatlCompIsMarkedForBackflush" )
    @JsonProperty( "MatlCompIsMarkedForBackflush" )
    @Nullable
    @ODataField( odataName = "MatlCompIsMarkedForBackflush" )
    private String matlCompIsMarkedForBackflush;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompIsMarkedForBackflush</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> MATL_COMP_IS_MARKED_FOR_BACKFLUSH =
        new ProductSupplyPlanningField<String>("MatlCompIsMarkedForBackflush");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProposedProductSupplyArea</b>
     * </p>
     *
     * @return Proposed Supply Area in Material Master Record
     */
    @SerializedName( "ProposedProductSupplyArea" )
    @JsonProperty( "ProposedProductSupplyArea" )
    @Nullable
    @ODataField( odataName = "ProposedProductSupplyArea" )
    private String proposedProductSupplyArea;
    /**
     * Use with available fluent helpers to apply the <b>ProposedProductSupplyArea</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PROPOSED_PRODUCT_SUPPLY_AREA =
        new ProductSupplyPlanningField<String>("ProposedProductSupplyArea");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> CURRENCY =
        new ProductSupplyPlanningField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderActionControl</b>
     * </p>
     *
     * @return Action Control: Planned Order Processing
     */
    @SerializedName( "PlannedOrderActionControl" )
    @JsonProperty( "PlannedOrderActionControl" )
    @Nullable
    @ODataField( odataName = "PlannedOrderActionControl" )
    private String plannedOrderActionControl;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOrderActionControl</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PLANNED_ORDER_ACTION_CONTROL =
        new ProductSupplyPlanningField<String>("PlannedOrderActionControl");

    @Nonnull
    @Override
    public Class<ProductSupplyPlanning> getType()
    {
        return ProductSupplyPlanning.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedLotSizeQuantity</b>
     * </p>
     *
     * @param fixedLotSizeQuantity
     *            Fixed lot size
     */
    public void setFixedLotSizeQuantity( @Nullable final BigDecimal fixedLotSizeQuantity )
    {
        rememberChangedField("FixedLotSizeQuantity", this.fixedLotSizeQuantity);
        this.fixedLotSizeQuantity = fixedLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @param maximumLotSizeQuantity
     *            Maximum Lot Size
     */
    public void setMaximumLotSizeQuantity( @Nullable final BigDecimal maximumLotSizeQuantity )
    {
        rememberChangedField("MaximumLotSizeQuantity", this.maximumLotSizeQuantity);
        this.maximumLotSizeQuantity = maximumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @param minimumLotSizeQuantity
     *            Minimum Lot Size
     */
    public void setMinimumLotSizeQuantity( @Nullable final BigDecimal minimumLotSizeQuantity )
    {
        rememberChangedField("MinimumLotSizeQuantity", this.minimumLotSizeQuantity);
        this.minimumLotSizeQuantity = minimumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LotSizeRoundingQuantity</b>
     * </p>
     *
     * @param lotSizeRoundingQuantity
     *            Rounding value for purchase order quantity
     */
    public void setLotSizeRoundingQuantity( @Nullable final BigDecimal lotSizeRoundingQuantity )
    {
        rememberChangedField("LotSizeRoundingQuantity", this.lotSizeRoundingQuantity);
        this.lotSizeRoundingQuantity = lotSizeRoundingQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LotSizingProcedure</b>
     * </p>
     *
     * @param lotSizingProcedure
     *            Lot Sizing Procedure in Materials Planning
     */
    public void setLotSizingProcedure( @Nullable final String lotSizingProcedure )
    {
        rememberChangedField("LotSizingProcedure", this.lotSizingProcedure);
        this.lotSizingProcedure = lotSizingProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPType</b>
     * </p>
     *
     * @param mRPType
     *            MRP Type
     */
    public void setMRPType( @Nullable final String mRPType )
    {
        rememberChangedField("MRPType", this.mRPType);
        this.mRPType = mRPType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPResponsible</b>
     * </p>
     *
     * @param mRPResponsible
     *            MRP Controller
     */
    public void setMRPResponsible( @Nullable final String mRPResponsible )
    {
        rememberChangedField("MRPResponsible", this.mRPResponsible);
        this.mRPResponsible = mRPResponsible;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SafetyStockQuantity</b>
     * </p>
     *
     * @param safetyStockQuantity
     *            Safety Stock
     */
    public void setSafetyStockQuantity( @Nullable final BigDecimal safetyStockQuantity )
    {
        rememberChangedField("SafetyStockQuantity", this.safetyStockQuantity);
        this.safetyStockQuantity = safetyStockQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumSafetyStockQuantity</b>
     * </p>
     *
     * @param minimumSafetyStockQuantity
     *            Minimum Safety Stock
     */
    public void setMinimumSafetyStockQuantity( @Nullable final BigDecimal minimumSafetyStockQuantity )
    {
        rememberChangedField("MinimumSafetyStockQuantity", this.minimumSafetyStockQuantity);
        this.minimumSafetyStockQuantity = minimumSafetyStockQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTimeFence</b>
     * </p>
     *
     * @param planningTimeFence
     *            Planning time fence
     */
    public void setPlanningTimeFence( @Nullable final String planningTimeFence )
    {
        rememberChangedField("PlanningTimeFence", this.planningTimeFence);
        this.planningTimeFence = planningTimeFence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicator</b>
     * </p>
     *
     * @param aBCIndicator
     *            ABC Indicator
     */
    public void setABCIndicator( @Nullable final String aBCIndicator )
    {
        rememberChangedField("ABCIndicator", this.aBCIndicator);
        this.aBCIndicator = aBCIndicator;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumStockQuantity</b>
     * </p>
     *
     * @param maximumStockQuantity
     *            Maximum Stock Level
     */
    public void setMaximumStockQuantity( @Nullable final BigDecimal maximumStockQuantity )
    {
        rememberChangedField("MaximumStockQuantity", this.maximumStockQuantity);
        this.maximumStockQuantity = maximumStockQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReorderThresholdQuantity</b>
     * </p>
     *
     * @param reorderThresholdQuantity
     *            Reorder Point
     */
    public void setReorderThresholdQuantity( @Nullable final BigDecimal reorderThresholdQuantity )
    {
        rememberChangedField("ReorderThresholdQuantity", this.reorderThresholdQuantity);
        this.reorderThresholdQuantity = reorderThresholdQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryDurationInDays</b>
     * </p>
     *
     * @param plannedDeliveryDurationInDays
     *            Planned Delivery Time in Days
     */
    public void setPlannedDeliveryDurationInDays( @Nullable final BigDecimal plannedDeliveryDurationInDays )
    {
        rememberChangedField("PlannedDeliveryDurationInDays", this.plannedDeliveryDurationInDays);
        this.plannedDeliveryDurationInDays = plannedDeliveryDurationInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SafetyDuration</b>
     * </p>
     *
     * @param safetyDuration
     *            Safety Time (in Workdays)
     */
    public void setSafetyDuration( @Nullable final String safetyDuration )
    {
        rememberChangedField("SafetyDuration", this.safetyDuration);
        this.safetyDuration = safetyDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlanningStrategyGroup</b>
     * </p>
     *
     * @param planningStrategyGroup
     *            Planning Strategy Group
     */
    public void setPlanningStrategyGroup( @Nullable final String planningStrategyGroup )
    {
        rememberChangedField("PlanningStrategyGroup", this.planningStrategyGroup);
        this.planningStrategyGroup = planningStrategyGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TotalReplenishmentLeadTime</b>
     * </p>
     *
     * @param totalReplenishmentLeadTime
     *            Total replenishment lead time (in workdays)
     */
    public void setTotalReplenishmentLeadTime( @Nullable final BigDecimal totalReplenishmentLeadTime )
    {
        rememberChangedField("TotalReplenishmentLeadTime", this.totalReplenishmentLeadTime);
        this.totalReplenishmentLeadTime = totalReplenishmentLeadTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementType</b>
     * </p>
     *
     * @param procurementType
     *            Procurement Type
     */
    public void setProcurementType( @Nullable final String procurementType )
    {
        rememberChangedField("ProcurementType", this.procurementType);
        this.procurementType = procurementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementSubType</b>
     * </p>
     *
     * @param procurementSubType
     *            Special Procurement Type
     */
    public void setProcurementSubType( @Nullable final String procurementSubType )
    {
        rememberChangedField("ProcurementSubType", this.procurementSubType);
        this.procurementSubType = procurementSubType;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssemblyScrapPercent</b>
     * </p>
     *
     * @param assemblyScrapPercent
     *            Assembly scrap in percent
     */
    public void setAssemblyScrapPercent( @Nullable final BigDecimal assemblyScrapPercent )
    {
        rememberChangedField("AssemblyScrapPercent", this.assemblyScrapPercent);
        this.assemblyScrapPercent = assemblyScrapPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityCheckType</b>
     * </p>
     *
     * @param availabilityCheckType
     *            Checking Group for Availability Check
     */
    public void setAvailabilityCheckType( @Nullable final String availabilityCheckType )
    {
        rememberChangedField("AvailabilityCheckType", this.availabilityCheckType);
        this.availabilityCheckType = availabilityCheckType;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDuration</b>
     * </p>
     *
     * @param goodsReceiptDuration
     *            Goods receipt processing time in days
     */
    public void setGoodsReceiptDuration( @Nullable final BigDecimal goodsReceiptDuration )
    {
        rememberChangedField("GoodsReceiptDuration", this.goodsReceiptDuration);
        this.goodsReceiptDuration = goodsReceiptDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPGroup</b>
     * </p>
     *
     * @param mRPGroup
     *            MRP Group
     */
    public void setMRPGroup( @Nullable final String mRPGroup )
    {
        rememberChangedField("MRPGroup", this.mRPGroup);
        this.mRPGroup = mRPGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DfltStorageLocationExtProcmt</b>
     * </p>
     *
     * @param dfltStorageLocationExtProcmt
     *            Default Storage Location for External Procurement
     */
    public void setDfltStorageLocationExtProcmt( @Nullable final String dfltStorageLocationExtProcmt )
    {
        rememberChangedField("DfltStorageLocationExtProcmt", this.dfltStorageLocationExtProcmt);
        this.dfltStorageLocationExtProcmt = dfltStorageLocationExtProcmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdRqmtsConsumptionMode</b>
     * </p>
     *
     * @param prodRqmtsConsumptionMode
     *            Consumption mode
     */
    public void setProdRqmtsConsumptionMode( @Nullable final String prodRqmtsConsumptionMode )
    {
        rememberChangedField("ProdRqmtsConsumptionMode", this.prodRqmtsConsumptionMode);
        this.prodRqmtsConsumptionMode = prodRqmtsConsumptionMode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BackwardCnsmpnPeriodInWorkDays</b>
     * </p>
     *
     * @param backwardCnsmpnPeriodInWorkDays
     *            Consumption Period: Backward
     */
    public void setBackwardCnsmpnPeriodInWorkDays( @Nullable final String backwardCnsmpnPeriodInWorkDays )
    {
        rememberChangedField("BackwardCnsmpnPeriodInWorkDays", this.backwardCnsmpnPeriodInWorkDays);
        this.backwardCnsmpnPeriodInWorkDays = backwardCnsmpnPeriodInWorkDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FwdConsumptionPeriodInWorkDays</b>
     * </p>
     *
     * @param fwdConsumptionPeriodInWorkDays
     *            Consumption period: Forward
     */
    public void setFwdConsumptionPeriodInWorkDays( @Nullable final String fwdConsumptionPeriodInWorkDays )
    {
        rememberChangedField("FwdConsumptionPeriodInWorkDays", this.fwdConsumptionPeriodInWorkDays);
        this.fwdConsumptionPeriodInWorkDays = fwdConsumptionPeriodInWorkDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlanAndOrderDayDetermination</b>
     * </p>
     *
     * @param planAndOrderDayDetermination
     *            Planning Cycle
     */
    public void setPlanAndOrderDayDetermination( @Nullable final String planAndOrderDayDetermination )
    {
        rememberChangedField("PlanAndOrderDayDetermination", this.planAndOrderDayDetermination);
        this.planAndOrderDayDetermination = planAndOrderDayDetermination;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RoundingProfile</b>
     * </p>
     *
     * @param roundingProfile
     *            Rounding Profile
     */
    public void setRoundingProfile( @Nullable final String roundingProfile )
    {
        rememberChangedField("RoundingProfile", this.roundingProfile);
        this.roundingProfile = roundingProfile;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LotSizeIndependentCosts</b>
     * </p>
     *
     * @param lotSizeIndependentCosts
     *            Lot-Size-Independent Costs
     */
    public void setLotSizeIndependentCosts( @Nullable final BigDecimal lotSizeIndependentCosts )
    {
        rememberChangedField("LotSizeIndependentCosts", this.lotSizeIndependentCosts);
        this.lotSizeIndependentCosts = lotSizeIndependentCosts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlanningCalendar</b>
     * </p>
     *
     * @param mRPPlanningCalendar
     *            Planning Calendar
     */
    public void setMRPPlanningCalendar( @Nullable final String mRPPlanningCalendar )
    {
        rememberChangedField("MRPPlanningCalendar", this.mRPPlanningCalendar);
        this.mRPPlanningCalendar = mRPPlanningCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RangeOfCvrgPrflCode</b>
     * </p>
     *
     * @param rangeOfCvrgPrflCode
     *            Range-of-Coverage Profile
     */
    public void setRangeOfCvrgPrflCode( @Nullable final String rangeOfCvrgPrflCode )
    {
        rememberChangedField("RangeOfCvrgPrflCode", this.rangeOfCvrgPrflCode);
        this.rangeOfCvrgPrflCode = rangeOfCvrgPrflCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSafetyTime</b>
     * </p>
     *
     * @param isSafetyTime
     *            Safety Time Indicator (with or without safety time)
     */
    public void setIsSafetyTime( @Nullable final String isSafetyTime )
    {
        rememberChangedField("IsSafetyTime", this.isSafetyTime);
        this.isSafetyTime = isSafetyTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PerdPrflForSftyTme</b>
     * </p>
     *
     * @param perdPrflForSftyTme
     *            Period Profile for Safety Time
     */
    public void setPerdPrflForSftyTme( @Nullable final String perdPrflForSftyTme )
    {
        rememberChangedField("PerdPrflForSftyTme", this.perdPrflForSftyTme);
        this.perdPrflForSftyTme = perdPrflForSftyTme;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMRPDependentRqmt</b>
     * </p>
     *
     * @param isMRPDependentRqmt
     *            MRP relevancy for dependent requirements
     */
    public void setIsMRPDependentRqmt( @Nullable final String isMRPDependentRqmt )
    {
        rememberChangedField("IsMRPDependentRqmt", this.isMRPDependentRqmt);
        this.isMRPDependentRqmt = isMRPDependentRqmt;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>InHouseProductionTime</b>
     * </p>
     *
     * @param inHouseProductionTime
     *            In-house production time
     */
    public void setInHouseProductionTime( @Nullable final BigDecimal inHouseProductionTime )
    {
        rememberChangedField("InHouseProductionTime", this.inHouseProductionTime);
        this.inHouseProductionTime = inHouseProductionTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsForCrossProject</b>
     * </p>
     *
     * @param productIsForCrossProject
     *            Indicator for Cross-Project Material
     */
    public void setProductIsForCrossProject( @Nullable final String productIsForCrossProject )
    {
        rememberChangedField("ProductIsForCrossProject", this.productIsForCrossProject);
        this.productIsForCrossProject = productIsForCrossProject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StorageCostsPercentageCode</b>
     * </p>
     *
     * @param storageCostsPercentageCode
     *            Storage Costs Percentage Code
     */
    public void setStorageCostsPercentageCode( @Nullable final String storageCostsPercentageCode )
    {
        rememberChangedField("StorageCostsPercentageCode", this.storageCostsPercentageCode);
        this.storageCostsPercentageCode = storageCostsPercentageCode;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcLvl</b>
     * </p>
     *
     * @param srvcLvl
     *            Service level
     */
    public void setSrvcLvl( @Nullable final BigDecimal srvcLvl )
    {
        rememberChangedField("SrvcLvl", this.srvcLvl);
        this.srvcLvl = srvcLvl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MRPAvailabilityType</b>
     * </p>
     *
     * @param mRPAvailabilityType
     *            Mixed MRP indicator
     */
    public void setMRPAvailabilityType( @Nullable final String mRPAvailabilityType )
    {
        rememberChangedField("MRPAvailabilityType", this.mRPAvailabilityType);
        this.mRPAvailabilityType = mRPAvailabilityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FollowUpProduct</b>
     * </p>
     *
     * @param followUpProduct
     *            Follow-Up Material
     */
    public void setFollowUpProduct( @Nullable final String followUpProduct )
    {
        rememberChangedField("FollowUpProduct", this.followUpProduct);
        this.followUpProduct = followUpProduct;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RepetitiveManufacturingIsAllwd</b>
     * </p>
     *
     * @param repetitiveManufacturingIsAllwd
     *            Repetitive Manufacturing Enabled
     */
    public void setRepetitiveManufacturingIsAllwd( @Nullable final Boolean repetitiveManufacturingIsAllwd )
    {
        rememberChangedField("RepetitiveManufacturingIsAllwd", this.repetitiveManufacturingIsAllwd);
        this.repetitiveManufacturingIsAllwd = repetitiveManufacturingIsAllwd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DependentRequirementsType</b>
     * </p>
     *
     * @param dependentRequirementsType
     *            Indicator for Individual and Collective Requirements
     */
    public void setDependentRequirementsType( @Nullable final String dependentRequirementsType )
    {
        rememberChangedField("DependentRequirementsType", this.dependentRequirementsType);
        this.dependentRequirementsType = dependentRequirementsType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBulkMaterialComponent</b>
     * </p>
     *
     * @param isBulkMaterialComponent
     *            Indicator: Bulk Material
     */
    public void setIsBulkMaterialComponent( @Nullable final Boolean isBulkMaterialComponent )
    {
        rememberChangedField("IsBulkMaterialComponent", this.isBulkMaterialComponent);
        this.isBulkMaterialComponent = isBulkMaterialComponent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RepetitiveManufacturingProfile</b>
     * </p>
     *
     * @param repetitiveManufacturingProfile
     *            Repetitive Manufacturing Profile
     */
    public void setRepetitiveManufacturingProfile( @Nullable final String repetitiveManufacturingProfile )
    {
        rememberChangedField("RepetitiveManufacturingProfile", this.repetitiveManufacturingProfile);
        this.repetitiveManufacturingProfile = repetitiveManufacturingProfile;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>RqmtQtyRcptTaktTmeInWrkgDays</b>
     * </p>
     *
     * @param rqmtQtyRcptTaktTmeInWrkgDays
     *            Takt time
     */
    public void setRqmtQtyRcptTaktTmeInWrkgDays( @Nullable final BigDecimal rqmtQtyRcptTaktTmeInWrkgDays )
    {
        rememberChangedField("RqmtQtyRcptTaktTmeInWrkgDays", this.rqmtQtyRcptTaktTmeInWrkgDays);
        this.rqmtQtyRcptTaktTmeInWrkgDays = rqmtQtyRcptTaktTmeInWrkgDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ForecastRequirementsAreSplit</b>
     * </p>
     *
     * @param forecastRequirementsAreSplit
     *            Splitting Indicator
     */
    public void setForecastRequirementsAreSplit( @Nullable final String forecastRequirementsAreSplit )
    {
        rememberChangedField("ForecastRequirementsAreSplit", this.forecastRequirementsAreSplit);
        this.forecastRequirementsAreSplit = forecastRequirementsAreSplit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EffectiveOutDate</b>
     * </p>
     *
     * @param effectiveOutDate
     *            Effective-Out Date
     */
    public void setEffectiveOutDate( @Nullable final LocalDateTime effectiveOutDate )
    {
        rememberChangedField("EffectiveOutDate", this.effectiveOutDate);
        this.effectiveOutDate = effectiveOutDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPProfile</b>
     * </p>
     *
     * @param mRPProfile
     *            Material: MRP profile
     */
    public void setMRPProfile( @Nullable final String mRPProfile )
    {
        rememberChangedField("MRPProfile", this.mRPProfile);
        this.mRPProfile = mRPProfile;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ComponentScrapInPercent</b>
     * </p>
     *
     * @param componentScrapInPercent
     *            Component Scrap in Percent
     */
    public void setComponentScrapInPercent( @Nullable final BigDecimal componentScrapInPercent )
    {
        rememberChangedField("ComponentScrapInPercent", this.componentScrapInPercent);
        this.componentScrapInPercent = componentScrapInPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsToBeDiscontinued</b>
     * </p>
     *
     * @param productIsToBeDiscontinued
     *            Discontinuation indicator
     */
    public void setProductIsToBeDiscontinued( @Nullable final String productIsToBeDiscontinued )
    {
        rememberChangedField("ProductIsToBeDiscontinued", this.productIsToBeDiscontinued);
        this.productIsToBeDiscontinued = productIsToBeDiscontinued;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdRqmtsAreConsolidated</b>
     * </p>
     *
     * @param prodRqmtsAreConsolidated
     *            Indicator for Requirements Grouping
     */
    public void setProdRqmtsAreConsolidated( @Nullable final String prodRqmtsAreConsolidated )
    {
        rememberChangedField("ProdRqmtsAreConsolidated", this.prodRqmtsAreConsolidated);
        this.prodRqmtsAreConsolidated = prodRqmtsAreConsolidated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     *
     * @param matlCompIsMarkedForBackflush
     *            Indicator: Backflush
     */
    public void setMatlCompIsMarkedForBackflush( @Nullable final String matlCompIsMarkedForBackflush )
    {
        rememberChangedField("MatlCompIsMarkedForBackflush", this.matlCompIsMarkedForBackflush);
        this.matlCompIsMarkedForBackflush = matlCompIsMarkedForBackflush;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProposedProductSupplyArea</b>
     * </p>
     *
     * @param proposedProductSupplyArea
     *            Proposed Supply Area in Material Master Record
     */
    public void setProposedProductSupplyArea( @Nullable final String proposedProductSupplyArea )
    {
        rememberChangedField("ProposedProductSupplyArea", this.proposedProductSupplyArea);
        this.proposedProductSupplyArea = proposedProductSupplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderActionControl</b>
     * </p>
     *
     * @param plannedOrderActionControl
     *            Action Control: Planned Order Processing
     */
    public void setPlannedOrderActionControl( @Nullable final String plannedOrderActionControl )
    {
        rememberChangedField("PlannedOrderActionControl", this.plannedOrderActionControl);
        this.plannedOrderActionControl = plannedOrderActionControl;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductSupplyPlanning";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("FixedLotSizeQuantity", getFixedLotSizeQuantity());
        values.put("MaximumLotSizeQuantity", getMaximumLotSizeQuantity());
        values.put("MinimumLotSizeQuantity", getMinimumLotSizeQuantity());
        values.put("LotSizeRoundingQuantity", getLotSizeRoundingQuantity());
        values.put("LotSizingProcedure", getLotSizingProcedure());
        values.put("MRPType", getMRPType());
        values.put("MRPResponsible", getMRPResponsible());
        values.put("SafetyStockQuantity", getSafetyStockQuantity());
        values.put("MinimumSafetyStockQuantity", getMinimumSafetyStockQuantity());
        values.put("PlanningTimeFence", getPlanningTimeFence());
        values.put("ABCIndicator", getABCIndicator());
        values.put("MaximumStockQuantity", getMaximumStockQuantity());
        values.put("ReorderThresholdQuantity", getReorderThresholdQuantity());
        values.put("PlannedDeliveryDurationInDays", getPlannedDeliveryDurationInDays());
        values.put("SafetyDuration", getSafetyDuration());
        values.put("PlanningStrategyGroup", getPlanningStrategyGroup());
        values.put("TotalReplenishmentLeadTime", getTotalReplenishmentLeadTime());
        values.put("ProcurementType", getProcurementType());
        values.put("ProcurementSubType", getProcurementSubType());
        values.put("AssemblyScrapPercent", getAssemblyScrapPercent());
        values.put("AvailabilityCheckType", getAvailabilityCheckType());
        values.put("GoodsReceiptDuration", getGoodsReceiptDuration());
        values.put("MRPGroup", getMRPGroup());
        values.put("DfltStorageLocationExtProcmt", getDfltStorageLocationExtProcmt());
        values.put("ProdRqmtsConsumptionMode", getProdRqmtsConsumptionMode());
        values.put("BackwardCnsmpnPeriodInWorkDays", getBackwardCnsmpnPeriodInWorkDays());
        values.put("FwdConsumptionPeriodInWorkDays", getFwdConsumptionPeriodInWorkDays());
        values.put("BaseUnit", getBaseUnit());
        values.put("PlanAndOrderDayDetermination", getPlanAndOrderDayDetermination());
        values.put("RoundingProfile", getRoundingProfile());
        values.put("LotSizeIndependentCosts", getLotSizeIndependentCosts());
        values.put("MRPPlanningCalendar", getMRPPlanningCalendar());
        values.put("RangeOfCvrgPrflCode", getRangeOfCvrgPrflCode());
        values.put("IsSafetyTime", getIsSafetyTime());
        values.put("PerdPrflForSftyTme", getPerdPrflForSftyTme());
        values.put("IsMRPDependentRqmt", getIsMRPDependentRqmt());
        values.put("InHouseProductionTime", getInHouseProductionTime());
        values.put("ProductIsForCrossProject", getProductIsForCrossProject());
        values.put("StorageCostsPercentageCode", getStorageCostsPercentageCode());
        values.put("SrvcLvl", getSrvcLvl());
        values.put("MRPAvailabilityType", getMRPAvailabilityType());
        values.put("FollowUpProduct", getFollowUpProduct());
        values.put("RepetitiveManufacturingIsAllwd", getRepetitiveManufacturingIsAllwd());
        values.put("DependentRequirementsType", getDependentRequirementsType());
        values.put("IsBulkMaterialComponent", getIsBulkMaterialComponent());
        values.put("RepetitiveManufacturingProfile", getRepetitiveManufacturingProfile());
        values.put("RqmtQtyRcptTaktTmeInWrkgDays", getRqmtQtyRcptTaktTmeInWrkgDays());
        values.put("ForecastRequirementsAreSplit", getForecastRequirementsAreSplit());
        values.put("EffectiveOutDate", getEffectiveOutDate());
        values.put("MRPProfile", getMRPProfile());
        values.put("ComponentScrapInPercent", getComponentScrapInPercent());
        values.put("ProductIsToBeDiscontinued", getProductIsToBeDiscontinued());
        values.put("ProdRqmtsAreConsolidated", getProdRqmtsAreConsolidated());
        values.put("MatlCompIsMarkedForBackflush", getMatlCompIsMarkedForBackflush());
        values.put("ProposedProductSupplyArea", getProposedProductSupplyArea());
        values.put("Currency", getCurrency());
        values.put("PlannedOrderActionControl", getPlannedOrderActionControl());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("FixedLotSizeQuantity") ) {
                final Object value = values.remove("FixedLotSizeQuantity");
                if( (value == null) || (!value.equals(getFixedLotSizeQuantity())) ) {
                    setFixedLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumLotSizeQuantity") ) {
                final Object value = values.remove("MaximumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMaximumLotSizeQuantity())) ) {
                    setMaximumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MinimumLotSizeQuantity") ) {
                final Object value = values.remove("MinimumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMinimumLotSizeQuantity())) ) {
                    setMinimumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("LotSizeRoundingQuantity") ) {
                final Object value = values.remove("LotSizeRoundingQuantity");
                if( (value == null) || (!value.equals(getLotSizeRoundingQuantity())) ) {
                    setLotSizeRoundingQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("LotSizingProcedure") ) {
                final Object value = values.remove("LotSizingProcedure");
                if( (value == null) || (!value.equals(getLotSizingProcedure())) ) {
                    setLotSizingProcedure(((String) value));
                }
            }
            if( values.containsKey("MRPType") ) {
                final Object value = values.remove("MRPType");
                if( (value == null) || (!value.equals(getMRPType())) ) {
                    setMRPType(((String) value));
                }
            }
            if( values.containsKey("MRPResponsible") ) {
                final Object value = values.remove("MRPResponsible");
                if( (value == null) || (!value.equals(getMRPResponsible())) ) {
                    setMRPResponsible(((String) value));
                }
            }
            if( values.containsKey("SafetyStockQuantity") ) {
                final Object value = values.remove("SafetyStockQuantity");
                if( (value == null) || (!value.equals(getSafetyStockQuantity())) ) {
                    setSafetyStockQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MinimumSafetyStockQuantity") ) {
                final Object value = values.remove("MinimumSafetyStockQuantity");
                if( (value == null) || (!value.equals(getMinimumSafetyStockQuantity())) ) {
                    setMinimumSafetyStockQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlanningTimeFence") ) {
                final Object value = values.remove("PlanningTimeFence");
                if( (value == null) || (!value.equals(getPlanningTimeFence())) ) {
                    setPlanningTimeFence(((String) value));
                }
            }
            if( values.containsKey("ABCIndicator") ) {
                final Object value = values.remove("ABCIndicator");
                if( (value == null) || (!value.equals(getABCIndicator())) ) {
                    setABCIndicator(((String) value));
                }
            }
            if( values.containsKey("MaximumStockQuantity") ) {
                final Object value = values.remove("MaximumStockQuantity");
                if( (value == null) || (!value.equals(getMaximumStockQuantity())) ) {
                    setMaximumStockQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReorderThresholdQuantity") ) {
                final Object value = values.remove("ReorderThresholdQuantity");
                if( (value == null) || (!value.equals(getReorderThresholdQuantity())) ) {
                    setReorderThresholdQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlannedDeliveryDurationInDays") ) {
                final Object value = values.remove("PlannedDeliveryDurationInDays");
                if( (value == null) || (!value.equals(getPlannedDeliveryDurationInDays())) ) {
                    setPlannedDeliveryDurationInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("SafetyDuration") ) {
                final Object value = values.remove("SafetyDuration");
                if( (value == null) || (!value.equals(getSafetyDuration())) ) {
                    setSafetyDuration(((String) value));
                }
            }
            if( values.containsKey("PlanningStrategyGroup") ) {
                final Object value = values.remove("PlanningStrategyGroup");
                if( (value == null) || (!value.equals(getPlanningStrategyGroup())) ) {
                    setPlanningStrategyGroup(((String) value));
                }
            }
            if( values.containsKey("TotalReplenishmentLeadTime") ) {
                final Object value = values.remove("TotalReplenishmentLeadTime");
                if( (value == null) || (!value.equals(getTotalReplenishmentLeadTime())) ) {
                    setTotalReplenishmentLeadTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProcurementType") ) {
                final Object value = values.remove("ProcurementType");
                if( (value == null) || (!value.equals(getProcurementType())) ) {
                    setProcurementType(((String) value));
                }
            }
            if( values.containsKey("ProcurementSubType") ) {
                final Object value = values.remove("ProcurementSubType");
                if( (value == null) || (!value.equals(getProcurementSubType())) ) {
                    setProcurementSubType(((String) value));
                }
            }
            if( values.containsKey("AssemblyScrapPercent") ) {
                final Object value = values.remove("AssemblyScrapPercent");
                if( (value == null) || (!value.equals(getAssemblyScrapPercent())) ) {
                    setAssemblyScrapPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("AvailabilityCheckType") ) {
                final Object value = values.remove("AvailabilityCheckType");
                if( (value == null) || (!value.equals(getAvailabilityCheckType())) ) {
                    setAvailabilityCheckType(((String) value));
                }
            }
            if( values.containsKey("GoodsReceiptDuration") ) {
                final Object value = values.remove("GoodsReceiptDuration");
                if( (value == null) || (!value.equals(getGoodsReceiptDuration())) ) {
                    setGoodsReceiptDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("MRPGroup") ) {
                final Object value = values.remove("MRPGroup");
                if( (value == null) || (!value.equals(getMRPGroup())) ) {
                    setMRPGroup(((String) value));
                }
            }
            if( values.containsKey("DfltStorageLocationExtProcmt") ) {
                final Object value = values.remove("DfltStorageLocationExtProcmt");
                if( (value == null) || (!value.equals(getDfltStorageLocationExtProcmt())) ) {
                    setDfltStorageLocationExtProcmt(((String) value));
                }
            }
            if( values.containsKey("ProdRqmtsConsumptionMode") ) {
                final Object value = values.remove("ProdRqmtsConsumptionMode");
                if( (value == null) || (!value.equals(getProdRqmtsConsumptionMode())) ) {
                    setProdRqmtsConsumptionMode(((String) value));
                }
            }
            if( values.containsKey("BackwardCnsmpnPeriodInWorkDays") ) {
                final Object value = values.remove("BackwardCnsmpnPeriodInWorkDays");
                if( (value == null) || (!value.equals(getBackwardCnsmpnPeriodInWorkDays())) ) {
                    setBackwardCnsmpnPeriodInWorkDays(((String) value));
                }
            }
            if( values.containsKey("FwdConsumptionPeriodInWorkDays") ) {
                final Object value = values.remove("FwdConsumptionPeriodInWorkDays");
                if( (value == null) || (!value.equals(getFwdConsumptionPeriodInWorkDays())) ) {
                    setFwdConsumptionPeriodInWorkDays(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("PlanAndOrderDayDetermination") ) {
                final Object value = values.remove("PlanAndOrderDayDetermination");
                if( (value == null) || (!value.equals(getPlanAndOrderDayDetermination())) ) {
                    setPlanAndOrderDayDetermination(((String) value));
                }
            }
            if( values.containsKey("RoundingProfile") ) {
                final Object value = values.remove("RoundingProfile");
                if( (value == null) || (!value.equals(getRoundingProfile())) ) {
                    setRoundingProfile(((String) value));
                }
            }
            if( values.containsKey("LotSizeIndependentCosts") ) {
                final Object value = values.remove("LotSizeIndependentCosts");
                if( (value == null) || (!value.equals(getLotSizeIndependentCosts())) ) {
                    setLotSizeIndependentCosts(((BigDecimal) value));
                }
            }
            if( values.containsKey("MRPPlanningCalendar") ) {
                final Object value = values.remove("MRPPlanningCalendar");
                if( (value == null) || (!value.equals(getMRPPlanningCalendar())) ) {
                    setMRPPlanningCalendar(((String) value));
                }
            }
            if( values.containsKey("RangeOfCvrgPrflCode") ) {
                final Object value = values.remove("RangeOfCvrgPrflCode");
                if( (value == null) || (!value.equals(getRangeOfCvrgPrflCode())) ) {
                    setRangeOfCvrgPrflCode(((String) value));
                }
            }
            if( values.containsKey("IsSafetyTime") ) {
                final Object value = values.remove("IsSafetyTime");
                if( (value == null) || (!value.equals(getIsSafetyTime())) ) {
                    setIsSafetyTime(((String) value));
                }
            }
            if( values.containsKey("PerdPrflForSftyTme") ) {
                final Object value = values.remove("PerdPrflForSftyTme");
                if( (value == null) || (!value.equals(getPerdPrflForSftyTme())) ) {
                    setPerdPrflForSftyTme(((String) value));
                }
            }
            if( values.containsKey("IsMRPDependentRqmt") ) {
                final Object value = values.remove("IsMRPDependentRqmt");
                if( (value == null) || (!value.equals(getIsMRPDependentRqmt())) ) {
                    setIsMRPDependentRqmt(((String) value));
                }
            }
            if( values.containsKey("InHouseProductionTime") ) {
                final Object value = values.remove("InHouseProductionTime");
                if( (value == null) || (!value.equals(getInHouseProductionTime())) ) {
                    setInHouseProductionTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductIsForCrossProject") ) {
                final Object value = values.remove("ProductIsForCrossProject");
                if( (value == null) || (!value.equals(getProductIsForCrossProject())) ) {
                    setProductIsForCrossProject(((String) value));
                }
            }
            if( values.containsKey("StorageCostsPercentageCode") ) {
                final Object value = values.remove("StorageCostsPercentageCode");
                if( (value == null) || (!value.equals(getStorageCostsPercentageCode())) ) {
                    setStorageCostsPercentageCode(((String) value));
                }
            }
            if( values.containsKey("SrvcLvl") ) {
                final Object value = values.remove("SrvcLvl");
                if( (value == null) || (!value.equals(getSrvcLvl())) ) {
                    setSrvcLvl(((BigDecimal) value));
                }
            }
            if( values.containsKey("MRPAvailabilityType") ) {
                final Object value = values.remove("MRPAvailabilityType");
                if( (value == null) || (!value.equals(getMRPAvailabilityType())) ) {
                    setMRPAvailabilityType(((String) value));
                }
            }
            if( values.containsKey("FollowUpProduct") ) {
                final Object value = values.remove("FollowUpProduct");
                if( (value == null) || (!value.equals(getFollowUpProduct())) ) {
                    setFollowUpProduct(((String) value));
                }
            }
            if( values.containsKey("RepetitiveManufacturingIsAllwd") ) {
                final Object value = values.remove("RepetitiveManufacturingIsAllwd");
                if( (value == null) || (!value.equals(getRepetitiveManufacturingIsAllwd())) ) {
                    setRepetitiveManufacturingIsAllwd(((Boolean) value));
                }
            }
            if( values.containsKey("DependentRequirementsType") ) {
                final Object value = values.remove("DependentRequirementsType");
                if( (value == null) || (!value.equals(getDependentRequirementsType())) ) {
                    setDependentRequirementsType(((String) value));
                }
            }
            if( values.containsKey("IsBulkMaterialComponent") ) {
                final Object value = values.remove("IsBulkMaterialComponent");
                if( (value == null) || (!value.equals(getIsBulkMaterialComponent())) ) {
                    setIsBulkMaterialComponent(((Boolean) value));
                }
            }
            if( values.containsKey("RepetitiveManufacturingProfile") ) {
                final Object value = values.remove("RepetitiveManufacturingProfile");
                if( (value == null) || (!value.equals(getRepetitiveManufacturingProfile())) ) {
                    setRepetitiveManufacturingProfile(((String) value));
                }
            }
            if( values.containsKey("RqmtQtyRcptTaktTmeInWrkgDays") ) {
                final Object value = values.remove("RqmtQtyRcptTaktTmeInWrkgDays");
                if( (value == null) || (!value.equals(getRqmtQtyRcptTaktTmeInWrkgDays())) ) {
                    setRqmtQtyRcptTaktTmeInWrkgDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("ForecastRequirementsAreSplit") ) {
                final Object value = values.remove("ForecastRequirementsAreSplit");
                if( (value == null) || (!value.equals(getForecastRequirementsAreSplit())) ) {
                    setForecastRequirementsAreSplit(((String) value));
                }
            }
            if( values.containsKey("EffectiveOutDate") ) {
                final Object value = values.remove("EffectiveOutDate");
                if( (value == null) || (!value.equals(getEffectiveOutDate())) ) {
                    setEffectiveOutDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MRPProfile") ) {
                final Object value = values.remove("MRPProfile");
                if( (value == null) || (!value.equals(getMRPProfile())) ) {
                    setMRPProfile(((String) value));
                }
            }
            if( values.containsKey("ComponentScrapInPercent") ) {
                final Object value = values.remove("ComponentScrapInPercent");
                if( (value == null) || (!value.equals(getComponentScrapInPercent())) ) {
                    setComponentScrapInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductIsToBeDiscontinued") ) {
                final Object value = values.remove("ProductIsToBeDiscontinued");
                if( (value == null) || (!value.equals(getProductIsToBeDiscontinued())) ) {
                    setProductIsToBeDiscontinued(((String) value));
                }
            }
            if( values.containsKey("ProdRqmtsAreConsolidated") ) {
                final Object value = values.remove("ProdRqmtsAreConsolidated");
                if( (value == null) || (!value.equals(getProdRqmtsAreConsolidated())) ) {
                    setProdRqmtsAreConsolidated(((String) value));
                }
            }
            if( values.containsKey("MatlCompIsMarkedForBackflush") ) {
                final Object value = values.remove("MatlCompIsMarkedForBackflush");
                if( (value == null) || (!value.equals(getMatlCompIsMarkedForBackflush())) ) {
                    setMatlCompIsMarkedForBackflush(((String) value));
                }
            }
            if( values.containsKey("ProposedProductSupplyArea") ) {
                final Object value = values.remove("ProposedProductSupplyArea");
                if( (value == null) || (!value.equals(getProposedProductSupplyArea())) ) {
                    setProposedProductSupplyArea(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("PlannedOrderActionControl") ) {
                final Object value = values.remove("PlannedOrderActionControl");
                if( (value == null) || (!value.equals(getPlannedOrderActionControl())) ) {
                    setPlannedOrderActionControl(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductSupplyPlanningField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductSupplyPlanningField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductSupplyPlanningField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductSupplyPlanningField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
