/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductUnitsOfMeasureField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductUnitsOfMeasureLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductUnitsOfMeasureSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Units of Measure
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductUnitsOfMeasureType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductUnitsOfMeasure extends VdmEntity<ProductUnitsOfMeasure>
{

    /**
     * Selector for all available fields of ProductUnitsOfMeasure.
     *
     */
    public final static ProductUnitsOfMeasureSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<String> PRODUCT = new ProductUnitsOfMeasureField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeUnit</b>
     * </p>
     *
     * @return Alternative Unit of Measure for Stockkeeping Unit
     */
    @Key
    @SerializedName( "AlternativeUnit" )
    @JsonProperty( "AlternativeUnit" )
    @Nullable
    @ODataField( odataName = "AlternativeUnit" )
    private String alternativeUnit;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeUnit</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<String> ALTERNATIVE_UNIT =
        new ProductUnitsOfMeasureField<String>("AlternativeUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuantityNumerator</b>
     * </p>
     *
     * @return Numerator for Conversion to Base Units of Measure
     */
    @SerializedName( "QuantityNumerator" )
    @JsonProperty( "QuantityNumerator" )
    @Nullable
    @ODataField( odataName = "QuantityNumerator" )
    private BigDecimal quantityNumerator;
    /**
     * Use with available fluent helpers to apply the <b>QuantityNumerator</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<BigDecimal> QUANTITY_NUMERATOR =
        new ProductUnitsOfMeasureField<BigDecimal>("QuantityNumerator");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuantityDenominator</b>
     * </p>
     *
     * @return Denominator for conversion to base units of measure
     */
    @SerializedName( "QuantityDenominator" )
    @JsonProperty( "QuantityDenominator" )
    @Nullable
    @ODataField( odataName = "QuantityDenominator" )
    private BigDecimal quantityDenominator;
    /**
     * Use with available fluent helpers to apply the <b>QuantityDenominator</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<BigDecimal> QUANTITY_DENOMINATOR =
        new ProductUnitsOfMeasureField<BigDecimal>("QuantityDenominator");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialVolume</b>
     * </p>
     *
     * @return Volume
     */
    @SerializedName( "MaterialVolume" )
    @JsonProperty( "MaterialVolume" )
    @Nullable
    @ODataField( odataName = "MaterialVolume" )
    private BigDecimal materialVolume;
    /**
     * Use with available fluent helpers to apply the <b>MaterialVolume</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<BigDecimal> MATERIAL_VOLUME =
        new ProductUnitsOfMeasureField<BigDecimal>("MaterialVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "VolumeUnit" )
    @JsonProperty( "VolumeUnit" )
    @Nullable
    @ODataField( odataName = "VolumeUnit" )
    private String volumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>VolumeUnit</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<String> VOLUME_UNIT =
        new ProductUnitsOfMeasureField<String>("VolumeUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeight</b>
     * </p>
     *
     * @return Gross Weight
     */
    @SerializedName( "GrossWeight" )
    @JsonProperty( "GrossWeight" )
    @Nullable
    @ODataField( odataName = "GrossWeight" )
    private BigDecimal grossWeight;
    /**
     * Use with available fluent helpers to apply the <b>GrossWeight</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<BigDecimal> GROSS_WEIGHT =
        new ProductUnitsOfMeasureField<BigDecimal>("GrossWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "WeightUnit" )
    @JsonProperty( "WeightUnit" )
    @Nullable
    @ODataField( odataName = "WeightUnit" )
    private String weightUnit;
    /**
     * Use with available fluent helpers to apply the <b>WeightUnit</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<String> WEIGHT_UNIT =
        new ProductUnitsOfMeasureField<String>("WeightUnit");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>GlobalTradeItemNumber</b>
     * </p>
     *
     * @return International Article Number (EAN/UPC)
     */
    @SerializedName( "GlobalTradeItemNumber" )
    @JsonProperty( "GlobalTradeItemNumber" )
    @Nullable
    @ODataField( odataName = "GlobalTradeItemNumber" )
    private String globalTradeItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>GlobalTradeItemNumber</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<String> GLOBAL_TRADE_ITEM_NUMBER =
        new ProductUnitsOfMeasureField<String>("GlobalTradeItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>GlobalTradeItemNumberCategory</b>
     * </p>
     *
     * @return Category of Global Trade Item Number (GTIN)
     */
    @SerializedName( "GlobalTradeItemNumberCategory" )
    @JsonProperty( "GlobalTradeItemNumberCategory" )
    @Nullable
    @ODataField( odataName = "GlobalTradeItemNumberCategory" )
    private String globalTradeItemNumberCategory;
    /**
     * Use with available fluent helpers to apply the <b>GlobalTradeItemNumberCategory</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<String> GLOBAL_TRADE_ITEM_NUMBER_CATEGORY =
        new ProductUnitsOfMeasureField<String>("GlobalTradeItemNumberCategory");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitSpecificProductLength</b>
     * </p>
     *
     * @return Length
     */
    @SerializedName( "UnitSpecificProductLength" )
    @JsonProperty( "UnitSpecificProductLength" )
    @Nullable
    @ODataField( odataName = "UnitSpecificProductLength" )
    private BigDecimal unitSpecificProductLength;
    /**
     * Use with available fluent helpers to apply the <b>UnitSpecificProductLength</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<BigDecimal> UNIT_SPECIFIC_PRODUCT_LENGTH =
        new ProductUnitsOfMeasureField<BigDecimal>("UnitSpecificProductLength");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitSpecificProductWidth</b>
     * </p>
     *
     * @return Width
     */
    @SerializedName( "UnitSpecificProductWidth" )
    @JsonProperty( "UnitSpecificProductWidth" )
    @Nullable
    @ODataField( odataName = "UnitSpecificProductWidth" )
    private BigDecimal unitSpecificProductWidth;
    /**
     * Use with available fluent helpers to apply the <b>UnitSpecificProductWidth</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<BigDecimal> UNIT_SPECIFIC_PRODUCT_WIDTH =
        new ProductUnitsOfMeasureField<BigDecimal>("UnitSpecificProductWidth");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitSpecificProductHeight</b>
     * </p>
     *
     * @return Height
     */
    @SerializedName( "UnitSpecificProductHeight" )
    @JsonProperty( "UnitSpecificProductHeight" )
    @Nullable
    @ODataField( odataName = "UnitSpecificProductHeight" )
    private BigDecimal unitSpecificProductHeight;
    /**
     * Use with available fluent helpers to apply the <b>UnitSpecificProductHeight</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<BigDecimal> UNIT_SPECIFIC_PRODUCT_HEIGHT =
        new ProductUnitsOfMeasureField<BigDecimal>("UnitSpecificProductHeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductMeasurementUnit</b>
     * </p>
     *
     * @return Unit of Dimension for Length/Width/Height
     */
    @SerializedName( "ProductMeasurementUnit" )
    @JsonProperty( "ProductMeasurementUnit" )
    @Nullable
    @ODataField( odataName = "ProductMeasurementUnit" )
    private String productMeasurementUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProductMeasurementUnit</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<String> PRODUCT_MEASUREMENT_UNIT =
        new ProductUnitsOfMeasureField<String>("ProductMeasurementUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LowerLevelPackagingUnit</b>
     * </p>
     *
     * @return Lower-Level Unit of Measure in a Packing Hierarchy
     */
    @SerializedName( "LowerLevelPackagingUnit" )
    @JsonProperty( "LowerLevelPackagingUnit" )
    @Nullable
    @ODataField( odataName = "LowerLevelPackagingUnit" )
    private String lowerLevelPackagingUnit;
    /**
     * Use with available fluent helpers to apply the <b>LowerLevelPackagingUnit</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<String> LOWER_LEVEL_PACKAGING_UNIT =
        new ProductUnitsOfMeasureField<String>("LowerLevelPackagingUnit");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>RemainingVolumeAfterNesting</b>
     * </p>
     *
     * @return Remaining Volume after Nesting (in Percentage)
     */
    @SerializedName( "RemainingVolumeAfterNesting" )
    @JsonProperty( "RemainingVolumeAfterNesting" )
    @Nullable
    @ODataField( odataName = "RemainingVolumeAfterNesting" )
    private BigDecimal remainingVolumeAfterNesting;
    /**
     * Use with available fluent helpers to apply the <b>RemainingVolumeAfterNesting</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<BigDecimal> REMAINING_VOLUME_AFTER_NESTING =
        new ProductUnitsOfMeasureField<BigDecimal>("RemainingVolumeAfterNesting");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaximumStackingFactor</b>
     * </p>
     *
     * @return Maximum Stacking Factor
     */
    @SerializedName( "MaximumStackingFactor" )
    @JsonProperty( "MaximumStackingFactor" )
    @Nullable
    @ODataField( odataName = "MaximumStackingFactor" )
    private Short maximumStackingFactor;
    /**
     * Use with available fluent helpers to apply the <b>MaximumStackingFactor</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<Short> MAXIMUM_STACKING_FACTOR =
        new ProductUnitsOfMeasureField<Short>("MaximumStackingFactor");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityUsage</b>
     * </p>
     *
     * @return Capacity Usage
     */
    @SerializedName( "CapacityUsage" )
    @JsonProperty( "CapacityUsage" )
    @Nullable
    @ODataField( odataName = "CapacityUsage" )
    private BigDecimal capacityUsage;
    /**
     * Use with available fluent helpers to apply the <b>CapacityUsage</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<BigDecimal> CAPACITY_USAGE =
        new ProductUnitsOfMeasureField<BigDecimal>("CapacityUsage");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureField<String> BASE_UNIT =
        new ProductUnitsOfMeasureField<String>("BaseUnit");
    /**
     * Navigation property <b>to_InternationalArticleNumber</b> for <b>ProductUnitsOfMeasure</b> to multiple
     * <b>ProductUnitsOfMeasureEAN</b>.
     *
     */
    @SerializedName( "to_InternationalArticleNumber" )
    @JsonProperty( "to_InternationalArticleNumber" )
    @ODataField( odataName = "to_InternationalArticleNumber" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductUnitsOfMeasureEAN> toInternationalArticleNumber;
    /**
     * Use with available fluent helpers to apply the <b>to_InternationalArticleNumber</b> navigation property to query
     * operations.
     *
     */
    public final static ProductUnitsOfMeasureLink<ProductUnitsOfMeasureEAN> TO_INTERNATIONAL_ARTICLE_NUMBER =
        new ProductUnitsOfMeasureLink<ProductUnitsOfMeasureEAN>("to_InternationalArticleNumber");

    @Nonnull
    @Override
    public Class<ProductUnitsOfMeasure> getType()
    {
        return ProductUnitsOfMeasure.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeUnit</b>
     * </p>
     *
     * @param alternativeUnit
     *            Alternative Unit of Measure for Stockkeeping Unit
     */
    public void setAlternativeUnit( @Nullable final String alternativeUnit )
    {
        rememberChangedField("AlternativeUnit", this.alternativeUnit);
        this.alternativeUnit = alternativeUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuantityNumerator</b>
     * </p>
     *
     * @param quantityNumerator
     *            Numerator for Conversion to Base Units of Measure
     */
    public void setQuantityNumerator( @Nullable final BigDecimal quantityNumerator )
    {
        rememberChangedField("QuantityNumerator", this.quantityNumerator);
        this.quantityNumerator = quantityNumerator;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuantityDenominator</b>
     * </p>
     *
     * @param quantityDenominator
     *            Denominator for conversion to base units of measure
     */
    public void setQuantityDenominator( @Nullable final BigDecimal quantityDenominator )
    {
        rememberChangedField("QuantityDenominator", this.quantityDenominator);
        this.quantityDenominator = quantityDenominator;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialVolume</b>
     * </p>
     *
     * @param materialVolume
     *            Volume
     */
    public void setMaterialVolume( @Nullable final BigDecimal materialVolume )
    {
        rememberChangedField("MaterialVolume", this.materialVolume);
        this.materialVolume = materialVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     *
     * @param volumeUnit
     *            Volume Unit
     */
    public void setVolumeUnit( @Nullable final String volumeUnit )
    {
        rememberChangedField("VolumeUnit", this.volumeUnit);
        this.volumeUnit = volumeUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeight</b>
     * </p>
     *
     * @param grossWeight
     *            Gross Weight
     */
    public void setGrossWeight( @Nullable final BigDecimal grossWeight )
    {
        rememberChangedField("GrossWeight", this.grossWeight);
        this.grossWeight = grossWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightUnit</b>
     * </p>
     *
     * @param weightUnit
     *            Unit of Weight
     */
    public void setWeightUnit( @Nullable final String weightUnit )
    {
        rememberChangedField("WeightUnit", this.weightUnit);
        this.weightUnit = weightUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>GlobalTradeItemNumber</b>
     * </p>
     *
     * @param globalTradeItemNumber
     *            International Article Number (EAN/UPC)
     */
    public void setGlobalTradeItemNumber( @Nullable final String globalTradeItemNumber )
    {
        rememberChangedField("GlobalTradeItemNumber", this.globalTradeItemNumber);
        this.globalTradeItemNumber = globalTradeItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>GlobalTradeItemNumberCategory</b>
     * </p>
     *
     * @param globalTradeItemNumberCategory
     *            Category of Global Trade Item Number (GTIN)
     */
    public void setGlobalTradeItemNumberCategory( @Nullable final String globalTradeItemNumberCategory )
    {
        rememberChangedField("GlobalTradeItemNumberCategory", this.globalTradeItemNumberCategory);
        this.globalTradeItemNumberCategory = globalTradeItemNumberCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitSpecificProductLength</b>
     * </p>
     *
     * @param unitSpecificProductLength
     *            Length
     */
    public void setUnitSpecificProductLength( @Nullable final BigDecimal unitSpecificProductLength )
    {
        rememberChangedField("UnitSpecificProductLength", this.unitSpecificProductLength);
        this.unitSpecificProductLength = unitSpecificProductLength;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitSpecificProductWidth</b>
     * </p>
     *
     * @param unitSpecificProductWidth
     *            Width
     */
    public void setUnitSpecificProductWidth( @Nullable final BigDecimal unitSpecificProductWidth )
    {
        rememberChangedField("UnitSpecificProductWidth", this.unitSpecificProductWidth);
        this.unitSpecificProductWidth = unitSpecificProductWidth;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitSpecificProductHeight</b>
     * </p>
     *
     * @param unitSpecificProductHeight
     *            Height
     */
    public void setUnitSpecificProductHeight( @Nullable final BigDecimal unitSpecificProductHeight )
    {
        rememberChangedField("UnitSpecificProductHeight", this.unitSpecificProductHeight);
        this.unitSpecificProductHeight = unitSpecificProductHeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductMeasurementUnit</b>
     * </p>
     *
     * @param productMeasurementUnit
     *            Unit of Dimension for Length/Width/Height
     */
    public void setProductMeasurementUnit( @Nullable final String productMeasurementUnit )
    {
        rememberChangedField("ProductMeasurementUnit", this.productMeasurementUnit);
        this.productMeasurementUnit = productMeasurementUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LowerLevelPackagingUnit</b>
     * </p>
     *
     * @param lowerLevelPackagingUnit
     *            Lower-Level Unit of Measure in a Packing Hierarchy
     */
    public void setLowerLevelPackagingUnit( @Nullable final String lowerLevelPackagingUnit )
    {
        rememberChangedField("LowerLevelPackagingUnit", this.lowerLevelPackagingUnit);
        this.lowerLevelPackagingUnit = lowerLevelPackagingUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>RemainingVolumeAfterNesting</b>
     * </p>
     *
     * @param remainingVolumeAfterNesting
     *            Remaining Volume after Nesting (in Percentage)
     */
    public void setRemainingVolumeAfterNesting( @Nullable final BigDecimal remainingVolumeAfterNesting )
    {
        rememberChangedField("RemainingVolumeAfterNesting", this.remainingVolumeAfterNesting);
        this.remainingVolumeAfterNesting = remainingVolumeAfterNesting;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaximumStackingFactor</b>
     * </p>
     *
     * @param maximumStackingFactor
     *            Maximum Stacking Factor
     */
    public void setMaximumStackingFactor( @Nullable final Short maximumStackingFactor )
    {
        rememberChangedField("MaximumStackingFactor", this.maximumStackingFactor);
        this.maximumStackingFactor = maximumStackingFactor;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityUsage</b>
     * </p>
     *
     * @param capacityUsage
     *            Capacity Usage
     */
    public void setCapacityUsage( @Nullable final BigDecimal capacityUsage )
    {
        rememberChangedField("CapacityUsage", this.capacityUsage);
        this.capacityUsage = capacityUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductUnitsOfMeasure";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("AlternativeUnit", getAlternativeUnit());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("AlternativeUnit", getAlternativeUnit());
        values.put("QuantityNumerator", getQuantityNumerator());
        values.put("QuantityDenominator", getQuantityDenominator());
        values.put("MaterialVolume", getMaterialVolume());
        values.put("VolumeUnit", getVolumeUnit());
        values.put("GrossWeight", getGrossWeight());
        values.put("WeightUnit", getWeightUnit());
        values.put("GlobalTradeItemNumber", getGlobalTradeItemNumber());
        values.put("GlobalTradeItemNumberCategory", getGlobalTradeItemNumberCategory());
        values.put("UnitSpecificProductLength", getUnitSpecificProductLength());
        values.put("UnitSpecificProductWidth", getUnitSpecificProductWidth());
        values.put("UnitSpecificProductHeight", getUnitSpecificProductHeight());
        values.put("ProductMeasurementUnit", getProductMeasurementUnit());
        values.put("LowerLevelPackagingUnit", getLowerLevelPackagingUnit());
        values.put("RemainingVolumeAfterNesting", getRemainingVolumeAfterNesting());
        values.put("MaximumStackingFactor", getMaximumStackingFactor());
        values.put("CapacityUsage", getCapacityUsage());
        values.put("BaseUnit", getBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("AlternativeUnit") ) {
                final Object value = values.remove("AlternativeUnit");
                if( (value == null) || (!value.equals(getAlternativeUnit())) ) {
                    setAlternativeUnit(((String) value));
                }
            }
            if( values.containsKey("QuantityNumerator") ) {
                final Object value = values.remove("QuantityNumerator");
                if( (value == null) || (!value.equals(getQuantityNumerator())) ) {
                    setQuantityNumerator(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityDenominator") ) {
                final Object value = values.remove("QuantityDenominator");
                if( (value == null) || (!value.equals(getQuantityDenominator())) ) {
                    setQuantityDenominator(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialVolume") ) {
                final Object value = values.remove("MaterialVolume");
                if( (value == null) || (!value.equals(getMaterialVolume())) ) {
                    setMaterialVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("VolumeUnit") ) {
                final Object value = values.remove("VolumeUnit");
                if( (value == null) || (!value.equals(getVolumeUnit())) ) {
                    setVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("GrossWeight") ) {
                final Object value = values.remove("GrossWeight");
                if( (value == null) || (!value.equals(getGrossWeight())) ) {
                    setGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("WeightUnit") ) {
                final Object value = values.remove("WeightUnit");
                if( (value == null) || (!value.equals(getWeightUnit())) ) {
                    setWeightUnit(((String) value));
                }
            }
            if( values.containsKey("GlobalTradeItemNumber") ) {
                final Object value = values.remove("GlobalTradeItemNumber");
                if( (value == null) || (!value.equals(getGlobalTradeItemNumber())) ) {
                    setGlobalTradeItemNumber(((String) value));
                }
            }
            if( values.containsKey("GlobalTradeItemNumberCategory") ) {
                final Object value = values.remove("GlobalTradeItemNumberCategory");
                if( (value == null) || (!value.equals(getGlobalTradeItemNumberCategory())) ) {
                    setGlobalTradeItemNumberCategory(((String) value));
                }
            }
            if( values.containsKey("UnitSpecificProductLength") ) {
                final Object value = values.remove("UnitSpecificProductLength");
                if( (value == null) || (!value.equals(getUnitSpecificProductLength())) ) {
                    setUnitSpecificProductLength(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnitSpecificProductWidth") ) {
                final Object value = values.remove("UnitSpecificProductWidth");
                if( (value == null) || (!value.equals(getUnitSpecificProductWidth())) ) {
                    setUnitSpecificProductWidth(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnitSpecificProductHeight") ) {
                final Object value = values.remove("UnitSpecificProductHeight");
                if( (value == null) || (!value.equals(getUnitSpecificProductHeight())) ) {
                    setUnitSpecificProductHeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductMeasurementUnit") ) {
                final Object value = values.remove("ProductMeasurementUnit");
                if( (value == null) || (!value.equals(getProductMeasurementUnit())) ) {
                    setProductMeasurementUnit(((String) value));
                }
            }
            if( values.containsKey("LowerLevelPackagingUnit") ) {
                final Object value = values.remove("LowerLevelPackagingUnit");
                if( (value == null) || (!value.equals(getLowerLevelPackagingUnit())) ) {
                    setLowerLevelPackagingUnit(((String) value));
                }
            }
            if( values.containsKey("RemainingVolumeAfterNesting") ) {
                final Object value = values.remove("RemainingVolumeAfterNesting");
                if( (value == null) || (!value.equals(getRemainingVolumeAfterNesting())) ) {
                    setRemainingVolumeAfterNesting(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumStackingFactor") ) {
                final Object value = values.remove("MaximumStackingFactor");
                if( (value == null) || (!value.equals(getMaximumStackingFactor())) ) {
                    setMaximumStackingFactor(((Short) value));
                }
            }
            if( values.containsKey("CapacityUsage") ) {
                final Object value = values.remove("CapacityUsage");
                if( (value == null) || (!value.equals(getCapacityUsage())) ) {
                    setCapacityUsage(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_InternationalArticleNumber") ) {
                final Object value = (values).remove("to_InternationalArticleNumber");
                if( value instanceof Iterable ) {
                    if( toInternationalArticleNumber == null ) {
                        toInternationalArticleNumber = Lists.newArrayList();
                    } else {
                        toInternationalArticleNumber = Lists.newArrayList(toInternationalArticleNumber);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductUnitsOfMeasureEAN entity;
                        if( toInternationalArticleNumber.size() > i ) {
                            entity = toInternationalArticleNumber.get(i);
                        } else {
                            entity = new ProductUnitsOfMeasureEAN();
                            toInternationalArticleNumber.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductUnitsOfMeasureField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductUnitsOfMeasureField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductUnitsOfMeasureField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductUnitsOfMeasureField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toInternationalArticleNumber != null ) {
            (values).put("to_InternationalArticleNumber", toInternationalArticleNumber);
        }
        return values;
    }

    /**
     * Fetches the <b>ProductUnitsOfMeasureEAN</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_InternationalArticleNumber</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductUnitsOfMeasureEAN</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductUnitsOfMeasureEAN> fetchInternationalArticleNumber()
    {
        return fetchFieldAsList("to_InternationalArticleNumber", ProductUnitsOfMeasureEAN.class);
    }

    /**
     * Retrieval of associated <b>ProductUnitsOfMeasureEAN</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_InternationalArticleNumber</b>.
     * <p>
     * If the navigation property <b>to_InternationalArticleNumber</b> of a queried <b>ProductUnitsOfMeasure</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductUnitsOfMeasureEAN</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductUnitsOfMeasureEAN> getInternationalArticleNumberOrFetch()
    {
        if( toInternationalArticleNumber == null ) {
            toInternationalArticleNumber = fetchInternationalArticleNumber();
        }
        return toInternationalArticleNumber;
    }

    /**
     * Retrieval of associated <b>ProductUnitsOfMeasureEAN</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_InternationalArticleNumber</b>.
     * <p>
     * If the navigation property for an entity <b>ProductUnitsOfMeasure</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_InternationalArticleNumber</b> is already loaded, the
     *         result will contain the <b>ProductUnitsOfMeasureEAN</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProductUnitsOfMeasureEAN>> getInternationalArticleNumberIfPresent()
    {
        return Option.of(toInternationalArticleNumber);
    }

    /**
     * Overwrites the list of associated <b>ProductUnitsOfMeasureEAN</b> entities for the loaded navigation property
     * <b>to_InternationalArticleNumber</b>.
     * <p>
     * If the navigation property <b>to_InternationalArticleNumber</b> of a queried <b>ProductUnitsOfMeasure</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductUnitsOfMeasureEAN</b> entities.
     */
    public void setInternationalArticleNumber( @Nonnull final List<ProductUnitsOfMeasureEAN> value )
    {
        if( toInternationalArticleNumber == null ) {
            toInternationalArticleNumber = Lists.newArrayList();
        }
        toInternationalArticleNumber.clear();
        toInternationalArticleNumber.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductUnitsOfMeasureEAN</b> entities. This corresponds to the OData
     * navigation property <b>to_InternationalArticleNumber</b>.
     * <p>
     * If the navigation property <b>to_InternationalArticleNumber</b> of a queried <b>ProductUnitsOfMeasure</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductUnitsOfMeasureEAN</b> entities.
     */
    public void addInternationalArticleNumber( ProductUnitsOfMeasureEAN... entity )
    {
        if( toInternationalArticleNumber == null ) {
            toInternationalArticleNumber = Lists.newArrayList();
        }
        toInternationalArticleNumber.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProductUnitsOfMeasure instances.
     *
     */
    public final static class ProductUnitsOfMeasureBuilder
    {

        private List<ProductUnitsOfMeasureEAN> toInternationalArticleNumber = Lists.newArrayList();

        private ProductUnitsOfMeasure.ProductUnitsOfMeasureBuilder toInternationalArticleNumber(
            final List<ProductUnitsOfMeasureEAN> value )
        {
            toInternationalArticleNumber.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_InternationalArticleNumber</b> for <b>ProductUnitsOfMeasure</b> to multiple
         * <b>ProductUnitsOfMeasureEAN</b>.
         *
         * @param value
         *            The ProductUnitsOfMeasureEANs to build this ProductUnitsOfMeasure with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductUnitsOfMeasure.ProductUnitsOfMeasureBuilder internationalArticleNumber(
            ProductUnitsOfMeasureEAN... value )
        {
            return toInternationalArticleNumber(Lists.newArrayList(value));
        }

    }

}
