/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductUnitsOfMeasureEANField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductUnitsOfMeasureEANSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * GTIN Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductUnitsOfMeasureEANType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductUnitsOfMeasureEAN extends VdmEntity<ProductUnitsOfMeasureEAN>
{

    /**
     * Selector for all available fields of ProductUnitsOfMeasureEAN.
     *
     */
    public final static ProductUnitsOfMeasureEANSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureEANField<String> PRODUCT =
        new ProductUnitsOfMeasureEANField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeUnit</b>
     * </p>
     *
     * @return Unit of Measure for Display
     */
    @Key
    @SerializedName( "AlternativeUnit" )
    @JsonProperty( "AlternativeUnit" )
    @Nullable
    @ODataField( odataName = "AlternativeUnit" )
    private String alternativeUnit;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeUnit</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureEANField<String> ALTERNATIVE_UNIT =
        new ProductUnitsOfMeasureEANField<String>("AlternativeUnit");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConsecutiveNumber</b>
     * </p>
     *
     * @return Consecutive Number
     */
    @Key
    @SerializedName( "ConsecutiveNumber" )
    @JsonProperty( "ConsecutiveNumber" )
    @Nullable
    @ODataField( odataName = "ConsecutiveNumber" )
    private String consecutiveNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConsecutiveNumber</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureEANField<String> CONSECUTIVE_NUMBER =
        new ProductUnitsOfMeasureEANField<String>("ConsecutiveNumber");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductStandardID</b>
     * </p>
     *
     * @return International Article Number (EAN/UPC)
     */
    @SerializedName( "ProductStandardID" )
    @JsonProperty( "ProductStandardID" )
    @Nullable
    @ODataField( odataName = "ProductStandardID" )
    private String productStandardID;
    /**
     * Use with available fluent helpers to apply the <b>ProductStandardID</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureEANField<String> PRODUCT_STANDARD_ID =
        new ProductUnitsOfMeasureEANField<String>("ProductStandardID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InternationalArticleNumberCat</b>
     * </p>
     *
     * @return Category of Global Trade Item Number (GTIN)
     */
    @SerializedName( "InternationalArticleNumberCat" )
    @JsonProperty( "InternationalArticleNumberCat" )
    @Nullable
    @ODataField( odataName = "InternationalArticleNumberCat" )
    private String internationalArticleNumberCat;
    /**
     * Use with available fluent helpers to apply the <b>InternationalArticleNumberCat</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureEANField<String> INTERNATIONAL_ARTICLE_NUMBER_CAT =
        new ProductUnitsOfMeasureEANField<String>("InternationalArticleNumberCat");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMainGlobalTradeItemNumber</b>
     * </p>
     *
     * @return Indicator: Main EAN
     */
    @SerializedName( "IsMainGlobalTradeItemNumber" )
    @JsonProperty( "IsMainGlobalTradeItemNumber" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMainGlobalTradeItemNumber" )
    private Boolean isMainGlobalTradeItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>IsMainGlobalTradeItemNumber</b> field to query operations.
     *
     */
    public final static ProductUnitsOfMeasureEANField<Boolean> IS_MAIN_GLOBAL_TRADE_ITEM_NUMBER =
        new ProductUnitsOfMeasureEANField<Boolean>("IsMainGlobalTradeItemNumber");

    @Nonnull
    @Override
    public Class<ProductUnitsOfMeasureEAN> getType()
    {
        return ProductUnitsOfMeasureEAN.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeUnit</b>
     * </p>
     *
     * @param alternativeUnit
     *            Unit of Measure for Display
     */
    public void setAlternativeUnit( @Nullable final String alternativeUnit )
    {
        rememberChangedField("AlternativeUnit", this.alternativeUnit);
        this.alternativeUnit = alternativeUnit;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConsecutiveNumber</b>
     * </p>
     *
     * @param consecutiveNumber
     *            Consecutive Number
     */
    public void setConsecutiveNumber( @Nullable final String consecutiveNumber )
    {
        rememberChangedField("ConsecutiveNumber", this.consecutiveNumber);
        this.consecutiveNumber = consecutiveNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductStandardID</b>
     * </p>
     *
     * @param productStandardID
     *            International Article Number (EAN/UPC)
     */
    public void setProductStandardID( @Nullable final String productStandardID )
    {
        rememberChangedField("ProductStandardID", this.productStandardID);
        this.productStandardID = productStandardID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InternationalArticleNumberCat</b>
     * </p>
     *
     * @param internationalArticleNumberCat
     *            Category of Global Trade Item Number (GTIN)
     */
    public void setInternationalArticleNumberCat( @Nullable final String internationalArticleNumberCat )
    {
        rememberChangedField("InternationalArticleNumberCat", this.internationalArticleNumberCat);
        this.internationalArticleNumberCat = internationalArticleNumberCat;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMainGlobalTradeItemNumber</b>
     * </p>
     *
     * @param isMainGlobalTradeItemNumber
     *            Indicator: Main EAN
     */
    public void setIsMainGlobalTradeItemNumber( @Nullable final Boolean isMainGlobalTradeItemNumber )
    {
        rememberChangedField("IsMainGlobalTradeItemNumber", this.isMainGlobalTradeItemNumber);
        this.isMainGlobalTradeItemNumber = isMainGlobalTradeItemNumber;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductUnitsOfMeasureEAN";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("AlternativeUnit", getAlternativeUnit());
        result.put("ConsecutiveNumber", getConsecutiveNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("AlternativeUnit", getAlternativeUnit());
        values.put("ConsecutiveNumber", getConsecutiveNumber());
        values.put("ProductStandardID", getProductStandardID());
        values.put("InternationalArticleNumberCat", getInternationalArticleNumberCat());
        values.put("IsMainGlobalTradeItemNumber", getIsMainGlobalTradeItemNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("AlternativeUnit") ) {
                final Object value = values.remove("AlternativeUnit");
                if( (value == null) || (!value.equals(getAlternativeUnit())) ) {
                    setAlternativeUnit(((String) value));
                }
            }
            if( values.containsKey("ConsecutiveNumber") ) {
                final Object value = values.remove("ConsecutiveNumber");
                if( (value == null) || (!value.equals(getConsecutiveNumber())) ) {
                    setConsecutiveNumber(((String) value));
                }
            }
            if( values.containsKey("ProductStandardID") ) {
                final Object value = values.remove("ProductStandardID");
                if( (value == null) || (!value.equals(getProductStandardID())) ) {
                    setProductStandardID(((String) value));
                }
            }
            if( values.containsKey("InternationalArticleNumberCat") ) {
                final Object value = values.remove("InternationalArticleNumberCat");
                if( (value == null) || (!value.equals(getInternationalArticleNumberCat())) ) {
                    setInternationalArticleNumberCat(((String) value));
                }
            }
            if( values.containsKey("IsMainGlobalTradeItemNumber") ) {
                final Object value = values.remove("IsMainGlobalTradeItemNumber");
                if( (value == null) || (!value.equals(getIsMainGlobalTradeItemNumber())) ) {
                    setIsMainGlobalTradeItemNumber(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductUnitsOfMeasureEANField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductUnitsOfMeasureEANField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductUnitsOfMeasureEANField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductUnitsOfMeasureEANField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
