/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductValuationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductValuationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductValuationOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductValuationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Valuation Area Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductValuationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductValuation extends VdmEntity<ProductValuation>
{

    /**
     * Selector for all available fields of ProductValuation.
     *
     */
    public final static ProductValuationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductValuationField<String> PRODUCT = new ProductValuationField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @return Valuation Area
     */
    @Key
    @SerializedName( "ValuationArea" )
    @JsonProperty( "ValuationArea" )
    @Nullable
    @ODataField( odataName = "ValuationArea" )
    private String valuationArea;
    /**
     * Use with available fluent helpers to apply the <b>ValuationArea</b> field to query operations.
     *
     */
    public final static ProductValuationField<String> VALUATION_AREA =
        new ProductValuationField<String>("ValuationArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @return Valuation Type
     */
    @Key
    @SerializedName( "ValuationType" )
    @JsonProperty( "ValuationType" )
    @Nullable
    @ODataField( odataName = "ValuationType" )
    private String valuationType;
    /**
     * Use with available fluent helpers to apply the <b>ValuationType</b> field to query operations.
     *
     */
    public final static ProductValuationField<String> VALUATION_TYPE =
        new ProductValuationField<String>("ValuationType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationClass</b>
     * </p>
     *
     * @return Valuation Class
     */
    @SerializedName( "ValuationClass" )
    @JsonProperty( "ValuationClass" )
    @Nullable
    @ODataField( odataName = "ValuationClass" )
    private String valuationClass;
    /**
     * Use with available fluent helpers to apply the <b>ValuationClass</b> field to query operations.
     *
     */
    public final static ProductValuationField<String> VALUATION_CLASS =
        new ProductValuationField<String>("ValuationClass");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PriceDeterminationControl</b>
     * </p>
     *
     * @return Material Price Determination: Control
     */
    @SerializedName( "PriceDeterminationControl" )
    @JsonProperty( "PriceDeterminationControl" )
    @Nullable
    @ODataField( odataName = "PriceDeterminationControl" )
    private String priceDeterminationControl;
    /**
     * Use with available fluent helpers to apply the <b>PriceDeterminationControl</b> field to query operations.
     *
     */
    public final static ProductValuationField<String> PRICE_DETERMINATION_CONTROL =
        new ProductValuationField<String>("PriceDeterminationControl");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardPrice</b>
     * </p>
     *
     * @return Standard price
     */
    @SerializedName( "StandardPrice" )
    @JsonProperty( "StandardPrice" )
    @Nullable
    @ODataField( odataName = "StandardPrice" )
    private BigDecimal standardPrice;
    /**
     * Use with available fluent helpers to apply the <b>StandardPrice</b> field to query operations.
     *
     */
    public final static ProductValuationField<BigDecimal> STANDARD_PRICE =
        new ProductValuationField<BigDecimal>("StandardPrice");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PriceUnitQty</b>
     * </p>
     *
     * @return Price unit
     */
    @SerializedName( "PriceUnitQty" )
    @JsonProperty( "PriceUnitQty" )
    @Nullable
    @ODataField( odataName = "PriceUnitQty" )
    private BigDecimal priceUnitQty;
    /**
     * Use with available fluent helpers to apply the <b>PriceUnitQty</b> field to query operations.
     *
     */
    public final static ProductValuationField<BigDecimal> PRICE_UNIT_QTY =
        new ProductValuationField<BigDecimal>("PriceUnitQty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationProcedure</b>
     * </p>
     *
     * @return Price Control
     */
    @SerializedName( "InventoryValuationProcedure" )
    @JsonProperty( "InventoryValuationProcedure" )
    @Nullable
    @ODataField( odataName = "InventoryValuationProcedure" )
    private String inventoryValuationProcedure;
    /**
     * Use with available fluent helpers to apply the <b>InventoryValuationProcedure</b> field to query operations.
     *
     */
    public final static ProductValuationField<String> INVENTORY_VALUATION_PROCEDURE =
        new ProductValuationField<String>("InventoryValuationProcedure");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Deletion flag for all material data of a valuation type
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static ProductValuationField<Boolean> IS_MARKED_FOR_DELETION =
        new ProductValuationField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MovingAveragePrice</b>
     * </p>
     *
     * @return Moving Average Price/Periodic Unit Price
     */
    @SerializedName( "MovingAveragePrice" )
    @JsonProperty( "MovingAveragePrice" )
    @Nullable
    @ODataField( odataName = "MovingAveragePrice" )
    private BigDecimal movingAveragePrice;
    /**
     * Use with available fluent helpers to apply the <b>MovingAveragePrice</b> field to query operations.
     *
     */
    public final static ProductValuationField<BigDecimal> MOVING_AVERAGE_PRICE =
        new ProductValuationField<BigDecimal>("MovingAveragePrice");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ValuationCategory</b>
     * </p>
     *
     * @return Valuation Category
     */
    @SerializedName( "ValuationCategory" )
    @JsonProperty( "ValuationCategory" )
    @Nullable
    @ODataField( odataName = "ValuationCategory" )
    private String valuationCategory;
    /**
     * Use with available fluent helpers to apply the <b>ValuationCategory</b> field to query operations.
     *
     */
    public final static ProductValuationField<String> VALUATION_CATEGORY =
        new ProductValuationField<String>("ValuationCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductUsageType</b>
     * </p>
     *
     * @return Usage of the Product
     */
    @SerializedName( "ProductUsageType" )
    @JsonProperty( "ProductUsageType" )
    @Nullable
    @ODataField( odataName = "ProductUsageType" )
    private String productUsageType;
    /**
     * Use with available fluent helpers to apply the <b>ProductUsageType</b> field to query operations.
     *
     */
    public final static ProductValuationField<String> PRODUCT_USAGE_TYPE =
        new ProductValuationField<String>("ProductUsageType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductOriginType</b>
     * </p>
     *
     * @return Origin of the Product
     */
    @SerializedName( "ProductOriginType" )
    @JsonProperty( "ProductOriginType" )
    @Nullable
    @ODataField( odataName = "ProductOriginType" )
    private String productOriginType;
    /**
     * Use with available fluent helpers to apply the <b>ProductOriginType</b> field to query operations.
     *
     */
    public final static ProductValuationField<String> PRODUCT_ORIGIN_TYPE =
        new ProductValuationField<String>("ProductOriginType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsProducedInhouse</b>
     * </p>
     *
     * @return Produced in-house
     */
    @SerializedName( "IsProducedInhouse" )
    @JsonProperty( "IsProducedInhouse" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsProducedInhouse" )
    private Boolean isProducedInhouse;
    /**
     * Use with available fluent helpers to apply the <b>IsProducedInhouse</b> field to query operations.
     *
     */
    public final static ProductValuationField<Boolean> IS_PRODUCED_INHOUSE =
        new ProductValuationField<Boolean>("IsProducedInhouse");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProdCostEstNumber</b>
     * </p>
     *
     * @return Cost Estimate Number - Product Costing
     */
    @SerializedName( "ProdCostEstNumber" )
    @JsonProperty( "ProdCostEstNumber" )
    @Nullable
    @ODataField( odataName = "ProdCostEstNumber" )
    private String prodCostEstNumber;
    /**
     * Use with available fluent helpers to apply the <b>ProdCostEstNumber</b> field to query operations.
     *
     */
    public final static ProductValuationField<String> PROD_COST_EST_NUMBER =
        new ProductValuationField<String>("ProdCostEstNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjectStockValuationClass</b>
     * </p>
     *
     * @return Valuation Class for Project Stock
     */
    @SerializedName( "ProjectStockValuationClass" )
    @JsonProperty( "ProjectStockValuationClass" )
    @Nullable
    @ODataField( odataName = "ProjectStockValuationClass" )
    private String projectStockValuationClass;
    /**
     * Use with available fluent helpers to apply the <b>ProjectStockValuationClass</b> field to query operations.
     *
     */
    public final static ProductValuationField<String> PROJECT_STOCK_VALUATION_CLASS =
        new ProductValuationField<String>("ProjectStockValuationClass");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationClassSalesOrderStock</b>
     * </p>
     *
     * @return Valuation Class for Sales Order Stock
     */
    @SerializedName( "ValuationClassSalesOrderStock" )
    @JsonProperty( "ValuationClassSalesOrderStock" )
    @Nullable
    @ODataField( odataName = "ValuationClassSalesOrderStock" )
    private String valuationClassSalesOrderStock;
    /**
     * Use with available fluent helpers to apply the <b>ValuationClassSalesOrderStock</b> field to query operations.
     *
     */
    public final static ProductValuationField<String> VALUATION_CLASS_SALES_ORDER_STOCK =
        new ProductValuationField<String>("ValuationClassSalesOrderStock");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPrice1InCoCodeCrcy</b>
     * </p>
     *
     * @return Future Planned Price 1
     */
    @SerializedName( "PlannedPrice1InCoCodeCrcy" )
    @JsonProperty( "PlannedPrice1InCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "PlannedPrice1InCoCodeCrcy" )
    private BigDecimal plannedPrice1InCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PlannedPrice1InCoCodeCrcy</b> field to query operations.
     *
     */
    public final static ProductValuationField<BigDecimal> PLANNED_PRICE1_IN_CO_CODE_CRCY =
        new ProductValuationField<BigDecimal>("PlannedPrice1InCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPrice2InCoCodeCrcy</b>
     * </p>
     *
     * @return Future Planned Price 2
     */
    @SerializedName( "PlannedPrice2InCoCodeCrcy" )
    @JsonProperty( "PlannedPrice2InCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "PlannedPrice2InCoCodeCrcy" )
    private BigDecimal plannedPrice2InCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PlannedPrice2InCoCodeCrcy</b> field to query operations.
     *
     */
    public final static ProductValuationField<BigDecimal> PLANNED_PRICE2_IN_CO_CODE_CRCY =
        new ProductValuationField<BigDecimal>("PlannedPrice2InCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPrice3InCoCodeCrcy</b>
     * </p>
     *
     * @return Future Planned Price 3
     */
    @SerializedName( "PlannedPrice3InCoCodeCrcy" )
    @JsonProperty( "PlannedPrice3InCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "PlannedPrice3InCoCodeCrcy" )
    private BigDecimal plannedPrice3InCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PlannedPrice3InCoCodeCrcy</b> field to query operations.
     *
     */
    public final static ProductValuationField<BigDecimal> PLANNED_PRICE3_IN_CO_CODE_CRCY =
        new ProductValuationField<BigDecimal>("PlannedPrice3InCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FuturePlndPrice1ValdtyDate</b>
     * </p>
     *
     * @return Date from Which Future Planned Price 1 Is Valid
     */
    @SerializedName( "FuturePlndPrice1ValdtyDate" )
    @JsonProperty( "FuturePlndPrice1ValdtyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FuturePlndPrice1ValdtyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime futurePlndPrice1ValdtyDate;
    /**
     * Use with available fluent helpers to apply the <b>FuturePlndPrice1ValdtyDate</b> field to query operations.
     *
     */
    public final static ProductValuationField<LocalDateTime> FUTURE_PLND_PRICE1_VALDTY_DATE =
        new ProductValuationField<LocalDateTime>("FuturePlndPrice1ValdtyDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FuturePlndPrice2ValdtyDate</b>
     * </p>
     *
     * @return Date from Which Future Planned Price 2 Is Valid
     */
    @SerializedName( "FuturePlndPrice2ValdtyDate" )
    @JsonProperty( "FuturePlndPrice2ValdtyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FuturePlndPrice2ValdtyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime futurePlndPrice2ValdtyDate;
    /**
     * Use with available fluent helpers to apply the <b>FuturePlndPrice2ValdtyDate</b> field to query operations.
     *
     */
    public final static ProductValuationField<LocalDateTime> FUTURE_PLND_PRICE2_VALDTY_DATE =
        new ProductValuationField<LocalDateTime>("FuturePlndPrice2ValdtyDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FuturePlndPrice3ValdtyDate</b>
     * </p>
     *
     * @return Date from Which Future Planned Price 3 Is Valid
     */
    @SerializedName( "FuturePlndPrice3ValdtyDate" )
    @JsonProperty( "FuturePlndPrice3ValdtyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FuturePlndPrice3ValdtyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime futurePlndPrice3ValdtyDate;
    /**
     * Use with available fluent helpers to apply the <b>FuturePlndPrice3ValdtyDate</b> field to query operations.
     *
     */
    public final static ProductValuationField<LocalDateTime> FUTURE_PLND_PRICE3_VALDTY_DATE =
        new ProductValuationField<LocalDateTime>("FuturePlndPrice3ValdtyDate");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxBasedPricesPriceUnitQty</b>
     * </p>
     *
     * @return Price unit for valuation prices based on tax/commercial law
     */
    @SerializedName( "TaxBasedPricesPriceUnitQty" )
    @JsonProperty( "TaxBasedPricesPriceUnitQty" )
    @Nullable
    @ODataField( odataName = "TaxBasedPricesPriceUnitQty" )
    private BigDecimal taxBasedPricesPriceUnitQty;
    /**
     * Use with available fluent helpers to apply the <b>TaxBasedPricesPriceUnitQty</b> field to query operations.
     *
     */
    public final static ProductValuationField<BigDecimal> TAX_BASED_PRICES_PRICE_UNIT_QTY =
        new ProductValuationField<BigDecimal>("TaxBasedPricesPriceUnitQty");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PriceLastChangeDate</b>
     * </p>
     *
     * @return Date of Last Price Change
     */
    @SerializedName( "PriceLastChangeDate" )
    @JsonProperty( "PriceLastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PriceLastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime priceLastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>PriceLastChangeDate</b> field to query operations.
     *
     */
    public final static ProductValuationField<LocalDateTime> PRICE_LAST_CHANGE_DATE =
        new ProductValuationField<LocalDateTime>("PriceLastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPrice</b>
     * </p>
     *
     * @return Future Planned Price
     */
    @SerializedName( "PlannedPrice" )
    @JsonProperty( "PlannedPrice" )
    @Nullable
    @ODataField( odataName = "PlannedPrice" )
    private BigDecimal plannedPrice;
    /**
     * Use with available fluent helpers to apply the <b>PlannedPrice</b> field to query operations.
     *
     */
    public final static ProductValuationField<BigDecimal> PLANNED_PRICE =
        new ProductValuationField<BigDecimal>("PlannedPrice");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrevInvtryPriceInCoCodeCrcy</b>
     * </p>
     *
     * @return Previous Price
     */
    @SerializedName( "PrevInvtryPriceInCoCodeCrcy" )
    @JsonProperty( "PrevInvtryPriceInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "PrevInvtryPriceInCoCodeCrcy" )
    private BigDecimal prevInvtryPriceInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PrevInvtryPriceInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static ProductValuationField<BigDecimal> PREV_INVTRY_PRICE_IN_CO_CODE_CRCY =
        new ProductValuationField<BigDecimal>("PrevInvtryPriceInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ProductValuationField<String> CURRENCY = new ProductValuationField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProductValuationField<String> BASE_UNIT = new ProductValuationField<String>("BaseUnit");
    /**
     * Navigation property <b>to_MLAccount</b> for <b>ProductValuation</b> to multiple <b>ProductMLAccount</b>.
     *
     */
    @SerializedName( "to_MLAccount" )
    @JsonProperty( "to_MLAccount" )
    @ODataField( odataName = "to_MLAccount" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductMLAccount> toMLAccount;
    /**
     * Navigation property <b>to_MLPrices</b> for <b>ProductValuation</b> to multiple <b>ProductMLPrices</b>.
     *
     */
    @SerializedName( "to_MLPrices" )
    @JsonProperty( "to_MLPrices" )
    @ODataField( odataName = "to_MLPrices" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductMLPrices> toMLPrices;
    /**
     * Navigation property <b>to_ValuationAccount</b> for <b>ProductValuation</b> to single
     * <b>ProductValuationAccount</b>.
     *
     */
    @SerializedName( "to_ValuationAccount" )
    @JsonProperty( "to_ValuationAccount" )
    @ODataField( odataName = "to_ValuationAccount" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProductValuationAccount toValuationAccount;
    /**
     * Navigation property <b>to_ValuationCosting</b> for <b>ProductValuation</b> to single
     * <b>ProductValuationCosting</b>.
     *
     */
    @SerializedName( "to_ValuationCosting" )
    @JsonProperty( "to_ValuationCosting" )
    @ODataField( odataName = "to_ValuationCosting" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProductValuationCosting toValuationCosting;
    /**
     * Use with available fluent helpers to apply the <b>to_MLAccount</b> navigation property to query operations.
     *
     */
    public final static ProductValuationLink<ProductMLAccount> TO_ML_ACCOUNT =
        new ProductValuationLink<ProductMLAccount>("to_MLAccount");
    /**
     * Use with available fluent helpers to apply the <b>to_MLPrices</b> navigation property to query operations.
     *
     */
    public final static ProductValuationLink<ProductMLPrices> TO_ML_PRICES =
        new ProductValuationLink<ProductMLPrices>("to_MLPrices");
    /**
     * Use with available fluent helpers to apply the <b>to_ValuationAccount</b> navigation property to query
     * operations.
     *
     */
    public final static ProductValuationOneToOneLink<ProductValuationAccount> TO_VALUATION_ACCOUNT =
        new ProductValuationOneToOneLink<ProductValuationAccount>("to_ValuationAccount");
    /**
     * Use with available fluent helpers to apply the <b>to_ValuationCosting</b> navigation property to query
     * operations.
     *
     */
    public final static ProductValuationOneToOneLink<ProductValuationCosting> TO_VALUATION_COSTING =
        new ProductValuationOneToOneLink<ProductValuationCosting>("to_ValuationCosting");

    @Nonnull
    @Override
    public Class<ProductValuation> getType()
    {
        return ProductValuation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @param valuationArea
     *            Valuation Area
     */
    public void setValuationArea( @Nullable final String valuationArea )
    {
        rememberChangedField("ValuationArea", this.valuationArea);
        this.valuationArea = valuationArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @param valuationType
     *            Valuation Type
     */
    public void setValuationType( @Nullable final String valuationType )
    {
        rememberChangedField("ValuationType", this.valuationType);
        this.valuationType = valuationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationClass</b>
     * </p>
     *
     * @param valuationClass
     *            Valuation Class
     */
    public void setValuationClass( @Nullable final String valuationClass )
    {
        rememberChangedField("ValuationClass", this.valuationClass);
        this.valuationClass = valuationClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PriceDeterminationControl</b>
     * </p>
     *
     * @param priceDeterminationControl
     *            Material Price Determination: Control
     */
    public void setPriceDeterminationControl( @Nullable final String priceDeterminationControl )
    {
        rememberChangedField("PriceDeterminationControl", this.priceDeterminationControl);
        this.priceDeterminationControl = priceDeterminationControl;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardPrice</b>
     * </p>
     *
     * @param standardPrice
     *            Standard price
     */
    public void setStandardPrice( @Nullable final BigDecimal standardPrice )
    {
        rememberChangedField("StandardPrice", this.standardPrice);
        this.standardPrice = standardPrice;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PriceUnitQty</b>
     * </p>
     *
     * @param priceUnitQty
     *            Price unit
     */
    public void setPriceUnitQty( @Nullable final BigDecimal priceUnitQty )
    {
        rememberChangedField("PriceUnitQty", this.priceUnitQty);
        this.priceUnitQty = priceUnitQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationProcedure</b>
     * </p>
     *
     * @param inventoryValuationProcedure
     *            Price Control
     */
    public void setInventoryValuationProcedure( @Nullable final String inventoryValuationProcedure )
    {
        rememberChangedField("InventoryValuationProcedure", this.inventoryValuationProcedure);
        this.inventoryValuationProcedure = inventoryValuationProcedure;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Deletion flag for all material data of a valuation type
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MovingAveragePrice</b>
     * </p>
     *
     * @param movingAveragePrice
     *            Moving Average Price/Periodic Unit Price
     */
    public void setMovingAveragePrice( @Nullable final BigDecimal movingAveragePrice )
    {
        rememberChangedField("MovingAveragePrice", this.movingAveragePrice);
        this.movingAveragePrice = movingAveragePrice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ValuationCategory</b>
     * </p>
     *
     * @param valuationCategory
     *            Valuation Category
     */
    public void setValuationCategory( @Nullable final String valuationCategory )
    {
        rememberChangedField("ValuationCategory", this.valuationCategory);
        this.valuationCategory = valuationCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductUsageType</b>
     * </p>
     *
     * @param productUsageType
     *            Usage of the Product
     */
    public void setProductUsageType( @Nullable final String productUsageType )
    {
        rememberChangedField("ProductUsageType", this.productUsageType);
        this.productUsageType = productUsageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductOriginType</b>
     * </p>
     *
     * @param productOriginType
     *            Origin of the Product
     */
    public void setProductOriginType( @Nullable final String productOriginType )
    {
        rememberChangedField("ProductOriginType", this.productOriginType);
        this.productOriginType = productOriginType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsProducedInhouse</b>
     * </p>
     *
     * @param isProducedInhouse
     *            Produced in-house
     */
    public void setIsProducedInhouse( @Nullable final Boolean isProducedInhouse )
    {
        rememberChangedField("IsProducedInhouse", this.isProducedInhouse);
        this.isProducedInhouse = isProducedInhouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProdCostEstNumber</b>
     * </p>
     *
     * @param prodCostEstNumber
     *            Cost Estimate Number - Product Costing
     */
    public void setProdCostEstNumber( @Nullable final String prodCostEstNumber )
    {
        rememberChangedField("ProdCostEstNumber", this.prodCostEstNumber);
        this.prodCostEstNumber = prodCostEstNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjectStockValuationClass</b>
     * </p>
     *
     * @param projectStockValuationClass
     *            Valuation Class for Project Stock
     */
    public void setProjectStockValuationClass( @Nullable final String projectStockValuationClass )
    {
        rememberChangedField("ProjectStockValuationClass", this.projectStockValuationClass);
        this.projectStockValuationClass = projectStockValuationClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationClassSalesOrderStock</b>
     * </p>
     *
     * @param valuationClassSalesOrderStock
     *            Valuation Class for Sales Order Stock
     */
    public void setValuationClassSalesOrderStock( @Nullable final String valuationClassSalesOrderStock )
    {
        rememberChangedField("ValuationClassSalesOrderStock", this.valuationClassSalesOrderStock);
        this.valuationClassSalesOrderStock = valuationClassSalesOrderStock;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPrice1InCoCodeCrcy</b>
     * </p>
     *
     * @param plannedPrice1InCoCodeCrcy
     *            Future Planned Price 1
     */
    public void setPlannedPrice1InCoCodeCrcy( @Nullable final BigDecimal plannedPrice1InCoCodeCrcy )
    {
        rememberChangedField("PlannedPrice1InCoCodeCrcy", this.plannedPrice1InCoCodeCrcy);
        this.plannedPrice1InCoCodeCrcy = plannedPrice1InCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPrice2InCoCodeCrcy</b>
     * </p>
     *
     * @param plannedPrice2InCoCodeCrcy
     *            Future Planned Price 2
     */
    public void setPlannedPrice2InCoCodeCrcy( @Nullable final BigDecimal plannedPrice2InCoCodeCrcy )
    {
        rememberChangedField("PlannedPrice2InCoCodeCrcy", this.plannedPrice2InCoCodeCrcy);
        this.plannedPrice2InCoCodeCrcy = plannedPrice2InCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPrice3InCoCodeCrcy</b>
     * </p>
     *
     * @param plannedPrice3InCoCodeCrcy
     *            Future Planned Price 3
     */
    public void setPlannedPrice3InCoCodeCrcy( @Nullable final BigDecimal plannedPrice3InCoCodeCrcy )
    {
        rememberChangedField("PlannedPrice3InCoCodeCrcy", this.plannedPrice3InCoCodeCrcy);
        this.plannedPrice3InCoCodeCrcy = plannedPrice3InCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FuturePlndPrice1ValdtyDate</b>
     * </p>
     *
     * @param futurePlndPrice1ValdtyDate
     *            Date from Which Future Planned Price 1 Is Valid
     */
    public void setFuturePlndPrice1ValdtyDate( @Nullable final LocalDateTime futurePlndPrice1ValdtyDate )
    {
        rememberChangedField("FuturePlndPrice1ValdtyDate", this.futurePlndPrice1ValdtyDate);
        this.futurePlndPrice1ValdtyDate = futurePlndPrice1ValdtyDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FuturePlndPrice2ValdtyDate</b>
     * </p>
     *
     * @param futurePlndPrice2ValdtyDate
     *            Date from Which Future Planned Price 2 Is Valid
     */
    public void setFuturePlndPrice2ValdtyDate( @Nullable final LocalDateTime futurePlndPrice2ValdtyDate )
    {
        rememberChangedField("FuturePlndPrice2ValdtyDate", this.futurePlndPrice2ValdtyDate);
        this.futurePlndPrice2ValdtyDate = futurePlndPrice2ValdtyDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FuturePlndPrice3ValdtyDate</b>
     * </p>
     *
     * @param futurePlndPrice3ValdtyDate
     *            Date from Which Future Planned Price 3 Is Valid
     */
    public void setFuturePlndPrice3ValdtyDate( @Nullable final LocalDateTime futurePlndPrice3ValdtyDate )
    {
        rememberChangedField("FuturePlndPrice3ValdtyDate", this.futurePlndPrice3ValdtyDate);
        this.futurePlndPrice3ValdtyDate = futurePlndPrice3ValdtyDate;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxBasedPricesPriceUnitQty</b>
     * </p>
     *
     * @param taxBasedPricesPriceUnitQty
     *            Price unit for valuation prices based on tax/commercial law
     */
    public void setTaxBasedPricesPriceUnitQty( @Nullable final BigDecimal taxBasedPricesPriceUnitQty )
    {
        rememberChangedField("TaxBasedPricesPriceUnitQty", this.taxBasedPricesPriceUnitQty);
        this.taxBasedPricesPriceUnitQty = taxBasedPricesPriceUnitQty;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PriceLastChangeDate</b>
     * </p>
     *
     * @param priceLastChangeDate
     *            Date of Last Price Change
     */
    public void setPriceLastChangeDate( @Nullable final LocalDateTime priceLastChangeDate )
    {
        rememberChangedField("PriceLastChangeDate", this.priceLastChangeDate);
        this.priceLastChangeDate = priceLastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPrice</b>
     * </p>
     *
     * @param plannedPrice
     *            Future Planned Price
     */
    public void setPlannedPrice( @Nullable final BigDecimal plannedPrice )
    {
        rememberChangedField("PlannedPrice", this.plannedPrice);
        this.plannedPrice = plannedPrice;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrevInvtryPriceInCoCodeCrcy</b>
     * </p>
     *
     * @param prevInvtryPriceInCoCodeCrcy
     *            Previous Price
     */
    public void setPrevInvtryPriceInCoCodeCrcy( @Nullable final BigDecimal prevInvtryPriceInCoCodeCrcy )
    {
        rememberChangedField("PrevInvtryPriceInCoCodeCrcy", this.prevInvtryPriceInCoCodeCrcy);
        this.prevInvtryPriceInCoCodeCrcy = prevInvtryPriceInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductValuation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("ValuationArea", getValuationArea());
        result.put("ValuationType", getValuationType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("ValuationArea", getValuationArea());
        values.put("ValuationType", getValuationType());
        values.put("ValuationClass", getValuationClass());
        values.put("PriceDeterminationControl", getPriceDeterminationControl());
        values.put("StandardPrice", getStandardPrice());
        values.put("PriceUnitQty", getPriceUnitQty());
        values.put("InventoryValuationProcedure", getInventoryValuationProcedure());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("MovingAveragePrice", getMovingAveragePrice());
        values.put("ValuationCategory", getValuationCategory());
        values.put("ProductUsageType", getProductUsageType());
        values.put("ProductOriginType", getProductOriginType());
        values.put("IsProducedInhouse", getIsProducedInhouse());
        values.put("ProdCostEstNumber", getProdCostEstNumber());
        values.put("ProjectStockValuationClass", getProjectStockValuationClass());
        values.put("ValuationClassSalesOrderStock", getValuationClassSalesOrderStock());
        values.put("PlannedPrice1InCoCodeCrcy", getPlannedPrice1InCoCodeCrcy());
        values.put("PlannedPrice2InCoCodeCrcy", getPlannedPrice2InCoCodeCrcy());
        values.put("PlannedPrice3InCoCodeCrcy", getPlannedPrice3InCoCodeCrcy());
        values.put("FuturePlndPrice1ValdtyDate", getFuturePlndPrice1ValdtyDate());
        values.put("FuturePlndPrice2ValdtyDate", getFuturePlndPrice2ValdtyDate());
        values.put("FuturePlndPrice3ValdtyDate", getFuturePlndPrice3ValdtyDate());
        values.put("TaxBasedPricesPriceUnitQty", getTaxBasedPricesPriceUnitQty());
        values.put("PriceLastChangeDate", getPriceLastChangeDate());
        values.put("PlannedPrice", getPlannedPrice());
        values.put("PrevInvtryPriceInCoCodeCrcy", getPrevInvtryPriceInCoCodeCrcy());
        values.put("Currency", getCurrency());
        values.put("BaseUnit", getBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("ValuationArea") ) {
                final Object value = values.remove("ValuationArea");
                if( (value == null) || (!value.equals(getValuationArea())) ) {
                    setValuationArea(((String) value));
                }
            }
            if( values.containsKey("ValuationType") ) {
                final Object value = values.remove("ValuationType");
                if( (value == null) || (!value.equals(getValuationType())) ) {
                    setValuationType(((String) value));
                }
            }
            if( values.containsKey("ValuationClass") ) {
                final Object value = values.remove("ValuationClass");
                if( (value == null) || (!value.equals(getValuationClass())) ) {
                    setValuationClass(((String) value));
                }
            }
            if( values.containsKey("PriceDeterminationControl") ) {
                final Object value = values.remove("PriceDeterminationControl");
                if( (value == null) || (!value.equals(getPriceDeterminationControl())) ) {
                    setPriceDeterminationControl(((String) value));
                }
            }
            if( values.containsKey("StandardPrice") ) {
                final Object value = values.remove("StandardPrice");
                if( (value == null) || (!value.equals(getStandardPrice())) ) {
                    setStandardPrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("PriceUnitQty") ) {
                final Object value = values.remove("PriceUnitQty");
                if( (value == null) || (!value.equals(getPriceUnitQty())) ) {
                    setPriceUnitQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("InventoryValuationProcedure") ) {
                final Object value = values.remove("InventoryValuationProcedure");
                if( (value == null) || (!value.equals(getInventoryValuationProcedure())) ) {
                    setInventoryValuationProcedure(((String) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("MovingAveragePrice") ) {
                final Object value = values.remove("MovingAveragePrice");
                if( (value == null) || (!value.equals(getMovingAveragePrice())) ) {
                    setMovingAveragePrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("ValuationCategory") ) {
                final Object value = values.remove("ValuationCategory");
                if( (value == null) || (!value.equals(getValuationCategory())) ) {
                    setValuationCategory(((String) value));
                }
            }
            if( values.containsKey("ProductUsageType") ) {
                final Object value = values.remove("ProductUsageType");
                if( (value == null) || (!value.equals(getProductUsageType())) ) {
                    setProductUsageType(((String) value));
                }
            }
            if( values.containsKey("ProductOriginType") ) {
                final Object value = values.remove("ProductOriginType");
                if( (value == null) || (!value.equals(getProductOriginType())) ) {
                    setProductOriginType(((String) value));
                }
            }
            if( values.containsKey("IsProducedInhouse") ) {
                final Object value = values.remove("IsProducedInhouse");
                if( (value == null) || (!value.equals(getIsProducedInhouse())) ) {
                    setIsProducedInhouse(((Boolean) value));
                }
            }
            if( values.containsKey("ProdCostEstNumber") ) {
                final Object value = values.remove("ProdCostEstNumber");
                if( (value == null) || (!value.equals(getProdCostEstNumber())) ) {
                    setProdCostEstNumber(((String) value));
                }
            }
            if( values.containsKey("ProjectStockValuationClass") ) {
                final Object value = values.remove("ProjectStockValuationClass");
                if( (value == null) || (!value.equals(getProjectStockValuationClass())) ) {
                    setProjectStockValuationClass(((String) value));
                }
            }
            if( values.containsKey("ValuationClassSalesOrderStock") ) {
                final Object value = values.remove("ValuationClassSalesOrderStock");
                if( (value == null) || (!value.equals(getValuationClassSalesOrderStock())) ) {
                    setValuationClassSalesOrderStock(((String) value));
                }
            }
            if( values.containsKey("PlannedPrice1InCoCodeCrcy") ) {
                final Object value = values.remove("PlannedPrice1InCoCodeCrcy");
                if( (value == null) || (!value.equals(getPlannedPrice1InCoCodeCrcy())) ) {
                    setPlannedPrice1InCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlannedPrice2InCoCodeCrcy") ) {
                final Object value = values.remove("PlannedPrice2InCoCodeCrcy");
                if( (value == null) || (!value.equals(getPlannedPrice2InCoCodeCrcy())) ) {
                    setPlannedPrice2InCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlannedPrice3InCoCodeCrcy") ) {
                final Object value = values.remove("PlannedPrice3InCoCodeCrcy");
                if( (value == null) || (!value.equals(getPlannedPrice3InCoCodeCrcy())) ) {
                    setPlannedPrice3InCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("FuturePlndPrice1ValdtyDate") ) {
                final Object value = values.remove("FuturePlndPrice1ValdtyDate");
                if( (value == null) || (!value.equals(getFuturePlndPrice1ValdtyDate())) ) {
                    setFuturePlndPrice1ValdtyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FuturePlndPrice2ValdtyDate") ) {
                final Object value = values.remove("FuturePlndPrice2ValdtyDate");
                if( (value == null) || (!value.equals(getFuturePlndPrice2ValdtyDate())) ) {
                    setFuturePlndPrice2ValdtyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FuturePlndPrice3ValdtyDate") ) {
                final Object value = values.remove("FuturePlndPrice3ValdtyDate");
                if( (value == null) || (!value.equals(getFuturePlndPrice3ValdtyDate())) ) {
                    setFuturePlndPrice3ValdtyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TaxBasedPricesPriceUnitQty") ) {
                final Object value = values.remove("TaxBasedPricesPriceUnitQty");
                if( (value == null) || (!value.equals(getTaxBasedPricesPriceUnitQty())) ) {
                    setTaxBasedPricesPriceUnitQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("PriceLastChangeDate") ) {
                final Object value = values.remove("PriceLastChangeDate");
                if( (value == null) || (!value.equals(getPriceLastChangeDate())) ) {
                    setPriceLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PlannedPrice") ) {
                final Object value = values.remove("PlannedPrice");
                if( (value == null) || (!value.equals(getPlannedPrice())) ) {
                    setPlannedPrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("PrevInvtryPriceInCoCodeCrcy") ) {
                final Object value = values.remove("PrevInvtryPriceInCoCodeCrcy");
                if( (value == null) || (!value.equals(getPrevInvtryPriceInCoCodeCrcy())) ) {
                    setPrevInvtryPriceInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MLAccount") ) {
                final Object value = (values).remove("to_MLAccount");
                if( value instanceof Iterable ) {
                    if( toMLAccount == null ) {
                        toMLAccount = Lists.newArrayList();
                    } else {
                        toMLAccount = Lists.newArrayList(toMLAccount);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductMLAccount entity;
                        if( toMLAccount.size() > i ) {
                            entity = toMLAccount.get(i);
                        } else {
                            entity = new ProductMLAccount();
                            toMLAccount.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MLPrices") ) {
                final Object value = (values).remove("to_MLPrices");
                if( value instanceof Iterable ) {
                    if( toMLPrices == null ) {
                        toMLPrices = Lists.newArrayList();
                    } else {
                        toMLPrices = Lists.newArrayList(toMLPrices);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductMLPrices entity;
                        if( toMLPrices.size() > i ) {
                            entity = toMLPrices.get(i);
                        } else {
                            entity = new ProductMLPrices();
                            toMLPrices.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ValuationAccount") ) {
                final Object value = (values).remove("to_ValuationAccount");
                if( value instanceof Map ) {
                    if( toValuationAccount == null ) {
                        toValuationAccount = new ProductValuationAccount();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toValuationAccount.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ValuationCosting") ) {
                final Object value = (values).remove("to_ValuationCosting");
                if( value instanceof Map ) {
                    if( toValuationCosting == null ) {
                        toValuationCosting = new ProductValuationCosting();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toValuationCosting.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductValuationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductValuationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductValuationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductValuationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMLAccount != null ) {
            (values).put("to_MLAccount", toMLAccount);
        }
        if( toMLPrices != null ) {
            (values).put("to_MLPrices", toMLPrices);
        }
        if( toValuationAccount != null ) {
            (values).put("to_ValuationAccount", toValuationAccount);
        }
        if( toValuationCosting != null ) {
            (values).put("to_ValuationCosting", toValuationCosting);
        }
        return values;
    }

    /**
     * Fetches the <b>ProductMLAccount</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MLAccount</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductMLAccount</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductMLAccount> fetchMLAccount()
    {
        return fetchFieldAsList("to_MLAccount", ProductMLAccount.class);
    }

    /**
     * Retrieval of associated <b>ProductMLAccount</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_MLAccount</b>.
     * <p>
     * If the navigation property <b>to_MLAccount</b> of a queried <b>ProductValuation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductMLAccount</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductMLAccount> getMLAccountOrFetch()
    {
        if( toMLAccount == null ) {
            toMLAccount = fetchMLAccount();
        }
        return toMLAccount;
    }

    /**
     * Retrieval of associated <b>ProductMLAccount</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_MLAccount</b>.
     * <p>
     * If the navigation property for an entity <b>ProductValuation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MLAccount</b> is already loaded, the result will contain
     *         the <b>ProductMLAccount</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<ProductMLAccount>> getMLAccountIfPresent()
    {
        return Option.of(toMLAccount);
    }

    /**
     * Overwrites the list of associated <b>ProductMLAccount</b> entities for the loaded navigation property
     * <b>to_MLAccount</b>.
     * <p>
     * If the navigation property <b>to_MLAccount</b> of a queried <b>ProductValuation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductMLAccount</b> entities.
     */
    public void setMLAccount( @Nonnull final List<ProductMLAccount> value )
    {
        if( toMLAccount == null ) {
            toMLAccount = Lists.newArrayList();
        }
        toMLAccount.clear();
        toMLAccount.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductMLAccount</b> entities. This corresponds to the OData
     * navigation property <b>to_MLAccount</b>.
     * <p>
     * If the navigation property <b>to_MLAccount</b> of a queried <b>ProductValuation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductMLAccount</b> entities.
     */
    public void addMLAccount( ProductMLAccount... entity )
    {
        if( toMLAccount == null ) {
            toMLAccount = Lists.newArrayList();
        }
        toMLAccount.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProductMLPrices</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MLPrices</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductMLPrices</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductMLPrices> fetchMLPrices()
    {
        return fetchFieldAsList("to_MLPrices", ProductMLPrices.class);
    }

    /**
     * Retrieval of associated <b>ProductMLPrices</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_MLPrices</b>.
     * <p>
     * If the navigation property <b>to_MLPrices</b> of a queried <b>ProductValuation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductMLPrices</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductMLPrices> getMLPricesOrFetch()
    {
        if( toMLPrices == null ) {
            toMLPrices = fetchMLPrices();
        }
        return toMLPrices;
    }

    /**
     * Retrieval of associated <b>ProductMLPrices</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_MLPrices</b>.
     * <p>
     * If the navigation property for an entity <b>ProductValuation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MLPrices</b> is already loaded, the result will contain
     *         the <b>ProductMLPrices</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<ProductMLPrices>> getMLPricesIfPresent()
    {
        return Option.of(toMLPrices);
    }

    /**
     * Overwrites the list of associated <b>ProductMLPrices</b> entities for the loaded navigation property
     * <b>to_MLPrices</b>.
     * <p>
     * If the navigation property <b>to_MLPrices</b> of a queried <b>ProductValuation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductMLPrices</b> entities.
     */
    public void setMLPrices( @Nonnull final List<ProductMLPrices> value )
    {
        if( toMLPrices == null ) {
            toMLPrices = Lists.newArrayList();
        }
        toMLPrices.clear();
        toMLPrices.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductMLPrices</b> entities. This corresponds to the OData navigation
     * property <b>to_MLPrices</b>.
     * <p>
     * If the navigation property <b>to_MLPrices</b> of a queried <b>ProductValuation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductMLPrices</b> entities.
     */
    public void addMLPrices( ProductMLPrices... entity )
    {
        if( toMLPrices == null ) {
            toMLPrices = Lists.newArrayList();
        }
        toMLPrices.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProductValuationAccount</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ValuationAccount</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProductValuationAccount</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProductValuationAccount fetchValuationAccount()
    {
        return fetchFieldAsSingle("to_ValuationAccount", ProductValuationAccount.class);
    }

    /**
     * Retrieval of associated <b>ProductValuationAccount</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ValuationAccount</b>.
     * <p>
     * If the navigation property <b>to_ValuationAccount</b> of a queried <b>ProductValuation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductValuationAccount</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProductValuationAccount getValuationAccountOrFetch()
    {
        if( toValuationAccount == null ) {
            toValuationAccount = fetchValuationAccount();
        }
        return toValuationAccount;
    }

    /**
     * Retrieval of associated <b>ProductValuationAccount</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ValuationAccount</b>.
     * <p>
     * If the navigation property for an entity <b>ProductValuation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ValuationAccount</b> is already loaded, the result will
     *         contain the <b>ProductValuationAccount</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProductValuationAccount> getValuationAccountIfPresent()
    {
        return Option.of(toValuationAccount);
    }

    /**
     * Overwrites the associated <b>ProductValuationAccount</b> entity for the loaded navigation property
     * <b>to_ValuationAccount</b>.
     *
     * @param value
     *            New <b>ProductValuationAccount</b> entity.
     */
    public void setValuationAccount( final ProductValuationAccount value )
    {
        toValuationAccount = value;
    }

    /**
     * Fetches the <b>ProductValuationCosting</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ValuationCosting</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProductValuationCosting</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProductValuationCosting fetchValuationCosting()
    {
        return fetchFieldAsSingle("to_ValuationCosting", ProductValuationCosting.class);
    }

    /**
     * Retrieval of associated <b>ProductValuationCosting</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ValuationCosting</b>.
     * <p>
     * If the navigation property <b>to_ValuationCosting</b> of a queried <b>ProductValuation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductValuationCosting</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProductValuationCosting getValuationCostingOrFetch()
    {
        if( toValuationCosting == null ) {
            toValuationCosting = fetchValuationCosting();
        }
        return toValuationCosting;
    }

    /**
     * Retrieval of associated <b>ProductValuationCosting</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ValuationCosting</b>.
     * <p>
     * If the navigation property for an entity <b>ProductValuation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ValuationCosting</b> is already loaded, the result will
     *         contain the <b>ProductValuationCosting</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProductValuationCosting> getValuationCostingIfPresent()
    {
        return Option.of(toValuationCosting);
    }

    /**
     * Overwrites the associated <b>ProductValuationCosting</b> entity for the loaded navigation property
     * <b>to_ValuationCosting</b>.
     *
     * @param value
     *            New <b>ProductValuationCosting</b> entity.
     */
    public void setValuationCosting( final ProductValuationCosting value )
    {
        toValuationCosting = value;
    }

    /**
     * Helper class to allow for fluent creation of ProductValuation instances.
     *
     */
    public final static class ProductValuationBuilder
    {

        private List<ProductMLAccount> toMLAccount = Lists.newArrayList();
        private List<ProductMLPrices> toMLPrices = Lists.newArrayList();
        private ProductValuationAccount toValuationAccount;
        private ProductValuationCosting toValuationCosting;

        private ProductValuation.ProductValuationBuilder toMLAccount( final List<ProductMLAccount> value )
        {
            toMLAccount.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MLAccount</b> for <b>ProductValuation</b> to multiple <b>ProductMLAccount</b>.
         *
         * @param value
         *            The ProductMLAccounts to build this ProductValuation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductValuation.ProductValuationBuilder mlAccount( ProductMLAccount... value )
        {
            return toMLAccount(Lists.newArrayList(value));
        }

        private ProductValuation.ProductValuationBuilder toMLPrices( final List<ProductMLPrices> value )
        {
            toMLPrices.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MLPrices</b> for <b>ProductValuation</b> to multiple <b>ProductMLPrices</b>.
         *
         * @param value
         *            The ProductMLPricess to build this ProductValuation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductValuation.ProductValuationBuilder mlPrices( ProductMLPrices... value )
        {
            return toMLPrices(Lists.newArrayList(value));
        }

        private ProductValuation.ProductValuationBuilder toValuationAccount( final ProductValuationAccount value )
        {
            toValuationAccount = value;
            return this;
        }

        /**
         * Navigation property <b>to_ValuationAccount</b> for <b>ProductValuation</b> to single
         * <b>ProductValuationAccount</b>.
         *
         * @param value
         *            The ProductValuationAccount to build this ProductValuation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductValuation.ProductValuationBuilder valuationAccount( final ProductValuationAccount value )
        {
            return toValuationAccount(value);
        }

        private ProductValuation.ProductValuationBuilder toValuationCosting( final ProductValuationCosting value )
        {
            toValuationCosting = value;
            return this;
        }

        /**
         * Navigation property <b>to_ValuationCosting</b> for <b>ProductValuation</b> to single
         * <b>ProductValuationCosting</b>.
         *
         * @param value
         *            The ProductValuationCosting to build this ProductValuation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductValuation.ProductValuationBuilder valuationCosting( final ProductValuationCosting value )
        {
            return toValuationCosting(value);
        }

    }

}
