/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductValuationAccountField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductValuationAccountSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Valuation Account Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductValuationAccountType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductValuationAccount extends VdmEntity<ProductValuationAccount>
{

    /**
     * Selector for all available fields of ProductValuationAccount.
     *
     */
    public final static ProductValuationAccountSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<String> PRODUCT =
        new ProductValuationAccountField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @return Valuation Area
     */
    @Key
    @SerializedName( "ValuationArea" )
    @JsonProperty( "ValuationArea" )
    @Nullable
    @ODataField( odataName = "ValuationArea" )
    private String valuationArea;
    /**
     * Use with available fluent helpers to apply the <b>ValuationArea</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<String> VALUATION_AREA =
        new ProductValuationAccountField<String>("ValuationArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @return Valuation Type
     */
    @Key
    @SerializedName( "ValuationType" )
    @JsonProperty( "ValuationType" )
    @Nullable
    @ODataField( odataName = "ValuationType" )
    private String valuationType;
    /**
     * Use with available fluent helpers to apply the <b>ValuationType</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<String> VALUATION_TYPE =
        new ProductValuationAccountField<String>("ValuationType");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CommercialPrice1InCoCodeCrcy</b>
     * </p>
     *
     * @return Valuation price based on commercial law: level 1
     */
    @SerializedName( "CommercialPrice1InCoCodeCrcy" )
    @JsonProperty( "CommercialPrice1InCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "CommercialPrice1InCoCodeCrcy" )
    private BigDecimal commercialPrice1InCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CommercialPrice1InCoCodeCrcy</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<BigDecimal> COMMERCIAL_PRICE1_IN_CO_CODE_CRCY =
        new ProductValuationAccountField<BigDecimal>("CommercialPrice1InCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CommercialPrice2InCoCodeCrcy</b>
     * </p>
     *
     * @return Valuation price based on commercial law: level 2
     */
    @SerializedName( "CommercialPrice2InCoCodeCrcy" )
    @JsonProperty( "CommercialPrice2InCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "CommercialPrice2InCoCodeCrcy" )
    private BigDecimal commercialPrice2InCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CommercialPrice2InCoCodeCrcy</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<BigDecimal> COMMERCIAL_PRICE2_IN_CO_CODE_CRCY =
        new ProductValuationAccountField<BigDecimal>("CommercialPrice2InCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CommercialPrice3InCoCodeCrcy</b>
     * </p>
     *
     * @return Valuation price based on commercial law: level 3
     */
    @SerializedName( "CommercialPrice3InCoCodeCrcy" )
    @JsonProperty( "CommercialPrice3InCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "CommercialPrice3InCoCodeCrcy" )
    private BigDecimal commercialPrice3InCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CommercialPrice3InCoCodeCrcy</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<BigDecimal> COMMERCIAL_PRICE3_IN_CO_CODE_CRCY =
        new ProductValuationAccountField<BigDecimal>("CommercialPrice3InCoCodeCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DevaluationYearCount</b>
     * </p>
     *
     * @return Lowest value: devaluation indicator
     */
    @SerializedName( "DevaluationYearCount" )
    @JsonProperty( "DevaluationYearCount" )
    @Nullable
    @ODataField( odataName = "DevaluationYearCount" )
    private String devaluationYearCount;
    /**
     * Use with available fluent helpers to apply the <b>DevaluationYearCount</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<String> DEVALUATION_YEAR_COUNT =
        new ProductValuationAccountField<String>("DevaluationYearCount");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FutureEvaluatedAmountValue</b>
     * </p>
     *
     * @return Future Price
     */
    @SerializedName( "FutureEvaluatedAmountValue" )
    @JsonProperty( "FutureEvaluatedAmountValue" )
    @Nullable
    @ODataField( odataName = "FutureEvaluatedAmountValue" )
    private BigDecimal futureEvaluatedAmountValue;
    /**
     * Use with available fluent helpers to apply the <b>FutureEvaluatedAmountValue</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<BigDecimal> FUTURE_EVALUATED_AMOUNT_VALUE =
        new ProductValuationAccountField<BigDecimal>("FutureEvaluatedAmountValue");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FuturePriceValidityStartDate</b>
     * </p>
     *
     * @return Date as of which the price is valid
     */
    @SerializedName( "FuturePriceValidityStartDate" )
    @JsonProperty( "FuturePriceValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FuturePriceValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime futurePriceValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>FuturePriceValidityStartDate</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<LocalDateTime> FUTURE_PRICE_VALIDITY_START_DATE =
        new ProductValuationAccountField<LocalDateTime>("FuturePriceValidityStartDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsLIFOAndFIFORelevant</b>
     * </p>
     *
     * @return Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    @SerializedName( "IsLIFOAndFIFORelevant" )
    @JsonProperty( "IsLIFOAndFIFORelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsLIFOAndFIFORelevant" )
    private Boolean isLIFOAndFIFORelevant;
    /**
     * Use with available fluent helpers to apply the <b>IsLIFOAndFIFORelevant</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<Boolean> IS_LIFO_AND_FIFO_RELEVANT =
        new ProductValuationAccountField<Boolean>("IsLIFOAndFIFORelevant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LIFOValuationPoolNumber</b>
     * </p>
     *
     * @return Pool number for LIFO valuation
     */
    @SerializedName( "LIFOValuationPoolNumber" )
    @JsonProperty( "LIFOValuationPoolNumber" )
    @Nullable
    @ODataField( odataName = "LIFOValuationPoolNumber" )
    private String lIFOValuationPoolNumber;
    /**
     * Use with available fluent helpers to apply the <b>LIFOValuationPoolNumber</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<String> LIFO_VALUATION_POOL_NUMBER =
        new ProductValuationAccountField<String>("LIFOValuationPoolNumber");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxPricel1InCoCodeCrcy</b>
     * </p>
     *
     * @return Valuation price based on tax law: level 1
     */
    @SerializedName( "TaxPricel1InCoCodeCrcy" )
    @JsonProperty( "TaxPricel1InCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "TaxPricel1InCoCodeCrcy" )
    private BigDecimal taxPricel1InCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>TaxPricel1InCoCodeCrcy</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<BigDecimal> TAX_PRICEL1_IN_CO_CODE_CRCY =
        new ProductValuationAccountField<BigDecimal>("TaxPricel1InCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxPrice2InCoCodeCrcy</b>
     * </p>
     *
     * @return Valuation price based on tax law: level 2
     */
    @SerializedName( "TaxPrice2InCoCodeCrcy" )
    @JsonProperty( "TaxPrice2InCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "TaxPrice2InCoCodeCrcy" )
    private BigDecimal taxPrice2InCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>TaxPrice2InCoCodeCrcy</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<BigDecimal> TAX_PRICE2_IN_CO_CODE_CRCY =
        new ProductValuationAccountField<BigDecimal>("TaxPrice2InCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxPrice3InCoCodeCrcy</b>
     * </p>
     *
     * @return Valuation price based on tax law: level 3
     */
    @SerializedName( "TaxPrice3InCoCodeCrcy" )
    @JsonProperty( "TaxPrice3InCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "TaxPrice3InCoCodeCrcy" )
    private BigDecimal taxPrice3InCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>TaxPrice3InCoCodeCrcy</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<BigDecimal> TAX_PRICE3_IN_CO_CODE_CRCY =
        new ProductValuationAccountField<BigDecimal>("TaxPrice3InCoCodeCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ProductValuationAccountField<String> CURRENCY =
        new ProductValuationAccountField<String>("Currency");

    @Nonnull
    @Override
    public Class<ProductValuationAccount> getType()
    {
        return ProductValuationAccount.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @param valuationArea
     *            Valuation Area
     */
    public void setValuationArea( @Nullable final String valuationArea )
    {
        rememberChangedField("ValuationArea", this.valuationArea);
        this.valuationArea = valuationArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @param valuationType
     *            Valuation Type
     */
    public void setValuationType( @Nullable final String valuationType )
    {
        rememberChangedField("ValuationType", this.valuationType);
        this.valuationType = valuationType;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CommercialPrice1InCoCodeCrcy</b>
     * </p>
     *
     * @param commercialPrice1InCoCodeCrcy
     *            Valuation price based on commercial law: level 1
     */
    public void setCommercialPrice1InCoCodeCrcy( @Nullable final BigDecimal commercialPrice1InCoCodeCrcy )
    {
        rememberChangedField("CommercialPrice1InCoCodeCrcy", this.commercialPrice1InCoCodeCrcy);
        this.commercialPrice1InCoCodeCrcy = commercialPrice1InCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CommercialPrice2InCoCodeCrcy</b>
     * </p>
     *
     * @param commercialPrice2InCoCodeCrcy
     *            Valuation price based on commercial law: level 2
     */
    public void setCommercialPrice2InCoCodeCrcy( @Nullable final BigDecimal commercialPrice2InCoCodeCrcy )
    {
        rememberChangedField("CommercialPrice2InCoCodeCrcy", this.commercialPrice2InCoCodeCrcy);
        this.commercialPrice2InCoCodeCrcy = commercialPrice2InCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CommercialPrice3InCoCodeCrcy</b>
     * </p>
     *
     * @param commercialPrice3InCoCodeCrcy
     *            Valuation price based on commercial law: level 3
     */
    public void setCommercialPrice3InCoCodeCrcy( @Nullable final BigDecimal commercialPrice3InCoCodeCrcy )
    {
        rememberChangedField("CommercialPrice3InCoCodeCrcy", this.commercialPrice3InCoCodeCrcy);
        this.commercialPrice3InCoCodeCrcy = commercialPrice3InCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DevaluationYearCount</b>
     * </p>
     *
     * @param devaluationYearCount
     *            Lowest value: devaluation indicator
     */
    public void setDevaluationYearCount( @Nullable final String devaluationYearCount )
    {
        rememberChangedField("DevaluationYearCount", this.devaluationYearCount);
        this.devaluationYearCount = devaluationYearCount;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FutureEvaluatedAmountValue</b>
     * </p>
     *
     * @param futureEvaluatedAmountValue
     *            Future Price
     */
    public void setFutureEvaluatedAmountValue( @Nullable final BigDecimal futureEvaluatedAmountValue )
    {
        rememberChangedField("FutureEvaluatedAmountValue", this.futureEvaluatedAmountValue);
        this.futureEvaluatedAmountValue = futureEvaluatedAmountValue;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FuturePriceValidityStartDate</b>
     * </p>
     *
     * @param futurePriceValidityStartDate
     *            Date as of which the price is valid
     */
    public void setFuturePriceValidityStartDate( @Nullable final LocalDateTime futurePriceValidityStartDate )
    {
        rememberChangedField("FuturePriceValidityStartDate", this.futurePriceValidityStartDate);
        this.futurePriceValidityStartDate = futurePriceValidityStartDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsLIFOAndFIFORelevant</b>
     * </p>
     *
     * @param isLIFOAndFIFORelevant
     *            Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    public void setIsLIFOAndFIFORelevant( @Nullable final Boolean isLIFOAndFIFORelevant )
    {
        rememberChangedField("IsLIFOAndFIFORelevant", this.isLIFOAndFIFORelevant);
        this.isLIFOAndFIFORelevant = isLIFOAndFIFORelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LIFOValuationPoolNumber</b>
     * </p>
     *
     * @param lIFOValuationPoolNumber
     *            Pool number for LIFO valuation
     */
    public void setLIFOValuationPoolNumber( @Nullable final String lIFOValuationPoolNumber )
    {
        rememberChangedField("LIFOValuationPoolNumber", this.lIFOValuationPoolNumber);
        this.lIFOValuationPoolNumber = lIFOValuationPoolNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxPricel1InCoCodeCrcy</b>
     * </p>
     *
     * @param taxPricel1InCoCodeCrcy
     *            Valuation price based on tax law: level 1
     */
    public void setTaxPricel1InCoCodeCrcy( @Nullable final BigDecimal taxPricel1InCoCodeCrcy )
    {
        rememberChangedField("TaxPricel1InCoCodeCrcy", this.taxPricel1InCoCodeCrcy);
        this.taxPricel1InCoCodeCrcy = taxPricel1InCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxPrice2InCoCodeCrcy</b>
     * </p>
     *
     * @param taxPrice2InCoCodeCrcy
     *            Valuation price based on tax law: level 2
     */
    public void setTaxPrice2InCoCodeCrcy( @Nullable final BigDecimal taxPrice2InCoCodeCrcy )
    {
        rememberChangedField("TaxPrice2InCoCodeCrcy", this.taxPrice2InCoCodeCrcy);
        this.taxPrice2InCoCodeCrcy = taxPrice2InCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxPrice3InCoCodeCrcy</b>
     * </p>
     *
     * @param taxPrice3InCoCodeCrcy
     *            Valuation price based on tax law: level 3
     */
    public void setTaxPrice3InCoCodeCrcy( @Nullable final BigDecimal taxPrice3InCoCodeCrcy )
    {
        rememberChangedField("TaxPrice3InCoCodeCrcy", this.taxPrice3InCoCodeCrcy);
        this.taxPrice3InCoCodeCrcy = taxPrice3InCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductValuationAccount";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("ValuationArea", getValuationArea());
        result.put("ValuationType", getValuationType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("ValuationArea", getValuationArea());
        values.put("ValuationType", getValuationType());
        values.put("CommercialPrice1InCoCodeCrcy", getCommercialPrice1InCoCodeCrcy());
        values.put("CommercialPrice2InCoCodeCrcy", getCommercialPrice2InCoCodeCrcy());
        values.put("CommercialPrice3InCoCodeCrcy", getCommercialPrice3InCoCodeCrcy());
        values.put("DevaluationYearCount", getDevaluationYearCount());
        values.put("FutureEvaluatedAmountValue", getFutureEvaluatedAmountValue());
        values.put("FuturePriceValidityStartDate", getFuturePriceValidityStartDate());
        values.put("IsLIFOAndFIFORelevant", getIsLIFOAndFIFORelevant());
        values.put("LIFOValuationPoolNumber", getLIFOValuationPoolNumber());
        values.put("TaxPricel1InCoCodeCrcy", getTaxPricel1InCoCodeCrcy());
        values.put("TaxPrice2InCoCodeCrcy", getTaxPrice2InCoCodeCrcy());
        values.put("TaxPrice3InCoCodeCrcy", getTaxPrice3InCoCodeCrcy());
        values.put("Currency", getCurrency());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("ValuationArea") ) {
                final Object value = values.remove("ValuationArea");
                if( (value == null) || (!value.equals(getValuationArea())) ) {
                    setValuationArea(((String) value));
                }
            }
            if( values.containsKey("ValuationType") ) {
                final Object value = values.remove("ValuationType");
                if( (value == null) || (!value.equals(getValuationType())) ) {
                    setValuationType(((String) value));
                }
            }
            if( values.containsKey("CommercialPrice1InCoCodeCrcy") ) {
                final Object value = values.remove("CommercialPrice1InCoCodeCrcy");
                if( (value == null) || (!value.equals(getCommercialPrice1InCoCodeCrcy())) ) {
                    setCommercialPrice1InCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CommercialPrice2InCoCodeCrcy") ) {
                final Object value = values.remove("CommercialPrice2InCoCodeCrcy");
                if( (value == null) || (!value.equals(getCommercialPrice2InCoCodeCrcy())) ) {
                    setCommercialPrice2InCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CommercialPrice3InCoCodeCrcy") ) {
                final Object value = values.remove("CommercialPrice3InCoCodeCrcy");
                if( (value == null) || (!value.equals(getCommercialPrice3InCoCodeCrcy())) ) {
                    setCommercialPrice3InCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("DevaluationYearCount") ) {
                final Object value = values.remove("DevaluationYearCount");
                if( (value == null) || (!value.equals(getDevaluationYearCount())) ) {
                    setDevaluationYearCount(((String) value));
                }
            }
            if( values.containsKey("FutureEvaluatedAmountValue") ) {
                final Object value = values.remove("FutureEvaluatedAmountValue");
                if( (value == null) || (!value.equals(getFutureEvaluatedAmountValue())) ) {
                    setFutureEvaluatedAmountValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("FuturePriceValidityStartDate") ) {
                final Object value = values.remove("FuturePriceValidityStartDate");
                if( (value == null) || (!value.equals(getFuturePriceValidityStartDate())) ) {
                    setFuturePriceValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("IsLIFOAndFIFORelevant") ) {
                final Object value = values.remove("IsLIFOAndFIFORelevant");
                if( (value == null) || (!value.equals(getIsLIFOAndFIFORelevant())) ) {
                    setIsLIFOAndFIFORelevant(((Boolean) value));
                }
            }
            if( values.containsKey("LIFOValuationPoolNumber") ) {
                final Object value = values.remove("LIFOValuationPoolNumber");
                if( (value == null) || (!value.equals(getLIFOValuationPoolNumber())) ) {
                    setLIFOValuationPoolNumber(((String) value));
                }
            }
            if( values.containsKey("TaxPricel1InCoCodeCrcy") ) {
                final Object value = values.remove("TaxPricel1InCoCodeCrcy");
                if( (value == null) || (!value.equals(getTaxPricel1InCoCodeCrcy())) ) {
                    setTaxPricel1InCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxPrice2InCoCodeCrcy") ) {
                final Object value = values.remove("TaxPrice2InCoCodeCrcy");
                if( (value == null) || (!value.equals(getTaxPrice2InCoCodeCrcy())) ) {
                    setTaxPrice2InCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxPrice3InCoCodeCrcy") ) {
                final Object value = values.remove("TaxPrice3InCoCodeCrcy");
                if( (value == null) || (!value.equals(getTaxPrice3InCoCodeCrcy())) ) {
                    setTaxPrice3InCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductValuationAccountField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductValuationAccountField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductValuationAccountField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductValuationAccountField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
