/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductValuationCostingField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductValuationCostingSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Valuation Costing Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductValuationCostingType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductValuationCosting extends VdmEntity<ProductValuationCosting>
{

    /**
     * Selector for all available fields of ProductValuationCosting.
     *
     */
    public final static ProductValuationCostingSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductValuationCostingField<String> PRODUCT =
        new ProductValuationCostingField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @return Valuation Area
     */
    @Key
    @SerializedName( "ValuationArea" )
    @JsonProperty( "ValuationArea" )
    @Nullable
    @ODataField( odataName = "ValuationArea" )
    private String valuationArea;
    /**
     * Use with available fluent helpers to apply the <b>ValuationArea</b> field to query operations.
     *
     */
    public final static ProductValuationCostingField<String> VALUATION_AREA =
        new ProductValuationCostingField<String>("ValuationArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @return Valuation Type
     */
    @Key
    @SerializedName( "ValuationType" )
    @JsonProperty( "ValuationType" )
    @Nullable
    @ODataField( odataName = "ValuationType" )
    private String valuationType;
    /**
     * Use with available fluent helpers to apply the <b>ValuationType</b> field to query operations.
     *
     */
    public final static ProductValuationCostingField<String> VALUATION_TYPE =
        new ProductValuationCostingField<String>("ValuationType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMaterialCostedWithQtyStruc</b>
     * </p>
     *
     * @return Material Is Costed with Quantity Structure
     */
    @SerializedName( "IsMaterialCostedWithQtyStruc" )
    @JsonProperty( "IsMaterialCostedWithQtyStruc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMaterialCostedWithQtyStruc" )
    private Boolean isMaterialCostedWithQtyStruc;
    /**
     * Use with available fluent helpers to apply the <b>IsMaterialCostedWithQtyStruc</b> field to query operations.
     *
     */
    public final static ProductValuationCostingField<Boolean> IS_MATERIAL_COSTED_WITH_QTY_STRUC =
        new ProductValuationCostingField<Boolean>("IsMaterialCostedWithQtyStruc");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMaterialRelatedOrigin</b>
     * </p>
     *
     * @return Material-related origin
     */
    @SerializedName( "IsMaterialRelatedOrigin" )
    @JsonProperty( "IsMaterialRelatedOrigin" )
    @Nullable
    @ODataField( odataName = "IsMaterialRelatedOrigin" )
    private String isMaterialRelatedOrigin;
    /**
     * Use with available fluent helpers to apply the <b>IsMaterialRelatedOrigin</b> field to query operations.
     *
     */
    public final static ProductValuationCostingField<String> IS_MATERIAL_RELATED_ORIGIN =
        new ProductValuationCostingField<String>("IsMaterialRelatedOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostOriginGroup</b>
     * </p>
     *
     * @return Origin Group as Subdivision of Cost Element
     */
    @SerializedName( "CostOriginGroup" )
    @JsonProperty( "CostOriginGroup" )
    @Nullable
    @ODataField( odataName = "CostOriginGroup" )
    private String costOriginGroup;
    /**
     * Use with available fluent helpers to apply the <b>CostOriginGroup</b> field to query operations.
     *
     */
    public final static ProductValuationCostingField<String> COST_ORIGIN_GROUP =
        new ProductValuationCostingField<String>("CostOriginGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostingOverheadGroup</b>
     * </p>
     *
     * @return Costing Overhead Group
     */
    @SerializedName( "CostingOverheadGroup" )
    @JsonProperty( "CostingOverheadGroup" )
    @Nullable
    @ODataField( odataName = "CostingOverheadGroup" )
    private String costingOverheadGroup;
    /**
     * Use with available fluent helpers to apply the <b>CostingOverheadGroup</b> field to query operations.
     *
     */
    public final static ProductValuationCostingField<String> COSTING_OVERHEAD_GROUP =
        new ProductValuationCostingField<String>("CostingOverheadGroup");

    @Nonnull
    @Override
    public Class<ProductValuationCosting> getType()
    {
        return ProductValuationCosting.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @param valuationArea
     *            Valuation Area
     */
    public void setValuationArea( @Nullable final String valuationArea )
    {
        rememberChangedField("ValuationArea", this.valuationArea);
        this.valuationArea = valuationArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @param valuationType
     *            Valuation Type
     */
    public void setValuationType( @Nullable final String valuationType )
    {
        rememberChangedField("ValuationType", this.valuationType);
        this.valuationType = valuationType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMaterialCostedWithQtyStruc</b>
     * </p>
     *
     * @param isMaterialCostedWithQtyStruc
     *            Material Is Costed with Quantity Structure
     */
    public void setIsMaterialCostedWithQtyStruc( @Nullable final Boolean isMaterialCostedWithQtyStruc )
    {
        rememberChangedField("IsMaterialCostedWithQtyStruc", this.isMaterialCostedWithQtyStruc);
        this.isMaterialCostedWithQtyStruc = isMaterialCostedWithQtyStruc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMaterialRelatedOrigin</b>
     * </p>
     *
     * @param isMaterialRelatedOrigin
     *            Material-related origin
     */
    public void setIsMaterialRelatedOrigin( @Nullable final String isMaterialRelatedOrigin )
    {
        rememberChangedField("IsMaterialRelatedOrigin", this.isMaterialRelatedOrigin);
        this.isMaterialRelatedOrigin = isMaterialRelatedOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostOriginGroup</b>
     * </p>
     *
     * @param costOriginGroup
     *            Origin Group as Subdivision of Cost Element
     */
    public void setCostOriginGroup( @Nullable final String costOriginGroup )
    {
        rememberChangedField("CostOriginGroup", this.costOriginGroup);
        this.costOriginGroup = costOriginGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostingOverheadGroup</b>
     * </p>
     *
     * @param costingOverheadGroup
     *            Costing Overhead Group
     */
    public void setCostingOverheadGroup( @Nullable final String costingOverheadGroup )
    {
        rememberChangedField("CostingOverheadGroup", this.costingOverheadGroup);
        this.costingOverheadGroup = costingOverheadGroup;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductValuationCosting";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("ValuationArea", getValuationArea());
        result.put("ValuationType", getValuationType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("ValuationArea", getValuationArea());
        values.put("ValuationType", getValuationType());
        values.put("IsMaterialCostedWithQtyStruc", getIsMaterialCostedWithQtyStruc());
        values.put("IsMaterialRelatedOrigin", getIsMaterialRelatedOrigin());
        values.put("CostOriginGroup", getCostOriginGroup());
        values.put("CostingOverheadGroup", getCostingOverheadGroup());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("ValuationArea") ) {
                final Object value = values.remove("ValuationArea");
                if( (value == null) || (!value.equals(getValuationArea())) ) {
                    setValuationArea(((String) value));
                }
            }
            if( values.containsKey("ValuationType") ) {
                final Object value = values.remove("ValuationType");
                if( (value == null) || (!value.equals(getValuationType())) ) {
                    setValuationType(((String) value));
                }
            }
            if( values.containsKey("IsMaterialCostedWithQtyStruc") ) {
                final Object value = values.remove("IsMaterialCostedWithQtyStruc");
                if( (value == null) || (!value.equals(getIsMaterialCostedWithQtyStruc())) ) {
                    setIsMaterialCostedWithQtyStruc(((Boolean) value));
                }
            }
            if( values.containsKey("IsMaterialRelatedOrigin") ) {
                final Object value = values.remove("IsMaterialRelatedOrigin");
                if( (value == null) || (!value.equals(getIsMaterialRelatedOrigin())) ) {
                    setIsMaterialRelatedOrigin(((String) value));
                }
            }
            if( values.containsKey("CostOriginGroup") ) {
                final Object value = values.remove("CostOriginGroup");
                if( (value == null) || (!value.equals(getCostOriginGroup())) ) {
                    setCostOriginGroup(((String) value));
                }
            }
            if( values.containsKey("CostingOverheadGroup") ) {
                final Object value = values.remove("CostingOverheadGroup");
                if( (value == null) || (!value.equals(getCostingOverheadGroup())) ) {
                    setCostingOverheadGroup(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductValuationCostingField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductValuationCostingField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductValuationCostingField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductValuationCostingField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

}
