/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ProductMasterServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService ProductMasterService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultProductMasterServiceBatch
    extends
    BatchFluentHelperBasic<ProductMasterServiceBatch, ProductMasterServiceBatchChangeSet>
    implements
    ProductMasterServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultProductMasterServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductMasterServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultProductMasterServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductMasterServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultProductMasterServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultProductMasterServiceBatchChangeSet(this, service);
    }

}
