/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling;

/**
 * Implementation of the {@link ProductMasterServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService ProductMasterService}.
 *
 */
public class DefaultProductMasterServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProductMasterServiceBatch, ProductMasterServiceBatchChangeSet>
    implements
    ProductMasterServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService service;

    @SuppressWarnings( "deprecation" )
    DefaultProductMasterServiceBatchChangeSet(
        @Nonnull final DefaultProductMasterServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProductMasterServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProduct( @Nonnull final Product product )
    {
        return addRequestCreate(service::createProduct, product);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProduct( @Nonnull final Product product )
    {
        return addRequestUpdate(service::updateProduct, product);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductBasicText( @Nonnull final ProductBasicText productBasicText )
    {
        return addRequestCreate(service::createProductBasicText, productBasicText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductBasicText( @Nonnull final ProductBasicText productBasicText )
    {
        return addRequestUpdate(service::updateProductBasicText, productBasicText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet deleteProductBasicText( @Nonnull final ProductBasicText productBasicText )
    {
        return addRequestDelete(service::deleteProductBasicText, productBasicText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return addRequestCreate(service::createProductDescription, productDescription);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return addRequestUpdate(service::updateProductDescription, productDescription);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet deleteProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return addRequestDelete(service::deleteProductDescription, productDescription);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductInspectionText(
        @Nonnull final ProductInspectionText productInspectionText )
    {
        return addRequestCreate(service::createProductInspectionText, productInspectionText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductInspectionText(
        @Nonnull final ProductInspectionText productInspectionText )
    {
        return addRequestUpdate(service::updateProductInspectionText, productInspectionText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet deleteProductInspectionText(
        @Nonnull final ProductInspectionText productInspectionText )
    {
        return addRequestDelete(service::deleteProductInspectionText, productInspectionText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductMLAccount( @Nonnull final ProductMLAccount productMLAccount )
    {
        return addRequestCreate(service::createProductMLAccount, productMLAccount);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductMLAccount( @Nonnull final ProductMLAccount productMLAccount )
    {
        return addRequestUpdate(service::updateProductMLAccount, productMLAccount);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductMLPrices( @Nonnull final ProductMLPrices productMLPrices )
    {
        return addRequestCreate(service::createProductMLPrices, productMLPrices);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductMLPrices( @Nonnull final ProductMLPrices productMLPrices )
    {
        return addRequestUpdate(service::updateProductMLPrices, productMLPrices);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductPlant( @Nonnull final ProductPlant productPlant )
    {
        return addRequestCreate(service::createProductPlant, productPlant);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductPlant( @Nonnull final ProductPlant productPlant )
    {
        return addRequestUpdate(service::updateProductPlant, productPlant);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductPlantCosting(
        @Nonnull final ProductPlantCosting productPlantCosting )
    {
        return addRequestCreate(service::createProductPlantCosting, productPlantCosting);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductPlantCosting(
        @Nonnull final ProductPlantCosting productPlantCosting )
    {
        return addRequestUpdate(service::updateProductPlantCosting, productPlantCosting);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductPlantForecasting(
        @Nonnull final ProductPlantForecasting productPlantForecasting )
    {
        return addRequestCreate(service::createProductPlantForecasting, productPlantForecasting);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductPlantForecasting(
        @Nonnull final ProductPlantForecasting productPlantForecasting )
    {
        return addRequestUpdate(service::updateProductPlantForecasting, productPlantForecasting);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductPlantIntlTrd(
        @Nonnull final ProductPlantIntlTrd productPlantIntlTrd )
    {
        return addRequestCreate(service::createProductPlantIntlTrd, productPlantIntlTrd);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductPlantIntlTrd(
        @Nonnull final ProductPlantIntlTrd productPlantIntlTrd )
    {
        return addRequestUpdate(service::updateProductPlantIntlTrd, productPlantIntlTrd);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductPlantMRPArea(
        @Nonnull final ProductPlantMRPArea productPlantMRPArea )
    {
        return addRequestCreate(service::createProductPlantMRPArea, productPlantMRPArea);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductPlantMRPArea(
        @Nonnull final ProductPlantMRPArea productPlantMRPArea )
    {
        return addRequestUpdate(service::updateProductPlantMRPArea, productPlantMRPArea);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductPlantProcurement(
        @Nonnull final ProductPlantProcurement productPlantProcurement )
    {
        return addRequestCreate(service::createProductPlantProcurement, productPlantProcurement);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductPlantProcurement(
        @Nonnull final ProductPlantProcurement productPlantProcurement )
    {
        return addRequestUpdate(service::updateProductPlantProcurement, productPlantProcurement);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductPlantQualityMgmt(
        @Nonnull final ProductPlantQualityMgmt productPlantQualityMgmt )
    {
        return addRequestCreate(service::createProductPlantQualityMgmt, productPlantQualityMgmt);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductPlantQualityMgmt(
        @Nonnull final ProductPlantQualityMgmt productPlantQualityMgmt )
    {
        return addRequestUpdate(service::updateProductPlantQualityMgmt, productPlantQualityMgmt);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductPlantSales(
        @Nonnull final ProductPlantSales productPlantSales )
    {
        return addRequestCreate(service::createProductPlantSales, productPlantSales);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductPlantSales(
        @Nonnull final ProductPlantSales productPlantSales )
    {
        return addRequestUpdate(service::updateProductPlantSales, productPlantSales);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductPlantStorage(
        @Nonnull final ProductPlantStorage productPlantStorage )
    {
        return addRequestCreate(service::createProductPlantStorage, productPlantStorage);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductPlantStorage(
        @Nonnull final ProductPlantStorage productPlantStorage )
    {
        return addRequestUpdate(service::updateProductPlantStorage, productPlantStorage);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductPlantText( @Nonnull final ProductPlantText productPlantText )
    {
        return addRequestCreate(service::createProductPlantText, productPlantText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductPlantText( @Nonnull final ProductPlantText productPlantText )
    {
        return addRequestUpdate(service::updateProductPlantText, productPlantText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet deleteProductPlantText( @Nonnull final ProductPlantText productPlantText )
    {
        return addRequestDelete(service::deleteProductPlantText, productPlantText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductProcurement(
        @Nonnull final ProductProcurement productProcurement )
    {
        return addRequestCreate(service::createProductProcurement, productProcurement);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductProcurement(
        @Nonnull final ProductProcurement productProcurement )
    {
        return addRequestUpdate(service::updateProductProcurement, productProcurement);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductPurchaseText(
        @Nonnull final ProductPurchaseText productPurchaseText )
    {
        return addRequestCreate(service::createProductPurchaseText, productPurchaseText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductPurchaseText(
        @Nonnull final ProductPurchaseText productPurchaseText )
    {
        return addRequestUpdate(service::updateProductPurchaseText, productPurchaseText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet deleteProductPurchaseText(
        @Nonnull final ProductPurchaseText productPurchaseText )
    {
        return addRequestDelete(service::deleteProductPurchaseText, productPurchaseText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductQualityMgmt(
        @Nonnull final ProductQualityMgmt productQualityMgmt )
    {
        return addRequestCreate(service::createProductQualityMgmt, productQualityMgmt);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductQualityMgmt(
        @Nonnull final ProductQualityMgmt productQualityMgmt )
    {
        return addRequestUpdate(service::updateProductQualityMgmt, productQualityMgmt);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductSales( @Nonnull final ProductSales productSales )
    {
        return addRequestCreate(service::createProductSales, productSales);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductSales( @Nonnull final ProductSales productSales )
    {
        return addRequestUpdate(service::updateProductSales, productSales);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductSalesDelivery(
        @Nonnull final ProductSalesDelivery productSalesDelivery )
    {
        return addRequestCreate(service::createProductSalesDelivery, productSalesDelivery);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductSalesDelivery(
        @Nonnull final ProductSalesDelivery productSalesDelivery )
    {
        return addRequestUpdate(service::updateProductSalesDelivery, productSalesDelivery);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductSalesTax( @Nonnull final ProductSalesTax productSalesTax )
    {
        return addRequestCreate(service::createProductSalesTax, productSalesTax);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductSalesTax( @Nonnull final ProductSalesTax productSalesTax )
    {
        return addRequestUpdate(service::updateProductSalesTax, productSalesTax);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet deleteProductSalesTax( @Nonnull final ProductSalesTax productSalesTax )
    {
        return addRequestDelete(service::deleteProductSalesTax, productSalesTax);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductSalesText( @Nonnull final ProductSalesText productSalesText )
    {
        return addRequestCreate(service::createProductSalesText, productSalesText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductSalesText( @Nonnull final ProductSalesText productSalesText )
    {
        return addRequestUpdate(service::updateProductSalesText, productSalesText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet deleteProductSalesText( @Nonnull final ProductSalesText productSalesText )
    {
        return addRequestDelete(service::deleteProductSalesText, productSalesText);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductStorage( @Nonnull final ProductStorage productStorage )
    {
        return addRequestCreate(service::createProductStorage, productStorage);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductStorage( @Nonnull final ProductStorage productStorage )
    {
        return addRequestUpdate(service::updateProductStorage, productStorage);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductStorageLocation(
        @Nonnull final ProductStorageLocation productStorageLocation )
    {
        return addRequestCreate(service::createProductStorageLocation, productStorageLocation);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductStorageLocation(
        @Nonnull final ProductStorageLocation productStorageLocation )
    {
        return addRequestUpdate(service::updateProductStorageLocation, productStorageLocation);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductSupplyPlanning(
        @Nonnull final ProductSupplyPlanning productSupplyPlanning )
    {
        return addRequestCreate(service::createProductSupplyPlanning, productSupplyPlanning);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductSupplyPlanning(
        @Nonnull final ProductSupplyPlanning productSupplyPlanning )
    {
        return addRequestUpdate(service::updateProductSupplyPlanning, productSupplyPlanning);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductUnitsOfMeasure(
        @Nonnull final ProductUnitsOfMeasure productUnitsOfMeasure )
    {
        return addRequestCreate(service::createProductUnitsOfMeasure, productUnitsOfMeasure);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductUnitsOfMeasure(
        @Nonnull final ProductUnitsOfMeasure productUnitsOfMeasure )
    {
        return addRequestUpdate(service::updateProductUnitsOfMeasure, productUnitsOfMeasure);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet deleteProductUnitsOfMeasure(
        @Nonnull final ProductUnitsOfMeasure productUnitsOfMeasure )
    {
        return addRequestDelete(service::deleteProductUnitsOfMeasure, productUnitsOfMeasure);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductUnitsOfMeasureEAN(
        @Nonnull final ProductUnitsOfMeasureEAN productUnitsOfMeasureEAN )
    {
        return addRequestCreate(service::createProductUnitsOfMeasureEAN, productUnitsOfMeasureEAN);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductUnitsOfMeasureEAN(
        @Nonnull final ProductUnitsOfMeasureEAN productUnitsOfMeasureEAN )
    {
        return addRequestUpdate(service::updateProductUnitsOfMeasureEAN, productUnitsOfMeasureEAN);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet deleteProductUnitsOfMeasureEAN(
        @Nonnull final ProductUnitsOfMeasureEAN productUnitsOfMeasureEAN )
    {
        return addRequestDelete(service::deleteProductUnitsOfMeasureEAN, productUnitsOfMeasureEAN);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductValuation( @Nonnull final ProductValuation productValuation )
    {
        return addRequestCreate(service::createProductValuation, productValuation);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductValuation( @Nonnull final ProductValuation productValuation )
    {
        return addRequestUpdate(service::updateProductValuation, productValuation);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductValuationAccount(
        @Nonnull final ProductValuationAccount productValuationAccount )
    {
        return addRequestCreate(service::createProductValuationAccount, productValuationAccount);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductValuationAccount(
        @Nonnull final ProductValuationAccount productValuationAccount )
    {
        return addRequestUpdate(service::updateProductValuationAccount, productValuationAccount);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductValuationCosting(
        @Nonnull final ProductValuationCosting productValuationCosting )
    {
        return addRequestCreate(service::createProductValuationCosting, productValuationCosting);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductValuationCosting(
        @Nonnull final ProductValuationCosting productValuationCosting )
    {
        return addRequestUpdate(service::updateProductValuationCosting, productValuationCosting);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet createProductWorkScheduling(
        @Nonnull final ProductWorkScheduling productWorkScheduling )
    {
        return addRequestCreate(service::createProductWorkScheduling, productWorkScheduling);
    }

    @Nonnull
    @Override
    public ProductMasterServiceBatchChangeSet updateProductWorkScheduling(
        @Nonnull final ProductWorkScheduling productWorkScheduling )
    {
        return addRequestUpdate(service::updateProductWorkScheduling, productWorkScheduling);
    }

}
