/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterService ProductMasterService}.
 *
 */
public interface ProductMasterServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ProductMasterServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ProductMasterServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product Product} entity and
     * save it to the S/4HANA system.
     *
     * @param product
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product Product} entity
     *            object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProduct( @Nonnull final Product product );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product Product}
     * entity and save it to the S/4HANA system.
     *
     * @param product
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product Product} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProduct( @Nonnull final Product product );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     * ProductBasicText} entity and save it to the S/4HANA system.
     *
     * @param productBasicText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     *            ProductBasicText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProductBasicText( @Nonnull final ProductBasicText productBasicText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     * ProductBasicText} entity and save it to the S/4HANA system.
     *
     * @param productBasicText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     *            ProductBasicText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProductBasicText( @Nonnull final ProductBasicText productBasicText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     * ProductBasicText} entity in the S/4HANA system.
     *
     * @param productBasicText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     *            ProductBasicText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet deleteProductBasicText( @Nonnull final ProductBasicText productBasicText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     * ProductDescription} entity and save it to the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     *            ProductDescription} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     * ProductDescription} entity and save it to the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     *            ProductDescription} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     * ProductDescription} entity in the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     *            ProductDescription} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet deleteProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     * ProductInspectionText} entity and save it to the S/4HANA system.
     *
     * @param productInspectionText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     *            ProductInspectionText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductInspectionText( @Nonnull final ProductInspectionText productInspectionText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     * ProductInspectionText} entity and save it to the S/4HANA system.
     *
     * @param productInspectionText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     *            ProductInspectionText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductInspectionText( @Nonnull final ProductInspectionText productInspectionText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     * ProductInspectionText} entity in the S/4HANA system.
     *
     * @param productInspectionText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     *            ProductInspectionText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        deleteProductInspectionText( @Nonnull final ProductInspectionText productInspectionText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount
     * ProductMLAccount} entity and save it to the S/4HANA system.
     *
     * @param productMLAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount
     *            ProductMLAccount} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProductMLAccount( @Nonnull final ProductMLAccount productMLAccount );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount
     * ProductMLAccount} entity and save it to the S/4HANA system.
     *
     * @param productMLAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount
     *            ProductMLAccount} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProductMLAccount( @Nonnull final ProductMLAccount productMLAccount );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices
     * ProductMLPrices} entity and save it to the S/4HANA system.
     *
     * @param productMLPrices
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices
     *            ProductMLPrices} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProductMLPrices( @Nonnull final ProductMLPrices productMLPrices );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices
     * ProductMLPrices} entity and save it to the S/4HANA system.
     *
     * @param productMLPrices
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices
     *            ProductMLPrices} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProductMLPrices( @Nonnull final ProductMLPrices productMLPrices );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant ProductPlant}
     * entity and save it to the S/4HANA system.
     *
     * @param productPlant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant ProductPlant}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProductPlant( @Nonnull final ProductPlant productPlant );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant
     * ProductPlant} entity and save it to the S/4HANA system.
     *
     * @param productPlant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant ProductPlant}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProductPlant( @Nonnull final ProductPlant productPlant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting
     * ProductPlantCosting} entity and save it to the S/4HANA system.
     *
     * @param productPlantCosting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting
     *            ProductPlantCosting} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductPlantCosting( @Nonnull final ProductPlantCosting productPlantCosting );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting
     * ProductPlantCosting} entity and save it to the S/4HANA system.
     *
     * @param productPlantCosting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting
     *            ProductPlantCosting} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductPlantCosting( @Nonnull final ProductPlantCosting productPlantCosting );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting
     * ProductPlantForecasting} entity and save it to the S/4HANA system.
     *
     * @param productPlantForecasting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting
     *            ProductPlantForecasting} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductPlantForecasting( @Nonnull final ProductPlantForecasting productPlantForecasting );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting
     * ProductPlantForecasting} entity and save it to the S/4HANA system.
     *
     * @param productPlantForecasting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting
     *            ProductPlantForecasting} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductPlantForecasting( @Nonnull final ProductPlantForecasting productPlantForecasting );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd
     * ProductPlantIntlTrd} entity and save it to the S/4HANA system.
     *
     * @param productPlantIntlTrd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd
     *            ProductPlantIntlTrd} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductPlantIntlTrd( @Nonnull final ProductPlantIntlTrd productPlantIntlTrd );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd
     * ProductPlantIntlTrd} entity and save it to the S/4HANA system.
     *
     * @param productPlantIntlTrd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd
     *            ProductPlantIntlTrd} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductPlantIntlTrd( @Nonnull final ProductPlantIntlTrd productPlantIntlTrd );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea
     * ProductPlantMRPArea} entity and save it to the S/4HANA system.
     *
     * @param productPlantMRPArea
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea
     *            ProductPlantMRPArea} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductPlantMRPArea( @Nonnull final ProductPlantMRPArea productPlantMRPArea );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea
     * ProductPlantMRPArea} entity and save it to the S/4HANA system.
     *
     * @param productPlantMRPArea
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea
     *            ProductPlantMRPArea} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductPlantMRPArea( @Nonnull final ProductPlantMRPArea productPlantMRPArea );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
     * ProductPlantProcurement} entity and save it to the S/4HANA system.
     *
     * @param productPlantProcurement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
     *            ProductPlantProcurement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductPlantProcurement( @Nonnull final ProductPlantProcurement productPlantProcurement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
     * ProductPlantProcurement} entity and save it to the S/4HANA system.
     *
     * @param productPlantProcurement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
     *            ProductPlantProcurement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductPlantProcurement( @Nonnull final ProductPlantProcurement productPlantProcurement );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     * ProductPlantQualityMgmt} entity and save it to the S/4HANA system.
     *
     * @param productPlantQualityMgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     *            ProductPlantQualityMgmt} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductPlantQualityMgmt( @Nonnull final ProductPlantQualityMgmt productPlantQualityMgmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     * ProductPlantQualityMgmt} entity and save it to the S/4HANA system.
     *
     * @param productPlantQualityMgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     *            ProductPlantQualityMgmt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductPlantQualityMgmt( @Nonnull final ProductPlantQualityMgmt productPlantQualityMgmt );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales
     * ProductPlantSales} entity and save it to the S/4HANA system.
     *
     * @param productPlantSales
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales
     *            ProductPlantSales} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProductPlantSales( @Nonnull final ProductPlantSales productPlantSales );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales
     * ProductPlantSales} entity and save it to the S/4HANA system.
     *
     * @param productPlantSales
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales
     *            ProductPlantSales} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProductPlantSales( @Nonnull final ProductPlantSales productPlantSales );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage
     * ProductPlantStorage} entity and save it to the S/4HANA system.
     *
     * @param productPlantStorage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage
     *            ProductPlantStorage} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductPlantStorage( @Nonnull final ProductPlantStorage productPlantStorage );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage
     * ProductPlantStorage} entity and save it to the S/4HANA system.
     *
     * @param productPlantStorage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage
     *            ProductPlantStorage} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductPlantStorage( @Nonnull final ProductPlantStorage productPlantStorage );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     * ProductPlantText} entity and save it to the S/4HANA system.
     *
     * @param productPlantText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     *            ProductPlantText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProductPlantText( @Nonnull final ProductPlantText productPlantText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     * ProductPlantText} entity and save it to the S/4HANA system.
     *
     * @param productPlantText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     *            ProductPlantText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProductPlantText( @Nonnull final ProductPlantText productPlantText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     * ProductPlantText} entity in the S/4HANA system.
     *
     * @param productPlantText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     *            ProductPlantText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet deleteProductPlantText( @Nonnull final ProductPlantText productPlantText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement
     * ProductProcurement} entity and save it to the S/4HANA system.
     *
     * @param productProcurement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement
     *            ProductProcurement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProductProcurement( @Nonnull final ProductProcurement productProcurement );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement
     * ProductProcurement} entity and save it to the S/4HANA system.
     *
     * @param productProcurement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement
     *            ProductProcurement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProductProcurement( @Nonnull final ProductProcurement productProcurement );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     * ProductPurchaseText} entity and save it to the S/4HANA system.
     *
     * @param productPurchaseText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     *            ProductPurchaseText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductPurchaseText( @Nonnull final ProductPurchaseText productPurchaseText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     * ProductPurchaseText} entity and save it to the S/4HANA system.
     *
     * @param productPurchaseText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     *            ProductPurchaseText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductPurchaseText( @Nonnull final ProductPurchaseText productPurchaseText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     * ProductPurchaseText} entity in the S/4HANA system.
     *
     * @param productPurchaseText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     *            ProductPurchaseText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        deleteProductPurchaseText( @Nonnull final ProductPurchaseText productPurchaseText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt
     * ProductQualityMgmt} entity and save it to the S/4HANA system.
     *
     * @param productQualityMgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt
     *            ProductQualityMgmt} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProductQualityMgmt( @Nonnull final ProductQualityMgmt productQualityMgmt );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt
     * ProductQualityMgmt} entity and save it to the S/4HANA system.
     *
     * @param productQualityMgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt
     *            ProductQualityMgmt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProductQualityMgmt( @Nonnull final ProductQualityMgmt productQualityMgmt );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales ProductSales}
     * entity and save it to the S/4HANA system.
     *
     * @param productSales
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales ProductSales}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProductSales( @Nonnull final ProductSales productSales );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales
     * ProductSales} entity and save it to the S/4HANA system.
     *
     * @param productSales
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales ProductSales}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProductSales( @Nonnull final ProductSales productSales );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery
     * ProductSalesDelivery} entity and save it to the S/4HANA system.
     *
     * @param productSalesDelivery
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery
     *            ProductSalesDelivery} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductSalesDelivery( @Nonnull final ProductSalesDelivery productSalesDelivery );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery
     * ProductSalesDelivery} entity and save it to the S/4HANA system.
     *
     * @param productSalesDelivery
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery
     *            ProductSalesDelivery} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductSalesDelivery( @Nonnull final ProductSalesDelivery productSalesDelivery );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax
     * ProductSalesTax} entity and save it to the S/4HANA system.
     *
     * @param productSalesTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax
     *            ProductSalesTax} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProductSalesTax( @Nonnull final ProductSalesTax productSalesTax );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax
     * ProductSalesTax} entity and save it to the S/4HANA system.
     *
     * @param productSalesTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax
     *            ProductSalesTax} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProductSalesTax( @Nonnull final ProductSalesTax productSalesTax );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax
     * ProductSalesTax} entity in the S/4HANA system.
     *
     * @param productSalesTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax
     *            ProductSalesTax} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet deleteProductSalesTax( @Nonnull final ProductSalesTax productSalesTax );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     * ProductSalesText} entity and save it to the S/4HANA system.
     *
     * @param productSalesText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     *            ProductSalesText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProductSalesText( @Nonnull final ProductSalesText productSalesText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     * ProductSalesText} entity and save it to the S/4HANA system.
     *
     * @param productSalesText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     *            ProductSalesText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProductSalesText( @Nonnull final ProductSalesText productSalesText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     * ProductSalesText} entity in the S/4HANA system.
     *
     * @param productSalesText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     *            ProductSalesText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet deleteProductSalesText( @Nonnull final ProductSalesText productSalesText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage
     * ProductStorage} entity and save it to the S/4HANA system.
     *
     * @param productStorage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage
     *            ProductStorage} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProductStorage( @Nonnull final ProductStorage productStorage );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage
     * ProductStorage} entity and save it to the S/4HANA system.
     *
     * @param productStorage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage
     *            ProductStorage} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProductStorage( @Nonnull final ProductStorage productStorage );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
     * ProductStorageLocation} entity and save it to the S/4HANA system.
     *
     * @param productStorageLocation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
     *            ProductStorageLocation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductStorageLocation( @Nonnull final ProductStorageLocation productStorageLocation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
     * ProductStorageLocation} entity and save it to the S/4HANA system.
     *
     * @param productStorageLocation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
     *            ProductStorageLocation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductStorageLocation( @Nonnull final ProductStorageLocation productStorageLocation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
     * ProductSupplyPlanning} entity and save it to the S/4HANA system.
     *
     * @param productSupplyPlanning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
     *            ProductSupplyPlanning} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductSupplyPlanning( @Nonnull final ProductSupplyPlanning productSupplyPlanning );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
     * ProductSupplyPlanning} entity and save it to the S/4HANA system.
     *
     * @param productSupplyPlanning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
     *            ProductSupplyPlanning} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductSupplyPlanning( @Nonnull final ProductSupplyPlanning productSupplyPlanning );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     * ProductUnitsOfMeasure} entity and save it to the S/4HANA system.
     *
     * @param productUnitsOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     *            ProductUnitsOfMeasure} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductUnitsOfMeasure( @Nonnull final ProductUnitsOfMeasure productUnitsOfMeasure );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     * ProductUnitsOfMeasure} entity and save it to the S/4HANA system.
     *
     * @param productUnitsOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     *            ProductUnitsOfMeasure} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductUnitsOfMeasure( @Nonnull final ProductUnitsOfMeasure productUnitsOfMeasure );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     * ProductUnitsOfMeasure} entity in the S/4HANA system.
     *
     * @param productUnitsOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     *            ProductUnitsOfMeasure} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        deleteProductUnitsOfMeasure( @Nonnull final ProductUnitsOfMeasure productUnitsOfMeasure );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     * ProductUnitsOfMeasureEAN} entity and save it to the S/4HANA system.
     *
     * @param productUnitsOfMeasureEAN
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     *            ProductUnitsOfMeasureEAN} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductUnitsOfMeasureEAN( @Nonnull final ProductUnitsOfMeasureEAN productUnitsOfMeasureEAN );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     * ProductUnitsOfMeasureEAN} entity and save it to the S/4HANA system.
     *
     * @param productUnitsOfMeasureEAN
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     *            ProductUnitsOfMeasureEAN} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductUnitsOfMeasureEAN( @Nonnull final ProductUnitsOfMeasureEAN productUnitsOfMeasureEAN );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     * ProductUnitsOfMeasureEAN} entity in the S/4HANA system.
     *
     * @param productUnitsOfMeasureEAN
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     *            ProductUnitsOfMeasureEAN} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        deleteProductUnitsOfMeasureEAN( @Nonnull final ProductUnitsOfMeasureEAN productUnitsOfMeasureEAN );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation
     * ProductValuation} entity and save it to the S/4HANA system.
     *
     * @param productValuation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation
     *            ProductValuation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet createProductValuation( @Nonnull final ProductValuation productValuation );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation
     * ProductValuation} entity and save it to the S/4HANA system.
     *
     * @param productValuation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation
     *            ProductValuation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet updateProductValuation( @Nonnull final ProductValuation productValuation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
     * ProductValuationAccount} entity and save it to the S/4HANA system.
     *
     * @param productValuationAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
     *            ProductValuationAccount} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductValuationAccount( @Nonnull final ProductValuationAccount productValuationAccount );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
     * ProductValuationAccount} entity and save it to the S/4HANA system.
     *
     * @param productValuationAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
     *            ProductValuationAccount} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductValuationAccount( @Nonnull final ProductValuationAccount productValuationAccount );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
     * ProductValuationCosting} entity and save it to the S/4HANA system.
     *
     * @param productValuationCosting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
     *            ProductValuationCosting} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductValuationCosting( @Nonnull final ProductValuationCosting productValuationCosting );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
     * ProductValuationCosting} entity and save it to the S/4HANA system.
     *
     * @param productValuationCosting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
     *            ProductValuationCosting} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductValuationCosting( @Nonnull final ProductValuationCosting productValuationCosting );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
     * ProductWorkScheduling} entity and save it to the S/4HANA system.
     *
     * @param productWorkScheduling
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
     *            ProductWorkScheduling} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        createProductWorkScheduling( @Nonnull final ProductWorkScheduling productWorkScheduling );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
     * ProductWorkScheduling} entity and save it to the S/4HANA system.
     *
     * @param productWorkScheduling
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
     *            ProductWorkScheduling} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductMasterServiceBatchChangeSet
        updateProductWorkScheduling( @Nonnull final ProductWorkScheduling productWorkScheduling );

}
