/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductSalesTextSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText ProductSalesText} to other
 * entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains methods
 * to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class ProductSalesTextLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<ProductSalesTextLink<ObjectT>, ProductSalesText, ObjectT>
    implements
    ProductSalesTextSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public ProductSalesTextLink( final String fieldName )
    {
        super(fieldName);
    }

    private ProductSalesTextLink( final EntityLink<ProductSalesTextLink<ObjectT>, ProductSalesText, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected ProductSalesTextLink<ObjectT> translateLinkType(
        final EntityLink<ProductSalesTextLink<ObjectT>, ProductSalesText, ObjectT> link )
    {
        return new ProductSalesTextLink<ObjectT>(link);
    }

}
