/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText ProductBasicText}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductBasicTextField
 * ProductBasicTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductBasicTextLink
 * ProductBasicTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText#PRODUCT PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText#LONG_TEXT
 * LONG_TEXT}</li>
 * </ul>
 *
 */
public interface ProductBasicTextSelectable extends EntitySelectable<ProductBasicText>
{

}
