/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd ProductPlantIntlTrd}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductPlantIntlTrdField
 * ProductPlantIntlTrdField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductPlantIntlTrdLink
 * ProductPlantIntlTrdLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd#COUNTRY_OF_ORIGIN
 * COUNTRY_OF_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd#REGION_OF_ORIGIN
 * REGION_OF_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd#CONSUMPTION_TAX_CTRL_CODE
 * CONSUMPTION_TAX_CTRL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd#PRODUCT_CAS_NUMBER
 * PRODUCT_CAS_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd#PROD_INTL_TRADE_CLASSIFICATION
 * PROD_INTL_TRADE_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd#EXPORT_AND_IMPORT_PRODUCT_GROUP
 * EXPORT_AND_IMPORT_PRODUCT_GROUP}</li>
 * </ul>
 *
 */
public interface ProductPlantIntlTrdSelectable extends EntitySelectable<ProductPlantIntlTrd>
{

}
