/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea ProductPlantMRPArea}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductPlantMRPAreaField
 * ProductPlantMRPAreaField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductPlantMRPAreaLink
 * ProductPlantMRPAreaLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#MRP_AREA
 * MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#MRP_TYPE
 * MRP_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#MRP_RESPONSIBLE
 * MRP_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#MRP_GROUP
 * MRP_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#REORDER_THRESHOLD_QUANTITY
 * REORDER_THRESHOLD_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#PLANNING_TIME_FENCE
 * PLANNING_TIME_FENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#LOT_SIZING_PROCEDURE
 * LOT_SIZING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#LOT_SIZE_ROUNDING_QUANTITY
 * LOT_SIZE_ROUNDING_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#MINIMUM_LOT_SIZE_QUANTITY
 * MINIMUM_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#MAXIMUM_LOT_SIZE_QUANTITY
 * MAXIMUM_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#MAXIMUM_STOCK_QUANTITY
 * MAXIMUM_STOCK_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#ASSEMBLY_SCRAP_PERCENT
 * ASSEMBLY_SCRAP_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#PROCUREMENT_SUB_TYPE
 * PROCUREMENT_SUB_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#DFLT_STORAGE_LOCATION_EXT_PROCMT
 * DFLT_STORAGE_LOCATION_EXT_PROCMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#MRP_PLANNING_CALENDAR
 * MRP_PLANNING_CALENDAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#SAFETY_STOCK_QUANTITY
 * SAFETY_STOCK_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#RANGE_OF_CVRG_PRFL_CODE
 * RANGE_OF_CVRG_PRFL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#SAFETY_DURATION
 * SAFETY_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#FIXED_LOT_SIZE_QUANTITY
 * FIXED_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#LOT_SIZE_INDEPENDENT_COSTS
 * LOT_SIZE_INDEPENDENT_COSTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#IS_STORAGE_COSTS
 * IS_STORAGE_COSTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#RQMT_QTY_RCPT_TAKT_TME_IN_WRKG_DAYS
 * RQMT_QTY_RCPT_TAKT_TME_IN_WRKG_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#SRVC_LVL
 * SRVC_LVL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#PERD_PRFL_FOR_SFTY_TME
 * PERD_PRFL_FOR_SFTY_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#IS_MRP_DEPENDENT_RQMT
 * IS_MRP_DEPENDENT_RQMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#IS_SAFETY_TIME
 * IS_SAFETY_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#PLANNED_DELIVERY_DURATION_IN_DAYS
 * PLANNED_DELIVERY_DURATION_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#IS_PLANNED_DELIVERY_TIME
 * IS_PLANNED_DELIVERY_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#PLAN_AND_ORDER_DAY_DETERMINATION
 * PLAN_AND_ORDER_DAY_DETERMINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#ROUNDING_PROFILE
 * ROUNDING_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * </ul>
 *
 */
public interface ProductPlantMRPAreaSelectable extends EntitySelectable<ProductPlantMRPArea>
{

}
