/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
 * ProductPlantProcurement}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductPlantProcurementField
 * ProductPlantProcurementField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductPlantProcurementLink
 * ProductPlantProcurementLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement#IS_AUTO_PUR_ORD_CREATION_ALLOWED
 * IS_AUTO_PUR_ORD_CREATION_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement#IS_SOURCE_LIST_REQUIRED
 * IS_SOURCE_LIST_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement#SOURCE_OF_SUPPLY_CATEGORY
 * SOURCE_OF_SUPPLY_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement#ITM_IS_RLVT_TO_JIT_DELIV_SCHEDULES
 * ITM_IS_RLVT_TO_JIT_DELIV_SCHEDULES}</li>
 * </ul>
 *
 */
public interface ProductPlantProcurementSelectable extends EntitySelectable<ProductPlantProcurement>
{

}
