/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
 * ProductPlantQualityMgmt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductPlantQualityMgmtField
 * ProductPlantQualityMgmtField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductPlantQualityMgmtLink
 * ProductPlantQualityMgmtLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt#MAXIMUM_STORAGE_PERIOD
 * MAXIMUM_STORAGE_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt#QUALITY_MGMT_CTRL_KEY
 * QUALITY_MGMT_CTRL_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt#MATL_QUALITY_AUTHORIZATION_GROUP
 * MATL_QUALITY_AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt#HAS_POST_TO_INSPECTION_STOCK
 * HAS_POST_TO_INSPECTION_STOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt#INSP_LOT_DOCUMENTATION_IS_REQUIRED
 * INSP_LOT_DOCUMENTATION_IS_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt#SUPLR_QUALITY_MANAGEMENT_SYSTEM
 * SUPLR_QUALITY_MANAGEMENT_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt#RECRRG_INSP_INTERVAL_TIME_IN_DAYS
 * RECRRG_INSP_INTERVAL_TIME_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt#PRODUCT_QUALITY_CERTIFICATE_TYPE
 * PRODUCT_QUALITY_CERTIFICATE_TYPE}</li>
 * </ul>
 *
 */
public interface ProductPlantQualityMgmtSelectable extends EntitySelectable<ProductPlantQualityMgmt>
{

}
