/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage ProductPlantStorage}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductPlantStorageField
 * ProductPlantStorageField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductPlantStorageLink
 * ProductPlantStorageLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage#INVENTORY_FOR_CYCLE_COUNT_IND
 * INVENTORY_FOR_CYCLE_COUNT_IND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage#PROVISIONING_SERVICE_LEVEL
 * PROVISIONING_SERVICE_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage#CYCLE_COUNTING_INDICATOR_IS_FIXED
 * CYCLE_COUNTING_INDICATOR_IS_FIXED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage#PROD_MAXIMUM_STORAGE_PERIOD_UNIT
 * PROD_MAXIMUM_STORAGE_PERIOD_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage#WRHS_MGMT_PTWY_AND_STK_REMOVAL_STRGY
 * WRHS_MGMT_PTWY_AND_STK_REMOVAL_STRGY}</li>
 * </ul>
 *
 */
public interface ProductPlantStorageSelectable extends EntitySelectable<ProductPlantStorage>
{

}
