/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText ProductPurchaseText}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductPurchaseTextField
 * ProductPurchaseTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductPurchaseTextLink
 * ProductPurchaseTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText#LONG_TEXT
 * LONG_TEXT}</li>
 * </ul>
 *
 */
public interface ProductPurchaseTextSelectable extends EntitySelectable<ProductPurchaseText>
{

}
