/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery ProductSalesDelivery}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductSalesDeliveryField
 * ProductSalesDeliveryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductSalesDeliveryLink
 * ProductSalesDeliveryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_SALES_ORG
 * PRODUCT_SALES_ORG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_DISTRIBUTION_CHNL
 * PRODUCT_DISTRIBUTION_CHNL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#MINIMUM_ORDER_QUANTITY
 * MINIMUM_ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#SUPPLYING_PLANT
 * SUPPLYING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRICE_SPECIFICATION_PRODUCT_GROUP
 * PRICE_SPECIFICATION_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#ACCOUNT_DETN_PRODUCT_GROUP
 * ACCOUNT_DETN_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#DELIVERY_NOTE_PROC_MIN_DELIV_QTY
 * DELIVERY_NOTE_PROC_MIN_DELIV_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#ITEM_CATEGORY_GROUP
 * ITEM_CATEGORY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#DELIVERY_QUANTITY_UNIT
 * DELIVERY_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#DELIVERY_QUANTITY
 * DELIVERY_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_SALES_STATUS
 * PRODUCT_SALES_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_SALES_STATUS_VALIDITY_DATE
 * PRODUCT_SALES_STATUS_VALIDITY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#SALES_MEASURE_UNIT
 * SALES_MEASURE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_HIERARCHY
 * PRODUCT_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#FIRST_SALES_SPEC_PRODUCT_GROUP
 * FIRST_SALES_SPEC_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#SECOND_SALES_SPEC_PRODUCT_GROUP
 * SECOND_SALES_SPEC_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#THIRD_SALES_SPEC_PRODUCT_GROUP
 * THIRD_SALES_SPEC_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#FOURTH_SALES_SPEC_PRODUCT_GROUP
 * FOURTH_SALES_SPEC_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#FIFTH_SALES_SPEC_PRODUCT_GROUP
 * FIFTH_SALES_SPEC_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#MINIMUM_MAKE_TO_ORDER_ORDER_QTY
 * MINIMUM_MAKE_TO_ORDER_ORDER_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#LOGISTICS_STATISTICS_GROUP
 * LOGISTICS_STATISTICS_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#VOLUME_REBATE_GROUP
 * VOLUME_REBATE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_COMMISSION_GROUP
 * PRODUCT_COMMISSION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#CASH_DISCOUNT_IS_DEDUCTIBLE
 * CASH_DISCOUNT_IS_DEDUCTIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRICING_REFERENCE_PRODUCT
 * PRICING_REFERENCE_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#ROUNDING_PROFILE
 * ROUNDING_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_UNIT_GROUP
 * PRODUCT_UNIT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#VARIABLE_SALES_UNIT_IS_NOT_ALLOWED
 * VARIABLE_SALES_UNIT_IS_NOT_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_HAS_ATTRIBUTE_I_D01
 * PRODUCT_HAS_ATTRIBUTE_I_D01}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_HAS_ATTRIBUTE_I_D02
 * PRODUCT_HAS_ATTRIBUTE_I_D02}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_HAS_ATTRIBUTE_I_D03
 * PRODUCT_HAS_ATTRIBUTE_I_D03}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_HAS_ATTRIBUTE_I_D04
 * PRODUCT_HAS_ATTRIBUTE_I_D04}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_HAS_ATTRIBUTE_I_D05
 * PRODUCT_HAS_ATTRIBUTE_I_D05}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_HAS_ATTRIBUTE_I_D06
 * PRODUCT_HAS_ATTRIBUTE_I_D06}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_HAS_ATTRIBUTE_I_D07
 * PRODUCT_HAS_ATTRIBUTE_I_D07}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_HAS_ATTRIBUTE_I_D08
 * PRODUCT_HAS_ATTRIBUTE_I_D08}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_HAS_ATTRIBUTE_I_D09
 * PRODUCT_HAS_ATTRIBUTE_I_D09}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#PRODUCT_HAS_ATTRIBUTE_I_D10
 * PRODUCT_HAS_ATTRIBUTE_I_D10}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#TO_SALES_TAX
 * TO_SALES_TAX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery#TO_SALES_TEXT
 * TO_SALES_TEXT}</li>
 * </ul>
 *
 */
public interface ProductSalesDeliverySelectable extends EntitySelectable<ProductSalesDelivery>
{

}
