/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales ProductSales}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductSalesField
 * ProductSalesField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductSalesLink
 * ProductSalesLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales#PRODUCT PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales#SALES_STATUS
 * SALES_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales#SALES_STATUS_VALIDITY_DATE
 * SALES_STATUS_VALIDITY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales#TAX_CLASSIFICATION
 * TAX_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales#TRANSPORTATION_GROUP
 * TRANSPORTATION_GROUP}</li>
 * </ul>
 *
 */
public interface ProductSalesSelectable extends EntitySelectable<ProductSales>
{

}
