/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
 * ProductStorageLocation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductStorageLocationField
 * ProductStorageLocationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductStorageLocationLink
 * ProductStorageLocationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#WAREHOUSE_STORAGE_BIN
 * WAREHOUSE_STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#MAINTENANCE_STATUS
 * MAINTENANCE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#PHYSICAL_INVENTORY_BLOCK_IND
 * PHYSICAL_INVENTORY_BLOCK_IND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#DATE_OF_LAST_POSTED_CNT_UN_RSTRCD_STK
 * DATE_OF_LAST_POSTED_CNT_UN_RSTRCD_STK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#INVENTORY_CORRECTION_FACTOR
 * INVENTORY_CORRECTION_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#INVTRY_RESTRICTED_USE_STOCK_IND
 * INVTRY_RESTRICTED_USE_STOCK_IND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#INVTRY_CURRENT_YEAR_STOCK_IND
 * INVTRY_CURRENT_YEAR_STOCK_IND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#INVTRY_QUAL_INSP_CURRENT_YR_STK_IND
 * INVTRY_QUAL_INSP_CURRENT_YR_STK_IND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#INVENTORY_BLOCK_STOCK_IND
 * INVENTORY_BLOCK_STOCK_IND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#INVTRY_REST_STOCK_PREV_PERIOD_IND
 * INVTRY_REST_STOCK_PREV_PERIOD_IND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#INVENTORY_STOCK_PREV_PERIOD
 * INVENTORY_STOCK_PREV_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#INVTRY_STOCK_QLTY_INSP_PREV_PERIOD
 * INVTRY_STOCK_QLTY_INSP_PREV_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#HAS_INVTRY_BLOCK_STOCK_PREV_PERIOD
 * HAS_INVTRY_BLOCK_STOCK_PREV_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#FISCAL_YEAR_CURRENT_PERIOD
 * FISCAL_YEAR_CURRENT_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#FISCAL_MONTH_CURRENT_PERIOD
 * FISCAL_MONTH_CURRENT_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#FISCAL_YEAR_CURRENT_INVTRY_PERIOD
 * FISCAL_YEAR_CURRENT_INVTRY_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation#LEAN_WRHS_MANAGEMENT_PICKING_AREA
 * LEAN_WRHS_MANAGEMENT_PICKING_AREA}</li>
 * </ul>
 *
 */
public interface ProductStorageLocationSelectable extends EntitySelectable<ProductStorageLocation>
{

}
