/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage ProductStorage}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductStorageField
 * ProductStorageField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductStorageLink ProductStorageLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage#PRODUCT PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage#STORAGE_CONDITIONS
 * STORAGE_CONDITIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage#TEMPERATURE_CONDITION_IND
 * TEMPERATURE_CONDITION_IND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage#HAZARDOUS_MATERIAL_NUMBER
 * HAZARDOUS_MATERIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage#NMBR_OF_GR_OR_GI_SLIPS_TO_PRINT_QTY
 * NMBR_OF_GR_OR_GI_SLIPS_TO_PRINT_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage#LABEL_TYPE
 * LABEL_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage#LABEL_FORM
 * LABEL_FORM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage#MIN_REMAINING_SHELF_LIFE
 * MIN_REMAINING_SHELF_LIFE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage#EXPIRATION_DATE
 * EXPIRATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage#SHELF_LIFE_EXPIRATION_DATE_PERIOD
 * SHELF_LIFE_EXPIRATION_DATE_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage#TOTAL_SHELF_LIFE
 * TOTAL_SHELF_LIFE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage#BASE_UNIT BASE_UNIT}</li>
 * </ul>
 *
 */
public interface ProductStorageSelectable extends EntitySelectable<ProductStorage>
{

}
