/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
 * ProductSupplyPlanning}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductSupplyPlanningField
 * ProductSupplyPlanningField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductSupplyPlanningLink
 * ProductSupplyPlanningLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#FIXED_LOT_SIZE_QUANTITY
 * FIXED_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#MAXIMUM_LOT_SIZE_QUANTITY
 * MAXIMUM_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#MINIMUM_LOT_SIZE_QUANTITY
 * MINIMUM_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#LOT_SIZE_ROUNDING_QUANTITY
 * LOT_SIZE_ROUNDING_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#LOT_SIZING_PROCEDURE
 * LOT_SIZING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#MRP_TYPE
 * MRP_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#MRP_RESPONSIBLE
 * MRP_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#SAFETY_STOCK_QUANTITY
 * SAFETY_STOCK_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#MINIMUM_SAFETY_STOCK_QUANTITY
 * MINIMUM_SAFETY_STOCK_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PLANNING_TIME_FENCE
 * PLANNING_TIME_FENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#ABC_INDICATOR
 * ABC_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#MAXIMUM_STOCK_QUANTITY
 * MAXIMUM_STOCK_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#REORDER_THRESHOLD_QUANTITY
 * REORDER_THRESHOLD_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PLANNED_DELIVERY_DURATION_IN_DAYS
 * PLANNED_DELIVERY_DURATION_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#SAFETY_DURATION
 * SAFETY_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PLANNING_STRATEGY_GROUP
 * PLANNING_STRATEGY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#TOTAL_REPLENISHMENT_LEAD_TIME
 * TOTAL_REPLENISHMENT_LEAD_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PROCUREMENT_TYPE
 * PROCUREMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PROCUREMENT_SUB_TYPE
 * PROCUREMENT_SUB_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#ASSEMBLY_SCRAP_PERCENT
 * ASSEMBLY_SCRAP_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#AVAILABILITY_CHECK_TYPE
 * AVAILABILITY_CHECK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#GOODS_RECEIPT_DURATION
 * GOODS_RECEIPT_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#MRP_GROUP
 * MRP_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#DFLT_STORAGE_LOCATION_EXT_PROCMT
 * DFLT_STORAGE_LOCATION_EXT_PROCMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PROD_RQMTS_CONSUMPTION_MODE
 * PROD_RQMTS_CONSUMPTION_MODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#BACKWARD_CNSMPN_PERIOD_IN_WORK_DAYS
 * BACKWARD_CNSMPN_PERIOD_IN_WORK_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#FWD_CONSUMPTION_PERIOD_IN_WORK_DAYS
 * FWD_CONSUMPTION_PERIOD_IN_WORK_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PLAN_AND_ORDER_DAY_DETERMINATION
 * PLAN_AND_ORDER_DAY_DETERMINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#ROUNDING_PROFILE
 * ROUNDING_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#LOT_SIZE_INDEPENDENT_COSTS
 * LOT_SIZE_INDEPENDENT_COSTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#MRP_PLANNING_CALENDAR
 * MRP_PLANNING_CALENDAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#RANGE_OF_CVRG_PRFL_CODE
 * RANGE_OF_CVRG_PRFL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#IS_SAFETY_TIME
 * IS_SAFETY_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PERD_PRFL_FOR_SFTY_TME
 * PERD_PRFL_FOR_SFTY_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#IS_MRP_DEPENDENT_RQMT
 * IS_MRP_DEPENDENT_RQMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#IN_HOUSE_PRODUCTION_TIME
 * IN_HOUSE_PRODUCTION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PRODUCT_IS_FOR_CROSS_PROJECT
 * PRODUCT_IS_FOR_CROSS_PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#STORAGE_COSTS_PERCENTAGE_CODE
 * STORAGE_COSTS_PERCENTAGE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#SRVC_LVL
 * SRVC_LVL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#MRP_AVAILABILITY_TYPE
 * MRP_AVAILABILITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#FOLLOW_UP_PRODUCT
 * FOLLOW_UP_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#REPETITIVE_MANUFACTURING_IS_ALLWD
 * REPETITIVE_MANUFACTURING_IS_ALLWD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#DEPENDENT_REQUIREMENTS_TYPE
 * DEPENDENT_REQUIREMENTS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#IS_BULK_MATERIAL_COMPONENT
 * IS_BULK_MATERIAL_COMPONENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#REPETITIVE_MANUFACTURING_PROFILE
 * REPETITIVE_MANUFACTURING_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#RQMT_QTY_RCPT_TAKT_TME_IN_WRKG_DAYS
 * RQMT_QTY_RCPT_TAKT_TME_IN_WRKG_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#FORECAST_REQUIREMENTS_ARE_SPLIT
 * FORECAST_REQUIREMENTS_ARE_SPLIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#EFFECTIVE_OUT_DATE
 * EFFECTIVE_OUT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#MRP_PROFILE
 * MRP_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#COMPONENT_SCRAP_IN_PERCENT
 * COMPONENT_SCRAP_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PRODUCT_IS_TO_BE_DISCONTINUED
 * PRODUCT_IS_TO_BE_DISCONTINUED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PROD_RQMTS_ARE_CONSOLIDATED
 * PROD_RQMTS_ARE_CONSOLIDATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#MATL_COMP_IS_MARKED_FOR_BACKFLUSH
 * MATL_COMP_IS_MARKED_FOR_BACKFLUSH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PROPOSED_PRODUCT_SUPPLY_AREA
 * PROPOSED_PRODUCT_SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning#PLANNED_ORDER_ACTION_CONTROL
 * PLANNED_ORDER_ACTION_CONTROL}</li>
 * </ul>
 *
 */
public interface ProductSupplyPlanningSelectable extends EntitySelectable<ProductSupplyPlanning>
{

}
