/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
 * ProductUnitsOfMeasureEAN}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductUnitsOfMeasureEANField
 * ProductUnitsOfMeasureEANField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductUnitsOfMeasureEANLink
 * ProductUnitsOfMeasureEANLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN#ALTERNATIVE_UNIT
 * ALTERNATIVE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN#CONSECUTIVE_NUMBER
 * CONSECUTIVE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN#PRODUCT_STANDARD_ID
 * PRODUCT_STANDARD_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN#INTERNATIONAL_ARTICLE_NUMBER_CAT
 * INTERNATIONAL_ARTICLE_NUMBER_CAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN#IS_MAIN_GLOBAL_TRADE_ITEM_NUMBER
 * IS_MAIN_GLOBAL_TRADE_ITEM_NUMBER}</li>
 * </ul>
 *
 */
public interface ProductUnitsOfMeasureEANSelectable extends EntitySelectable<ProductUnitsOfMeasureEAN>
{

}
