/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
 * ProductUnitsOfMeasure}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductUnitsOfMeasureField
 * ProductUnitsOfMeasureField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductUnitsOfMeasureLink
 * ProductUnitsOfMeasureLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#ALTERNATIVE_UNIT
 * ALTERNATIVE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#QUANTITY_NUMERATOR
 * QUANTITY_NUMERATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#QUANTITY_DENOMINATOR
 * QUANTITY_DENOMINATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#MATERIAL_VOLUME
 * MATERIAL_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#VOLUME_UNIT
 * VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#GROSS_WEIGHT
 * GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#WEIGHT_UNIT
 * WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#GLOBAL_TRADE_ITEM_NUMBER
 * GLOBAL_TRADE_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#GLOBAL_TRADE_ITEM_NUMBER_CATEGORY
 * GLOBAL_TRADE_ITEM_NUMBER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#UNIT_SPECIFIC_PRODUCT_LENGTH
 * UNIT_SPECIFIC_PRODUCT_LENGTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#UNIT_SPECIFIC_PRODUCT_WIDTH
 * UNIT_SPECIFIC_PRODUCT_WIDTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#UNIT_SPECIFIC_PRODUCT_HEIGHT
 * UNIT_SPECIFIC_PRODUCT_HEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#PRODUCT_MEASUREMENT_UNIT
 * PRODUCT_MEASUREMENT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#LOWER_LEVEL_PACKAGING_UNIT
 * LOWER_LEVEL_PACKAGING_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#REMAINING_VOLUME_AFTER_NESTING
 * REMAINING_VOLUME_AFTER_NESTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#MAXIMUM_STACKING_FACTOR
 * MAXIMUM_STACKING_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#CAPACITY_USAGE
 * CAPACITY_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure#TO_INTERNATIONAL_ARTICLE_NUMBER
 * TO_INTERNATIONAL_ARTICLE_NUMBER}</li>
 * </ul>
 *
 */
public interface ProductUnitsOfMeasureSelectable extends EntitySelectable<ProductUnitsOfMeasure>
{

}
