/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
 * ProductValuationAccount}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductValuationAccountField
 * ProductValuationAccountField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductValuationAccountLink
 * ProductValuationAccountLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#VALUATION_AREA
 * VALUATION_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#VALUATION_TYPE
 * VALUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#COMMERCIAL_PRICE1_IN_CO_CODE_CRCY
 * COMMERCIAL_PRICE1_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#COMMERCIAL_PRICE2_IN_CO_CODE_CRCY
 * COMMERCIAL_PRICE2_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#COMMERCIAL_PRICE3_IN_CO_CODE_CRCY
 * COMMERCIAL_PRICE3_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#DEVALUATION_YEAR_COUNT
 * DEVALUATION_YEAR_COUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#FUTURE_EVALUATED_AMOUNT_VALUE
 * FUTURE_EVALUATED_AMOUNT_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#FUTURE_PRICE_VALIDITY_START_DATE
 * FUTURE_PRICE_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#IS_LIFO_AND_FIFO_RELEVANT
 * IS_LIFO_AND_FIFO_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#LIFO_VALUATION_POOL_NUMBER
 * LIFO_VALUATION_POOL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#TAX_PRICEL1_IN_CO_CODE_CRCY
 * TAX_PRICEL1_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#TAX_PRICE2_IN_CO_CODE_CRCY
 * TAX_PRICE2_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#TAX_PRICE3_IN_CO_CODE_CRCY
 * TAX_PRICE3_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount#CURRENCY
 * CURRENCY}</li>
 * </ul>
 *
 */
public interface ProductValuationAccountSelectable extends EntitySelectable<ProductValuationAccount>
{

}
