/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
 * ProductValuationCosting}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductValuationCostingField
 * ProductValuationCostingField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductValuationCostingLink
 * ProductValuationCostingLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting#VALUATION_AREA
 * VALUATION_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting#VALUATION_TYPE
 * VALUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting#IS_MATERIAL_COSTED_WITH_QTY_STRUC
 * IS_MATERIAL_COSTED_WITH_QTY_STRUC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting#IS_MATERIAL_RELATED_ORIGIN
 * IS_MATERIAL_RELATED_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting#COST_ORIGIN_GROUP
 * COST_ORIGIN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting#COSTING_OVERHEAD_GROUP
 * COSTING_OVERHEAD_GROUP}</li>
 * </ul>
 *
 */
public interface ProductValuationCostingSelectable extends EntitySelectable<ProductValuationCosting>
{

}
